/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.formplugin.basesetting.FpmBaseFilterPlugin;

public class MetricMemberList
extends FpmBaseFilterPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btn_addmember"});
    }

    @Override
    protected String getBodySystemProp() {
        return "bodysystem";
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelId = this.getPageCache().get("bodysystem.id");
        if (modelId == null) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("bodysystem.name")).findFirst().get();
        filterColumn.setDefaultValue(modelId);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> first = qFilters.stream().filter(i -> i.getProperty().startsWith("bodysystem")).findFirst();
        QFilter systemFilter = first.orElse(null);
        if (systemFilter == null) {
            systemFilter = new QFilter("bodysystem.id", "=", (Object)0L);
            qFilters.add(systemFilter);
            return;
        }
        String property = systemFilter.getProperty();
        if (!"bodysystem.id".equals(property)) {
            return;
        }
        String modelId = systemFilter.getValue().toString();
        if (modelId.contains("[")) {
            String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
            modelId = modelIdArr[0].trim();
        }
        this.getPageCache().put("bodysystem.id", modelId);
        QFilter filter = new QFilter("dimtype", "=", (Object)DimsionEnums.METRIC.getNumber());
        qFilters.add(filter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addmember": {
                String systemId = this.getPageCache().get("bodysystem.id");
                if (EmptyUtil.isEmpty((String)systemId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"MetricMemberList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("bodysystem", "=", (Object)Long.valueOf(systemId));
                filter.and(new QFilter("dimtype", "=", (Object)DimsionEnums.METRIC.getNumber()));
                DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_member", (String)"id,number", (QFilter[])new QFilter[]{filter});
                List sortedList = Arrays.stream(load).sorted(Comparator.comparing(o -> {
                    String number = o.getString("number");
                    return Integer.valueOf(number.substring(1));
                }, Comparator.reverseOrder())).collect(Collectors.toList());
                DynamicObject firstMetric = (DynamicObject)sortedList.get(0);
                String number = firstMetric.getString("number");
                String endNumberStr = number.substring(1);
                String finalStr = "M";
                int endNum = Integer.parseInt(endNumberStr) + 1;
                finalStr = endNum < 10 ? finalStr + "00" + endNum : (endNum < 99 ? finalStr + "0" + endNum : finalStr + endNum);
                this.getPageCache().put("MetricNumber", finalStr);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("chkdisable".equals(key)) {
            this.getView().invokeOperation("disable");
        }
    }
}

