/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.common.enums.BeginOrEndMarkEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.WaysEnum;

public class SubjectMemberEditPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"formula"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("formula".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("fpm_subjectformula");
            final Object modelId = ((DynamicObject)this.getModel().getValue("bodysysmanage")).getPkValue();
            final Object express = this.getModel().getValue("formulavalue_tag");
            final Object expressDesc = this.getModel().getValue("formula");
            final Object subjectId = this.getModel().getValue("id");
            parameter.setCustomParams((Map)new HashMap<String, Object>(){
                {
                    this.put("model", modelId);
                    this.put("id", subjectId);
                    this.put("express", express);
                    this.put("expressDesc", expressDesc);
                }
            });
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_formulaedit"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent ccevt) {
        super.closedCallBack(ccevt);
        String actionId = ccevt.getActionId();
        if ("close_formulaedit".equals(actionId)) {
            Map returnData = (Map)ccevt.getReturnData();
            if (null == returnData) {
                return;
            }
            String descript = (String)returnData.get("expressiondesc");
            this.getModel().setValue("formula", (Object)(descript.length() > 1000 ? descript.substring(0, 997) : descript));
            this.getModel().setValue("formulavalue", returnData.get("expression"));
            this.getModel().setValue("formulavalue_tag", returnData.get("expression"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                DynamicObject parentMember = (DynamicObject)this.getModel().getValue("parent");
                this.getView().getPageCache().put("cache_subjectmember_upid", Optional.ofNullable(parentMember).map(o -> o.getString("id")).orElseGet(() -> null));
                break;
            }
            case "new": {
                String subjectId = this.getView().getPageCache().get("cache_subjectmember_upid");
                Optional.ofNullable(subjectId).ifPresent(o -> this.getModel().setValue("parent", o));
                this.getPageCache().remove("cache_subjectmember_upid");
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String subjectId;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String strbodySysManageId = parentView.getPageCache().get("cache_subjectmember_bodysysmanager");
        if (null == strbodySysManageId || strbodySysManageId.trim().isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u4f53\u7cfb\u3002", (String)"SubjectMemberEditPlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bodySysManageId = Objects.equals(strbodySysManageId, "empty") || StringUtils.isEmpty((CharSequence)strbodySysManageId) ? 0L : Long.parseLong(strbodySysManageId);
        this.getModel().setValue("bodysystem", (Object)bodySysManageId);
        this.getModel().setValue("bodysysmanage", (Object)bodySysManageId);
        DynamicObject bodySysManager = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id,number,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bodySysManageId)});
        if (Objects.nonNull(bodySysManager)) {
            Object org = bodySysManager.get("org");
            this.getModel().setValue("org", org);
        }
        if (null != (subjectId = this.getView().getParentView().getPageCache().get("cache_subjectmember_id"))) {
            this.getModel().setValue("parent", (Object)subjectId);
            DynamicObject parentSubject = (DynamicObject)this.getModel().getValue("parent");
            String flow = parentSubject.getString("flow");
            this.getModel().setValue("flow", (Object)flow);
        }
        this.getView().getParentView().getPageCache().remove("cache_subjectmember_id");
    }

    public void afterBindData(EventObject e) {
        boolean isleaf;
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.toString().equals("EDIT") && !(isleaf = ((Boolean)this.getModel().getValue("isleaf")).booleanValue())) {
            ComboEdit waysCombo = (ComboEdit)this.getControl("ways");
            WaysEnum[] waysEnums = WaysEnum.values();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(waysEnums.length - 1);
            for (WaysEnum ways : waysEnums) {
                if (ways.getValue().equals("3")) continue;
                items.add(new ComboItem(new LocaleString(ways.getName()), ways.getValue()));
            }
            waysCombo.setComboItems(items);
        }
    }

    private void initF7() {
        IDataModel model = this.getModel();
        BasedataEdit linkSubjectEdit = (BasedataEdit)this.getControl("linksubject");
        linkSubjectEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("flow", "=", (Object)FlowEnum.BALANCE.getValue());
            filter.and("beginorendmark", "=", (Object)BeginOrEndMarkEnum.BEGIN_PERIOD.getValue());
            filter.and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber());
            DynamicObject subjectMember = model.getDataEntity();
            filter.and("bodysystem.id", "=", (Object)subjectMember.getLong("bodysystem.id"));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }
}

