/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

public class BaseMemberTree {
    private Long id;
    private Long parentId;
    private String number;
    private String name;
    private int level;
    private boolean isLeaf;
    private List<BaseMemberTree> children;

    public BaseMemberTree() {
    }

    public BaseMemberTree(Long id, Long parentId, String number, String name, int level, boolean isLeaf) {
        this.id = id;
        this.parentId = parentId;
        this.number = number;
        this.name = name;
        this.level = level;
        this.isLeaf = isLeaf;
    }

    public static BaseMemberTree getInstanceFormDynamicObject(DynamicObject dynamicObject) {
        DynamicObject parentObject = dynamicObject.getDynamicObject("parent");
        Long id = (Long)dynamicObject.getPkValue();
        Long parentId = 0L;
        if (Objects.nonNull(parentObject)) {
            parentId = (Long)parentObject.getPkValue();
        }
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        int level = dynamicObject.getInt("level");
        boolean isLeaf = dynamicObject.getBoolean("isleaf");
        return new BaseMemberTree(id, parentId, number, name, level, isLeaf);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public List<BaseMemberTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<BaseMemberTree> children) {
        this.children = children;
    }

    public static List<BaseMemberTree> convertToBaseMemberTree(Collection<DynamicObject> dynamicObjects) {
        ArrayList<BaseMemberTree> baseMemberTreeList = new ArrayList<BaseMemberTree>(dynamicObjects.size());
        List dynamicObjectList = dynamicObjects.stream().sorted(Comparator.comparing(BaseMemberTree::getLevel)).collect(Collectors.toList());
        HashMap<Long, BaseMemberTree> baseMemberTreeMap = new HashMap<Long, BaseMemberTree>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjectList) {
            BaseMemberTree subjectTree = BaseMemberTree.getInstanceFormDynamicObject(dynamicObject);
            Long parentId = subjectTree.getParentId();
            if (EmptyUtil.isEmpty((Long)parentId)) {
                baseMemberTreeList.add(subjectTree);
            }
            if (baseMemberTreeMap.containsKey(parentId)) {
                BaseMemberTree parentSubjectTree = (BaseMemberTree)baseMemberTreeMap.get(parentId);
                List<BaseMemberTree> children = parentSubjectTree.getChildren();
                if (CollectionUtils.isEmpty(children)) {
                    children = new ArrayList<BaseMemberTree>(4);
                    parentSubjectTree.setChildren(children);
                }
                children.add(subjectTree);
            }
            baseMemberTreeMap.put(subjectTree.getId(), subjectTree);
        }
        return baseMemberTreeList;
    }

    private static int getLevel(DynamicObject dynamicObject) {
        return dynamicObject.getInt("level");
    }
}

