/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InoutDirectionType;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;

public class F7ListenerHelper {
    public static BeforeF7SelectListener inoutPollBeforeF7SelectListener(final IDataModel model, final IFormView formView) {
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
                BasedataProp property = (BasedataProp)basedataEdit.getProperty();
                String baseEntityId = property.getBaseEntityId();
                String key = basedataEdit.getKey();
                DynamicObject org = (DynamicObject)model.getValue("applyorg");
                switch (key) {
                    case "fundpurpose": 
                    case "feeproject": {
                        if (org == null) {
                            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u7ec4\u7ec7\u3002", (String)"F7ListenerHelper_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                            beforeF7SelectEvent.setCancel(true);
                            return null;
                        }
                        QFilter authOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)((Long)org.getPkValue()));
                        authOrgFilter = F7ListenerHelper.andFlowFilterIfNeed(key, authOrgFilter, model);
                        return 1.qFilterResultBuilder().qFilter(authOrgFilter).build();
                    }
                    case "settletype": 
                    case "currency": 
                    case "opusername": {
                        return 1.qFilterResultBuilder().build();
                    }
                    case "project": {
                        if (org == null) {
                            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u7ec4\u7ec7\u3002", (String)"F7ListenerHelper_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                            beforeF7SelectEvent.setCancel(true);
                            return null;
                        }
                        return 1.qFilterResultBuilder().qFilter(BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)((Long)org.getPkValue()))).build();
                    }
                }
                return null;
            }
        };
    }

    public static BeforeF7SelectListener sumPlanBeforeF7SelectListener(final IDataModel model, final IFormView formView) {
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
                String key = basedataEdit.getKey();
                DynamicObject bodySys = (DynamicObject)model.getValue("bodysys");
                if (Objects.isNull(bodySys)) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"F7ListenerHelper_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return null;
                }
                switch (key) {
                    case "sumreporttype": {
                        bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)bodySys.getPkValue()));
                        DynamicObjectCollection dynamicObjectCollection = bodySys.getDynamicObjectCollection("applyrereportentry");
                        List objectList = dynamicObjectCollection.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"enable", (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> dynamicObject.get("rerporttype.id")).collect(Collectors.toList());
                        return 2.qFilterResultBuilder().qFilter(new QFilter("id", "in", objectList)).build();
                    }
                    case "sum_currencymapcase": {
                        return 2.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", bodySys.getPkValue())).build();
                    }
                }
                return null;
            }
        };
    }

    private static QFilter andFlowFilterIfNeed(String key, QFilter authOrgFilter, IDataModel model) {
        if (!StringUtils.equals((CharSequence)key, (CharSequence)"fundpurpose")) {
            return authOrgFilter;
        }
        String value = (String)model.getValue("inoutdirection");
        if (EmptyUtil.isEmpty((String)value)) {
            return authOrgFilter;
        }
        String flow = "";
        if (StringUtils.equals((CharSequence)value, (CharSequence)InoutDirectionType.IN.getNumber())) {
            flow = "B";
        } else if (StringUtils.equals((CharSequence)value, (CharSequence)InoutDirectionType.OUT.getNumber())) {
            flow = "C";
        } else if (StringUtils.equals((CharSequence)value, (CharSequence)InoutDirectionType.OTHER.getNumber())) {
            flow = "A";
        }
        authOrgFilter = authOrgFilter.and("direction", "=", (Object)flow);
        return authOrgFilter;
    }
}

