/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.factory.LinkSearchSubParamFactory;
import kd.tmc.fpm.common.param.LinkSearchSubParam;
import kd.tmc.fpm.formplugin.report.LinkSubReportEdit;
import org.apache.commons.collections.CollectionUtils;

public class LinkSearchSubFormHelper {
    public static final String OPERATION_STATUS = "OperationStatus";

    public static void showForm(IFormView formView, DynamicObject dynamicObject, String showFormId, Map<String, Object> customParams) {
        FormShowParameter parentParameter;
        IFormView parentView = formView.getParentView();
        if (Objects.isNull(parentView) || !StringUtils.equals((CharSequence)(parentParameter = parentView.getFormShowParameter()).getFormId(), (CharSequence)"fpm_linksubreport")) {
            return;
        }
        OperationStatus status = OperationStatus.VIEW;
        FormShowParameter formShowParameter = new FormShowParameter();
        if (Objects.nonNull(customParams) && !customParams.isEmpty()) {
            formShowParameter.setCustomParams(customParams);
            Object operationStatus = customParams.get(OPERATION_STATUS);
            if (Objects.nonNull(operationStatus)) {
                status = OperationStatus.valueOf((String)operationStatus.toString());
            }
        }
        String paramClassName = (String)parentParameter.getCustomParam("LINK_SEARCH_SUB_PARAM");
        LinkSearchSubParam linkSearchSubReportParam = LinkSearchSubParamFactory.getLinkSearchSubReportParam((String)paramClassName);
        formShowParameter.setFormId(EmptyUtil.isEmpty((String)showFormId) ? (String)parentParameter.getCustomParam("FORM_ENTITY_NAME") : showFormId);
        formShowParameter.setCaption(linkSearchSubReportParam.getFormCaption(dynamicObject));
        formShowParameter.setCustomParam("report_id", dynamicObject.getPkValue());
        formShowParameter.setCustomParam("param_from_link_search_child", parentParameter.getCustomParam("param_from_link_search_child"));
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.setStatus(status);
        formShowParameter.getOpenStyle().setTargetKey("tabap");
        formShowParameter.setHasRight(true);
        formShowParameter.setParentPageId(parentView.getPageId());
        formShowParameter.setParentFormId(parentView.getFormShowParameter().getFormId());
        IPageCache pageCache = parentView.getPageCache();
        String pageIdsJsonStr = pageCache.get("pageids");
        Map<String, String> pageIds = StringUtils.isBlank((CharSequence)pageIdsJsonStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)pageIdsJsonStr, Map.class);
        String cacheKey = formShowParameter.getFormId() + '_' + dynamicObject.getPkValue();
        if (!pageIds.containsKey(cacheKey)) {
            pageIds.put(cacheKey, formShowParameter.getPageId());
        }
        pageCache.put("pageids", SerializationUtils.toJsonString(pageIds));
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin(LinkSubReportEdit.class.getName());
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, cacheKey));
        parentView.showForm(formShowParameter);
        formView.sendFormAction(parentView);
    }

    public static void removeListFilterContainerFilters(ListShowParameter listShowParameter, SetFilterEvent setFilterEvent) {
        Boolean isFormLinkSearchChild = (Boolean)listShowParameter.getCustomParam("param_from_link_search_child");
        if (isFormLinkSearchChild == null || !isFormLinkSearchChild.booleanValue()) {
            return;
        }
        Object source = setFilterEvent.getSource();
        if (source instanceof BillList) {
            ListFilterParameter listFilterParameter;
            FilterParameter queryFilterParameter;
            FilterParameter clientQueryFilterParameter;
            BillList billList = (BillList)source;
            ArrayList needRemoveList = new ArrayList();
            FilterParameter filterParameter = billList.getFilterParameter();
            if (CollectionUtils.isNotEmpty((Collection)filterParameter.getQFilters())) {
                needRemoveList.addAll(filterParameter.getQFilters());
            }
            if (CollectionUtils.isNotEmpty((Collection)(clientQueryFilterParameter = billList.getClientQueryFilterParameter()).getQFilters())) {
                needRemoveList.addAll(clientQueryFilterParameter.getQFilters());
            }
            if (CollectionUtils.isNotEmpty((Collection)(queryFilterParameter = billList.getQueryFilterParameter()).getQFilters())) {
                needRemoveList.addAll(queryFilterParameter.getQFilters());
            }
            if (CollectionUtils.isNotEmpty((Collection)(listFilterParameter = listShowParameter.getListFilterParameter()).getQFilters())) {
                needRemoveList.removeAll(listFilterParameter.getQFilters());
            }
            setFilterEvent.getQFilters().removeAll(needRemoveList);
        } else {
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            Set<String> collect = listFilterParameter.getQFilters().stream().map(QFilter::getProperty).collect(Collectors.toSet());
            LinkSearchSubFormHelper.filterFilter(collect, setFilterEvent.getQFilters());
            LinkSearchSubFormHelper.filterFilter(collect, setFilterEvent.getCustomQFilters());
            LinkSearchSubFormHelper.filterFilter(collect, setFilterEvent.getDataPermQFilters());
            LinkSearchSubFormHelper.filterFilter(collect, setFilterEvent.getBasedataCoreQFilters());
        }
        setFilterEvent.setMainOrgQFilter(null);
        setFilterEvent.setSpecialDataPermQFilter(null);
    }

    private static void filterFilter(Set<String> collect, List<QFilter> qFilters) {
        if (EmptyUtil.isEmpty(qFilters)) {
            return;
        }
        Iterator<QFilter> iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter next = iterator.next();
            if (EmptyUtil.isEmpty((Object)next) || collect.contains(next.getProperty())) continue;
            iterator.remove();
        }
    }

    public static void hideControl(IFormView iFormView, String ... controlKeys) {
        Boolean isFormLinkSearchChild = (Boolean)iFormView.getFormShowParameter().getCustomParam("param_from_link_search_child");
        if (isFormLinkSearchChild == null || !isFormLinkSearchChild.booleanValue()) {
            return;
        }
        iFormView.setVisible(Boolean.FALSE, controlKeys);
    }

    public static FormShowParameter createLinkSearchFormShow(LinkSearchFormParam linkSearchFormParam) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linksubreport");
        formShowParameter.setCustomParam("param_from_link_search_child", (Object)linkSearchFormParam.isLinkSearch());
        formShowParameter.setCustomParam("FORM_ENTITY_NAME", (Object)linkSearchFormParam.getFormId());
        formShowParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)linkSearchFormParam.getSearchFormNumber());
        formShowParameter.setCustomParam("ENTITY_IDS", linkSearchFormParam.getSearchIds());
        formShowParameter.setCustomParam("LIST_ENTITY_NAME", (Object)linkSearchFormParam.getListForm());
        formShowParameter.setCustomParam("LIST_FORM_ID", (Object)linkSearchFormParam.getListFormId());
        formShowParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)linkSearchFormParam.getLinkSearchSubTypeEnum().getType().getName());
        formShowParameter.setCaption(linkSearchFormParam.getCaption());
        Optional<Function<FormShowParameter, Void>> optional = Optional.ofNullable(linkSearchFormParam.getExtendFunction());
        optional.ifPresent(formShowParameterVoidFunction -> {
            Void cfr_ignored_0 = (Void)formShowParameterVoidFunction.apply(formShowParameter);
        });
        return formShowParameter;
    }

    public static class LinkSearchFormParamBuilder {
        private String formId;
        private String searchFormNumber;
        private List<Object> searchIds;
        private String listForm;
        private String listFormId;
        private boolean linkSearch = true;
        private LinkSearchSubTypeEnum linkSearchSubTypeEnum;
        private String caption;
        private Function<FormShowParameter, Void> extendFunction;

        public LinkSearchFormParamBuilder formId(String formId) {
            this.formId = formId;
            return this;
        }

        public LinkSearchFormParamBuilder searchFormNumber(String searchFormNumber) {
            this.searchFormNumber = searchFormNumber;
            return this;
        }

        public LinkSearchFormParamBuilder searchIds(List<Object> searchIds) {
            this.searchIds = searchIds;
            return this;
        }

        public LinkSearchFormParamBuilder listForm(String listForm) {
            this.listForm = listForm;
            return this;
        }

        public LinkSearchFormParamBuilder listFormId(String listFormId) {
            this.listFormId = listFormId;
            return this;
        }

        public LinkSearchFormParamBuilder linkSearch(boolean linkSearch) {
            this.linkSearch = linkSearch;
            return this;
        }

        public LinkSearchFormParamBuilder linkSearchSubTypeEnum(LinkSearchSubTypeEnum linkSearchSubTypeEnum) {
            this.linkSearchSubTypeEnum = linkSearchSubTypeEnum;
            return this;
        }

        public LinkSearchFormParamBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public LinkSearchFormParamBuilder extendFunction(Function<FormShowParameter, Void> extendFunction) {
            this.extendFunction = extendFunction;
            return this;
        }

        public LinkSearchFormParam build() {
            return new LinkSearchFormParam(this.formId, this.searchFormNumber, this.searchIds, this.listForm, this.listFormId, this.linkSearch, this.linkSearchSubTypeEnum, this.caption, this.extendFunction);
        }
    }

    public static class LinkSearchFormParam {
        private String formId;
        private String searchFormNumber;
        private List<Object> searchIds;
        private String listForm;
        private String listFormId;
        private boolean linkSearch = true;
        private LinkSearchSubTypeEnum linkSearchSubTypeEnum;
        private String caption;
        private Function<FormShowParameter, Void> extendFunction;

        public LinkSearchFormParam() {
        }

        public LinkSearchFormParam(String formId, String searchFormNumber, List<Object> searchIds, String listForm, String listFormId, boolean linkSearch, LinkSearchSubTypeEnum linkSearchSubTypeEnum, String caption, Function<FormShowParameter, Void> extendFunction) {
            this.formId = formId;
            this.searchFormNumber = searchFormNumber;
            this.searchIds = searchIds;
            this.listForm = listForm;
            this.listFormId = listFormId;
            this.linkSearch = linkSearch;
            this.linkSearchSubTypeEnum = linkSearchSubTypeEnum;
            this.caption = caption;
            this.extendFunction = extendFunction;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public String getSearchFormNumber() {
            return this.searchFormNumber;
        }

        public void setSearchFormNumber(String searchFormNumber) {
            this.searchFormNumber = searchFormNumber;
        }

        public List<Object> getSearchIds() {
            return this.searchIds;
        }

        public void setSearchIds(List<Object> searchIds) {
            this.searchIds = searchIds;
        }

        public String getListForm() {
            return this.listForm;
        }

        public void setListForm(String listForm) {
            this.listForm = listForm;
        }

        public String getListFormId() {
            return this.listFormId;
        }

        public void setListFormId(String listFormId) {
            this.listFormId = listFormId;
        }

        public boolean isLinkSearch() {
            return this.linkSearch;
        }

        public void setLinkSearch(boolean linkSearch) {
            this.linkSearch = linkSearch;
        }

        public LinkSearchSubTypeEnum getLinkSearchSubTypeEnum() {
            return this.linkSearchSubTypeEnum;
        }

        public void setLinkSearchSubTypeEnum(LinkSearchSubTypeEnum linkSearchSubTypeEnum) {
            this.linkSearchSubTypeEnum = linkSearchSubTypeEnum;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public Function<FormShowParameter, Void> getExtendFunction() {
            return this.extendFunction;
        }

        public void setExtendFunction(Function<FormShowParameter, Void> extendFunction) {
            this.extendFunction = extendFunction;
        }

        public static LinkSearchFormParamBuilder builder() {
            return new LinkSearchFormParamBuilder();
        }
    }
}

