/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportDataSourceType;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckParamDTO;

public class ReportRuleCheckHelper {
    public static List<ReportRuleCheckDTO> initRuleCheckDTO(List<VerifyReport> verifyReports, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit) {
        ReportRuleCheckParamDTO checkParam = new ReportRuleCheckParamDTO(ReportDataSourceType.REPORT, isFromCommit, isBatchCommit).setVerifyReports(verifyReports).setReportManagerJson(reportManagerJson);
        return verifyController.loadRule(checkParam);
    }

    public static List<ReportRuleCheckDTO> initRuleCheckDTOForSumPlan(Collection<DynamicObject> planSumList, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit) {
        Map<Long, DynamicObject> planSumMap = ReportRuleCheckHelper.getReportIdMap(planSumList, "originalreportids");
        if (planSumMap.isEmpty()) {
            return Collections.emptyList();
        }
        return ReportRuleCheckHelper.getReportRuleCheckDTOs(verifyController, ReportDataSourceType.REPORT_SUM, reportManagerJson, isBatchCommit, isFromCommit, planSumMap);
    }

    private static List<ReportRuleCheckDTO> getReportRuleCheckDTOs(IReportVerifyController verifyController, ReportDataSourceType dataSourceType, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit, Map<Long, DynamicObject> planSumMap) {
        ArrayList<ReportRuleCheckDTO> result = new ArrayList<ReportRuleCheckDTO>(planSumMap.size());
        QFilter qFilter = new QFilter("id", "in", planSumMap.keySet());
        DynamicObjectCollection reportObjs = QueryServiceHelper.query((String)"fpm_report", (String)"id,bodysys.id,template.reporttype", (QFilter[])qFilter.toArray());
        for (DynamicObject reportObj : reportObjs) {
            long reportId = reportObj.getLong("id");
            DynamicObject planSum = planSumMap.get(reportId);
            if (planSum == null) continue;
            ReportRuleCheckDTO checkDTO = new ReportRuleCheckDTO();
            checkDTO.setReportId(Long.valueOf(reportId));
            checkDTO.setRecordId(Long.valueOf(planSum.getLong("id")));
            checkDTO.setOrgId(Long.valueOf(planSum.getLong("reportorg.id")));
            checkDTO.setOrgName(planSum.getString("reportorg.name"));
            checkDTO.setReportTypeId(Long.valueOf(planSum.getLong("reporttype.id")));
            checkDTO.setReportPeriodId(Long.valueOf(planSum.getLong("reportperiod.id")));
            checkDTO.setReportPeriodName(planSum.getString("reportperiod.name"));
            checkDTO.setDataSourceType(dataSourceType);
            checkDTO.setReportManagerJson(reportManagerJson);
            checkDTO.setFromCommit(Boolean.valueOf(isFromCommit));
            checkDTO.setBatchCommit(Boolean.valueOf(isBatchCommit));
            checkDTO.setSystemId(Long.valueOf(reportObj.getLong("bodysys.id")));
            checkDTO.setTemplateType(reportObj.getString("template.reporttype"));
            result.add(checkDTO);
        }
        return result.stream().filter(item -> verifyController.loadRule(item, null)).collect(Collectors.toList());
    }

    private static List<ReportRuleCheckDTO> initRuleCheckDTO2(Collection<DynamicObject> reportList, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit, ReportDataSourceType dataSourceType) {
        String origReportIdProp = null;
        switch (dataSourceType) {
            case REPORT_SUM: {
                origReportIdProp = "originalreportids";
                break;
            }
            case REPORT_PLAN_CHANGE: {
                origReportIdProp = "originalreportids";
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        Map<Long, DynamicObject> reportIdMap = ReportRuleCheckHelper.getReportIdMap(reportList, origReportIdProp);
        if (reportIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        List verifyReports = new ReportRepository().getReportForVerifyRule(reportIdMap.keySet());
        ReportRuleCheckParamDTO checkParam = new ReportRuleCheckParamDTO(dataSourceType, isFromCommit, isBatchCommit).setReportManagerJson(reportManagerJson).setVerifyReports((Collection)verifyReports);
        List checkDTOS = verifyController.loadRule(checkParam);
        for (ReportRuleCheckDTO checkDTO : checkDTOS) {
            checkDTO.setReportId(Long.valueOf(reportIdMap.get(checkDTO.getReportId()).getLong("id")));
        }
        return checkDTOS;
    }

    private static Map<Long, DynamicObject> getReportIdMap(Collection<DynamicObject> reportList, String origReportIdProp) {
        HashMap<Long, DynamicObject> reportIdMap = new HashMap<Long, DynamicObject>(10);
        if (EmptyUtil.isEmpty((Collection)(reportList = (Collection)reportList.stream().filter(d -> !EmptyUtil.isEmpty((String)d.getString(origReportIdProp))).collect(Collectors.toList())))) {
            return reportIdMap;
        }
        for (DynamicObject planAdjust : reportList) {
            for (String reportId : planAdjust.getString(origReportIdProp).split(",")) {
                reportIdMap.put(Long.parseLong(reportId), planAdjust);
            }
        }
        return reportIdMap;
    }

    public static List<ReportRuleCheckDTO> initRuleCheckDTOForSumPlan2(Collection<DynamicObject> planSumList, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit) {
        return ReportRuleCheckHelper.initRuleCheckDTO2(planSumList, verifyController, reportManagerJson, isBatchCommit, isFromCommit, ReportDataSourceType.REPORT_SUM);
    }

    public static List<ReportRuleCheckDTO> initRuleCheckDTOForAdjustPlan(Collection<DynamicObject> planAdjustList, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit) {
        ArrayList<ReportRuleCheckDTO> result = new ArrayList<ReportRuleCheckDTO>();
        Map<Long, DynamicObject> planAdjustMap = ReportRuleCheckHelper.getReportIdMap(planAdjustList, "originalreportids");
        if (planAdjustMap.isEmpty()) {
            return result;
        }
        return ReportRuleCheckHelper.getReportRuleCheckDTOs(verifyController, ReportDataSourceType.REPORT_PLAN_CHANGE, reportManagerJson, isBatchCommit, isFromCommit, planAdjustMap);
    }

    public static List<ReportRuleCheckDTO> initRuleCheckDTOForAdjustPlan2(Collection<DynamicObject> planAdjustList, IReportVerifyController verifyController, String reportManagerJson, boolean isBatchCommit, boolean isFromCommit) {
        return ReportRuleCheckHelper.initRuleCheckDTO2(planAdjustList, verifyController, reportManagerJson, isBatchCommit, isFromCommit, ReportDataSourceType.REPORT_PLAN_CHANGE);
    }
}

