/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.formplugin.domain.BaseMemberTree;
import org.apache.commons.lang3.StringUtils;

public class SumPlanHelper {
    public static Set<Long> getSumOrgMemberRange(DynamicObject template) {
        return SumPlanHelper.getSumOrgMemberRange((Long)template.getDynamicObject("model").getPkValue(), template);
    }

    public static Set<Long> getSumOrgMemberRange(Long sysId, DynamicObject template) {
        DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("reporttype");
        List<Long> objectList = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList());
        Set<Long> allAuditOrgBySysId = SumPlanHelper.getAllAuditOrgBySysId(sysId, objectList);
        DynamicObject dynamicObject = template.getDynamicObjectCollection("layoutentry").stream().filter(dy -> Objects.equals(dy.getDynamicObject("layoutdim").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
        String memberScope = dynamicObject.getString("memberscope");
        if (StringUtils.equals((CharSequence)memberScope, (CharSequence)DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
            return SumPlanHelper.getFixMemberCommonUpperAndIntersectAllAudit(sysId, template, dynamicObject, allAuditOrgBySysId);
        }
        return allAuditOrgBySysId;
    }

    public static Set<Long> getFixMemberCommonUpperAndIntersectAllAudit(DynamicObject template) {
        Long sysId = (Long)template.getDynamicObject("model").getPkValue();
        DynamicObject dynamicObject = template.getDynamicObjectCollection("layoutentry").stream().filter(dy -> Objects.equals(dy.getDynamicObject("layoutdim").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
        Set<Long> allAuditOrgBySysId = SumPlanHelper.getAllAuditOrgBySysId(template);
        return SumPlanHelper.getFixMemberCommonUpperAndIntersectAllAudit(sysId, template, dynamicObject, allAuditOrgBySysId);
    }

    public static Set<Long> getFixMemberCommonUpperAndIntersectAllAudit(Long sysId, DynamicObject template, DynamicObject dynamicObject, Set<Long> auditOrgIdSet) {
        String memberScope = dynamicObject.getString("memberscope");
        if (!StringUtils.equals((CharSequence)memberScope, (CharSequence)DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
            return Collections.emptySet();
        }
        DynamicObject orgEntry = template.getDynamicObjectCollection("dimsettingentry").stream().filter(dy -> !dy.getBoolean("isdetaildim")).filter(dy -> Objects.equals(dy.getDynamicObject("dimbd").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
        Set<Long> fixedMemberRange = orgEntry.getDynamicObjectCollection("plantemplatemember").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toSet());
        Set<Long> togetherParent = SumPlanHelper.getCommonUpperAndIntersectAllAudit(sysId, auditOrgIdSet, fixedMemberRange);
        return togetherParent;
    }

    public static Set<Long> getCommonUpperAndIntersectAllAudit(Set<Long> allStatTemplateOrgMembers, DynamicObject template) {
        Long sysId = (Long)template.getDynamicObject("model").getPkValue();
        return SumPlanHelper.getCommonUpperAndIntersectAllAudit(sysId, SumPlanHelper.getAllAuditOrgBySysId(template), allStatTemplateOrgMembers);
    }

    public static Set<Long> getCommonUpperAndIntersectAllAudit(Long sysId, Set<Long> auditOrgIdSet, Set<Long> allStatTemplateOrgMembers) {
        String orgSelectFields = String.join((CharSequence)",", "id", "name", "number", "parent", "level", "isleaf");
        QFilter orgFilter = new QFilter("bodysystem", "=", (Object)sysId).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and("enable", "=", (Object)"1");
        DynamicObject[] orgDyArr = TmcDataServiceHelper.load((String)"fpm_member", (String)orgSelectFields, (QFilter[])new QFilter[]{orgFilter});
        Map<Long, BaseMemberTree> memberTreeMap = Arrays.stream(orgDyArr).map(dy -> BaseMemberTree.getInstanceFormDynamicObject(dy)).collect(Collectors.toMap(baseMemberTree -> baseMemberTree.getId(), Function.identity()));
        HashSet<Long> togetherParent = new HashSet<Long>(16);
        boolean init = true;
        for (Long orgId : allStatTemplateOrgMembers) {
            HashSet<Long> allParent = new HashSet<Long>(16);
            SumPlanHelper.getAllParent(allParent, orgId, memberTreeMap);
            if (init) {
                togetherParent.addAll(allParent);
                init = false;
                continue;
            }
            togetherParent.retainAll(allParent);
            if (!CollectionUtils.isEmpty(togetherParent)) continue;
            break;
        }
        if (!CollectionUtils.isEmpty(togetherParent)) {
            togetherParent.retainAll(auditOrgIdSet);
        }
        return togetherParent;
    }

    private static void getAllParent(Set<Long> allParent, Long orgId, Map<Long, BaseMemberTree> memberTreeMap) {
        if (EmptyUtil.isEmpty((Long)orgId)) {
            return;
        }
        allParent.add(orgId);
        BaseMemberTree baseMemberTree = memberTreeMap.get(orgId);
        Long parentId = baseMemberTree.getParentId();
        SumPlanHelper.getAllParent(allParent, parentId, memberTreeMap);
    }

    public static Set<Long> getAllAuditOrgBySysId(Long sysId, Collection<Long> reportTypes) {
        String entryOrgProp = String.join((CharSequence)".", "treeentryentity", "sum_reportorg");
        String entryIsSumAuditProp = String.join((CharSequence)".", "treeentryentity", "sum_issumaudit");
        String selectFields = String.join((CharSequence)",", "id", entryOrgProp, entryIsSumAuditProp);
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)sysId).and("enable", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(reportTypes)) {
            qFilter = qFilter.and(reportTypeProp, "in", reportTypes);
        }
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(load).flatMap(dy -> dy.getDynamicObjectCollection("treeentryentity").stream()).filter(dy -> dy.getBoolean("sum_issumaudit")).map(dy -> dy.getDynamicObject("sum_reportorg")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toSet());
    }

    public static Set<Long> getAllAuditOrgBySysId(DynamicObject template) {
        DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("reporttype");
        List<Long> objectList = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList());
        Long sysId = (Long)template.getDynamicObject("model").getPkValue();
        return SumPlanHelper.getAllAuditOrgBySysId(sysId, objectList);
    }
}

