/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.utils.system.DefaultModelHelper;
import org.apache.commons.collections.CollectionUtils;

public class PlanExecuteTrendAnalysisPlugin
extends AbstractFormPlugin {
    private static final String SELECT_BODY_SYS = "bodysys";
    private static final String SELECT_REPORT_TYPE = "reporttype";
    private static final String SELECT_REPORT_ORG = "reportorg";
    private static final String SELECT_SUBJECT_FLOW = "subjectflow";
    private static final String SELECT_CURRENCY = "currency";
    private static final String SELECT_AMT_UNIT = "amtunit";
    private static final String PERIODS = "periods";
    private static final String PLAN_AMOUNTS = "planAmounts";
    private static final String ACT_AMOUNTS = "actAmounts";
    private static final String BODY_SYS_CHANGE = "BODY_SYS_CHANGE";
    private static final String DEFAULT_PANEL = "defaultpanel";
    private static final String DATA_PANEL = "datapanel";
    private static Log LOGGER = LogFactory.getLog(PlanExecuteTrendAnalysisPlugin.class);

    public void initialize() {
        super.initialize();
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_report");
        if (EmptyUtil.isEmpty((Long)systemId)) {
            return;
        }
        this.initValueByBodySys(systemId);
    }

    private void initValueByBodySys(Long bodySysId) {
        DynamicObject targetCurrency;
        this.getPageCache().put(BODY_SYS_CHANGE, "Y");
        DynamicObject bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)bodySysId);
        if (Objects.isNull(bodySys)) {
            return;
        }
        this.getModel().setValue(SELECT_BODY_SYS, bodySys.getPkValue());
        Optional<DynamicObject> reportType = bodySys.getDynamicObjectCollection("applyrereportentry").stream().filter(item -> "enable".equals(item.getString("rereporttypestatus"))).map(item -> item.getDynamicObject("rerporttype")).sorted(Comparator.comparing(item -> this.getReportTypeScore(item.getString("orgreportcycle")))).findFirst();
        if (reportType.isPresent()) {
            this.getModel().setValue(SELECT_REPORT_TYPE, reportType.get().getPkValue());
        }
        if (Objects.isNull(targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", bodySys.getDynamicObject(SELECT_CURRENCY).getPkValue()), new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()), new QFilter("bodysystem", "=", bodySys.getPkValue())}))) {
            QFilter filter = new QFilter("bodysystem", "=", bodySys.getPkValue());
            DynamicObject member = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter});
            if (Objects.nonNull(member)) {
                this.getModel().setValue(SELECT_CURRENCY, member.get("id"));
            }
        } else {
            this.getModel().setValue(SELECT_CURRENCY, (Object)targetCurrency.getLong("id"));
        }
        this.getPageCache().put(BODY_SYS_CHANGE, "N");
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = ModelHelper.getOrgAuthScopeBySystemId((String)appId, (String)"fpm_report", (Long)((Long)bodySys.getPkValue()));
        if (CollectionUtils.isNotEmpty((Collection)orgIds)) {
            this.getModel().setValue(SELECT_REPORT_ORG, orgIds.get(0));
        } else {
            this.getModel().setValue(SELECT_REPORT_ORG, null);
        }
        this.initViewAndData();
    }

    private void initF7() {
        this.initBodySys();
        this.initReportType();
        this.initReportOrg();
        this.initCurrency();
    }

    private void initCurrency() {
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl(SELECT_CURRENCY);
        currencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySystem = this.getModel().getDataEntity().getDynamicObject(SELECT_BODY_SYS);
            if (Objects.isNull(bodySystem)) {
                this.showBodySysNotify();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("bodysystem", "=", bodySystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
    }

    private void initReportOrg() {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(SELECT_REPORT_ORG);
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySystem = this.getModel().getDataEntity().getDynamicObject(SELECT_BODY_SYS);
            if (Objects.isNull(bodySystem)) {
                this.showBodySysNotify();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("bodysystem", "=", bodySystem.getPkValue());
            String appId = this.getView().getFormShowParameter().getAppId();
            filter.and(ModelHelper.getOrgAuthFilter((String)appId, (String)"fpm_report"));
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
    }

    private void initReportType() {
        BasedataEdit reportType = (BasedataEdit)this.getControl(SELECT_REPORT_TYPE);
        reportType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject(SELECT_BODY_SYS);
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotify();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            bodySys = TmcDataServiceHelper.loadSingleFromCache((Object)bodySys.getPkValue(), (String)"fpm_bodysysmanage");
            DynamicObjectCollection dynamicObjectCollection = bodySys.getDynamicObjectCollection("applyrereportentry");
            List objectList = dynamicObjectCollection.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"enable", (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> dynamicObject.getDynamicObject("rerporttype")).sorted(Comparator.comparing(dy -> this.getReportTypeScore(dy.getString("orgreportcycle")))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", objectList).and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void showBodySysNotify() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"PlanExecuteTrendAnalysisPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private int getReportTypeScore(String reportCycle) {
        if (Objects.equals(OrgReportTypeCycleEnum.MONTH.getValue(), reportCycle)) {
            return 0;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportCycle)) {
            return 1;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.DAY.getValue(), reportCycle)) {
            return 2;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.QUARTER.getValue(), reportCycle)) {
            return 3;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.HALFYEAR.getValue(), reportCycle)) {
            return 4;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.YEAR.getValue(), reportCycle)) {
            return 5;
        }
        return 6;
    }

    private void initBodySys() {
        BasedataEdit bodySystemEdit = (BasedataEdit)this.getControl(SELECT_BODY_SYS);
        bodySystemEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            showParameter.getListFilterParameter().setFilter(ModelHelper.getSystemAuthWithCheckManagerFilter((String)appId, (String)"fpm_report"));
            showParameter.setShowTitle(false);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "bodysys": {
                ChangeData[] changeSet = e.getChangeSet();
                if (Objects.isNull(changeSet) || changeSet.length == 0) {
                    return;
                }
                ChangeData changeData = changeSet[0];
                Object newValue = changeData.getNewValue();
                if (Objects.isNull(newValue)) {
                    return;
                }
                long systemId = ((DynamicObject)newValue).getLong("id");
                this.initValueByBodySys(systemId);
                DefaultModelHelper.save(systemId);
                break;
            }
            case "reporttype": 
            case "reportorg": 
            case "subjectflow": 
            case "currency": 
            case "amtunit": {
                if (Objects.equals(this.getPageCache().get(BODY_SYS_CHANGE), "Y")) {
                    return;
                }
                this.initViewAndData();
                break;
            }
        }
    }

    private void initViewAndData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{DEFAULT_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{DATA_PANEL});
        if (!this.validateSearchParam()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DEFAULT_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{DATA_PANEL});
            return;
        }
        this.initView();
    }

    private Map<String, Object> queryDataAndFormat() {
        QueryCondition queryCondition = this.getQueryCondition();
        DataSet dataSet = this.queryData(queryCondition);
        List<DataSum> dataSums = this.convertDataSumList(dataSet, queryCondition);
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{dataSet});
        LOGGER.info("\u67e5\u8be2\u7ed3\u679c:{}", dataSums);
        List<DataSum> dataSumList = this.summaryDataSum(dataSums);
        return this.formatData(dataSumList, queryCondition.getPeriodList());
    }

    private DataSet queryData(QueryCondition queryCondition) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        this.convertToFilter(qFilterList, queryCondition);
        LOGGER.info("\u67e5\u8be2\u6761\u4ef6:{}", (Object)queryCondition);
        LOGGER.info("\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", qFilterList);
        Set entryPropertySet = FpmHelper.getEntryPropertyS((String)"fpm_report", (String)"maindimentry");
        String idProp = String.join((CharSequence)".", "maindimentry", "id");
        entryPropertySet.add(idProp);
        entryPropertySet.add("id");
        DataSet mainEntryDataSet = QueryServiceHelper.queryDataSet((String)"PlanExecuteTrendAnalysisPlugin.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"");
        return mainEntryDataSet;
    }

    private Map<String, Object> formatData(List<DataSum> summaryDataSumList, List<Period> periodList) {
        int number = periodList.size();
        Map periodDataSumMap = summaryDataSumList.stream().collect(Collectors.toMap(dataSum -> dataSum.getPeriod().getId(), Function.identity()));
        String[] periods = new String[number];
        Number[] planAmounts = new Number[number];
        Number[] actAmounts = new Number[number];
        for (int i = 0; i < periodList.size(); ++i) {
            Period period = periodList.get(i);
            DataSum dataSum2 = (DataSum)periodDataSumMap.get(period.getId());
            periods[i] = period.getName();
            planAmounts[i] = BigDecimal.ZERO;
            actAmounts[i] = BigDecimal.ZERO;
            if (dataSum2 == null) continue;
            planAmounts[i] = dataSum2.getPlanAmt();
            actAmounts[i] = dataSum2.getActAmt();
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>(8);
        objectMap.put(PERIODS, periods);
        objectMap.put(PLAN_AMOUNTS, planAmounts);
        objectMap.put(ACT_AMOUNTS, actAmounts);
        return objectMap;
    }

    private List<DataSum> summaryDataSum(List<DataSum> sumList) {
        Map<Period, List<DataSum>> groupByPeriod = sumList.stream().collect(Collectors.groupingBy(DataSum::getPeriod));
        ArrayList<DataSum> summaryDataSumList = new ArrayList<DataSum>(groupByPeriod.size());
        for (Map.Entry<Period, List<DataSum>> entry : groupByPeriod.entrySet()) {
            List<DataSum> dataSumList = entry.getValue();
            if (CollectionUtils.isEmpty(dataSumList)) continue;
            DataSum dataSum = dataSumList.get(0);
            for (DataSum data : dataSumList) {
                if (data == dataSum) continue;
                dataSum.addPlanAmt(data.getPlanAmt(), data.getAmountUnit());
                dataSum.addActAmt(data.getActAmt(), data.getAmountUnit());
            }
            summaryDataSumList.add(dataSum);
        }
        return summaryDataSumList;
    }

    private List<DataSum> convertDataSumList(DataSet reportDataDataSet, QueryCondition queryCondition) {
        List<Period> periodList = queryCondition.getPeriodList();
        Map periodMap = periodList.stream().collect(Collectors.toMap(Period::getId, Function.identity()));
        Map<Long, Long> orgAllChildWithTopMap = this.getDimMemberTopMap(DimensionType.ORG, true, true);
        Map<Long, Long> reportPeriodMap = this.getAllReportPeriodMap(reportDataDataSet);
        HashMap<String, DataSum> dataSumMap = new HashMap<String, DataSum>(16);
        while (reportDataDataSet.hasNext()) {
            Row row = reportDataDataSet.next();
            Long reportOrgId = row.getLong(String.join((CharSequence)".", "maindimentry", "orgmem"));
            Long topSubjectId = row.getLong(String.join((CharSequence)".", "maindimentry", "subjectmem"));
            Long topReportOrgId = orgAllChildWithTopMap.get(reportOrgId);
            if (EmptyUtil.isEmpty((Long)topReportOrgId)) {
                LOGGER.error("\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u9876\u7ea7\u7f16\u62a5\u4e3b\u4f53id\u4e3a\u7a7a", (Object)reportOrgId);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53\uff1a\u3010%1$s\u3011\uff0c\u9876\u7ea7\u7f16\u62a5\u4e3b\u4f53id\u4e3a\u7a7a", (String)"PlanExecuteTrendAnalysisPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), reportOrgId));
            }
            Long reportPeriodId = row.getLong(String.join((CharSequence)".", "maindimentry", "entryreportperiod"));
            Long reportDetailId = row.getLong(String.join((CharSequence)".", "maindimentry", "periodmem"));
            if (!Objects.equals(reportDetailId, reportPeriodId)) {
                Long parentId = reportPeriodMap.get(reportDetailId);
                if (Objects.equals(parentId, reportPeriodId)) {
                    LOGGER.info("\u660e\u7ec6\u671f\u95f4:{},\u5c5e\u4e8e\u7f16\u62a5\u671f\u95f4:{}", (Object)reportDetailId, (Object)reportPeriodId);
                    continue;
                }
                if (periodMap.get(reportDetailId) == null) {
                    LOGGER.info("\u671f\u95f4\uff1a{},\u4e0d\u5728\u67e5\u8be2\u671f\u95f4\u8303\u56f4\u5185", (Object)reportDetailId);
                    continue;
                }
            }
            String key = String.join((CharSequence)"_", topReportOrgId.toString(), topSubjectId.toString(), reportPeriodId.toString(), reportDetailId.toString());
            Period detailPeriod = (Period)periodMap.get(reportDetailId);
            DataSum dataSum2 = dataSumMap.computeIfAbsent(key, k -> {
                Period period = (Period)periodMap.get(reportPeriodId);
                return new DataSum(topReportOrgId, topSubjectId, queryCondition.getCurrencyId(), period, detailPeriod, queryCondition.getAmountUnit());
            });
            BigDecimal planAmt = row.getBigDecimal(String.join((CharSequence)".", "maindimentry", "planamt"));
            String amountUnitStr = row.getString(String.join((CharSequence)".", "maindimentry", "amountunit"));
            AmountUnit amountUnit = AmountUnit.getByNumber((String)amountUnitStr);
            dataSum2.addPlanAmt(planAmt, amountUnit);
            BigDecimal actAmt = row.getBigDecimal(String.join((CharSequence)".", "maindimentry", "realamt"));
            dataSum2.addActAmt(actAmt, amountUnit);
        }
        Map<Period, List<DataSum>> periodListMap = dataSumMap.entrySet().stream().map(Map.Entry::getValue).filter(dataSum -> !Objects.equals(dataSum.getPeriod(), dataSum.getDetailPeriod())).collect(Collectors.groupingBy(DataSum::getDetailPeriod));
        List<DataSum> dataSumList = dataSumMap.entrySet().stream().map(Map.Entry::getValue).filter(dataSum -> Objects.equals(dataSum.getPeriod(), dataSum.getDetailPeriod())).collect(Collectors.toList());
        Set detailPeriodSet = dataSumList.stream().map(DataSum::getDetailPeriod).collect(Collectors.toSet());
        for (Map.Entry<Period, List<DataSum>> entry : periodListMap.entrySet()) {
            Period detailPeriod = entry.getKey();
            if (detailPeriodSet.contains(detailPeriod)) {
                LOGGER.info("\u671f\u95f4:{},\u7f16\u5236\u4e86\u671f\u95f4\u81ea\u8eab\u7684\u6570\u636e\uff0c\u5ffd\u7565\u5386\u53f2\u6240\u6709\u7684\u6eda\u52a8\u6570\u636e", (Object)detailPeriod.getName());
                continue;
            }
            List<DataSum> value = entry.getValue();
            List sumList = value.stream().sorted(Comparator.comparing(dataSum -> dataSum.getPeriod().getStartDate())).collect(Collectors.toList());
            DataSum finalDataSum = (DataSum)sumList.get(sumList.size() - 1);
            for (DataSum dataSum3 : sumList) {
                if (dataSum3 == finalDataSum || !Objects.equals(dataSum3.getPeriod(), finalDataSum.getPeriod())) continue;
                finalDataSum.addPlanAmt(dataSum3.getPlanAmt(), dataSum3.getAmountUnit());
                finalDataSum.addActAmt(dataSum3.getActAmt(), dataSum3.getAmountUnit());
            }
            finalDataSum.setPeriod(finalDataSum.getDetailPeriod());
            dataSumList.add(finalDataSum);
        }
        return dataSumList;
    }

    private Map<Long, Long> getAllReportPeriodMap(DataSet reportDataDataSet) {
        DataSet copy = reportDataDataSet.copy();
        HashSet<Long> periodIds = new HashSet<Long>(32);
        while (copy.hasNext()) {
            Row next = copy.next();
            Long reportDetailId = next.getLong(String.join((CharSequence)".", "maindimentry", "periodmem"));
            periodIds.add(reportDetailId);
        }
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{copy});
        String selectFields = String.join((CharSequence)",", "id", "parent");
        DynamicObjectCollection reportPeriodColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", periodIds)});
        return reportPeriodColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("parent")));
    }

    private void convertToFilter(List<QFilter> qFilterList, QueryCondition queryCondition) {
        Long systemId = queryCondition.getSystemId();
        qFilterList.add(new QFilter(SELECT_BODY_SYS, "=", (Object)systemId));
        Set<Long> reportOrgIds = queryCondition.getReportOrgIds();
        if (CollectionUtils.isNotEmpty(reportOrgIds)) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", SELECT_REPORT_ORG, "id"), "in", reportOrgIds));
        }
        Set reportPeriodIds = queryCondition.getPeriodList().stream().map(Period::getId).collect(Collectors.toSet());
        qFilterList.add(new QFilter(String.join((CharSequence)".", "reportperiod", "id"), "in", reportPeriodIds));
        qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "currencymem", "id"), "=", (Object)queryCondition.getCurrencyId()));
        String subjectFlow = queryCondition.getSubjectFlow();
        Set<Long> topSubjectIdByFlow = this.getTopSubjectIdByFlow(subjectFlow);
        qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "subjectmem", "id"), "in", topSubjectIdByFlow));
        qFilterList.add(new QFilter("planstatus", "=", (Object)"B"));
        qFilterList.add(new QFilter("maindimentry.maintable", "=", (Object)"1"));
    }

    private Set<Long> getTopSubjectIdByFlow(String subjectFlow) {
        HashSet<Long> topFlowSubjectIdSet = new HashSet<Long>(16);
        List<DynamicObject> dimensionMember = this.getDimensionMember(DimensionType.SUBJECTS, "flow", "name");
        HashSet<Long> flowSubjectIds = new HashSet<Long>(dimensionMember.size());
        for (DynamicObject dynamicObject : dimensionMember) {
            DynamicObject parent = dynamicObject.getDynamicObject("parent");
            Long id = dynamicObject.getLong("id");
            String flow = dynamicObject.getString("flow");
            String subjectName = dynamicObject.getString("name");
            if (parent == null) {
                if (Objects.equals(flow, subjectFlow)) {
                    LOGGER.info("\u9876\u7ea7\u79d1\u76ee\uff1a{}\uff0c\u6d41\u5411\uff1a{}\u8ddf\u6761\u4ef6\u6d41\u5411:{}\u4e00\u81f4", new Object[]{subjectName, flow, subjectFlow});
                    topFlowSubjectIdSet.add(id);
                    flowSubjectIds.add(id);
                }
                LOGGER.info("\u9876\u7ea7\u79d1\u76ee\uff1a{}\uff0c\u6d41\u5411\uff1a{}\u8ddf\u6761\u4ef6\u6d41\u5411:{}\u4e0d\u4e00\u81f4", new Object[]{subjectName, flow, subjectFlow});
                continue;
            }
            Long parentId = (Long)parent.getPkValue();
            if (flowSubjectIds.contains(parentId)) {
                flowSubjectIds.add(id);
                LOGGER.info("\u79d1\u76ee\uff1a{},\u5df2\u627e\u5230\u6d41\u5411\uff1a{}\u7684\u4e0a\u7ea7\u79d1\u76ee\uff1a{},\u6240\u6709\u5bf9\u5e94\u6d41\u5411\u7684\u4e0a\u7ea7\u79d1\u76ee:{}", new Object[]{subjectName, flow, parent.getString("name"), flowSubjectIds});
                continue;
            }
            if (!Objects.equals(flow, subjectFlow)) continue;
            LOGGER.info("\u79d1\u76ee\uff1a{}\u4e3a\u6d41\u5411\uff1a{}\u7684\u9876\u7ea7\u79d1\u76ee", (Object)subjectName, (Object)subjectFlow);
            topFlowSubjectIdSet.add(id);
            flowSubjectIds.add(id);
        }
        return topFlowSubjectIdSet;
    }

    private Map<Long, Long> getDimMemberTopMap(DimensionType dimensionType, boolean needAllChild, boolean needTop) {
        List<DynamicObject> objectList = this.getDimensionMember(dimensionType, new String[0]);
        HashMap<Long, Set> topWithLeafChildMap = new HashMap<Long, Set>(16);
        HashMap<Long, Long> notLeafChildWithTopMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : objectList) {
            DynamicObject parent = dynamicObject.getDynamicObject("parent");
            Long id = dynamicObject.getLong("id");
            if (EmptyUtil.isEmpty((DynamicObject)parent)) {
                topWithLeafChildMap.computeIfAbsent(id, key -> new HashSet(64));
                if (!needTop) continue;
                notLeafChildWithTopMap.put(id, id);
                continue;
            }
            Long parentId = (Long)parent.getPkValue();
            boolean isLeaf = dynamicObject.getBoolean("isleaf");
            if (isLeaf) {
                Set leafChildSet = (Set)topWithLeafChildMap.get(parentId);
                if (leafChildSet == null) {
                    Long topId = (Long)notLeafChildWithTopMap.get(parentId);
                    leafChildSet = (Set)topWithLeafChildMap.get(topId);
                    if (leafChildSet == null) continue;
                    leafChildSet.add(id);
                    continue;
                }
                leafChildSet.add(id);
                continue;
            }
            Long topId = (Long)notLeafChildWithTopMap.get(parentId);
            if (EmptyUtil.isEmpty((Long)topId)) {
                notLeafChildWithTopMap.put(id, parentId);
                continue;
            }
            notLeafChildWithTopMap.put(id, topId);
        }
        HashMap<Long, Long> leafChildWithTopMap = new HashMap<Long, Long>(128);
        for (Map.Entry entry : topWithLeafChildMap.entrySet()) {
            for (Long leafChild : (Set)entry.getValue()) {
                leafChildWithTopMap.put(leafChild, (Long)entry.getKey());
            }
        }
        if (needAllChild) {
            leafChildWithTopMap.putAll(notLeafChildWithTopMap);
        }
        return leafChildWithTopMap;
    }

    private List<DynamicObject> getDimensionMember(DimensionType dimensionType, String ... extendSelectFields) {
        Object pkValue = this.getModel().getDataEntity().getDynamicObject(SELECT_BODY_SYS).getPkValue();
        QFilter qFilter = new QFilter("dimtype", "=", (Object)dimensionType.getNumber()).and("bodysystem", "=", pkValue);
        String selectFields = String.join((CharSequence)",", "id", "parent", "isleaf", "level");
        if (extendSelectFields != null && extendSelectFields.length != 0) {
            String join = String.join((CharSequence)",", extendSelectFields);
            selectFields = String.join((CharSequence)",", selectFields, join);
        }
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        List<DynamicObject> objectList = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getInt("level"))).collect(Collectors.toList());
        return objectList;
    }

    private void initView() {
        CustomChart chart = (CustomChart)this.getControl("chart");
        chart.clearData();
        chart.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u6267\u884c\u4e0e\u8d8b\u52bf\u5206\u6790", (String)"PlanExecuteTrendAnalysisPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTitle(false);
        String amtUnit = this.getModel().getDataEntity().getString(SELECT_AMT_UNIT);
        AmountUnit amountUnit = AmountUnit.getByNumber((String)amtUnit);
        Axis xAxis = chart.createXAxis("", AxisType.category);
        Axis yAxis = chart.createYAxis(amountUnit.getName(), AxisType.value);
        HashMap<String, String> yAxisStyle = new HashMap<String, String>(2);
        yAxisStyle.put("align", "left");
        yAxis.setPropValue("nameTextStyle", yAxisStyle);
        Map<String, Object> dataMap = this.queryDataAndFormat();
        xAxis.setCategorys((String[])dataMap.get(PERIODS));
        LineSeries line = chart.createLineSeries(ResManager.loadKDString((String)"\u8ba1\u5212\u989d\u5ea6", (String)"PlanExecuteTrendAnalysisPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        line.setLineColor("#63CBDB");
        line.setItemColor("#63CBDB");
        line.setSmooth(true);
        line.setData((Number[])dataMap.get(PLAN_AMOUNTS));
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dashed");
        lineStyle.put("color", "#63CBDB");
        lineStyle.put("opacity", "0.3");
        line.setPropValue("lineStyle", lineStyle);
        BarSeries planAmtBar = chart.createBarSeries(ResManager.loadKDString((String)"\u8ba1\u5212\u989d\u5ea6", (String)"PlanExecuteTrendAnalysisPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        planAmtBar.setData((Number[])dataMap.get(PLAN_AMOUNTS));
        planAmtBar.setColor("#63CBDB");
        BarSeries actAmtBar = chart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u989d\u5ea6", (String)"PlanExecuteTrendAnalysisPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        actAmtBar.setData((Number[])dataMap.get(ACT_AMOUNTS));
        actAmtBar.setColor("#68A4FF");
        chart.setShowTooltip(true);
        chart.setLegendPropValue("left", (Object)"center");
        chart.setLegendPropValue("top", (Object)0);
        chart.setMargin(Position.top, "34");
        chart.bindData(null);
    }

    private boolean validateSearchParam() {
        return Objects.nonNull(this.getModel().getValue(SELECT_BODY_SYS)) && Objects.nonNull(this.getModel().getValue(SELECT_REPORT_TYPE)) && Objects.nonNull(this.getModel().getValue(SELECT_SUBJECT_FLOW)) && Objects.nonNull(this.getModel().getValue(SELECT_REPORT_ORG)) && Objects.nonNull(this.getModel().getValue(SELECT_CURRENCY)) && Objects.nonNull(this.getModel().getValue(SELECT_AMT_UNIT));
    }

    private List<Period> getReportPeriodListByReportTypeFromCurrent() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject bodySys = dataEntity.getDynamicObject(SELECT_BODY_SYS);
        DynamicObject reportType = dataEntity.getDynamicObject(SELECT_REPORT_TYPE);
        if (Objects.isNull(bodySys) || Objects.isNull(reportType)) {
            return Collections.emptyList();
        }
        reportType = QueryServiceHelper.queryOne((String)"fpm_orgreporttype", (String)"id,orgreportcycle", (QFilter[])new QFilter("id", "=", reportType.getPkValue()).toArray());
        String reportCycle = reportType.getString("orgreportcycle");
        Date date = new Date();
        AtomicInteger count = new AtomicInteger(0);
        Date prevEndDate = this.getPervEndDate(date, reportCycle, count);
        int periodCount = count.get();
        QFilter qFilter = new QFilter("bodysystem", "=", bodySys.getPkValue()).and(SELECT_REPORT_TYPE, "=", reportType.get("id")).and("periodtype", "=", (Object)reportCycle).and(new QFilter("startdate", ">=", (Object)prevEndDate).and("enddate", "<", (Object)date).or(new QFilter("startdate", "<=", (Object)date).and("enddate", ">=", (Object)date)));
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "startdate", "name"), (QFilter[])new QFilter[]{qFilter});
        List periodList = load.stream().sorted(Comparator.comparing(d -> d.getDate("startdate"))).map(dynamicObject -> new Period(dynamicObject.getLong("id"), dynamicObject.getDate("startdate"), dynamicObject.getString("name"))).collect(Collectors.toList());
        for (int i = 0; i < periodList.size() - periodCount; ++i) {
            periodList.set(i, null);
        }
        return periodList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private QueryCondition getQueryCondition() {
        QueryCondition queryCondition = new QueryCondition();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long systemId = (Long)dataEntity.getDynamicObject(SELECT_BODY_SYS).getPkValue();
        queryCondition.setSystemId(systemId);
        queryCondition.setReportTypeId((Long)dataEntity.getDynamicObject(SELECT_REPORT_TYPE).getPkValue());
        queryCondition.setPeriodList(this.getReportPeriodListByReportTypeFromCurrent());
        DynamicObject orgObj = dataEntity.getDynamicObject(SELECT_REPORT_ORG);
        HashSet<Long> reportOrgIds = new HashSet<Long>();
        reportOrgIds.add((Long)orgObj.getPkValue());
        queryCondition.setReportOrgIds(reportOrgIds);
        queryCondition.setSubjectFlow(dataEntity.getString(SELECT_SUBJECT_FLOW));
        queryCondition.setCurrencyId((Long)dataEntity.getDynamicObject(SELECT_CURRENCY).getPkValue());
        queryCondition.setAmountUnit(AmountUnit.getByNumber((String)dataEntity.getString(SELECT_AMT_UNIT)));
        return queryCondition;
    }

    private Date getPervEndDate(Date date, String reportCycle, AtomicInteger count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        count.set(12);
        if (Objects.equals(OrgReportTypeCycleEnum.MONTH.getValue(), reportCycle)) {
            this.prevTime(calendar, 2, count.get());
        }
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportCycle)) {
            this.prevTime(calendar, 4, count.get());
        }
        if (Objects.equals(OrgReportTypeCycleEnum.TEN.getValue(), reportCycle)) {
            this.prevTime(calendar, 5, count.get() * 10);
        }
        if (Objects.equals(OrgReportTypeCycleEnum.QUARTER.getValue(), reportCycle)) {
            this.prevTime(calendar, 2, count.get() * 3);
        }
        if (Objects.equals(OrgReportTypeCycleEnum.DAY.getValue(), reportCycle)) {
            count.set(15);
            this.prevTime(calendar, 5, count.get());
        }
        if (Objects.equals(OrgReportTypeCycleEnum.HALFYEAR.getValue(), reportCycle)) {
            this.prevTime(calendar, 2, count.get() * 6);
        }
        if (Objects.equals(OrgReportTypeCycleEnum.YEAR.getValue(), reportCycle)) {
            count.set(5);
            this.prevTime(calendar, 1, count.get());
        }
        return calendar.getTime();
    }

    private void prevTime(Calendar calendar, int field, int periods) {
        calendar.add(field, -periods);
    }

    static class Period {
        private Long id;
        private Date startDate;
        private String name;

        public Period(Long id, Date startDate, String name) {
            this.id = id;
            this.startDate = startDate;
            this.name = name;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Period{id=" + this.id + ", startDate=" + this.startDate + ", name='" + this.name + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Period period = (Period)o;
            return Objects.equals(this.id, period.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    static class DataSum {
        private Long topReportOrgId;
        private Long topSubjectId;
        private Long currencyId;
        private Period period;
        private Period detailPeriod;
        private AmountUnit amountUnit;
        private BigDecimal planAmt;
        private BigDecimal actAmt;

        public DataSum(Long topReportOrgId, Long topSubjectId, Long currencyId, Period period, Period detailPeriod, AmountUnit amountUnit) {
            this.topReportOrgId = topReportOrgId;
            this.topSubjectId = topSubjectId;
            this.currencyId = currencyId;
            this.amountUnit = amountUnit;
            this.period = period;
            this.detailPeriod = detailPeriod;
            this.planAmt = BigDecimal.ZERO;
            this.actAmt = BigDecimal.ZERO;
        }

        public Long getTopReportOrgId() {
            return this.topReportOrgId;
        }

        public void setTopReportOrgId(Long topReportOrgId) {
            this.topReportOrgId = topReportOrgId;
        }

        public Long getTopSubjectId() {
            return this.topSubjectId;
        }

        public void setTopSubjectId(Long topSubjectId) {
            this.topSubjectId = topSubjectId;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public AmountUnit getAmountUnit() {
            return this.amountUnit;
        }

        public void setAmountUnit(AmountUnit amountUnit) {
            this.amountUnit = amountUnit;
        }

        public BigDecimal getPlanAmt() {
            return this.planAmt;
        }

        public void setPlanAmt(BigDecimal planAmt) {
            this.planAmt = planAmt;
        }

        public BigDecimal getActAmt() {
            return this.actAmt;
        }

        public void setActAmt(BigDecimal actAmt) {
            this.actAmt = actAmt;
        }

        public Period getPeriod() {
            return this.period;
        }

        public void setPeriod(Period period) {
            this.period = period;
        }

        public Period getDetailPeriod() {
            return this.detailPeriod;
        }

        public void setDetailPeriod(Period detailPeriod) {
            this.detailPeriod = detailPeriod;
        }

        public void addPlanAmt(BigDecimal planAmt, AmountUnit amountUnit) {
            planAmt = this.convertAmountUnit(planAmt, amountUnit);
            this.planAmt = this.planAmt.add(planAmt);
        }

        public void addActAmt(BigDecimal actAmt, AmountUnit amountUnit) {
            actAmt = this.convertAmountUnit(actAmt, amountUnit);
            this.actAmt = this.actAmt.add(actAmt);
        }

        private BigDecimal convertAmountUnit(BigDecimal amount, AmountUnit amountUnit) {
            if (this.amountUnit == amountUnit) {
                return amount;
            }
            return AmountUtil.convert((AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)this.amountUnit.name())), (BigDecimal)amount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataSum dataSum = (DataSum)o;
            return Objects.equals(this.topReportOrgId, dataSum.topReportOrgId) && Objects.equals(this.topSubjectId, dataSum.topSubjectId);
        }

        public int hashCode() {
            return Objects.hash(this.topReportOrgId, this.topSubjectId);
        }

        public String toString() {
            return "DataSum{topReportOrgId=" + this.topReportOrgId + ", topSubjectId=" + this.topSubjectId + ", currencyId=" + this.currencyId + ", period=" + this.period + ", detailPeriod=" + this.detailPeriod + ", amountUnit=" + this.amountUnit + ", planAmt=" + this.planAmt + ", actAmt=" + this.actAmt + '}';
        }
    }

    static class QueryCondition {
        private Long systemId;
        private Long reportTypeId;
        private Set<Long> reportOrgIds = new HashSet<Long>(16);
        private String subjectFlow;
        private Long currencyId;
        private AmountUnit amountUnit;
        private List<Period> periodList;

        QueryCondition() {
        }

        public Long getSystemId() {
            return this.systemId;
        }

        public void setSystemId(Long systemId) {
            this.systemId = systemId;
        }

        public Long getReportTypeId() {
            return this.reportTypeId;
        }

        public void setReportTypeId(Long reportTypeId) {
            this.reportTypeId = reportTypeId;
        }

        public Set<Long> getReportOrgIds() {
            return this.reportOrgIds;
        }

        public void setReportOrgIds(Set<Long> reportOrgIds) {
            this.reportOrgIds = reportOrgIds;
        }

        public String getSubjectFlow() {
            return this.subjectFlow;
        }

        public void setSubjectFlow(String subjectFlow) {
            this.subjectFlow = subjectFlow;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public List<Period> getPeriodList() {
            return this.periodList;
        }

        public void setPeriodList(List<Period> periodList) {
            this.periodList = periodList;
        }

        public AmountUnit getAmountUnit() {
            return this.amountUnit;
        }

        public void setAmountUnit(AmountUnit amountUnit) {
            this.amountUnit = amountUnit;
        }

        public String toString() {
            return "QueryCondition{systemId=" + this.systemId + ", reportTypeId=" + this.reportTypeId + ", reportOrgIds=" + this.reportOrgIds + ", subjectFlow='" + this.subjectFlow + '\'' + ", currencyId=" + this.currencyId + ", amountUnit=" + this.amountUnit + ", periodList=" + this.periodList + '}';
        }
    }
}

