/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectInoutDirectionEnum;
import kd.tmc.fpm.common.property.ApprovalDisposeProp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ApprovalDisposeEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                ApprovalDisposeEdit.this.setDescription();
            }

            public void entryRowDoubleClick(RowClickEvent evt) {
                ApprovalDisposeEdit.this.setDescription();
            }
        });
        entryGrid.addHyperClickListener(hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            Long applyInfoId = (Long)this.getModel().getValue("entry_applyinfoid", rowIndex);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)applyInfoId);
            billShowParameter.setFormId("fpm_inoutcollect");
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)billShowParameter);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "adddetailplan": {
                this.checkAndAShowForm();
                break;
            }
            case "submit": {
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (operationResult.isSuccess()) break;
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDescription();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "adddetailplan": {
                this.addDetailPlan(closedCallBackEvent);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": {
                this.setDescription();
                break;
            }
            case "delete": {
                this.getView().close();
            }
        }
    }

    private void setDescription() {
        Label total = (Label)this.getControl("total");
        Label selected = (Label)this.getControl("selected");
        Label flowIn = (Label)this.getControl("flowin");
        Label flowOut = (Label)this.getControl("flowout");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        total.setText(String.valueOf(dynamicObjectCollection.size()));
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        selected.setText(String.valueOf(selectRows.length));
        int flowInCount = 0;
        int flowOutCount = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String inoutDirection = dynamicObject.getString("entry_inoutdirection");
            if (StringUtils.equals((CharSequence)inoutDirection, (CharSequence)InoutCollectInoutDirectionEnum.IN.getCode())) {
                ++flowInCount;
            }
            if (!StringUtils.equals((CharSequence)inoutDirection, (CharSequence)InoutCollectInoutDirectionEnum.OUT.getCode())) continue;
            ++flowOutCount;
        }
        flowIn.setText(String.valueOf(flowInCount));
        flowOut.setText(String.valueOf(flowOutCount));
    }

    private void addDetailPlan(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (!ListSelectedRowCollection.class.isInstance(returnData)) {
            return;
        }
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set existIdSet = entryEntity.stream().map(entry -> entry.getLong("entry_applyinfoid")).collect(Collectors.toSet());
        HashSet existsBillNo = new HashSet(8);
        List pkValueList = listSelectedRowCollection.stream().filter(listSelectedRow -> {
            if (existIdSet.contains(listSelectedRow.getPrimaryKeyValue())) {
                existsBillNo.add(listSelectedRow.getBillNo());
                return false;
            }
            return true;
        }).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(existsBillNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\u5206\u5f55\u3002", (String)"ApprovalDisposeEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[]{existsBillNo.stream().collect(Collectors.joining(","))}));
        }
        if (CollectionUtils.isEmpty(pkValueList)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", pkValueList);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_inoutcollect", (String)ApprovalDisposeProp.INOUT_COLLECT_SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter});
        String[] split = ApprovalDisposeProp.INOUT_COLLECT_SELECT_FIELDS.split(",");
        for (DynamicObject dynamicObject : load) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            for (String field : split) {
                if (StringUtils.equals((CharSequence)field, (CharSequence)"id")) {
                    this.getModel().setValue("entry_applyinfoid", dynamicObject.get(field), newEntryRow);
                    continue;
                }
                String fieldNumber = String.join((CharSequence)"_", "entry", field);
                this.getModel().setValue(fieldNumber, dynamicObject.get(field), newEntryRow);
            }
        }
        this.setDescription();
    }

    private void checkAndAShowForm() {
        String businessType = (String)this.getModel().getValue("businesstype");
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
        if (StringUtils.isEmpty((CharSequence)businessType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ApprovalDisposeEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (applyOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u7ec4\u7ec7\u3002", (String)"ApprovalDisposeEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("businesstype", "=", (Object)businessType).and("applyorg", "=", applyOrg.getPkValue()).and("approvalstatus", "=", (Object)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode()).and("abandonstatus", "!=", (Object)"1");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("fpm_inoutcollect");
        showParameter.setFormId("bos_listf7");
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("580px");
        css.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setF7Style(0);
        showParameter.setShowWaterMark(true);
        showParameter.setShowTitle(false);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(true);
        showParameter.setShowFrequent(false);
        showParameter.setHasRight(true);
        showParameter.setLookUp(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8ba1\u5212", (String)"ApprovalDisposeEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adddetailplan"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

