/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.util.Arrays;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;

public class CronPlanGeneratePlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("applyorgrange");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter authOrgFilter = this.getAuthOrgFilter();
                return 1.qFilterResultBuilder().qFilter(authOrgFilter).build();
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "confirm": {
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                this.getView().close();
            }
        }
    }

    private void initView() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String applyOrgIdStr = (String)formShowParameter.getCustomParam("APPLY_ORG");
        this.getView().setEnable(Boolean.FALSE, new String[]{"applyorgrange"});
        if (StringUtils.isEmpty((CharSequence)applyOrgIdStr)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"applyorgrange"});
            return;
        }
        String[] split = applyOrgIdStr.split(",");
        Long[] objects = Arrays.stream(split).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList()).toArray(new Long[0]);
        this.getModel().setValue("applyorgrange", (Object)objects);
    }
}

