/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.InoutCycleEnum;
import kd.tmc.fpm.common.property.CronPlanTemplateProp;
import kd.tmc.fpm.formplugin.helper.F7ListenerHelper;
import kd.tmc.fpm.formplugin.helper.InoutCollectSearchHelper;

public class CronPlanTemplateEdit
extends AbstractFormPlugin {
    private static final String BOS_ORG_FUND = "fisbankroll";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (property.getName()) {
            case "firstexpectdate": {
                this.setExpectDate(e);
                this.setFutureThreeExpectDate(false);
                break;
            }
            case "expectcashamount": {
                this.setCurrentPlanAmountDefault(e);
                break;
            }
            case "inoutcycle": 
            case "repeatcycle": 
            case "expiredate": {
                this.setFutureThreeExpectDate(false);
                break;
            }
            case "inoutdirection": {
                this.getModel().setValue("fundpurpose", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "viewgeneratedrecord": {
                this.linkSearchInoutRecord();
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "disable": 
            case "enable": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFutureThreeExpectDate(true);
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
        Object applyOrgId = RequestContext.get().getOrgId();
        if (Objects.nonNull(applyOrg)) {
            applyOrgId = applyOrg.getPkValue();
        }
        String selectFields = String.join((CharSequence)",", "id", BOS_ORG_FUND);
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)applyOrgId, (String)"bos_org", (String)selectFields);
        boolean isFundOrg = dynamicObject.getBoolean(BOS_ORG_FUND);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyorg", (Object)applyOrgId);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyuser", (Object)RequestContext.get().getCurrUserId());
        DynamicObject fundOrg = (DynamicObject)this.getModel().getValue("fundorg");
        if (Objects.isNull(fundOrg)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"fundorg", (Object)(isFundOrg ? applyOrgId : Long.valueOf(0L)));
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"cronid", (Object)dataEntity.getPkValue());
        if (dataEntity.getBoolean("enable") && EmptyUtil.isNoEmpty((Object)dataEntity.getPkValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
    }

    private void linkSearchInoutRecord() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (EmptyUtil.isEmpty((Object)pkValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CronPlanTemplateEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        InoutCollectSearchHelper.viewGeneratedRecord(this.getView(), dataEntity);
    }

    private void setCurrentPlanAmountDefault(PropertyChangedArgs e) {
        BigDecimal bigDecimal = this.getModel().getDataEntity().getBigDecimal("currentplanamount");
        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        this.getModel().setValue("currentplanamount", newValue);
    }

    private void setFutureThreeExpectDate(boolean isInit) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        Date recentExpectDate = dataEntity.getDate("recentrecordexpectdate");
        if (recentExpectDate == null) {
            recentExpectDate = dataEntity.getDate("firstexpectdate");
        }
        if (recentExpectDate == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        Date firstDate = dataEntity.getDate("firstexpectdate");
        calendar.setTime(firstDate);
        int day = calendar.get(5);
        Date currentDate = DateUtils.getCurrentDate();
        AtomicReference<Date> currentDateRef = new AtomicReference<Date>(currentDate);
        if (recentExpectDate.compareTo(firstDate) >= 0) {
            firstDate = recentExpectDate;
            calendar.setTime(firstDate);
            calendar.add(5, 1);
            if (recentExpectDate.after(currentDate)) {
                currentDateRef.set(calendar.getTime());
            }
        }
        String inoutCycle = dataEntity.getString("inoutcycle");
        InoutCycleEnum inoutCycleEnum = InoutCycleEnum.getByCode((String)inoutCycle);
        int repeatCount = dataEntity.getInt("repeatcycle");
        String[] nextThreeExpectDateArr = new String[3];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        InoutCycleEnum.InoutCycleDay inoutCycleDay = new InoutCycleEnum.InoutCycleDay(inoutCycleEnum, day, repeatCount);
        Date expireDate = dataEntity.getDate("expiredate");
        for (int i = 0; i < nextThreeExpectDateArr.length; ++i) {
            Date expectDate;
            firstDate = expectDate = inoutCycleDay.getExpectDate(firstDate, currentDateRef, calendar);
            if (expireDate != null && !expireDate.after(expectDate)) continue;
            nextThreeExpectDateArr[i] = simpleDateFormat.format(expectDate);
        }
        String nextThreeExpectDate = Arrays.stream(nextThreeExpectDateArr).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
        if (isInit) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"futurethreeexpectdate", (Object)nextThreeExpectDate);
            return;
        }
        this.getModel().setValue("futurethreeexpectdate", (Object)nextThreeExpectDate);
    }

    private void setExpectDate(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            this.getModel().setValue("expectdate", null);
            return;
        }
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        this.getModel().setValue("expectdate", newValue);
    }

    private void initF7() {
        for (String field : CronPlanTemplateProp.F7_FIELDS) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            basedataEdit.addBeforeF7SelectListener(F7ListenerHelper.inoutPollBeforeF7SelectListener(this.getModel(), this.getView()));
        }
    }
}

