/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.common.property.InspectionLogProp;
import kd.tmc.fpm.formplugin.domain.inspection.ErrorInfo;

public class ErrorExecRecordPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDataEntry();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btn_repair"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "dorepair": {
                this.doRepair();
                break;
            }
            case "reconfirm": {
                this.confirmNoError();
                break;
            }
        }
    }

    private void confirmNoError() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ErrorExecRecordPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            return;
        }
        ArrayList<Long> entryIds = new ArrayList<Long>(selectRows.length);
        Long resultDetailId = 0L;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i : selectRows) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            InspectionRepairResult repairResult = (InspectionRepairResult)ITypeEnum.getByNumber((String)entry.getString("repairresult"), InspectionRepairResult.class);
            if (EmptyUtil.isEmpty((Object)repairResult) || repairResult.isRepaired()) continue;
            if (EmptyUtil.isEmpty((Long)resultDetailId)) {
                resultDetailId = entry.getLong("resultdetailentryid");
            }
            entryIds.add(entry.getLong("originentryid"));
        }
        if (EmptyUtil.isEmpty(entryIds)) {
            String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u90fd\u5df2\u4fee\u590d\u3002", (String)"ErrorExecRecordPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            return;
        }
        Boolean flag = Boolean.FALSE;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DataSaveServiceImpl dataSaveService = new DataSaveServiceImpl();
                dataSaveService.updateAndCheckResult(() -> "update t_fpm_log_chainerror set frepairresult='REPAIRED' where fentryid=?", entryIds, (t, d) -> d.add(t));
                QFilter qFilter = new QFilter(String.join((CharSequence)".", "entry_exec_chainerror", "b_resultentryid"), "=", (Object)resultDetailId).and(String.join((CharSequence)".", "entry_exec_chainerror", "b_repairresult"), "=", (Object)InspectionRepairResult.PENDING.getNumber());
                boolean exists = QueryServiceHelper.exists((String)"fpm_inspection_log", (QFilter[])new QFilter[]{qFilter});
                if (!exists) {
                    dataSaveService.updateAndCheckResult(() -> "update t_fpm_inspect_log_detail set frepairresult='REPAIRED' where fentryid=?", Collections.singletonList(resultDetailId), (t, d) -> d.add(t));
                    flag = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                tx.markRollback();
                flag = Boolean.FALSE;
            }
        }
        this.getView().returnDataToParent((Object)flag);
        this.getView().close();
    }

    private void doRepair() {
        String errorMsg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u94fe\u8def\u5f02\u5e38\u4fee\u590d\u3002", (String)"ErrorExecRecordPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        this.getView().showTipNotification(errorMsg);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject clickEntryDO = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
        switch (fieldName) {
            case "bizbillno": {
                DynamicObject bizBill = clickEntryDO.getDynamicObject("bizbill");
                Long bizBillId = clickEntryDO.getLong("bizbillid");
                this.showView(bizBill.getString("number"), bizBillId);
            }
            case "execrecordno": {
                Long execRecordId = clickEntryDO.getLong("execrecordid");
                this.showView("fpm_executeplan", execRecordId);
            }
        }
    }

    private void showView(String entityType, Long pkid) {
        BaseShowParameter showParameter = new BaseShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(entityType);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initDataEntry() {
        JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("errorInfoList");
        if (jsonArray == null) {
            return;
        }
        String bizObjType = (String)this.getView().getFormShowParameter().getCustomParam("bizObjType");
        DynamicObject bosEntityObject = BusinessDataServiceHelper.loadSingle((Object)bizObjType, (String)"bos_entityobject");
        List errorInfoList = JSONObject.parseArray((String)JSON.toJSONString((Object)jsonArray), ErrorInfo.class);
        Set execRecordIdList = errorInfoList.stream().map(ErrorInfo::getBillId).collect(Collectors.toSet());
        DynamicObject[] execRecordDOs = TmcDataServiceHelper.load((String)"fpm_executeplan", (String)InspectionLogProp.EXEC_RECORD_SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", execRecordIdList)});
        Map<Long, DynamicObject> execRecordMap = Arrays.stream(execRecordDOs).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), v -> v, (k1, k2) -> k1));
        this.getModel().setValue("inspectlogid", this.getView().getFormShowParameter().getCustomParam("inspectlogid"));
        this.getModel().setValue("inspectconfigid", this.getView().getFormShowParameter().getCustomParam("inspectconfigid"));
        this.getModel().setValue("inspecttype", this.getView().getFormShowParameter().getCustomParam("inspecttype"));
        this.getModel().setValue("inspectscope", this.getView().getFormShowParameter().getCustomParam("inspectscope"));
        this.getModel().setValue("inspecttarget", this.getView().getFormShowParameter().getCustomParam("inspecttarget"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (ErrorInfo errorInfo : errorInfoList) {
            DynamicObject dynamicObject2 = entryEntity.addNew();
            dynamicObject2.set("resultdetailentryid", (Object)errorInfo.getResultEntryId());
            dynamicObject2.set("execrecordno", (Object)errorInfo.getBillNo());
            dynamicObject2.set("originentryid", (Object)errorInfo.getEntryId());
            dynamicObject2.set("repairresult", (Object)errorInfo.getRepairResult());
            dynamicObject2.set("bizbill", (Object)bosEntityObject);
            dynamicObject2.set("execrecordid", (Object)errorInfo.getBillId());
            dynamicObject2.set("errorinfo", (Object)errorInfo.getErrorInfo());
            DynamicObject execRecordDO = execRecordMap.get(errorInfo.getBillId());
            if (execRecordDO == null) continue;
            dynamicObject2.set("opname", (Object)execRecordDO.getString("planexecuteop"));
            dynamicObject2.set("realamt", execRecordDO.get("realamt"));
            dynamicObject2.set("org", (Object)execRecordDO.getDynamicObject("reportorg"));
            dynamicObject2.set("reporttype", (Object)execRecordDO.getDynamicObject("reporttype"));
            dynamicObject2.set("subject", (Object)execRecordDO.getDynamicObject("subjectmem"));
            dynamicObject2.set("currency", (Object)execRecordDO.getDynamicObject("currencymem"));
            dynamicObject2.set("execdate", (Object)execRecordDO.getDate("executedate"));
            dynamicObject2.set("execinfo", (Object)execRecordDO.getString("executeinfo"));
            dynamicObject2.set("system", (Object)execRecordDO.getDynamicObject("bodysys"));
            dynamicObject2.set("bizbillno", (Object)execRecordDO.getString("bizbillcode"));
            dynamicObject2.set("bizbillid", (Object)execRecordDO.getString("bizbillid"));
            dynamicObject2.set("billstatus", (Object)execRecordDO.getString("billstatus"));
            dynamicObject2.set("opstatus", (Object)execRecordDO.getString("executeoperatorstatus"));
            dynamicObject2.set("failreason", (Object)execRecordDO.getString("exectuefailreason"));
            dynamicObject2.set("rate", execRecordDO.get("rate"));
            dynamicObject2.set("bizbillcurrency", (Object)execRecordDO.getDynamicObject("bizbillcurrency"));
            dynamicObject2.set("bizbillamount", execRecordDO.get("bizbillamount"));
            dynamicObject2.set("creator", execRecordDO.get("creator"));
            dynamicObject2.set("createdate", execRecordDO.get("createtime"));
        }
    }
}

