/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionExecType;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.formplugin.basesetting.FpmBaseFilterPlugin;

public class InspectionConfigList
extends FpmBaseFilterPlugin {
    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    public void setFilter(SetFilterEvent e) {
        String property;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> first = qFilters.stream().filter(Objects::nonNull).filter(i -> i.getProperty().startsWith("bodysys")).findFirst();
        QFilter systemFilter = first.orElse(null);
        if (systemFilter != null && "bodysys.id".equals(property = systemFilter.getProperty())) {
            this.getPageCache().put("INSPECTION_CONFIG_MODEL_CACHE_KEY", systemFilter.getValue().toString());
        }
        qFilters.add(new QFilter("bodysys.id", "in", this.getAuthBodySystemIds()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "execinspection": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u6267\u884c\u5de1\u68c0", (String)"InspectionConfigList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "execinspection": {
                if (!args.getOperationResult().isSuccess()) break;
                this.showExecInspectionForm();
                break;
            }
            case "inspectionlog": {
                this.showInspectionLog();
                break;
            }
        }
    }

    private void showExecInspectionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_exec_inspection");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "execinspection"));
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        showParameter.setCustomParam("inspectionConfigId", selectedRows.get(0).getPrimaryKeyValue());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0", (String)"InspectionConfigList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void showInspectionLog() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("fpm_inspection_log");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String modelId = this.getPageCache().get("INSPECTION_CONFIG_MODEL_CACHE_KEY");
        showParameter.setCustomParam("INSPECTION_CONFIG_MODEL_CACHE_KEY", (Object)modelId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5de1\u68c0\u65e5\u5fd7", (String)"InspectionConfigList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "execinspection": {
                this.execInspection(closedCallBackEvent.getReturnData());
                break;
            }
            case "execInspectionCallBack": {
                this.afterExecInspectionCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    private void execInspection(Object returnData) {
        if (returnData == null) {
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u6570\u636e\u5de1\u68c0\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u5de1\u68c0\u7ed3\u679c\u3002", (String)"InspectionConfigList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        DynamicObject execInfo = (DynamicObject)returnData;
        InspectHeader header = this.wrapperHeader(execInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "execInspectionCallBack");
        JobFormInfo execJobInfo = InspectionConfigList.getExecJobInfo(header, this.getView());
        execJobInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)execJobInfo, (IFormView)this.getView());
    }

    public static JobFormInfo getExecJobInfo(InspectHeader header, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname("kd.tmc.fpm.business.task.ExecInspectionTask");
        jobInfo.setName(ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0\u8c03\u5ea6\u4efb\u52a1", (String)"InspectionConfigList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0\u8c03\u5ea6\u4efb\u52a1", (String)"InspectionConfigList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, String> params = new HashMap<String, String>(2);
        String headerStr = FpmSerializeUtil.serialize((Object)header);
        params.put("inspectHeader", headerStr);
        params.put("pageId", formView.getPageId());
        params.put("traceId", RequestContext.get().getTraceId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.tmc.fpm.business.task.ReportImportDataClickTask");
        return jobFormInfo;
    }

    private void afterExecInspectionCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            Object taskinfoObj = result.get("taskinfo");
            if (EmptyUtil.isEmpty(taskinfoObj)) {
                return;
            }
            String taskInfoStr = (String)taskinfoObj;
            if (EmptyUtil.isEmpty((String)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                boolean success = (Boolean)mapData.get("success");
                if (!success) {
                    String errorMessage = (String)mapData.get("errorMessage");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0\u4efb\u52a1\u5f02\u5e38\uff1a%s", (String)"InspectionConfigList_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"InspectionConfigList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private InspectHeader wrapperHeader(DynamicObject execInfo) {
        InspectHeader header = new InspectHeader();
        header.setInspectionConfigId((Long)this.getSelectedRows().get(0).getPrimaryKeyValue());
        InspectionExecType execType = (InspectionExecType)ITypeEnum.getByNumber((String)execInfo.getString("exectype"), InspectionExecType.class);
        header.setExecType(execType);
        if (execType == InspectionExecType.BY_DATE) {
            header.setStartDate(execInfo.getDate("startdate"));
            header.setEndDate(execInfo.getDate("enddate"));
        } else if (execType == InspectionExecType.BY_PERIOD) {
            DynamicObjectCollection periodScopeCollection = execInfo.getDynamicObjectCollection("exec_period_scope");
            List periodScope = periodScopeCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setPeriodScope(periodScope);
        }
        DynamicObjectCollection orgScopeCollection = execInfo.getDynamicObjectCollection("exec_org_scope");
        List orgScope = orgScopeCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
        header.setOrgScope(orgScope);
        return header;
    }
}

