/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.inspection.ControlRepairInfo;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.common.enums.InspectionScopeEnum;
import kd.tmc.fpm.common.enums.InspectionTypeEnum;
import kd.tmc.fpm.common.property.InspectionLogProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.formplugin.domain.inspection.BillInfo;
import kd.tmc.fpm.formplugin.domain.inspection.ErrorInfo;
import org.apache.commons.collections.CollectionUtils;

public class InspectionLogPlugin
extends TmcBaseDataEdit
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_detail_errorbizinfo", "e_detail_errorexecrecord", "repair_failedbills"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry_consistency_error");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid repairEntryGrid = (EntryGrid)this.getControl("repair_entry");
        repairEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName;
        switch (fieldName = hyperLinkClickEvent.getFieldName()) {
            case "e_cons_reportplan_no": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_consistency_error");
                DynamicObject clickEntryDO = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
                long reportId = clickEntryDO.getLong("e_cons_reportid");
                String reportType = clickEntryDO.getString("e_cons_reporttype");
                this.showReport(reportType, reportId);
                break;
            }
            case "repair_operator": {
                this.showRepairDetailInfo(hyperLinkClickEvent);
                break;
            }
        }
    }

    private void showReport(String reportType, long reportId) {
        String entityType;
        BaseShowParameter showParameter = new BaseShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        if (ReportPlanType.REPORTPLAN.getNumber().equals(reportType)) {
            entityType = "fpm_report";
            showParameter.setPkId((Object)reportId);
        } else {
            entityType = "fpm_reportplansum";
            String originReportIds = "%" + reportId + "%";
            DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)"id", (QFilter[])new QFilter[]{new QFilter("originalreportids", "like", (Object)originReportIds)});
            showParameter.setPkId((Object)load[0].getLong("id"));
        }
        showParameter.setFormId(entityType);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateLabel();
        this.setFieldDisable();
        this.fillConsistencyErrorInfo();
        this.fillExecRecordBillInfo();
        this.fillRepairEntryClickDetail();
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "e_detail_errorbizinfo": {
                this.showErrorBizBillInfoPage();
                break;
            }
            case "e_detail_errorexecrecord": {
                this.showErrorExecRecordPage();
                break;
            }
            case "repair_failedbills": {
                this.showBizBillInfo();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "repair_consistency": {
                this.getView().showConfirm("", ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u6309\u7167\u6267\u884c\u8bb0\u5f55\u989d\u5ea6\u66f4\u65b0\u8ba1\u5212\u8868\u5185\u7684\u9884\u5360/\u5b9e\u9645\u6570\u989d\u5ea6\uff0c\u8bf7\u5148\u786e\u8ba4\u6267\u884c\u8bb0\u5f55\u7684\u6b63\u786e\u540e\uff0c\u518d\u8fdb\u884c\u8ba1\u5212\u8868\u5185\u989d\u5ea6\u4fee\u590d", (String)"InspectionLogPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("reportConsistencyConfirm", (IFormPlugin)this));
                break;
            }
            case "repair_billcomparison": 
            case "repair_execrecord": {
                this.repair(operateKey);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("reportConsistencyConfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.repair("repair_consistency");
        }
    }

    public void repair(String key) {
        if (!this.checkBeforeRepair(key)) {
            return;
        }
        switch (key) {
            case "repair_billcomparison": {
                this.repairControl();
                break;
            }
            case "repair_consistency": {
                this.repairConsistency();
                break;
            }
            case "repair_execrecord": {
                this.repairBillNotExist();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "repairDataCallBack": {
                this.afterRepairCallBack(closedCallBackEvent);
                break;
            }
            case "e_detail_errorbizinfo": 
            case "e_detail_errorexecrecord": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (!Objects.nonNull(returnData) || !(returnData instanceof Boolean) || !((Boolean)returnData).booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"InspectionLogPlugin_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void execTask(RepairHeader header) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u4fee\u590d\u7a0b\u5e8f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6267\u884c\u8bb0\u5f55\u6216\u8ba1\u5212\u6267\u884c\u5206\u6790\u60c5\u51b5\u3002", (String)"InspectionLogPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "repairDataCallBack");
        JobFormInfo execJobInfo = InspectionLogPlugin.getRepairJobInfo(header, this.getView());
        execJobInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)execJobInfo, (IFormView)this.getView());
    }

    public static JobFormInfo getRepairJobInfo(RepairHeader header, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname("kd.tmc.fpm.business.task.RepairDataTask");
        jobInfo.setName(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u8c03\u5ea6\u4efb\u52a1", (String)"InspectionLogPlugin_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u4fee\u590d\u8c03\u5ea6\u4efb\u52a1", (String)"InspectionLogPlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, String> params = new HashMap<String, String>(2);
        String headerStr = FpmSerializeUtil.serialize((Object)header);
        params.put("repairHeader", headerStr);
        params.put("traceId", RequestContext.get().getTraceId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.tmc.fpm.business.task.ReportImportDataClickTask");
        return jobFormInfo;
    }

    private void afterRepairCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            Object taskinfoObj = result.get("taskinfo");
            if (EmptyUtil.isEmpty(taskinfoObj)) {
                return;
            }
            String taskInfoStr = (String)taskinfoObj;
            if (EmptyUtil.isEmpty((String)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                boolean success = (Boolean)mapData.get("success");
                if (!success) {
                    String errorMessage = (String)mapData.get("errorMessage");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u4fee\u590d\u4efb\u52a1\u5f02\u5e38\uff1a%s", (String)"InspectionLogPlugin_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"InspectionLogPlugin_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void repairControl() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry_result_detail");
        int[] selectRows = entryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u590d\u3002", (String)"InspectionLogPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject config = (DynamicObject)this.getModel().getValue("inspection_config");
        RepairHeader header = new RepairHeader();
        Long id = (Long)this.getModel().getValue("id");
        header.setInspectionLogId(id);
        header.setInspectionConfigId((Long)config.getPkValue());
        header.setInspectionScope((InspectionScope)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectionscope")), InspectionScope.class));
        header.setInspectionType((InspectionType)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectiontype")), InspectionType.class));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_result_detail");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        DynamicObjectCollection billBizEntry = this.getModel().getEntryEntity("entry_error_bizinfo");
        Map<Long, List<DynamicObject>> listMap = billBizEntry.stream().collect(Collectors.groupingBy(dy -> dy.getLong("a_resultentryid")));
        for (int index : selectRows) {
            List<DynamicObject> billIdList;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            String repairResult = dynamicObject.getString("e_detail_repairreuslt");
            if (EmptyUtil.isEmpty((String)repairResult) || Objects.equals(InspectionRepairResult.REPAIRED.getNumber(), repairResult) || EmptyUtil.isEmpty(billIdList = listMap.get(dynamicObject.getLong("id")))) continue;
            String inspectTarget = dynamicObject.getString("e_detail_inspecttarget");
            String entityType = (String)dynamicObject.getDynamicObject("e_detail_bizobj").getPkValue();
            ControlRepairInfo controlRepairInfo = new ControlRepairInfo((InspectionTargetType)ITypeEnum.getByNumber((String)inspectTarget, InspectionTargetType.class));
            controlRepairInfo.setEntityType(entityType);
            controlRepairInfo.setLogDetailEntryId(Long.valueOf(dynamicObject.getLong("id")));
            controlRepairInfo.setInspectionTargetType(InspectionTargetType.getByCode((String)inspectTarget));
            billIdList.stream().map(dy -> new ControlRepairInfo.LogBillInfo(Long.valueOf(dy.getLong("id")), Long.valueOf(dy.getLong("a_bizbillid")))).forEach(arg_0 -> ((ControlRepairInfo)controlRepairInfo).addLogBillInfo(arg_0));
            header.addControlRepairInfo(controlRepairInfo);
        }
        if (EmptyUtil.isEmpty((Collection)header.getControlRepairInfoList())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u4e1a\u52a1\u94fe\u8def\u5de1\u68c0\u4e14\u662f\u5f85\u4fee\u590d\u7684\u6570\u636e\u8fdb\u884c\u4fee\u590d\u3002", (String)"InspectionLogPlugin_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.execTask(header);
    }

    private void repairBillNotExist() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry_exec_record");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u4fee\u590d\u7684\u5f02\u5e38\u6267\u884c\u8bb0\u5f55\u3002", (String)"InspectionLogPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_exec_record");
        ArrayList<Long> execRecordIdList = new ArrayList<Long>(selectRows.length);
        for (int idx : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(idx);
            long execRecordId = dynamicObject.getLong("e_exec_record.id");
            execRecordIdList.add(execRecordId);
        }
        RepairHeader header = this.wrapperBillNotExistHeader(execRecordIdList);
        this.execTask(header);
    }

    private RepairHeader wrapperBillNotExistHeader(List<Long> execRecordIdList) {
        DynamicObject config = (DynamicObject)this.getModel().getValue("inspection_config");
        RepairHeader header = new RepairHeader();
        Long id = (Long)this.getModel().getValue("id");
        header.setExecRecordIdList(execRecordIdList);
        header.setInspectionLogId(id);
        header.setInspectionConfigId((Long)config.getPkValue());
        header.setInspectionScope((InspectionScope)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectionscope")), InspectionScope.class));
        header.setInspectionType((InspectionType)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectiontype")), InspectionType.class));
        return header;
    }

    private void repairConsistency() {
        RepairHeader header = this.wrapperConsistencyHeader();
        this.execTask(header);
    }

    private RepairHeader wrapperConsistencyHeader() {
        DynamicObject config = (DynamicObject)this.getModel().getValue("inspection_config");
        RepairHeader header = new RepairHeader();
        Long id = (Long)this.getModel().getValue("id");
        header.setInspectionLogId(id);
        header.setInspectionConfigId((Long)config.getPkValue());
        header.setInspectionScope((InspectionScope)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectionscope")), InspectionScope.class));
        header.setInspectionType((InspectionType)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectiontype")), InspectionType.class));
        DynamicObjectCollection periodScopeColl = (DynamicObjectCollection)this.getModel().getValue("exec_period_scope");
        if (CollectionUtils.isNotEmpty((Collection)periodScopeColl)) {
            List periodScope = periodScopeColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setPeriodScope(periodScope);
        } else {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            header.setEndDate(endDate);
            header.setStartDate(startDate);
        }
        DynamicObjectCollection orgScopeCollection = (DynamicObjectCollection)this.getModel().getValue("exec_org_scope");
        if (CollectionUtils.isNotEmpty((Collection)orgScopeCollection)) {
            List orgScope = orgScopeCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrgScope(orgScope);
        }
        return header;
    }

    private boolean checkBeforeRepair(String key) {
        EntryGrid entryGrid;
        int[] selectRows;
        InspectionRepairResult repairResult = (InspectionRepairResult)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("repairresult")), InspectionRepairResult.class);
        if (repairResult == InspectionRepairResult.REPAIRED) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f02\u5e38\u8bb0\u5f55\u5df2\u5168\u90e8\u4fee\u590d\u5b8c\u6bd5\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"InspectionLogPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (Objects.equals(key, "repair_execrecord") && (selectRows = (entryGrid = (EntryGrid)this.getView().getControl("entry_exec_record")).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u4fee\u590d\u7684\u5f02\u5e38\u6267\u884c\u8bb0\u5f55\u3002", (String)"InspectionLogPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showErrorExecRecordPage() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry_result_detail");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_result_detail");
        DynamicObject currentObj = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        Object entryId = currentObj.getPkValue();
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "entry_exec_chainerror", "b_resultentryid"), "=", entryId);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"inspectionLog.queryChainErrorInfo", (String)"fpm_inspection_log", (String)InspectionLogProp.ENTRY_CHAIN_ERROR_SELECT_PROPS, (QFilter[])new QFilter[]{qFilter}, (String)"");
        ArrayList<ErrorInfo> errorInfoList = new ArrayList<ErrorInfo>(10);
        while (rows.hasNext()) {
            Row row = rows.next();
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setErrorInfo(row.getString(String.join((CharSequence)".", "entry_exec_chainerror", "b_errorinfo")));
            errorInfo.setBillId(row.getLong(String.join((CharSequence)".", "entry_exec_chainerror", "b_execrecordid")));
            errorInfo.setEntryId(row.getLong(String.join((CharSequence)".", "entry_exec_chainerror", "id")));
            errorInfo.setRepairResult(row.getString(String.join((CharSequence)".", "entry_exec_chainerror", "b_repairresult")));
            errorInfo.setBillNo(row.getString(String.join((CharSequence)".", "entry_exec_chainerror", "b_execrecordnumber")));
            errorInfo.setBillNo(row.getString(String.join((CharSequence)".", "entry_exec_chainerror", "b_execrecordnumber")));
            errorInfo.setResultEntryId((Long)entryId);
            errorInfoList.add(errorInfo);
        }
        if (errorInfoList.size() == 0) {
            return;
        }
        DynamicObject bizObj = currentObj.getDynamicObject("e_detail_bizobj");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_error_execrecord");
        showParameter.setCustomParam("errorInfoList", errorInfoList);
        showParameter.setCustomParam("inspectconfigid", ((DynamicObject)this.getModel().getValue("inspection_config")).getPkValue());
        showParameter.setCustomParam("inspectlogid", this.getModel().getValue("id"));
        showParameter.setCustomParam("inspectscope", this.getModel().getValue("inspectionscope"));
        showParameter.setCustomParam("inspecttype", this.getModel().getValue("inspectiontype"));
        showParameter.setCustomParam("inspecttarget", (Object)currentObj.getString("e_detail_inspecttarget"));
        showParameter.setCustomParam("bizObjType", (Object)bizObj.getString("number"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_detail_errorbizinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u6267\u884c\u8bb0\u5f55\u4fe1\u606f", (String)"InspectionLogPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void showErrorBizBillInfoPage() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry_result_detail");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_result_detail");
        DynamicObject currentObj = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        Object entryId = currentObj.getPkValue();
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "entry_error_bizinfo", "a_resultentryid"), "=", entryId);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"inspectionLog.queryErrorBizInfo", (String)"fpm_inspection_log", (String)InspectionLogProp.ENTRY_ERROR_BIZ_INFO_SELECT_PROPS, (QFilter[])new QFilter[]{qFilter}, (String)"");
        ArrayList<ErrorInfo> errorInfoList = new ArrayList<ErrorInfo>(10);
        while (rows.hasNext()) {
            Row row = rows.next();
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setErrorInfo(row.getString(String.join((CharSequence)".", "entry_error_bizinfo", "a_errorinfo")));
            errorInfo.setBillId(row.getLong(String.join((CharSequence)".", "entry_error_bizinfo", "a_bizbillid")));
            errorInfo.setEntryId(row.getLong(String.join((CharSequence)".", "entry_error_bizinfo", "id")));
            errorInfo.setRepairResult(row.getString(String.join((CharSequence)".", "entry_error_bizinfo", "a_repairresult")));
            errorInfo.setBillNo(row.getString(String.join((CharSequence)".", "entry_error_bizinfo", "a_bizbillnumber")));
            errorInfo.setResultEntryId((Long)entryId);
            errorInfoList.add(errorInfo);
        }
        if (errorInfoList.size() == 0) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_error_bill_info");
        showParameter.setCustomParam("inspectconfigid", ((DynamicObject)this.getModel().getValue("inspection_config")).getPkValue());
        showParameter.setCustomParam("inspectlogid", this.getModel().getValue("id"));
        showParameter.setCustomParam("inspectscope", this.getModel().getValue("inspectionscope"));
        showParameter.setCustomParam("inspecttype", this.getModel().getValue("inspectiontype"));
        showParameter.setCustomParam("errorInfoList", errorInfoList);
        showParameter.setCustomParam("systemId", (Object)((DynamicObject)this.getModel().getValue("bodysys")).getLong("id"));
        showParameter.setCustomParam("matchRuleId", (Object)currentObj.getDynamicObject("e_detail_matchrule").getLong("id"));
        showParameter.setCustomParam("inspectionTarget", (Object)currentObj.getString("e_detail_inspecttarget"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_detail_errorbizinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u4e1a\u52a1\u5355\u636e\u4fe1\u606f", (String)"InspectionLogPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void fillConsistencyErrorInfo() {
        Object inspectType = this.getModel().getValue("inspectiontype");
        Object inspectScope = this.getModel().getValue("inspectionscope");
        if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_CONSISTENCY_INSPECTION.getValue()) && Objects.equals(inspectScope, InspectionScopeEnum.REPORT_INSPECTION.getValue())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_consistency_error");
            if (entryEntity == null || entryEntity.size() == 0) {
                return;
            }
            Set reportIdList = entryEntity.stream().map(dy -> dy.getLong("e_cons_reportid")).collect(Collectors.toSet());
            String selectedFields = String.join((CharSequence)",", "billno", "id", "reportplantype");
            DynamicObject[] reportDOS = TmcDataServiceHelper.load((String)"fpm_report", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIdList)});
            Map<Long, DynamicObject> reportDOMap = Arrays.stream(reportDOS).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), v -> v, (k1, k2) -> k1));
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject2 = (DynamicObject)entryEntity.get(i);
                long reportId = dynamicObject2.getLong("e_cons_reportid");
                DynamicObject reportDO = reportDOMap.get(reportId);
                if (reportDO == null) continue;
                String reportType = reportDO.getString("reportplantype");
                if (ReportPlanType.SUMPLAN.getNumber().equals(reportType)) {
                    String originReportIds = "%" + reportId + "%";
                    DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)"billno", (QFilter[])new QFilter[]{new QFilter("originalreportids", "like", (Object)originReportIds)});
                    String sumPlanBillNO = load[0].getString("billno");
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_cons_reportplan_no", (Object)sumPlanBillNO, (int)i);
                } else {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_cons_reportplan_no", (Object)reportDO.get("billno"), (int)i);
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_cons_reporttype", (Object)reportDO.get("reportplantype"), (int)i);
            }
        }
    }

    private void fillRepairEntryClickDetail() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("repair_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        String operator = String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6267\u884c\u8bb0\u5f55", (String)"InspectionLogPlugin_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), new Object[0]);
        for (int i = 0; i < entryEntity.size(); ++i) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"repair_operator", (Object)operator, (int)i);
        }
    }

    private void updateLabel() {
        Label detailLabel2;
        DynamicObjectCollection detailResultEntry = this.getModel().getEntryEntity("entry_result_detail");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)detailResultEntry)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconsummarypanelap"});
        } else {
            long size = detailResultEntry.stream().filter(dO -> Objects.equals(InspectionExecResult.EXCEPTION.getNumber(), dO.getString("e_detail_inspectresult"))).count();
            detailLabel2 = (Label)this.getControl("detail_label2");
            detailLabel2.setText(String.format(ResManager.loadKDString((String)"%s\u9879", (String)"InspectionLogPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), size));
        }
        DynamicObjectCollection execRecordEntry = this.getModel().getEntryEntity("entry_exec_record");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)execRecordEntry)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconsummarypanelap2"});
        } else {
            int size = execRecordEntry.size();
            detailLabel2 = (Label)this.getControl("record_label2");
            detailLabel2.setText(String.format(ResManager.loadKDString((String)"%s\u6761", (String)"InspectionLogPlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), size));
        }
        DynamicObjectCollection consistencyEntry = this.getModel().getEntryEntity("entry_consistency_error");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)consistencyEntry)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconsummarypanelap3"});
        }
    }

    private void setFieldDisable() {
        String execResult = (String)this.getModel().getValue("execresult");
        String repairResult = (String)this.getModel().getValue("repairresult");
        if (InspectionExecResult.SUCCESS.getNumber().equals(execResult) || InspectionRepairResult.REPAIRED.getNumber().equals(repairResult) || InspectionRepairResult.FAILED.getNumber().equals(repairResult)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"repair_billcomparison", "repair_execrecord", "repair_consistency"});
        }
    }

    private void fillExecRecordBillInfo() {
        Object inspectType = this.getModel().getValue("inspectiontype");
        Object inspectScope = this.getModel().getValue("inspectionscope");
        if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue()) && Objects.equals(inspectScope, InspectionScopeEnum.BILL_NOT_EXIST.getValue())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_exec_record");
            if (entryEntity == null || entryEntity.size() == 0) {
                return;
            }
            Set execRecordIdList = entryEntity.stream().map(dy -> dy.getDynamicObject("e_exec_record").getPkValue()).collect(Collectors.toSet());
            DynamicObject[] execRecordDOs = TmcDataServiceHelper.load((String)"fpm_executeplan", (String)InspectionLogProp.EXEC_RECORD_SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", execRecordIdList)});
            Map<Long, DynamicObject> execRecordMap = Arrays.stream(execRecordDOs).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), v -> v, (k1, k2) -> k1));
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject2 = (DynamicObject)entryEntity.get(i);
                DynamicObject bill = dynamicObject2.getDynamicObject("e_exec_record");
                DynamicObject execRecordDO = execRecordMap.get(bill.getLong("id"));
                if (execRecordDO == null) continue;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_opname", (Object)execRecordDO.getString("planexecuteop"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_opstatus", (Object)execRecordDO.getString("executeoperatorstatus"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_failreason", (Object)execRecordDO.getString("exectuefailreason"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_info", (Object)execRecordDO.getString("executeinfo"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bizbillcurrency", (Object)execRecordDO.getDynamicObject("bizbillcurrency"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bodysys", (Object)execRecordDO.getDynamicObject("bodysys"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_org", (Object)execRecordDO.getDynamicObject("reportorg"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_reporttype", (Object)execRecordDO.getDynamicObject("reporttype"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_subject", (Object)execRecordDO.getDynamicObject("subjectmem"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_date", (Object)execRecordDO.getDate("executedate"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_currency", (Object)execRecordDO.getDynamicObject("currencymem"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_rate", (Object)execRecordDO.get("rate"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bizbilltype", (Object)execRecordDO.getDynamicObject("billbizetype"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bizbillno", (Object)execRecordDO.getString("bizbillcode"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bizbillid", (Object)execRecordDO.getLong("bizbillid"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_billstatus", (Object)execRecordDO.getString("billstatus"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_realamt", (Object)execRecordDO.get("realamt"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_bizbillamount", (Object)execRecordDO.get("bizbillamount"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_creator", (Object)execRecordDO.get("creator"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_exec_createdate", (Object)execRecordDO.get("createtime"), (int)i);
            }
        }
    }

    private void showRepairDetailInfo(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("repair_entry");
        DynamicObject repairDy = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
        Object repairRecordId = repairDy.getPkValue();
        String recordIdProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_executerecordid");
        String selectFields = String.join((CharSequence)",", recordIdProp);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_inspection_log", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "rdetail_entry", "rdetail_repairid"), "=", repairRecordId)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return;
        }
        Set recordIds = query.stream().map(dy -> dy.getString(recordIdProp)).collect(Collectors.toSet());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_executeplaninfo");
        formShowParameter.setCustomParam("recordIds", recordIds);
        formShowParameter.setShowTitle(true);
        formShowParameter.setHasRight(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "repair_operator");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void showBizBillInfo() {
        QFilter qFilter;
        String failPlanRecordIdProp;
        String failReasonProp;
        String matchRuleIdProp;
        String billEntityTypeProp;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("repair_entry");
        DynamicObjectCollection repairEntry = this.getModel().getEntryEntity("repair_entry");
        DynamicObject currentObj = (DynamicObject)repairEntry.get(entryCurrentRowIndex);
        Object repairRecordId = currentObj.getPkValue();
        String billIdProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_billid");
        String selectFields = String.join((CharSequence)",", billIdProp, billEntityTypeProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_entitytype"), matchRuleIdProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_matchruleid"), failReasonProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_failedreason"), failPlanRecordIdProp = String.join((CharSequence)".", "rdetail_entry", "rdetail_executerecordid"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_inspection_log", (String)selectFields, (QFilter[])new QFilter[]{qFilter = new QFilter(String.join((CharSequence)".", "rdetail_entry", "rdetail_repairid"), "=", repairRecordId).and(String.join((CharSequence)".", "rdetail_entry", "rdetail_successflag"), "=", (Object)false)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return;
        }
        Map<Object, Object> map = Collections.emptyMap();
        Set planRecordIds = query.stream().map(dy -> dy.getLong(failPlanRecordIdProp)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(planRecordIds)) {
            DynamicObjectCollection planRecords = QueryServiceHelper.query((String)"fpm_executeplan", (String)String.join((CharSequence)",", "id", "exectuefailreason"), (QFilter[])new QFilter[]{new QFilter("id", "in", planRecordIds)});
            map = planRecords.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("exectuefailreason"), (a, b) -> a));
        }
        HashMap<String, BillInfo> billInfoMap = new HashMap<String, BillInfo>(16);
        for (DynamicObject dynamicObject : query) {
            String entityType = dynamicObject.getString(billEntityTypeProp);
            if (EmptyUtil.isEmpty((String)entityType)) continue;
            String errorMsg = dynamicObject.getString(failReasonProp);
            Long planRecordId = dynamicObject.getLong(failPlanRecordIdProp);
            BillInfo billInfo = billInfoMap.computeIfAbsent(entityType, BillInfo::new);
            billInfo.addBillId(dynamicObject.getLong(billIdProp), EmptyUtil.isEmpty((Long)planRecordId) ? errorMsg : map.getOrDefault(planRecordId, ""));
            billInfo.setMatchRuleId(dynamicObject.getLong(matchRuleIdProp));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_businessbillinfo");
        formShowParameter.setCustomParam("billInfo", billInfoMap.values());
        DynamicObject systemDy = (DynamicObject)this.getModel().getValue("bodysys");
        formShowParameter.setCustomParam("systemId", systemDy.getPkValue());
        formShowParameter.setShowTitle(true);
        formShowParameter.setHasRight(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "repair_failedbills");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }
}

