/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.period;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeEnum;
import kd.tmc.fpm.common.enums.WeekEnum;
import kd.tmc.fpm.formplugin.period.PeriodMemTree;
import kd.tmc.fpm.formplugin.period.PeriodParamInfo;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PeriodBatchAddEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"weektype", "ismerge", "startnode"});
        this.initStartYear(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "reporttype": {
                DynamicObject orgReportType = this.getModel().getDataEntity().getDynamicObject("reporttype");
                String reportType = orgReportType.getString("orgreporttype");
                String reportCycle = orgReportType.getString("orgreportcycle");
                this.getView().setVisible(Boolean.valueOf(OrgReportTypeCycleEnum.WEEK.getValue().equals(reportCycle)), new String[]{"weektype", "startnode"});
                this.getView().setVisible(Boolean.valueOf(OrgReportTypeCycleEnum.WEEK.getValue().equals(reportCycle) || OrgReportTypeEnum.WEEK.getValue().equals(reportType)), new String[]{"ismerge"});
                this.initStartYear(Long.valueOf(orgReportType.getPkValue().toString()));
                break;
            }
        }
    }

    private void initStartYear(Long reportTypeId) {
        DynamicObject[] periodDims;
        Date initYear = DateUtils.getCurrentDate();
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("isleaf", "=", (Object)"0"));
        qFilter.and(new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()));
        qFilter.and(new QFilter("year", "!=", (Object)0));
        if (Objects.nonNull(reportTypeId)) {
            qFilter.and(new QFilter("reporttype", "=", (Object)reportTypeId));
        }
        if ((periodDims = TmcDataServiceHelper.load((String)"fpm_member", (String)"startdate", (QFilter[])new QFilter[]{qFilter}, (String)"year desc")).length > 0) {
            initYear = DateUtils.getNextYear((Date)periodDims[0].getDate("startdate"), (int)1);
        }
        this.getModel().setValue("startyear", (Object)initYear);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            DynamicObject periodEntity = this.getModel().getDataEntity();
            DynamicObject reportType = periodEntity.getDynamicObject("reporttype");
            String reportCycle = reportType.getString("orgreportcycle");
            String orgReportType = reportType.getString("orgreporttype");
            String weekType = periodEntity.getString("weektype");
            PeriodParamInfo paramInfo = new PeriodParamInfo();
            if (OrgReportTypeCycleEnum.YEAR.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    paramInfo.setHasYear(true);
                } else if (OrgReportTypeEnum.HALFYEAR.getValue().equals(orgReportType)) {
                    paramInfo.setHasHalfYear(true);
                    paramInfo.setYearInHYear(true);
                } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                    paramInfo.setHasQuarter(true);
                    paramInfo.setYearInQuarter(true);
                } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                    paramInfo.setHasMonth(true);
                    paramInfo.setYearInMonth(true);
                }
            }
            if (OrgReportTypeCycleEnum.HALFYEAR.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    paramInfo.setHasHalfYear(true);
                } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                    paramInfo.setHasQuarter(true);
                    paramInfo.setHalfYearInQuarter(true);
                } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                    paramInfo.setHasMonth(true);
                    paramInfo.setHalfyearinMonth(true);
                }
            }
            if (OrgReportTypeCycleEnum.QUARTER.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    paramInfo.setHasQuarter(true);
                } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                    paramInfo.setHasMonth(true);
                    paramInfo.setQuarterinMonth(true);
                }
            }
            if (OrgReportTypeCycleEnum.MONTH.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    paramInfo.setHasMonth(true);
                } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                    paramInfo.setHasDay(true);
                    paramInfo.setMonthInDay(true);
                } else if (OrgReportTypeEnum.WEEK.getValue().equals(orgReportType)) {
                    if (weekType.equals("year")) {
                        paramInfo.setHasYearWeek(true);
                    } else {
                        paramInfo.setHasMonthWeek(true);
                        paramInfo.setMonthInMonthWeek(true);
                    }
                } else if (OrgReportTypeEnum.TEN.getValue().equals(orgReportType)) {
                    paramInfo.setMonthInTenday(true);
                    paramInfo.setHastenDay(true);
                }
            }
            if (OrgReportTypeCycleEnum.TEN.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    paramInfo.setHastenDay(true);
                } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                    paramInfo.setHasDay(true);
                    paramInfo.setTenDayInDay(true);
                }
            }
            if (OrgReportTypeCycleEnum.WEEK.getValue().equals(reportCycle)) {
                if (EmptyUtil.isEmpty((String)orgReportType)) {
                    if (weekType.equals("year")) {
                        paramInfo.setHasYearWeek(true);
                    } else {
                        paramInfo.setHasMonthWeek(true);
                    }
                } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                    paramInfo.setHasDay(true);
                    if (weekType.equals("year")) {
                        paramInfo.setYearWeekInDay(true);
                    } else {
                        paramInfo.setMonthWeekInDay(true);
                    }
                }
            }
            if (OrgReportTypeCycleEnum.DAY.getValue().equals(reportCycle)) {
                paramInfo.setHasDay(true);
            }
            String startNodeStr = periodEntity.getString("startnode");
            WeekEnum startNode = WeekEnum.getWeekEnumByCode((String)startNodeStr);
            paramInfo.setStartNode(startNode);
            paramInfo.setModel(this.getView().getFormShowParameter().getCustomParams().get("bodysystem").toString());
            paramInfo.setReportType(reportType.getLong("id"));
            String years = periodEntity.getString("years");
            PeriodMemTree periodTree = new PeriodMemTree(paramInfo);
            String dimensionId = this.getView().getFormShowParameter().getCustomParams().get("dimensionId").toString();
            periodTree.setDimension(Long.valueOf(dimensionId));
            Pair<String, String> createInfo = periodTree.createTree(DateUtils.getYear((Date)periodEntity.getDate("startyear")), Integer.parseInt(years));
            String successYear = (String)createInfo.getLeft();
            String errorYear = (String)createInfo.getRight();
            Pair message = Pair.of((Object)Boolean.TRUE, (Object)"");
            if (EmptyUtil.isNoEmpty((String)successYear) && EmptyUtil.isEmpty((String)errorYear)) {
                message = Pair.of((Object)Boolean.TRUE, (Object)String.format(ResManager.loadKDString((String)"%s\u671f\u95f4\u6210\u5458\u65b0\u589e\u6210\u529f\u3002", (String)"PeriodBatchAddEditPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), successYear));
            }
            if (EmptyUtil.isNoEmpty((String)successYear) && EmptyUtil.isNoEmpty((String)errorYear)) {
                message = Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"%1$s\u671f\u95f4\u6210\u5458\u65b0\u589e\u6210\u529f\uff1b\u4e14\u5df2\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u8d22\u5e74%2$s\u3002", (String)"PeriodBatchAddEditPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), successYear, errorYear));
            }
            if (EmptyUtil.isEmpty((String)successYear) && EmptyUtil.isNoEmpty((String)errorYear)) {
                message = Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u8d22\u5e74%s\u3002", (String)"PeriodBatchAddEditPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorYear));
            }
            this.getView().returnDataToParent((Object)message);
        }
    }

    private void initControlEvi() {
        BasedataEdit reportTypeF7 = (BasedataEdit)this.getView().getControl("reporttype");
        reportTypeF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Long modelId = this.getModelId();
            DynamicObject model = TmcDataServiceHelper.loadSingle((Object)modelId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
            DynamicObjectCollection entrys = model.getDynamicObjectCollection("applyrereportentry");
            List reportTypeIds = entrys.stream().filter(v -> "enable".equals(v.getString("rereporttypestatus"))).map(v -> v.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", reportTypeIds));
        });
        DateEdit startDayEdit = (DateEdit)this.getView().getControl("startyear");
        startDayEdit.setMinDate(DateUtils.getLastYear((Date)DateUtils.getCurrentDate(), (int)1));
    }

    private Long getModelId() {
        String bodySystem = ObjectUtils.toString(this.getView().getFormShowParameter().getCustomParams().get("bodysystem"), (String)"");
        return StringUtils.isBlank((CharSequence)bodySystem) ? 0L : Long.parseLong(bodySystem);
    }
}

