/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.planexecute;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.ExecutePlanOpTypeEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.ExecutePlanProp;

public class PlanExecutePlugin
extends AbstractBasePlugIn {
    DimensionRepository dimensionRepository = new DimensionRepository();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("relate_entryentity");
        entryGrid.addHyperClickListener(hyperLinkClickEvent -> {
            String message;
            Long pkId;
            String fieldName = hyperLinkClickEvent.getFieldName();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("relate_entryentity");
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject currentRow = (DynamicObject)entryEntity.get(rowIndex);
            BillShowParameter showParameter = new BillShowParameter();
            String entityType = "fpm_executeplan";
            switch (fieldName) {
                case "relate_billno": {
                    pkId = currentRow.getLong("relate_id");
                    message = ResManager.loadKDString((String)"\u6267\u884c\u8bb0\u5f55\u5df2\u5220\u9664\u3002", (String)"PlanExecutePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "relate_bizbillcode": {
                    entityType = (String)currentRow.getDynamicObject("relate_billbizetype").getPkValue();
                    pkId = currentRow.getLong("relate_bizbillid");
                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"PlanExecutePlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    return;
                }
            }
            boolean exists = QueryServiceHelper.exists((String)entityType, (Object)pkId);
            if (!exists) {
                view.showTipNotification(message);
                return;
            }
            MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)entityType);
            showParameter.setCaption(srcMainET.getDisplayName().getLocaleValue());
            showParameter.setPkId((Object)pkId);
            showParameter.setFormId(entityType);
            showParameter.setAppId("fpm");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        });
    }

    public void afterLoadData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long recordId = dataEntity.getLong("id");
        long originalId = dataEntity.getLong("originalrecordid");
        long relateRecordId = dataEntity.getLong("relaterecordid");
        QFilter filter = new QFilter("originalrecordid", "=", (Object)recordId).or(new QFilter("relaterecordid", "=", (Object)recordId)).or(new QFilter("id", "in", (Object)ListHelper.asList((Object[])new Long[]{originalId, relateRecordId})));
        Object[] query = BusinessDataServiceHelper.load((String)"fpm_executeplan", (String)ExecutePlanProp.SELECT_RELATE_QUERY_PROPS, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("relate_entryentity");
        entryEntity.clear();
        if (EmptyUtil.isEmpty((Object[])query)) {
            return;
        }
        Arrays.sort(query, Comparator.comparing(dy -> ((DynamicObject)dy).getDate("createtime")).reversed());
        for (Object dynamicObject : query) {
            DynamicObject entryRow = entryEntity.addNew();
            for (String queryProp : ExecutePlanProp.SELECT_RELATE_PROPS) {
                String relateProp = "relate_" + queryProp;
                Object o = dynamicObject.get(queryProp);
                if (!Objects.equals(queryProp, "billbizetype") && o instanceof DynamicObject) {
                    DynamicObject dy2 = (DynamicObject)o;
                    entryRow.set(relateProp, (Object)dy2.getString("name"));
                    continue;
                }
                if (Objects.equals(queryProp, "planexecuteop")) {
                    o = ExecutePlanOpTypeEnum.getName((String)StringHelper.getStringValue((Object)o));
                }
                entryRow.set(relateProp, o);
            }
        }
    }

    public void afterBindData(EventObject e) {
        Object modelVal = this.getModel().getValue("bodysys");
        if (Objects.isNull(modelVal)) {
            return;
        }
        DynamicObject system = (DynamicObject)modelVal;
        Long primaryKey = (Long)system.getPkValue();
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(primaryKey.longValue());
        this.transferExtraFieldValue(fundPlanSystem);
        super.afterBindData(e);
        this.disableFieldAfterLinkSearch(this.getView().getFormShowParameter());
    }

    private void transferExtraFieldValue(FundPlanSystem fundPlanSystem) {
        Map executePlanMappingWithoutEntry = DimensionMappingHelper.getDetailExtraFieldsMapping((Long)fundPlanSystem.getId(), (String)"fpm_executeplan");
        List extraBaseDataDimList = fundPlanSystem.getDimList().stream().filter(dimension -> dimension.getDetailDimType() != null).filter(dimension -> executePlanMappingWithoutEntry.containsKey(dimension.getDetailDimType().getNumber())).filter(dimension -> dimension.getMemberType() == MemberType.BASE_DATA).collect(Collectors.toList());
        for (Dimension dimension2 : extraBaseDataDimList) {
            String fieldName = (String)executePlanMappingWithoutEntry.get(dimension2.getDetailDimType().getNumber());
            Object value = this.getModel().getValue(fieldName);
            if (!EmptyUtil.isNoEmpty((Object)value)) continue;
            String baseDataType = dimension2.getBaseDataType();
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseDataType);
            String nameProperty = basedataEntityType.getNameProperty();
            DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)value, (String)baseDataType, (String)nameProperty);
            this.getModel().setValue(fieldName, (Object)dynamicObject.getString(nameProperty));
        }
    }

    public void disableFieldAfterLinkSearch(FormShowParameter formShowParameter) {
        Boolean isFormLinkSearchChild = (Boolean)formShowParameter.getCustomParam("param_from_link_search_child");
        if (isFormLinkSearchChild == null || !isFormLinkSearchChild.booleanValue()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_modify"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "delete": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6267\u884c\u8bb0\u5f55\uff0c\u8bf7\u4ece\u4e1a\u52a1\u5355\u636e\u8fdb\u884c\u9006\u5411\u64cd\u4f5c\u3002", (String)"PlanExecuteList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }
}

