/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;
import kd.tmc.fpm.formplugin.helper.ReportShowHelper;

public class ReportPlanAdjustList
extends FpmFilterBaseList
implements IReportVerifyView {
    private IReportVerifyController verifyController;

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "upsearch": {
                    this.trackUp();
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "submitadjustplan": {
                String notifyMessage = ResManager.loadKDString((String)"\u63d0\u4ea4\u524d\u8bf7\u786e\u8ba4\u4e3b\u9644\u8868\u4e2d\u6240\u9700\u8c03\u6574\u7684\u8d44\u91d1\u8ba1\u5212\u79d1\u76ee\u5747\u5df2\u8c03\u6574\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ReportPlanAdjustPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm("", notifyMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("submit", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "dataverifysubmit": {
                List<ReportRuleCheckDTO> dataVerifySubmitRuleFilter = this.initRuleCheckDTO();
                for (ReportRuleCheckDTO checkDTO : dataVerifySubmitRuleFilter) {
                    this.getReportVerifyController().ruleCheck(checkDTO, args);
                    if (!args.isCancel()) continue;
                    break;
                }
                if (args.isCancel()) break;
                this.getView().invokeOperation("submit");
                break;
            }
            case "audit": {
                String confirmAudit = this.getView().getPageCache().get("confirmAudit");
                if (!"1".equals(confirmAudit)) break;
                this.getView().getPageCache().put("confirmAudit", "0");
                break;
            }
            case "unaudit": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u6574\u5355\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u3002\u82e5\u9700\u8981\u4fee\u6539\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8ba1\u5212\u8c03\u6574\u3002", (String)"ReportPlanAdjustPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private List<ReportRuleCheckDTO> initRuleCheckDTO() {
        List adjustIds = this.getSelectedRows().stream().map(d -> (Long)d.getPrimaryKeyValue()).collect(Collectors.toList());
        String selectFields = "id,originalreportids,reportorg.id,reportorg.name,reportperiod.id,reportperiod.name,reporttype.id";
        DynamicObjectCollection planAdjustList = QueryServiceHelper.query((String)"fpm_reportplan_adjust", (String)selectFields, (QFilter[])new QFilter("id", "in", adjustIds).toArray());
        return ReportRuleCheckHelper.initRuleCheckDTOForAdjustPlan((Collection<DynamicObject>)planAdjustList, this.getReportVerifyController(), null, Boolean.TRUE, Boolean.FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (Objects.equals(callBackId, "submit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("dataverifysubmit");
        }
        if (Objects.equals(callBackId, "audit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().getPageCache().put("confirmAudit", "1");
            this.getView().invokeOperation("audit");
        }
    }

    @Override
    protected String getAuthEntityName() {
        return "fpm_reportplan_adjust";
    }

    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    @Override
    protected String getReportOrgProp() {
        return "reportorg";
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List authMemberOrgIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("authMemberOrgIds"), List.class);
        qFilters.add(new QFilter("reportorg", "in", (Object)authMemberOrgIds));
        if (this.getPageCache().get("tipFlag") != null && "true".equals(this.getPageCache().get("tipFlag"))) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "adjust_entryentity", "adjust_custompage1"), "is null", null).or(new QFilter(String.join((CharSequence)".", "adjust_entryentity", "adjust_custompage1"), "=", (Object)0L).and(new QFilter(String.join((CharSequence)".", "adjust_entryentity", "adjust_custompage2"), "=", (Object)0L)));
        qFilters.add(qFilter);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        LinkSearchSubFormHelper.removeListFilterContainerFilters(formShowParameter, e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LinkSearchSubFormHelper.hideControl(this.getView(), "filtercontainerap", "tbldel", "submit", "tblcheck");
    }

    private void trackUp() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectRow = billList.getCurrentSelectedRowInfo();
        Long recordId = (Long)selectRow.getPrimaryKeyValue();
        DynamicObject dbData = QueryServiceHelper.queryOne((String)"fpm_reportplan_adjust", (String)"mainreportid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recordId)});
        ReportShowHelper.showReportPlanView(this.getView(), dbData.get("mainreportid"), false);
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            this.verifyController = new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        this.getView().showForm(parameter);
    }

    public void showErrMessage(List<String> list) {
    }

    public void showSuccessMessage(String s) {
    }
}

