/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AdjustType;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeHeader;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.controller.IPlanChangeManageController;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.PlanChangeManageController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.view.IPlanChangeManageView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.RowAndColVisibleCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.command.generator.UpdateCellInfoGenerator;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.update.CellValueUpdateFactory;
import kd.tmc.fpm.business.spread.update.bean.CellUpdateResult;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.property.ReportPlanAdjustProp;
import kd.tmc.fpm.common.property.ReportPlanProp;
import kd.tmc.fpm.common.property.ReportProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;
import kd.tmc.fpm.formplugin.helper.ReportShowHelper;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import org.apache.commons.collections4.MapUtils;

public class ReportPlanAdjustPlugin
extends AbstractSpreadPlugin
implements IPlanChangeManageView,
IReportVerifyView {
    private static final String MAIN_REPORT_NUMBER = "MAIN_REPORT_NUMBER";
    private IPlanChangeManageController planChangeManageController;
    private IReportVerifyController verifyController;
    private static final String INIT_REPORT_FIRST = "INIT_REPORT_FIRST";
    private CellDataSource cellDataSource;
    private AuxiliaryCellStyleConvert auxiliaryCellStyleConvert = new AuxiliaryCellStyleConvert();

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void showWarnMessage(String warnMessage) {
        if (null != warnMessage) {
            this.getView().showTipNotification(warnMessage);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refreshreport", "refreshimg", "showadjustsubjects", "adjustrollperiod", "adjusttype"});
        this.addCardEntryListener();
        String mapperInfoStr = this.getView().getPageCache().get("page_dim_mapping_cache");
        String sysId = this.getView().getPageCache().get("system_id_cache");
        Map mapperInfo = (Map)FpmSerializeUtil.deserialize((String)mapperInfoStr, Map.class);
        if (EmptyUtil.isNoEmpty((Object)mapperInfo)) {
            Set entries = mapperInfo.entrySet();
            for (Map.Entry entry : entries) {
                BasedataEdit pageDim = (BasedataEdit)this.getControl((String)entry.getKey());
                pageDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    TemplateDim templateDim = (TemplateDim)entry.getValue();
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter filter = new QFilter("bodysystem", "=", (Object)Optional.ofNullable(sysId).map(Long::valueOf).orElseGet(() -> 0L));
                    filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                    showParameter.getListFilterParameter().setFilter(filter);
                    showParameter.setShowTitle(false);
                    showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
                });
            }
        }
        BasedataEdit detailPeriod = (BasedataEdit)this.getControl("detailperiod");
        detailPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject system = this.getModel().getDataEntity().getDynamicObject("bodysys");
            QFilter filter = new QFilter("bodysystem", "=", system.getPkValue());
            DynamicObject reportPeriodDy = this.getModel().getDataEntity().getDynamicObject("reportperiod");
            filter.and(new QFilter("parent", "=", reportPeriodDy.getPkValue()));
            DynamicObject reportType = this.getModel().getDataEntity().getDynamicObject("reporttype");
            filter.and("reporttype", "=", reportType.getPkValue());
            filter.and("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        this.addClickListeners(new String[]{"reportplanadjustbill", "openfilter", "adjustrollperiod"});
        this.filterControlInit();
    }

    private void addCardEntryListener() {
        final CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        cardEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                int[] selectRows = cardEntry.getSelectRows();
                if (selectRows.length != 1) {
                    cardEntry.selectRows(row, true);
                    if (ReportPlanAdjustPlugin.this.checkRequire()) {
                        ReportPlanAdjustPlugin.this.convertHeadAndDoSave();
                    }
                    return;
                }
                DynamicObjectCollection entryEntity = ReportPlanAdjustPlugin.this.getModel().getEntryEntity("card_entryentity");
                Long reportId = ((DynamicObject)entryEntity.get(row)).getLong("cardreportid");
                String reportTemplateTypeProp = "template.templatetype";
                DynamicObject reportDy = QueryServiceHelper.queryOne((String)"fpm_report", (String)reportTemplateTypeProp, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
                String templateType = reportDy.getString(reportTemplateTypeProp);
                String status = ReportPlanAdjustPlugin.this.getModel().getDataEntity().getString("billstatus");
                if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue()) && "A".equals(status)) {
                    ArrayList<String[]> contextMenuItemsEnums = new ArrayList<String[]>(){
                        {
                            this.add(new String[]{ContextMenuItemsEnum.DELETEROWS.getNumber()});
                        }
                    };
                    ReportPlanAdjustPlugin.this.getSpreadCommandInvoker().hideContextSubMenuItems(null, (List)contextMenuItemsEnums);
                }
                if (Objects.equals(ReportPlanAdjustPlugin.this.getPageCache().get(ReportPlanAdjustPlugin.INIT_REPORT_FIRST), "Y")) {
                    ReportPlanAdjustPlugin.this.getPageCache().put(ReportPlanAdjustPlugin.INIT_REPORT_FIRST, "N");
                    return;
                }
                ReportPlanAdjustPlugin.this.controlShowAdjustSubjectsFieldVisible(templateType, status, false);
                ReportPlanAdjustPlugin.this.switchParamLoadChangeReport("reportname", true);
                ReportPlanAdjustProp.FILTER_PROP_LIST.forEach(prop -> ReportPlanAdjustPlugin.this.getModel().setValue(prop, null));
                ReportPlanAdjustPlugin.this.rowAndColVisible();
                ReportPlanAdjustPlugin.this.hideRowByMeta();
            }
        });
        cardEntry.addHyperClickListener(hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            int[] selectRows = cardEntry.getSelectRows();
            if (selectRows.length > 1) {
                cardEntry.selectRows(rowIndex, true);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            Long reportId = dynamicObject.getLong("cardreportid");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setAppId("fpm");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("fpm_reportplan");
            showParameter.setCustomParam("report_id", (Object)reportId);
            showParameter.setHasRight(true);
            this.getView().showForm(showParameter);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        block7 : switch (key = op.getOperateKey()) {
            case "submitadjustplan": {
                String adjustReason = (String)this.getModel().getValue("adjustreason");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)adjustReason)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u6574\u539f\u56e0\u3002", (String)"ReportPlanAdjustPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String notifyMessage = ResManager.loadKDString((String)"\u63d0\u4ea4\u524d\u8bf7\u786e\u8ba4\u4e3b\u9644\u8868\u4e2d\u6240\u9700\u8c03\u6574\u7684\u8d44\u91d1\u8ba1\u5212\u79d1\u76ee\u5747\u5df2\u8c03\u6574\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ReportPlanAdjustPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm("", notifyMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("submit", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "dataverifysubmit": {
                this.beforeDataVerifySubmitOp(args);
                break;
            }
            case "dataverify": {
                args.setCancel(true);
                IReportVerifyController verifyController = this.getReportVerifyController();
                List<ReportRuleCheckDTO> dataVerifyRuleFilter = this.initRuleCheckDTO(verifyController, Boolean.FALSE);
                if (CollectionUtils.isEmpty(dataVerifyRuleFilter)) break;
                if (this.checkRequire()) {
                    this.getView().invokeOperation("saveadjustplan");
                }
                for (ReportRuleCheckDTO checkDTO : dataVerifyRuleFilter) {
                    verifyController.ruleCheck(checkDTO, args);
                    if (!args.isCancel()) continue;
                    break block7;
                }
                break;
            }
            case "audit": {
                String confirmAudit = this.getView().getPageCache().get("confirmAudit");
                if (!"1".equals(confirmAudit)) break;
                this.getView().getPageCache().put("confirmAudit", "0");
                break;
            }
            case "unaudit": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u6574\u5355\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u3002\u82e5\u9700\u8981\u4fee\u6539\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8ba1\u5212\u8c03\u6574\u3002", (String)"ReportPlanAdjustPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null) {
            switch (operateKey) {
                case "saveadjustplan": {
                    if (!operationResult.isSuccess()) break;
                    this.saveAndRefresh(true);
                    this.rowAndColVisible();
                    this.hideRowByMeta();
                    break;
                }
                case "upsearch": {
                    if (!operationResult.isSuccess()) break;
                    this.trackUp();
                    break;
                }
                case "dataverify": {
                    if (!operationResult.isSuccess()) break;
                    this.handleDataVerifyNotify(afterDoOperationEventArgs);
                    break;
                }
                case "submit": 
                case "audit": {
                    if (!operationResult.isSuccess()) break;
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "unsubmit": 
                case "unaudit": {
                    if (!operationResult.isSuccess()) break;
                    String billStatus = this.getModel().getDataEntity().getString("billstatus");
                    this.controlShowAdjustSubjectsFieldVisible(TemplateTypeEnum.FIXED.getValue(), billStatus, true);
                    break;
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initAdjustParamInfo();
        Long adjustId = Optional.ofNullable(this.getModel().getDataEntity().getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        Long reportId = this.getReportId();
        this.getOrCreateReportController().load(adjustId, reportId, this.getView().getPageId());
        this.selectDefaultCard(true, new int[0]);
        String originalReportIds = (String)this.getModel().getValue("originalreportids");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)originalReportIds)) {
            Object[] originalReportIdArr = Arrays.stream(originalReportIds.split(",")).map(Long::valueOf).toArray();
            DynamicObjectCollection originalReportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)originalReportIdArr)});
            this.getModel().setValue("reportplanadjustbill", (Object)originalReportDyColl.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.joining(";")));
        }
        this.lockAdjustRollPeriodSwitchIfNeed();
        this.rowAndColVisible();
        this.hideRowByMeta();
        this.getView().setVisible(Boolean.FALSE, new String[]{"filterflex"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "refreshreport": 
            case "refreshimg": {
                this.rowAndColVisible();
                this.hideRowByMeta();
                break;
            }
            case "openfilter": {
                Label label = (Label)this.getView().getControl("openfilter");
                String openFilter = this.getView().getPageCache().get("open_filter");
                String open = ResManager.loadKDString((String)"\u5c55\u5f00\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                String close = ResManager.loadKDString((String)"\u6536\u8d77\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                if (EmptyUtil.isEmpty((String)openFilter) || open.equals(openFilter)) {
                    openFilter = close;
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filterflex"});
                } else {
                    openFilter = open;
                    this.getView().setVisible(Boolean.FALSE, new String[]{"filterflex"});
                }
                label.setText(openFilter);
                this.getView().getPageCache().put("open_filter", openFilter);
                break;
            }
        }
    }

    private void saveAndRefresh(boolean refreshReport) {
        if (this.checkRequire()) {
            this.convertHeadAndDoSave();
        }
        this.switchParamLoadChangeReport("", refreshReport);
    }

    private boolean checkRequire() {
        String status = this.getModel().getDataEntity().getString("billstatus");
        return Objects.equals(status, BillStatus.STAGE.getNumber());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (changeKey) {
            case "adjustreference": {
                String newVal = Optional.ofNullable(newValue).map(o -> o.toString()).orElseGet(() -> "");
                Set newSets = Arrays.stream(newVal.split(",")).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty(newSets) && newSets.contains(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue())) {
                    newSets.add(PlanChangeReferIndex.LOCKAMT.getValue());
                    newSets.add(PlanChangeReferIndex.REALAMT.getValue());
                    this.getModel().setValue("adjustreference", (Object)newSets.stream().collect(Collectors.joining(",")));
                }
                this.getModel().setDataChanged(false);
                break;
            }
            case "showadjustsubjects": {
                if (!this.showAdjustSubject(e)) break;
                this.saveAndRefresh(true);
                this.rowAndColVisible();
                this.hideRowByMeta();
                this.getModel().setDataChanged(false);
                break;
            }
            case "adjustrollperiod": {
                this.saveAndRefresh(true);
                this.rowAndColVisible();
                this.hideRowByMeta();
                break;
            }
            case "custompagemember1": 
            case "custompagemember2": 
            case "detailperiod": {
                this.saveAndRefresh(true);
                this.rowAndColVisible();
                this.hideRowByMeta();
            }
            case "reportplanadjustbill": 
            case "amountunit": 
            case "cardreportname": 
            case "cardreportnumber": 
            case "cardreportid": 
            case "filter_col_01": 
            case "filter_col_02": 
            case "filter_row_01": 
            case "filter_row_02": {
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter)) {
            return;
        }
        Long recordId = (Long)formShowParameter.getCustomParam("report_id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"fpm_reportplan_adjust");
        String originalReportIds = dynamicObject.getString("originalreportids");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)originalReportIds)) {
            Object[] originalReportIdArr = Arrays.stream(originalReportIds.split(",")).map(Long::valueOf).toArray();
            DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)originalReportIdArr)});
            if (dynamicObjects.length > 0) {
                dynamicObject.set("reportplanadjustbill", (Object)Arrays.stream(dynamicObjects).map(dy -> dy.getString("billno")).collect(Collectors.joining(";")));
            }
        }
        e.setDataEntity((Object)dynamicObject);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child"), true)) {
            this.initAdjustParamInfo();
        }
    }

    public void refreshPageDim(List<ReportCalcVal> reportCalcVals, boolean isChange, ReportTemplate reportTemplate) {
        HashMap<String, TemplateDim> mapper = new HashMap<String, TemplateDim>(16);
        List pageDimList = reportTemplate.getPageDimList();
        int count = 1;
        for (int i = 0; i < pageDimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)pageDimList.get(i);
            if (templateDim.getDimType() == DimensionType.ORG) continue;
            String pageDimSign = String.format("custompagemember%s", count++);
            mapper.put(pageDimSign, templateDim);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"custompagemember1", "custompagemember2"});
        block1: for (ReportCalcVal reportCalcVal : reportCalcVals) {
            Long id = Long.valueOf(reportCalcVal.getValue().toString());
            Set entrys = mapper.entrySet();
            for (Map.Entry entry : entrys) {
                String sign = (String)entry.getKey();
                List ids = ((TemplateDim)entry.getValue()).getMemberScope();
                DynamicObject reportorg = (DynamicObject)this.getModel().getValue("reportorg");
                if (!ids.contains(id)) continue;
                boolean bool = id.compareTo(Long.valueOf(reportorg.getPkValue().toString())) == 0;
                this.getView().setVisible(Boolean.valueOf(!bool), new String[]{sign});
                BasedataEdit control = (BasedataEdit)this.getControl(sign);
                control.setCaption(new LocaleString(((TemplateDim)entry.getValue()).getDimensionName()));
                if (isChange) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)sign, (Object)id);
                } else {
                    this.getView().getModel().setValue(sign, (Object)id);
                }
                this.getModel().setDataChanged(false);
                continue block1;
            }
        }
        this.getView().getPageCache().put("page_dim_mapping_cache", FpmSerializeUtil.serialize(mapper));
        this.getView().getPageCache().put("system_id_cache", reportTemplate.getSystemId().toString());
    }

    public PlanChangeHeader getReferIndex() {
        ArrayList<PlanChangeReferIndex> referIndexs = new ArrayList<PlanChangeReferIndex>();
        referIndexs.add(PlanChangeReferIndex.CURRENTPLANAMT);
        referIndexs.add(PlanChangeReferIndex.ADJUSTAMT);
        referIndexs.add(PlanChangeReferIndex.AFTERADJUSTAMT);
        referIndexs.add(PlanChangeReferIndex.PLANAMT);
        referIndexs.add(PlanChangeReferIndex.LOCKAMT);
        referIndexs.add(PlanChangeReferIndex.REALAMT);
        referIndexs.add(PlanChangeReferIndex.AVAILABLEAMT);
        referIndexs.add(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT);
        PlanChangeHeader changeHeader = new PlanChangeHeader();
        changeHeader.setReferIndexS(referIndexs);
        DynamicObjectCollection detailPeriods = this.getModel().getDataEntity().getDynamicObjectCollection("detailperiod");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)detailPeriods)) {
            List detailPeriodIds = detailPeriods.stream().filter(Objects::nonNull).map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
            changeHeader.setDetailPeriods(detailPeriodIds);
        }
        Boolean showAdjustSubjects = (Boolean)this.getModel().getValue("showadjustsubjects");
        changeHeader.setShowAdjustSubjects(showAdjustSubjects.booleanValue());
        return changeHeader;
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u8c03\u8282\u8868\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u52a0\u8f7d\u9884\u89c8\u3002", (String)"ReportPlanAdjustPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        this.markFlagOfCol(book);
        int maxRow = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", Integer.class)).map(o -> o).orElseGet(() -> 0);
        int maxCol = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", Integer.class)).map(o -> o).orElseGet(() -> 0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.execCommand();
        List cacheCells = book.getSheet().getCellList();
        boolean existAdjustSubjects = cacheCells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).filter(cell -> cell.getCellType() == CellTypeEnum.AMOUNT).anyMatch(cell -> Objects.equals(cell.getStyleInfo().getBkc(), "#DFE6FA"));
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"exist_adjust_subject_cache", (Object)existAdjustSubjects);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void updateCell(List<Cell> cells) {
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, true).generatorChain(this.getSpreadCommandInvoker(), cells);
        spreadCommand.execCommand();
    }

    public void cellValueUpdate(List<CellValueEvent> events) {
        super.cellValueUpdate(events);
        CellDataSource cellDataSource = this.getCellDataSource();
        events.removeIf(event -> !cellDataSource.checkBounds(event.getCell().getRow(), event.getCell().getCol()));
        List copyDataBaseCellSources = events.stream().filter(Objects::nonNull).filter(o -> {
            CacheCell originCell = cellDataSource.getCell(o.getCell().getRow(), o.getCell().getCol());
            if (EmptyUtil.isEmpty((Object)originCell)) {
                return false;
            }
            CellTypeEnum cellType = originCell.getCellType();
            return cellType == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType;
        }).map(o -> new Cell(o.getCell().getRow(), o.getCell().getCol(), o.getNewValue())).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(copyDataBaseCellSources)) {
            this.getOrCreateReportController().copy(copyDataBaseCellSources);
        }
        int maxRow = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", Integer.class);
        int maxCol = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", Integer.class);
        ArrayList<CellUpdateResult> cellUpdateResults = new ArrayList<CellUpdateResult>(events.size());
        for (CellValueEvent event2 : events) {
            CacheCell originCell = cellDataSource.getCell(event2.getCell().getRow(), event2.getCell().getCol());
            if (EmptyUtil.isEmpty((Object)originCell)) {
                maxRow = event2.getCell().getRow() < maxRow ? maxRow : event2.getCell().getRow();
                maxCol = event2.getCell().getCol() < maxCol ? maxCol : event2.getCell().getCol();
                continue;
            }
            CellTypeEnum cellType = originCell.getCellType();
            if (cellType == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType || originCell.isSummary()) continue;
            try {
                CellUpdateResult updateCellInfo = null;
                updateCellInfo = CellValueUpdateFactory.createCellValueUpdateInstance((CellValueEvent)event2, (Cell)originCell).update();
                cellUpdateResults.add(updateCellInfo);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<String> failureMsgs = cellUpdateResults.stream().filter(Objects::nonNull).filter(o -> EmptyUtil.isNoEmpty((String)o.getErrMsg())).map(CellUpdateResult::getErrMsg).collect(Collectors.toList());
        this.showErrMessage(failureMsgs);
        List updateCells = cellUpdateResults.stream().filter(Objects::nonNull).map(CellUpdateResult::getCell).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(updateCells)) {
            this.getOrCreateReportController().update(updateCells);
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", (Object)maxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", (Object)maxCol);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.getOrCreateReportController().release();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("spreadjs_f7winclose_callback".equals(key)) {
            returnData = (ListSelectedRowCollection)event.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            Long id = (Long)returnData.getPrimaryKeyValues()[0];
            Cell currCell = (Cell)FpmSerializeUtil.deserialize((String)this.getPageCache().get("cell_pagecache"), Cell.class);
            CacheCell cell = this.getCellDataSource().getCell(currCell.getRow(), currCell.getCol());
            DynamicObject selectDataDy = QueryServiceHelper.queryOne((String)cell.getWidgetValue().toString(), (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            cell.setDisplayValue((Object)selectDataDy.getString("name"));
            cell.setNewValue((Object)id);
            cell.setValue((Object)id);
            this.getOrCreateReportController().update(Collections.singletonList(cell));
        }
        if ("dataverify".equals(key)) {
            returnData = (Map)event.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnData)) {
                return;
            }
            String dataVerifyResult = returnData.get("dataVerifyResult").toString();
            List notifyDTOList = JSONArray.parseArray((String)dataVerifyResult, ReportVerifyRuleNotifyDTO.class);
            if (CollectionUtils.isEmpty((Collection)notifyDTOList)) {
                return;
            }
            boolean commit = notifyDTOList.stream().anyMatch(ReportVerifyRuleNotifyDTO::getFromCommit);
            if (!commit) {
                return;
            }
            boolean anyMatch = notifyDTOList.stream().anyMatch(item -> ReportVerifyCheckEffectEnum.DISABLE.getCode().equals(item.getCheckEffect().getCode()));
            if (!anyMatch) {
                this.convertHeadAndDoSave();
                OperationResult submitOpResult = this.getView().invokeOperation("submit");
                if (submitOpResult.isSuccess()) {
                    this.updateCardView(false, true);
                } else {
                    this.updateCardView(false, false);
                }
            }
        }
    }

    public void deleteRows(AskExecuteEvent event) {
        super.deleteRows(event);
        List rows = (List)event.getParams();
        String rowsStr = rows.stream().map(o -> String.format("%s", o + 1)).collect(Collectors.joining(","));
        this.getView().getPageCache().put("deleteRows", FpmSerializeUtil.serialize((Object)event));
        this.getView().showConfirm("", String.format(ResManager.loadKDString((String)"\u8868\u5934\u884c\u4e0d\u80fd\u5220\u9664\uff0c\u786e\u5b9a\u5220\u9664%s\u884c\u5417\uff1f", (String)"ReportPlanPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rowsStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("deleteRows", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("deleteRows".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            AskExecuteEvent askEvent = (AskExecuteEvent)FpmSerializeUtil.deserialize((String)this.getView().getPageCache().get("deleteRows"), AskExecuteEvent.class);
            this.getOrCreateReportController().deleteRows(askEvent);
        }
        if (Objects.equals(callBackId, "submit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("dataverifysubmit");
        }
        if (Objects.equals(callBackId, "audit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().getPageCache().put("confirmAudit", "1");
            this.getView().invokeOperation("audit");
            this.updateCardView(false, true);
        }
    }

    private void updateCardView(boolean isRefreshReport, boolean resetSelectedCard) {
        Optional<String> originReportIdsOP = Optional.ofNullable(this.getModel().getDataEntity().getString("originalreportids"));
        if (!originReportIdsOP.isPresent()) {
            return;
        }
        String reportIds = originReportIdsOP.get();
        List originalReportIdList = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.loadAdjustBillReportCardProps()), (QFilter[])new QFilter[]{new QFilter("id", "in", originalReportIdList)});
        this.initCardEntryEntityAndGetDefaultReport(reportDyColl, resetSelectedCard);
        this.switchParamLoadChangeReport("", isRefreshReport);
    }

    public void spreadF7Click(int row, int col) {
        CacheCell cell = this.getCellDataSource().getCell(row, col);
        if (cell == null) {
            return;
        }
        String billSign = Optional.ofNullable(cell.getWidgetValue()).map(o -> o.toString()).orElseGet(() -> null);
        if (EmptyUtil.isEmpty((String)billSign)) {
            return;
        }
        ListShowParameter spreadJSF7ListForm = ShowFormHelper.createShowListForm((String)billSign, (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "spreadjs_f7winclose_callback");
        spreadJSF7ListForm.setCloseCallBack(callBack);
        List filters = spreadJSF7ListForm.getListFilterParameter().getQFilters();
        List f7Filters = ((PlanChangeManageController)this.getOrCreateReportController()).getF7Filter(row, col, null);
        if (!Arrays.asList(DetailDimType.BANK_CATE.getExtVal(), DetailDimType.BUSINESS_PARTNER.getExtVal()).contains(billSign)) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)billSign);
            String nameProperty = basedataEntityType.getNameProperty();
            String numberProperty = basedataEntityType.getNumberProperty();
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)nameProperty) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)numberProperty)) {
                f7Filters.add(new QFilter("1", "!=", (Object)1));
            }
        }
        filters.addAll(f7Filters);
        this.getView().showForm((FormShowParameter)spreadJSF7ListForm);
        Cell finalCell = new Cell();
        finalCell.setRow(row);
        finalCell.setCol(col);
        this.getPageCache().put("cell_pagecache", FpmSerializeUtil.serialize((Object)finalCell));
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        CacheCell cell = this.getCellDataSource().getCell(args.getR(), args.getC());
        if (cell == null) {
            return;
        }
        CellTypeEnum cellType = cell.getCellType();
        List<Object> params = null;
        if (cellType == CellTypeEnum.F7WIDGET) {
            Object billSign = cell.getWidgetValue();
            if (billSign == null || billSign.toString().isEmpty()) {
                return;
            }
            params = this.queryBaseDataInfo(billSign, args);
        } else if (cellType == CellTypeEnum.DOWNBOXWIDGET || cellType == CellTypeEnum.MUTITYPEWIDGET) {
            Map comboxValues = (Map)cell.getWidgetValue();
            Set entries = comboxValues.entrySet();
            params = new ArrayList<Object>(comboxValues.size());
            for (Map.Entry entry : entries) {
                ArrayList<Object> param = new ArrayList<Object>();
                param.add(entry.getValue());
                param.add(entry.getValue());
                param.add(entry.getKey());
                params.add(param);
            }
        }
        HashMap<String, Object> f7Params = new HashMap<String, Object>();
        f7Params.put("data", params);
        f7Params.put("r", args.getR());
        f7Params.put("c", args.getC());
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.invokeControlMethod(this.getSpreadKey(), "setLookupData", new Object[]{f7Params});
    }

    private List<Object> queryBaseDataInfo(Object billSign, LookUpDataArgs args) {
        ArrayList<Object> result = new ArrayList<Object>(20);
        String nameProperty = "name";
        String numberProperty = "number";
        if (!Arrays.asList(DetailDimType.BANK_CATE.getExtVal(), DetailDimType.BUSINESS_PARTNER.getExtVal()).contains(billSign)) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)billSign.toString());
            nameProperty = basedataEntityType.getNameProperty();
            numberProperty = basedataEntityType.getNumberProperty();
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)nameProperty) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)numberProperty)) {
            return result;
        }
        List f7Filters = ((PlanChangeManageController)this.getOrCreateReportController()).getF7Filter(args.getR(), args.getC(), args.getValue().trim());
        DynamicObjectCollection elements = QueryServiceHelper.query((String)billSign.toString(), (String)String.join((CharSequence)",", "id", nameProperty, numberProperty), (QFilter[])f7Filters.toArray(new QFilter[0]), (String)"", (int)20);
        for (DynamicObject element : elements) {
            ArrayList<String> param = new ArrayList<String>(3);
            param.add(element.getString("id"));
            param.add(element.getString(numberProperty));
            param.add(element.getString(nameProperty));
            result.add(param);
        }
        return result;
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        if (EmptyUtil.isEmpty((String)arg.getName()) && EmptyUtil.isEmpty((String)arg.getNumber())) {
            return;
        }
        Cell cell = new Cell();
        cell.setRowAndCol(arg.getR(), arg.getC());
        cell.setDisplayValue((Object)arg.getName());
        Object value = arg.getId();
        value = !Long.valueOf(value.toString()).equals(0L) ? value : arg.getNumber();
        cell.setNewValue(value);
        cell.setValue(value);
        this.getOrCreateReportController().update(Collections.singletonList(cell));
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, false).generatorChain(this.getSpreadCommandInvoker(), Collections.singletonList(cell));
        spreadCommand.execCommand();
    }

    protected IPlanChangeManageController getOrCreateReportController() {
        if (null == this.planChangeManageController) {
            this.planChangeManageController = new PlanChangeManageController((IPlanChangeManageView)this);
        }
        return this.planChangeManageController;
    }

    private void initAdjustParamInfo() {
        DynamicObject defaultReportDy = null;
        Optional<String> originReportIdsOP = Optional.ofNullable(this.getModel().getDataEntity().getString("originalreportids"));
        if (!originReportIdsOP.isPresent()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u7684\u4e3b\u8868", (String)"ReportPlanAdjustPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String reportIds = originReportIdsOP.get();
        List originalReportIdList = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.loadAdjustBillReportCardProps()), (QFilter[])new QFilter[]{new QFilter("id", "in", originalReportIdList)});
        defaultReportDy = this.initCardEntryEntityAndGetDefaultReport(reportDyColl, true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailperiod"});
        DynamicObject reportType = (DynamicObject)this.getModel().getValue("reporttype");
        String detailReportType = reportType.getString("orgreporttype");
        if (EmptyUtil.isNoEmpty((String)detailReportType.trim())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"detailperiod"});
        }
        String amount = defaultReportDy.getString("template.amountunit");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"amountunit"});
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amountunit", (Object)amount);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"exratetable", (Object)defaultReportDy.getString("exratetable.name"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"exchangeratedate", (Object)defaultReportDy.getDate("exchangeratedate"));
        ComboEdit referIndex = (ComboEdit)this.getView().getControl("adjustreference");
        ArrayList<ComboItem> referIndexItems = new ArrayList<ComboItem>(16);
        String status = this.getModel().getDataEntity().getString("billstatus");
        for (PlanChangeReferIndex refer : PlanChangeReferIndex.getIsChoiceReferIndex()) {
            if (BillStatusEnum.AUDIT.getValue().equals(status) && refer != PlanChangeReferIndex.PLANAMT) continue;
            ComboItem comboItem = new ComboItem(new LocaleString(refer.getName()), refer.getValue());
            referIndexItems.add(comboItem);
        }
        referIndex.setComboItems(referIndexItems);
        String templateType = defaultReportDy.getString("template.templatetype");
        this.controlShowAdjustSubjectsFieldVisible(templateType, status, false);
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
        }
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
    }

    private DynamicObject initCardEntryEntityAndGetDefaultReport(DynamicObjectCollection reportDyColl, boolean resetSelectedCard) {
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        int[] currCardEntrySelectRows = cardEntry.getSelectRows();
        Long reportId = 0L;
        int index = 0;
        String managerJson = this.getView().getPageCache().get("adjustbill_reportdata_manager_cache");
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)managerJson)) {
            IReportDataManagerV2 managerV2 = (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
            reportId = managerV2.getReportId();
        }
        DynamicObjectCollection cardEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("card_entryentity");
        cardEntryEntity.clear();
        List reportList = reportDyColl.stream().sorted(Comparator.comparing(this::getReportScore)).collect(Collectors.toList());
        boolean dataChanged = this.getModel().getDataChanged();
        for (int i = 0; i < reportList.size(); ++i) {
            DynamicObject report = (DynamicObject)reportList.get(i);
            DynamicObject dynamicObject = cardEntryEntity.addNew();
            dynamicObject.set("cardreportname", (Object)report.getString("name"));
            dynamicObject.set("cardreportnumber", (Object)report.getString("billno"));
            dynamicObject.set("cardreportid", (Object)report.getString("id"));
            if (!NumberUtils.equals((Long)reportId, (Long)report.getLong("id"))) continue;
            index = i;
        }
        this.getModel().setDataChanged(dataChanged);
        DynamicObject defaultReportDy = (DynamicObject)reportList.get(0);
        if (currCardEntrySelectRows.length == 0) {
            currCardEntrySelectRows = new int[]{index};
        }
        this.selectDefaultCard(resetSelectedCard, currCardEntrySelectRows);
        return defaultReportDy;
    }

    private void selectDefaultCard(boolean resetSelectedCard, int[] currCardEntrySelectRows) {
        logger.info("\u6bcf\u6b21\u9009\u62e9\u65f6\u53c2\u6570-resetSelectedCard[{}]-currCardEntrySelectRows[{}]", (Object)resetSelectedCard, (Object)Arrays.stream(currCardEntrySelectRows).mapToObj(Integer::valueOf).map(String::valueOf).collect(Collectors.joining("#")));
        this.getView().updateView("card_entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        if (resetSelectedCard || currCardEntrySelectRows.length == 0) {
            this.getPageCache().put(INIT_REPORT_FIRST, "Y");
            cardEntry.selectRows(0, true);
        } else {
            int curCardIdx = currCardEntrySelectRows[0];
            cardEntry.selectRows(curCardIdx, true);
        }
    }

    private int getReportScore(DynamicObject report) {
        if (Objects.equals(report.getString("id"), this.getModel().getDataEntity().getString("mainreportid"))) {
            return 0;
        }
        return 1;
    }

    public void switchParamLoadChangeReport(String option, boolean sameReportIdNeedRefresh) {
        Long adjustId = Optional.ofNullable(this.getModel().getValue("id")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        if (!sameReportIdNeedRefresh) {
            return;
        }
        Long reportId = this.getReportId();
        if (EmptyUtil.isEmpty((Long)reportId)) {
            return;
        }
        if (option.equals("reportname")) {
            this.getOrCreateReportController().release();
            this.getOrCreateReportController().load(adjustId, reportId, this.getView().getPageId());
        } else {
            this.getOrCreateReportController().load(adjustId, reportId, this.getPageDimMemberIds(), this.getView().getPageId());
        }
    }

    private Long getReportId() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            String ids = this.getModel().getDataEntity().getString("originalreportids");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)ids)) {
                return 0L;
            }
            return Long.parseLong(ids.split(",")[0]);
        }
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return ((DynamicObject)entryEntity.get(0)).getLong("cardreportid");
        }
        Long reportId = ((DynamicObject)entryEntity.get(selectRows[0])).getLong("cardreportid");
        if (NumberUtils.equalsZero((Long)reportId)) {
            return ((DynamicObject)entryEntity.get(0)).getLong("cardreportid");
        }
        return reportId;
    }

    private List<Long> getPageDimMemberIds() {
        Long pageMember2;
        ArrayList<Long> pageDimS = new ArrayList<Long>(2);
        Long reportOrgId = this.getView().getModel().getDataEntity(true).getLong("reportorg.id");
        pageDimS.add(reportOrgId);
        Long pageMember1 = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("custompagemember1")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
        if (EmptyUtil.isNoEmpty((Long)pageMember1)) {
            pageDimS.add(pageMember1);
        }
        if (EmptyUtil.isNoEmpty((Long)(pageMember2 = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("custompagemember2")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null)))) {
            pageDimS.add(pageMember2);
        }
        return pageDimS;
    }

    private void convertHeadAndDoSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        PlanChangeRecord planChangeRecord = new PlanChangeRecord();
        planChangeRecord.setId((Long)dataEntity.getPkValue());
        planChangeRecord.setAdjustType((AdjustType)ITypeEnum.getByNumber((String)dataEntity.getString("adjusttype"), AdjustType.class));
        planChangeRecord.setCreatorId(String.valueOf(RequestContext.get().getCurrUserId()));
        planChangeRecord.setApplyDate(dataEntity.getDate("applydate"));
        planChangeRecord.setOriginalReportIdList(Arrays.stream(dataEntity.getString("originalreportids").split(",")).map(Long::valueOf).collect(Collectors.toList()));
        planChangeRecord.setAdjustReason(dataEntity.getString("adjustreason"));
        planChangeRecord.setAmountUnit(AmountUnit.getByNumber((String)dataEntity.getString("amountunit")));
        planChangeRecord.setAdjustRollPeriod(dataEntity.getBoolean("adjustrollperiod"));
        this.getOrCreateReportController().save(planChangeRecord);
    }

    private void trackUp() {
        Object reportId = this.getModel().getValue("mainreportid");
        ReportShowHelper.showReportPlanView(this.getView(), reportId, false);
    }

    private void initSpreadJSComponent(DynamicObject report) {
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        DynamicObject templateDy = report.getDynamicObject("template");
        String templateType = templateDy.getString("templatetype");
        if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
        }
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
    }

    private Map<String, Set<Integer>> markFlagOfCol(Book book) {
        HashMap<String, Set<Integer>> markMap = null;
        if (EmptyUtil.isNoEmpty((Object)book)) {
            markMap = new HashMap(16);
            List colDimsLst = book.getSheet().getCellList().stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.COLDIMS).collect(Collectors.toList());
            Set adjustAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.ADJUSTAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.ADJUSTAMT.getValue(), adjustAmtCols);
            Set adjustedAvaAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue(), adjustedAvaAmtCols);
            Set afterAdjAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.AFTERADJUSTAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.AFTERADJUSTAMT.getValue(), afterAdjAmtCols);
            this.getView().getPageCache().put("cellColMarkInfo", FpmSerializeUtil.serialize(markMap));
        } else {
            markMap = (Map)FpmSerializeUtil.deserialize((String)this.getView().getPageCache().get("cellColMarkInfo"), Map.class);
        }
        return markMap;
    }

    private void filterControlInit() {
        ReportPlanAdjustProp.FILTER_PROP_LIST.forEach(prop -> this.getView().setVisible(Boolean.FALSE, new String[]{prop}));
        String managerJson = this.getView().getPageCache().get("adjustbill_reportdata_manager_cache");
        IReportDataManagerV2 reportDataManager = (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        if (EmptyUtil.isEmpty((Object)reportTemplate)) {
            return;
        }
        Long systemId = reportTemplate.getSystemId();
        if (EmptyUtil.isEmpty((Collection)reportTemplate.getAllTemplateDim())) {
            return;
        }
        List filterDimList = reportTemplate.getAllTemplateDim().stream().filter(TemplateDim::isFilterDim).filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        int colFilterIndex = 1;
        int rowFilterIndex = 1;
        for (TemplateDim templateDim : filterDimList) {
            String controlKey = "";
            if (templateDim.getLocation() == DimLocation.COL) {
                controlKey = String.format("filter_col_0%s", colFilterIndex++);
            } else {
                if (templateDim.getLocation() != DimLocation.ROW) continue;
                controlKey = String.format("filter_row_0%s", rowFilterIndex++);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
            BasedataEdit filterDim = (BasedataEdit)this.getControl(controlKey);
            filterDim.setCaption(new LocaleString(templateDim.getDimensionName() + "\uff1a"));
            filterDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
                filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                filter.and("dimension", "=", (Object)templateDim.getDimensionId());
                if (templateDim.getDimType() == DimensionType.PERIOD) {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "in", (Object)templateDim.getMemberScope())});
                    List idList = query.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(idList)) {
                        filter.and("id", "in", (Object)templateDim.getMemberScope());
                    } else {
                        filter.and("id", "in", idList);
                    }
                } else {
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                }
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
            });
        }
    }

    private void rowAndColVisible() {
        String managerJson = this.getView().getPageCache().get("adjustbill_reportdata_manager_cache");
        IReportDataManagerV2 reportDataManager = (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        FundPlanSystem system = reportDataManager.getSystem();
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        if (reportTemplate.getTemplateType().isFixed()) {
            this.fixReportRowAndColVisible(meta, reportTemplate, system);
        }
        if (reportTemplate.getTemplateType().isDetail()) {
            this.detailReportRowAndColVisible(meta, reportTemplate, system, reportDataManager);
        }
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    private void handleDataVerifyNotify(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)operationResult.getMessage())) {
            this.showSuccessMessage(operationResult.getMessage());
            return;
        }
        InteractionContext interactionContext = operationResult.getInteractionContext();
        if (null == interactionContext) {
            return;
        }
        Map customShowParameter = interactionContext.getCustShowParameter();
        if (CollectionUtils.isEmpty((Map)customShowParameter)) {
            return;
        }
        customShowParameter.put("fromCommit", String.valueOf(false));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        this.getView().showForm(parameter);
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(cardEntry.getSelectRows()[0]);
            Long reportId = dynamicObject.getLong("cardreportid");
            this.verifyController = EmptyUtil.isNoEmpty((Long)reportId) ? new ReportVerifyControllerImpl((IReportVerifyView)this, reportId) : new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    private List<ReportRuleCheckDTO> initRuleCheckDTO(IReportVerifyController verifyController, boolean commit) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String managerJson = this.getView().getPageCache().get("adjustbill_reportdata_manager_cache");
        return ReportRuleCheckHelper.initRuleCheckDTOForAdjustPlan(Collections.singletonList(dataEntity), verifyController, managerJson, Boolean.FALSE, commit);
    }

    private CellDataSource getCellDataSource() {
        if (this.cellDataSource == null) {
            this.cellDataSource = new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId()));
        }
        return this.cellDataSource;
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    private void controlShowAdjustSubjectsFieldVisible(String templateType, String billStatus, boolean propertyChanged) {
        BiConsumer<Boolean, Boolean> biConsumer = (init, val) -> {
            if (propertyChanged) {
                this.getModel().setValue("showadjustsubjects", val);
                return;
            }
            this.getModel().beginInit();
            this.getModel().setValue("showadjustsubjects", val);
            this.getView().updateView("showadjustsubjects");
            this.getModel().endInit();
        };
        if (!Objects.equals(TemplateTypeEnum.FIXED.getValue(), templateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"showadjustsubjects"});
            biConsumer.accept(propertyChanged, Boolean.FALSE);
            return;
        }
        if (Objects.equals(BillStatusEnum.SAVE.getValue(), billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showadjustsubjects"});
            biConsumer.accept(propertyChanged, Boolean.FALSE);
            return;
        }
        if (Objects.equals(BillStatusEnum.SUBMIT.getValue(), billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showadjustsubjects"});
            biConsumer.accept(propertyChanged, Boolean.TRUE);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"showadjustsubjects"});
        biConsumer.accept(propertyChanged, Boolean.FALSE);
    }

    private List<Integer> getRollPeriodRow4DetailTemp(IReportDataManagerV2 reportDataManager, ReportTemplate reportTemplate) {
        TemplateDim mustInputTplDim;
        if (reportTemplate.getTemplateType() != TemplateType.DETAIL) {
            return Collections.emptyList();
        }
        Optional<TemplateDim> periodTplDimOpt = reportTemplate.getColDimList().stream().filter(item -> item.getDimType().isPeriodDim()).findAny();
        if (!periodTplDimOpt.isPresent()) {
            return Collections.emptyList();
        }
        TemplateDim periodTplDim = periodTplDimOpt.get();
        if (periodTplDim.isExpand()) {
            FundPlanSystem fundPlanSystem = reportDataManager.getSystem();
            Map systemDimMap = fundPlanSystem.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
            Optional<TemplateDim> mustInputTplDimOpt = reportTemplate.getColDimList().stream().filter(TemplateDim::isVisible).filter(tplDim -> !tplDim.isViDim()).filter(tplDim -> !tplDim.getDimType().isPeriodDim()).filter(tplDim -> !tplDim.isDetailDim()).filter(tplDim -> ((Dimension)systemDimMap.get(tplDim.getDimensionId())).isMustInput()).findAny();
            if (!mustInputTplDimOpt.isPresent()) {
                return Collections.emptyList();
            }
            mustInputTplDim = mustInputTplDimOpt.get();
        } else {
            mustInputTplDim = periodTplDim;
        }
        Long mustInputDimId = mustInputTplDim.getDimensionId();
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List colDimList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        int mustInputDimCol = colDimList.stream().filter(calcVal -> Objects.equals(mustInputDimId, calcVal.getDimensionId())).mapToInt(ReportCalcVal::getCol).findAny().getAsInt();
        CellDataSource cellDataSource = this.getCellDataSource();
        List<Integer> rollPeriodHideRows = IntStream.rangeClosed(meta.getRowOffSet(), meta.getMaxRow()).filter(row -> {
            CacheCell periodCell = cellDataSource.getCell(row, mustInputDimCol);
            if (Objects.isNull(periodCell)) {
                return false;
            }
            AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = this.auxiliaryCellStyleConvert.toAuxiliaryCellStyle(periodCell.getCellStyleMark());
            CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
            return cellStyleInfo.isL() != false && Objects.isNull(periodCell.getValue());
        }).mapToObj(Integer::valueOf).collect(Collectors.toList());
        return rollPeriodHideRows;
    }

    private boolean showAdjustSubject(PropertyChangedArgs e) {
        Boolean existAdjustSubject = (Boolean)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"exist_adjust_subject_cache", Boolean.class);
        Boolean oldValue = (Boolean)e.getChangeSet()[0].getOldValue();
        oldValue = Objects.isNull(oldValue) ? Boolean.FALSE : oldValue;
        Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
        if (!newValue.booleanValue() && oldValue.booleanValue() && (Objects.isNull(existAdjustSubject) || !existAdjustSubject.booleanValue())) {
            return false;
        }
        if (!newValue.booleanValue() || Objects.nonNull(existAdjustSubject) && existAdjustSubject.booleanValue()) {
            return true;
        }
        this.getModel().setValue("showadjustsubjects", (Object)Boolean.FALSE);
        this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u65e0\u8c03\u6574\u9879\uff0c\u65e0\u6cd5\u663e\u793a\u3002\u8bf7\u5148\u4fdd\u5b58\u8c03\u6574\u9879\u540e\u518d\u67e5\u770b\u3002", (String)"ReportPlanAdjustPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
        return false;
    }

    private List<Integer> listDetailReportHideRowByFilterDim(ReportTemplate reportTemplate, FundPlanSystem system) {
        if (!reportTemplate.getTemplateType().isDetail()) {
            return new ArrayList<Integer>(0);
        }
        List filterDimList = reportTemplate.getColDimList().stream().filter(tplDim -> !tplDim.isViDim()).filter(TemplateDim::isFilterDim).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        int i = 0;
        HashMap prop2MemberIdMap = new HashMap(8, 1.0f);
        HashMap<String, Long> prop2DimIdMap = new HashMap<String, Long>(8, 1.0f);
        for (int j = 0; i < filterDimList.size() && j < ReportPlanAdjustProp.FILTER_COL_PROP_LIST.size(); ++i, ++j) {
            String filterColProp = (String)ReportPlanProp.FILTER_COL_PROP_LIST.get(j);
            DynamicObjectCollection filterColMemberDyColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(filterColProp);
            Set filterColMemberIdSet = filterColMemberDyColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(filterColMemberIdSet)) continue;
            prop2MemberIdMap.put(filterColProp, filterColMemberIdSet);
            prop2DimIdMap.put(filterColProp, ((TemplateDim)filterDimList.get(i)).getDimensionId());
        }
        if (MapUtils.isEmpty(prop2MemberIdMap) && MapUtils.isEmpty(prop2DimIdMap)) {
            return new ArrayList<Integer>(0);
        }
        boolean hasDetailPeriod = this.hasDetailPeriodByPageCache(system);
        int dataStartRow = reportTemplate.getTotalRow() + reportTemplate.getDataStartRow(hasDetailPeriod) + 1;
        int dataMaxRow = dataStartRow + reportTemplate.getMaxLineCount() - 1;
        Set filterColDimIdSet = prop2DimIdMap.values().stream().collect(Collectors.toSet());
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Map<Long, List<ReportCalcVal>> dimId2ColNodeMap = currColDimValList.stream().filter(item -> filterColDimIdSet.contains(item.getDimensionId())).filter(item -> item.getValue() != null).collect(Collectors.groupingBy(ReportCalcVal::getDimensionId));
        Set expandDimIdSet = reportTemplate.getColDimList().stream().filter(TemplateDim::isExpand).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        ArrayList<Integer> needHideRowList = new ArrayList<Integer>(10);
        int[] emptyRowArr = new int[dataMaxRow + 1];
        int lastNonEmptyRow = -1;
        for (int row2 = dataStartRow; row2 <= dataMaxRow; ++row2) {
            if (this.isEmptyRowIfDetailReport(row2, currColDimValList)) {
                emptyRowArr[row2] = 1;
                continue;
            }
            lastNonEmptyRow = row2;
            boolean isHideRow = false;
            for (Map.Entry prop2DimIdEntry : prop2DimIdMap.entrySet()) {
                if (isHideRow) break;
                boolean memberAnyMatch = false;
                Long dimId = (Long)prop2DimIdEntry.getValue();
                List<ReportCalcVal> colNodeList = dimId2ColNodeMap.get(dimId);
                Set filterMemberIdSet = (Set)prop2MemberIdMap.get(prop2DimIdEntry.getKey());
                for (ReportCalcVal colNode : colNodeList) {
                    Object cellVal;
                    if (expandDimIdSet.contains(colNode.getDimensionId())) {
                        cellVal = colNode.getValue();
                    } else {
                        int col = colNode.getCol();
                        CacheCell currDimValCell = this.getCellDataSource().getCell(row2, col);
                        cellVal = Objects.nonNull(currDimValCell) ? currDimValCell.getValue() : null;
                    }
                    if (!(memberAnyMatch = Objects.nonNull(cellVal) && filterMemberIdSet.contains(cellVal))) continue;
                    break;
                }
                isHideRow = isHideRow || !memberAnyMatch;
            }
            if (!isHideRow) continue;
            needHideRowList.add(row2);
        }
        if (lastNonEmptyRow >= 0) {
            IntStream.range(0, lastNonEmptyRow).filter(row -> emptyRowArr[row] == 1).forEach(row -> needHideRowList.add(row));
        }
        return needHideRowList;
    }

    private boolean isEmptyRowIfDetailReport(int row, List<ReportCalcVal> colDimValLeafList) {
        for (ReportCalcVal colNode : colDimValLeafList) {
            int col = colNode.getCol();
            CacheCell currDimValCell = this.getCellDataSource().getCell(row, col);
            if (!Objects.nonNull(currDimValCell) || !EmptyUtil.isNoEmpty((Object)currDimValCell.getValue())) continue;
            return false;
        }
        return true;
    }

    private void beforeDataVerifySubmitOp(BeforeDoOperationEventArgs args) {
        IReportVerifyController verifyController = this.getReportVerifyController();
        List<ReportRuleCheckDTO> dataVerifyRuleFilter = this.initRuleCheckDTO(verifyController, Boolean.TRUE);
        if (!CollectionUtils.isEmpty(dataVerifyRuleFilter)) {
            for (ReportRuleCheckDTO checkDTO : dataVerifyRuleFilter) {
                verifyController.ruleCheck(checkDTO, args);
                if (!args.isCancel()) continue;
                break;
            }
        }
        if (!args.isCancel()) {
            this.saveAndRefresh(false);
            OperationResult submitOpResult = this.getView().invokeOperation("submit");
            if (submitOpResult.isSuccess()) {
                this.updateCardView(false, true);
            } else {
                this.updateCardView(false, false);
            }
        }
    }

    private void lockAdjustRollPeriodSwitchIfNeed() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billStatus = dataEntity.getString("billstatus");
        if (!Objects.equals(BillStatusEnum.SAVE.getValue(), billStatus)) {
            return;
        }
        Long reportTypeId = dataEntity.getLong("reporttype.id");
        Long systemId = dataEntity.getLong("bodysys.id");
        String isRollProp = "applyrereportentry.isroll";
        String rollNumberProp = "applyrereportentry.rollnumber";
        QFilter qFilter = new QFilter("id", "=", (Object)systemId).and("applyrereportentry.rerporttype", "=", (Object)reportTypeId);
        DynamicObjectCollection reportTypeDyColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)(isRollProp + "," + rollNumberProp), (QFilter[])qFilter.toArray());
        DynamicObject reportTypeDy = (DynamicObject)reportTypeDyColl.get(0);
        boolean isRoll = reportTypeDy.getBoolean(isRollProp);
        int rollNumber = reportTypeDy.getInt(rollNumberProp);
        if (!isRoll || rollNumber <= 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"adjustrollperiod"});
        }
    }

    private List<Integer> loadAdjustReferHideCols(ReportTemplate reportTemplate, FundPlanSystem fundPlanSystem, List<ReportCalcVal> colDimValList) {
        Dimension adjustDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.ADJUSTDATATYPE);
        Map<String, Long> adjustDimMemberMap = adjustDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getNumber, DimMember::getId, (a, b) -> a));
        HashSet<Long> referIndexSet = new HashSet<Long>(8, 1.0f);
        referIndexSet.add(adjustDimMemberMap.get(PlanChangeReferIndex.CURRENTPLANAMT.getValue()));
        referIndexSet.add(adjustDimMemberMap.get(PlanChangeReferIndex.ADJUSTAMT.getValue()));
        referIndexSet.add(adjustDimMemberMap.get(PlanChangeReferIndex.AFTERADJUSTAMT.getValue()));
        Object adjustRefer = this.getModel().getValue("adjustreference");
        if (EmptyUtil.isNoEmpty((Object)adjustRefer)) {
            String[] refers;
            for (String refer : refers = adjustRefer.toString().split(",")) {
                if (!EmptyUtil.isNoEmpty((String)refer.trim())) continue;
                referIndexSet.add(adjustDimMemberMap.get(refer.trim()));
            }
        }
        TemplateDim adjustTypeDim = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get();
        List needHideList = colDimValList.stream().filter(item -> Objects.equals(item.getDimensionId(), adjustTypeDim.getDimensionId())).filter(item -> !referIndexSet.contains(item.getValue())).collect(Collectors.toList());
        LinkedList<Integer> needHideColList = new LinkedList<Integer>();
        for (ReportCalcVal reportCalcVal : needHideList) {
            needHideColList.add(reportCalcVal.getCol());
            for (int i = 1; i < reportCalcVal.getColSpan(); ++i) {
                needHideColList.add(reportCalcVal.getCol() + i);
            }
        }
        return needHideColList;
    }

    private boolean hasDetailPeriodByPageCache(FundPlanSystem system) {
        Long periodTypeId = this.getModel().getDataEntity().getLong("reporttype.id");
        ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(periodTypeId);
        return reportPeriodType.getDetailPeriodType() != null;
    }

    private void fixReportRowAndColVisible(CacheCellMeta meta, ReportTemplate reportTemplate, FundPlanSystem fundPlanSystem) {
        if (!reportTemplate.getTemplateType().isFixed()) {
            return;
        }
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List<Integer> needHideColList = this.loadAdjustReferHideCols(reportTemplate, fundPlanSystem, currColDimValList);
        List filterColDimList = reportTemplate.getColDimList().stream().filter(item -> !item.isViDim()).filter(TemplateDim::isFilterDim).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(filterColDimList)) {
            int i = 0;
            ArrayList<Predicate<ReportCalcVal>> hideColPredicateListByFilterCol = new ArrayList<Predicate<ReportCalcVal>>(filterColDimList.size());
            while (i < filterColDimList.size() && i < ReportPlanAdjustProp.FIX_TEMP_COL_PROP_LIST.size()) {
                DynamicObjectCollection currFilterMemberDyColl = this.getModel().getDataEntity(true).getDynamicObjectCollection((String)ReportPlanAdjustProp.FIX_TEMP_COL_PROP_LIST.get(i));
                Predicate<ReportCalcVal> currHideColPredicateByFilterCol = reportCalcVal -> false;
                if (CollectionUtils.isEmpty((Collection)currFilterMemberDyColl)) {
                    ++i;
                    hideColPredicateListByFilterCol.add(currHideColPredicateByFilterCol);
                    continue;
                }
                Set currFilterMemberIdSet = currFilterMemberDyColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty((Collection)currFilterMemberIdSet)) {
                    boolean hasDetailPeriod;
                    TemplateDim currFilterTplDim = (TemplateDim)filterColDimList.get(i);
                    Long currFilterDimId = currFilterTplDim.getDimensionId();
                    int currFilterColDimMaxRow = currColDimValList.stream().filter(item -> Objects.equals(currFilterDimId, item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0);
                    int currFilterColDimMinRow = currColDimValList.stream().filter(item -> Objects.equals(currFilterDimId, item.getDimensionId())).mapToInt(ReportCalcVal::getRow).min().orElse(0);
                    if (currFilterTplDim.getDimType() == DimensionType.PERIOD && (hasDetailPeriod = this.hasDetailPeriodByPageCache(fundPlanSystem))) {
                        currFilterMemberDyColl.stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> item.getDynamicObject("parent")).filter(Objects::nonNull).map(item -> item.getLong("id")).filter(item -> item > 0L).forEach(currFilterMemberIdSet::add);
                    }
                    currHideColPredicateByFilterCol = reportCalcVal -> currFilterDimId.equals(reportCalcVal.getDimensionId()) && !currFilterMemberIdSet.contains(reportCalcVal.getValue()) && currFilterColDimMinRow <= reportCalcVal.getRow() && currFilterColDimMaxRow >= reportCalcVal.getRow();
                }
                hideColPredicateListByFilterCol.add(currHideColPredicateByFilterCol);
                ++i;
            }
            List needHideList = currColDimValList.stream().filter(item -> !item.isReferenceCell()).filter(item -> item.getValue() != null).filter(item -> {
                for (Predicate predicate : hideColPredicateListByFilterCol) {
                    if (!predicate.test(item)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            HashSet<Integer> needHideColSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal2 : needHideList) {
                needHideColSet.add(reportCalcVal2.getCol());
                for (i = 1; i < reportCalcVal2.getColSpan(); ++i) {
                    needHideColSet.add(reportCalcVal2.getCol() + i);
                }
            }
            needHideColList.addAll(needHideColSet);
        }
        LinkedList<Integer> needHideRowList = new LinkedList<Integer>();
        List rowDimList = reportTemplate.getRowDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObjectCollection firstRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_01");
        DynamicObjectCollection secondRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_02");
        if (!CollectionUtils.isEmpty((Collection)firstRowIdList) || !CollectionUtils.isEmpty((Collection)secondRowIdList)) {
            List currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
            List firstRowDimIdList = firstRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            List secondRowDimIdList = secondRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            List needHideList = currRowDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstRowDimIdList) && !firstRowDimIdList.contains(item.getValue()) && ((TemplateDim)rowDimList.get(0)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondRowDimIdList) && !secondRowDimIdList.contains(item.getValue()) && ((TemplateDim)rowDimList.get(1)).getDimensionId().equals(item.getDimensionId()))).collect(Collectors.toList());
            HashSet<Integer> needHidRowSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal3 : needHideList) {
                needHidRowSet.add(reportCalcVal3.getRow());
                for (int i = 1; i < reportCalcVal3.getRowSpan(); ++i) {
                    needHidRowSet.add(reportCalcVal3.getRow() + i);
                }
            }
            needHideRowList.addAll(needHidRowSet);
        }
        List<Integer> unadjustedSubjectRows = this.listFixReportUnAdjustedSubjectRow(meta, reportTemplate, fundPlanSystem);
        needHideRowList.addAll(unadjustedSubjectRows);
        this.setRowAndColVisible(needHideRowList, needHideColList);
    }

    private void setRowAndColVisible(List<Integer> needHideRowList, List<Integer> needHideColList) {
        String hideColsStr = this.getPageCache().get("HIDECOLS");
        String hideRowsStr = this.getPageCache().get("HIDEROWS");
        if (!StringUtils.isEmpty((Object)hideColsStr) || !StringUtils.isEmpty((Object)hideRowsStr)) {
            List colS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideColsStr)) {
                colS = JSONArray.parseArray((String)hideColsStr, Integer.class);
            }
            List rowS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideRowsStr)) {
                rowS = JSONArray.parseArray((String)hideRowsStr, Integer.class);
            }
            RowAndColVisibleCmdChain showSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), rowS, colS, Boolean.valueOf(true));
            showSpreadCommand.execCommand();
        }
        if (!CollectionUtils.isEmpty(needHideRowList) || !CollectionUtils.isEmpty(needHideColList)) {
            RowAndColVisibleCmdChain hideSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), needHideRowList, needHideColList, Boolean.valueOf(false));
            hideSpreadCommand.execCommand();
            this.getPageCache().put("HIDECOLS", JSON.toJSONString(needHideColList));
            this.getPageCache().put("HIDEROWS", JSON.toJSONString(needHideRowList));
        }
    }

    private void detailReportRowAndColVisible(CacheCellMeta meta, ReportTemplate reportTemplate, FundPlanSystem fundPlanSystem, IReportDataManagerV2 reportDataManager) {
        if (!reportTemplate.getTemplateType().isDetail()) {
            return;
        }
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List<Integer> needHideColList = this.loadAdjustReferHideCols(reportTemplate, fundPlanSystem, currColDimValList);
        LinkedList<Integer> needHideRowList = new LinkedList<Integer>();
        List<Integer> detailReportHideTotalRows = this.listDetailReportHideTotalRow(meta, reportTemplate);
        needHideRowList.addAll(detailReportHideTotalRows);
        List<Integer> detailReportHideRowsByFilterDim = this.listDetailReportHideRowByFilterDim(reportTemplate, fundPlanSystem);
        needHideRowList.addAll(detailReportHideRowsByFilterDim);
        List<Integer> rollPeriodHideRows = this.getRollPeriodRow4DetailTemp(reportDataManager, reportTemplate);
        needHideRowList.addAll(rollPeriodHideRows);
        this.setRowAndColVisible(needHideRowList, needHideColList);
    }

    private List<Integer> listDetailReportHideTotalRow(CacheCellMeta meta, ReportTemplate reportTemplate) {
        List currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        LinkedList<Integer> needHideRowList = new LinkedList<Integer>();
        if (reportTemplate.getTotalRow() > 0) {
            int currRow = currColDimValList.stream().max(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
            for (int i = 1; i <= reportTemplate.getTotalRow(); ++i) {
                needHideRowList.add(++currRow);
            }
        }
        if (reportTemplate.getTemplateType() == TemplateType.DETAIL) {
            int colDimMaxRow = currColDimValList.stream().mapToInt(ReportCalcVal::getEndRow).max().getAsInt();
            IntStream.range(colDimMaxRow + 1, meta.getRowOffSet()).forEach(totalRow -> needHideRowList.add(totalRow));
        }
        return needHideRowList;
    }

    private List<Integer> listFixReportUnAdjustedSubjectRow(CacheCellMeta meta, ReportTemplate reportTemplate, FundPlanSystem fundPlanSystem) {
        int i;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean showAdjustSubjects = dataEntity.getBoolean("showadjustsubjects");
        String billStatus = dataEntity.getString("billstatus");
        if (Objects.equals(billStatus, BillStatus.AUDITED.getNumber()) || !showAdjustSubjects || reportTemplate == null || !reportTemplate.getTemplateType().isFixed() || fundPlanSystem == null || meta == null) {
            return new ArrayList<Integer>(0);
        }
        Dimension adjustDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.ADJUSTDATATYPE);
        Map<String, Long> adjustDimMemberMap = adjustDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getNumber, DimMember::getId, (a, b) -> a));
        HashSet<Long> referIndexSet = new HashSet<Long>(1, 1.0f);
        referIndexSet.add(adjustDimMemberMap.get(PlanChangeReferIndex.ADJUSTAMT.getValue()));
        List colDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List adjustAmtCaclValLIst = colDimValList.stream().filter(item -> Objects.equals(item.getDimensionId(), adjustDim.getId())).filter(item -> referIndexSet.contains(item.getValue())).collect(Collectors.toList());
        HashSet<Integer> adjustAmtColSet = new HashSet<Integer>(8);
        for (ReportCalcVal reportCalcVal : adjustAmtCaclValLIst) {
            adjustAmtColSet.add(reportCalcVal.getCol());
            for (i = 1; i < reportCalcVal.getColSpan(); ++i) {
                adjustAmtColSet.add(reportCalcVal.getCol() + i);
            }
        }
        LinkedList<Integer> unadjustedSubjectRows = new LinkedList<Integer>();
        CellDataSource cellDataSource = this.getCellDataSource();
        for (i = meta.getRowOffSet(); i <= meta.getMaxRow(); ++i) {
            boolean adjusted = false;
            Iterator iterator = adjustAmtColSet.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                CacheCell cell = cellDataSource.getCell(i, j);
                if (cell == null || !EmptyUtil.isNoEmpty((Object)cell.getValue())) continue;
                adjusted = true;
                break;
            }
            if (adjusted) continue;
            unadjustedSubjectRows.add(i);
        }
        return unadjustedSubjectRows;
    }

    private void hideRowByMeta() {
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        if (meta == null || CollectionUtils.isEmpty((Collection)meta.getHideRowSet())) {
            return;
        }
        RowAndColVisibleCmdChain rowAndColVisibleCmdChain = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), new ArrayList(meta.getHideRowSet()), null, Boolean.valueOf(false));
        rowAndColVisibleCmdChain.execCommand();
    }
}

