/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.Objects;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;

public class ReportPlanAttachPlugin
extends AbstractBasePlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        IDataModel dataModel = this.getView().getModel();
        switch (opKey) {
            case "save": 
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                Long reportId = Long.valueOf(dataModel.getValue("reportid").toString());
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fpm_report");
                DynamicObject reportDy = new DynamicObject((DynamicObjectType)entityType);
                Long attachId = Optional.ofNullable(this.getView().getPageCache().get("attachId")).map(Long::valueOf).orElseGet(() -> 0L);
                reportDy.set("id", (Object)reportId);
                reportDy.set("attachinfo", (Object)attachId);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{reportDy});
                break;
            }
            case "addattach": {
                OperationStatus operationStatus = OperationStatus.ADDNEW;
                BaseShowParameter showParameter = new BaseShowParameter();
                Long reportId = Long.valueOf(dataModel.getValue("reportid").toString());
                DynamicObject reportDy = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_report", (String)String.format("%s,%s,%s,%s", "id", "name", "billstatus", "attachinfo"));
                ReportProcessStatus processStatus = Optional.ofNullable(reportDy.get("billstatus")).map(o -> ReportProcessStatus.getStatusByVal((String)o.toString())).orElseGet(() -> null);
                Long attachId = Optional.ofNullable(reportDy.getDynamicObject("attachinfo")).filter(Objects::nonNull).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> 0L);
                if (processStatus == ReportProcessStatus.SUBMIT || processStatus == ReportProcessStatus.AUDIT) {
                    if (attachId != null && attachId.compareTo(0L) != 0) {
                        showParameter.setPkId((Object)attachId);
                    }
                    operationStatus = OperationStatus.VIEW;
                } else if (processStatus == ReportProcessStatus.SAVE && attachId != null && attachId.compareTo(0L) != 0) {
                    showParameter.setPkId((Object)attachId);
                    operationStatus = OperationStatus.EDIT;
                }
                showParameter.setStatus(operationStatus);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("fpm_reportattachment");
                showParameter.setCustomParam("linkreportid", (Object)reportId);
                showParameter.setCustomParam("linkreportname", (Object)reportDy.getString("name"));
                showParameter.setCustomParam("pageType", (Object)this.getPageCache().get("pageType"));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_linkattach_close"));
                showParameter.setShowClose(false);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("callback_linkattach_close".equals(key)) {
            Optional.ofNullable(event.getReturnData()).ifPresent(attachId -> this.getView().getPageCache().put("attachId", attachId.toString()));
        }
    }
}

