/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.export.excel.impl.PlanExecFormsExportImpl;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.PlanAmtVersionEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.TemplateMetricTypeEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.system.DefaultModelHelper;
import org.apache.commons.compress.utils.Sets;

public class ReportPlanExecAnalysPlugin
extends AbstractSpreadPlugin
implements IAnalysisReportManageView,
SearchListener {
    private IAnalysisReportManageController controller;
    private CellDataSource cellDS;
    public static final List<String> allowSearchMetricType = Arrays.asList(TemplateMetricTypeEnum.PLANAMT.getCode(), TemplateMetricTypeEnum.LOCKAMT.getCode(), TemplateMetricTypeEnum.ACTMAT.getCode());

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxcol");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxrow");
        this.getOrCreateReportController().release();
    }

    public void search(SearchEvent searchEvent) {
        AnalysisHeader header;
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        boolean isSuccess = this.getAnalysisHeader(reportQueryParam, header = new AnalysisHeader());
        if (!isSuccess) {
            return;
        }
        this.getOrCreateReportController().loadAnalysisReport(AnalysisReportType.PLANEXECANALYS, header);
        this.getModel().setValue("exratetable", (Object)header.getExchangeRateTableId());
        this.getModel().setValue("exchangeratedate", (Object)header.getExchangeRateDate());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "exportexcel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"print"});
    }

    public void initialize() {
        super.initialize();
        this.initF7Widget();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
        this.handleCustomDimension();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("exportexcel".equals(opKey)) {
            AnalysisHeader header = new AnalysisHeader();
            boolean success = this.getAnalysisHeader(null, header);
            if (!success) {
                return;
            }
            PlanExecFormsExportImpl exportExcel = new PlanExecFormsExportImpl(header);
            Tuple exportResult = exportExcel.export();
            if (((Boolean)exportResult.item1).booleanValue()) {
                this.getView().download((String)exportResult.item2);
            } else {
                this.showErrMessage(Collections.singletonList(exportResult.item2));
            }
        } else if ("refresh".equals(opKey)) {
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
        } else if ("print".equals(opKey)) {
            this.getSpreadCommandInvoker().print();
        } else if ("showemptyrow".equals(opKey)) {
            this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getEmptyValRows());
        } else if ("hideemptyrow".equals(opKey)) {
            this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getEmptyValRows());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        new InitialToolbarAndRightKeyItemGenerator(null, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_planexecanalys");
        if (EmptyUtil.isNoEmpty((Long)systemId)) {
            this.initBodySystem(systemId);
        }
        this.handleCustomDimension();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        switch (propName) {
            case "bodysystem": {
                if (newValue == null) {
                    return;
                }
                this.getModel().setValue("reporttype", null);
                this.getModel().setValue("period", null);
                this.getModel().setValue("org", null);
                this.getModel().setValue("flow", (Object)FlowEnum.NONLIMIT.getValue());
                this.getModel().setValue("subjects", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("company", null);
                this.getModel().setValue("settlementmethod", null);
                this.getModel().setValue("containdetailreporttype", (Object)false);
                this.getModel().setValue("metricmember", null);
                DynamicObject bodysystem = (DynamicObject)newValue;
                this.initBodySystem(bodysystem.getPkValue());
                this.getModel().setValue("custommember1", null);
                this.getModel().setValue("custommember2", null);
                this.getModel().setValue("custommember3", null);
                this.handleCustomDimension();
                DefaultModelHelper.save((Long)bodysystem.getPkValue());
                break;
            }
            case "reporttype": {
                if (newValue == null) {
                    return;
                }
                DynamicObject reportType = (DynamicObject)newValue;
                String detailReportType = reportType.getString("orgreporttype");
                this.getView().setEnable(Boolean.valueOf(EmptyUtil.isNotEmpty((CharSequence)detailReportType)), new String[]{"containdetailreporttype"});
                this.getModel().setValue("containdetailreporttype", (Object)Boolean.FALSE);
                this.getModel().setValue("period", null);
                break;
            }
            case "flow": {
                if (FlowEnum.NONLIMIT.getValue().equals(newValue)) break;
                DynamicObjectCollection subjectList = new DynamicObjectCollection();
                DynamicObjectCollection subjects = (DynamicObjectCollection)this.getModel().getValue("subjects");
                for (DynamicObject subject : subjects) {
                    if (!subject.getString("fbasedataid.flow").equals(newValue)) continue;
                    subjectList.add((Object)subject);
                }
                if (subjectList.size() < 1) {
                    subjectList = null;
                }
                this.getModel().setValue("subjects", (Object)subjectList);
                break;
            }
            case "amountunit": {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.addSearchListener((SearchListener)this);
                control.search();
                break;
            }
            case "metricmember": {
                this.tipSelectedInvalidMetricIfNeed((DynamicObjectCollection)newValue);
                break;
            }
        }
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String err = ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        Integer currentMaxRow = book.getSheet().getRows().stream().max(Integer::compareTo).orElse(0);
        Integer currentMaxCol = book.getSheet().getCols().stream().max(Integer::compareTo).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)Math.max(maxRow, currentMaxRow));
        List maxCols = Sheet.generateIntegerNumByScope((Integer)Math.max(maxCol, currentMaxCol));
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(2);
        extraMenuItems.add(ContextMenuItemsEnum.LINK_SEARCH_ANALYSE_REPORT);
        extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHEXECRECORD);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        AbsSpreadCommand initialToolBarCommand = (AbsSpreadCommand)new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(invoker);
        spreadCommand.appendTailCommand(initialToolBarCommand);
        spreadCommand.execCommand();
        Map<Integer, List<Cell>> rowCellMap = book.getSheet().getCellList().stream().filter(o -> o.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.groupingBy(Cell::getRow));
        List rows = rowCellMap.entrySet().stream().filter(o -> ((List)o.getValue()).stream().noneMatch(cell -> EmptyUtil.isNoEmpty((Object)cell.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"emptyRows", rows);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", (Object)currentMaxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", (Object)currentMaxCol);
    }

    public void refreshAnalysisBook(Book book) {
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate template) {
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void linkSearchExecRecord(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataBeforeLinkSearch()) {
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkexecrecord");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("bodysystem", dataEntity.getDynamicObject("bodysystem").getPkValue());
        formShowParameter.setCustomParam("reporttype", dataEntity.getDynamicObject("reporttype").getPkValue());
        formShowParameter.setCustomParam("amountunit", dataEntity.get("amountunit"));
        List<Map<Long, ReportCalcVal>> selectedRowDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
        List<Map<Long, ReportCalcVal>> selectedColDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        formShowParameter.setCustomParam("pageDimMemberIds", new ArrayList(0));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    private void initF7Widget() {
        IDataModel model = this.getModel();
        String errTip1 = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"FundPositionTableReportPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        String errTip2 = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u62a5\u7c7b\u578b\u3002", (String)"FundPositionTableReportPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        BasedataEdit bodysystemEdit = (BasedataEdit)this.getControl("bodysystem");
        bodysystemEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter systemAuthFilter = ModelHelper.getSystemAuthWithCheckManagerFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_planexecanalys");
            showParameter.getListFilterParameter().setFilter(systemAuthFilter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportTypeEdit = (BasedataEdit)this.getControl("reporttype");
        reportTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            List rerporttypeids = bodysystem.getDynamicObjectCollection("applyrereportentry").stream().map(o -> o.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", rerporttypeids);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject reporttype = (DynamicObject)model.getValue("reporttype");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            if (reporttype == null) {
                throw new KDBizException(errTip2);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("reporttype", "=", reporttype.getPkValue());
            String periodType = reporttype.getString("orgreportcycle");
            if (PeriodType.MONTH_WEEK.getNumber().equals(periodType)) {
                filter.and("periodtype", "in", (Object)new Object[]{PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
            } else {
                filter.and("periodtype", "in", (Object)new Object[]{periodType});
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            QFilter orgAuthFilter = ModelHelper.getOrgAuthWithCheckManagerFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_planexecanalys");
            filter.and(orgAuthFilter);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit subjectsEdit = (BasedataEdit)this.getControl("subjects");
        subjectsEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String flow = (String)model.getValue("flow");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            if (!FlowEnum.NONLIMIT.getValue().equals(flow)) {
                filter.and("flow", "=", (Object)flow);
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        currencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportCurrencyEdit = (BasedataEdit)this.getControl("reportcurrency");
        reportCurrencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit companyEdit = (BasedataEdit)this.getControl("company");
        companyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit settlementmethodEdit = (BasedataEdit)this.getControl("settlementmethod");
        settlementmethodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        MulBasedataEdit metricMember = (MulBasedataEdit)this.getControl("metricmember");
        metricMember.addBeforeF7SelectListener(this.getBeforeF7SelectListener());
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("plannversion");
        mulComboEdit.setComboItems(Collections.singletonList(new ComboItem(new LocaleString(PlanAmtVersionEnum.EFFECTIVEVERSION.getName()), PlanAmtVersionEnum.EFFECTIVEVERSION.getValue())));
    }

    private BeforeF7SelectListener getBeforeF7SelectListener() {
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                String key;
                DynamicObject model = (DynamicObject)ReportPlanExecAnalysPlugin.this.getModel().getValue("bodysystem");
                if (model == null) {
                    ReportPlanExecAnalysPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"FundPositionTableReportPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return null;
                }
                BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
                switch (key = basedataEdit.getKey()) {
                    case "metricmember": {
                        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                        showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"TemplateManageBasePlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", model.getPkValue()).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber())).build();
                    }
                }
                return 1.qFilterResultBuilder().build();
            }
        };
    }

    private void initBodySystem(Object pkValue) {
        DynamicObject bodysystem = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"fpm_bodysysmanage");
        if (bodysystem == null) {
            return;
        }
        this.getModel().setValue("bodysystem", bodysystem.getPkValue());
        QFilter memberFilter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("number", "!=", (Object)DimensionType.PERIOD.getNumber());
        DynamicObjectCollection dimtypes = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{memberFilter}, (String)"id");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company", "settlementmethod"});
        boolean companyVisible = false;
        boolean settlementVisible = false;
        for (DynamicObject dimtype : dimtypes) {
            String number = dimtype.getString("number");
            if (DimensionType.COMPANY.getNumber().equals(number)) {
                companyVisible = true;
                continue;
            }
            if (DimensionType.SETTLEMENT_TYPE.getNumber().equals(number)) {
                settlementVisible = true;
                continue;
            }
            if (!companyVisible || !settlementVisible) continue;
            break;
        }
        this.getView().setVisible(Boolean.valueOf(companyVisible), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(settlementVisible), new String[]{"settlementmethod"});
        Optional<DynamicObject> rerporttype = bodysystem.getDynamicObjectCollection("applyrereportentry").stream().filter(item -> "enable".equals(item.getString("rereporttypestatus"))).map(item -> item.getDynamicObject("rerporttype")).findFirst();
        if (rerporttype.isPresent()) {
            this.getModel().setValue("reporttype", rerporttype.get().getPkValue());
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("reporttype", "=", rerporttype.get().getPkValue());
            filter.and("periodtype", "=", (Object)rerporttype.get().getString("orgreportcycle"));
            filter.and("startdate", "<=", (Object)new Date());
            DynamicObjectCollection periodMems = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"longnumber desc");
            if (periodMems != null && periodMems.size() > 0) {
                this.getModel().setValue("period", (Object)new Long[]{((DynamicObject)periodMems.get(0)).getLong("id")});
            }
        }
        QFilter qFilter = new QFilter("sourceid", "=", bodysystem.getDynamicObject("currency").getPkValue());
        qFilter.and(new QFilter("bodysystem", "=", bodysystem.getPkValue()));
        qFilter.and(new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()));
        DynamicObject targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("reportcurrency", (Object)Optional.ofNullable(targetCurrency).map(o -> o.getLong("id")).orElseGet(() -> null));
        List<String> metricTypes = Arrays.asList(TemplateMetricType.PLANAMT.getCode(), TemplateMetricType.LOCKAMT.getCode(), TemplateMetricType.ACTMAT.getCode(), TemplateMetricType.AVAILABLEAMT.getCode(), TemplateMetricType.EXECUTEPERCENT.getCode(), TemplateMetricType.DEVIATIONPERCENT.getCode());
        QFilter metricFilter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
        metricFilter.and(new QFilter("dimtype", "=", (Object)DimensionType.METRIC.getNumber()));
        metricFilter.and(new QFilter("metricpresettype", "in", metricTypes));
        DynamicObject[] metricDOS = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{metricFilter}, (String)"number asc");
        Object[] objects = Arrays.stream(metricDOS).map(DataEntityBase::getPkValue).map(Long.class::cast).toArray();
        this.getModel().setValue("metricmember", (Object)objects);
    }

    private IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader header) {
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        Map<String, Object> filterItemMap = reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, o -> o.getValue(), (a, b) -> a));
        DynamicObject bodysystem = (DynamicObject)filterItemMap.get("bodysystem");
        DynamicObject reporttype = (DynamicObject)filterItemMap.get("reporttype");
        DynamicObjectCollection periods = (DynamicObjectCollection)filterItemMap.get("period");
        DynamicObject reportcurrency = (DynamicObject)filterItemMap.get("reportcurrency");
        DynamicObjectCollection mainReports = (DynamicObjectCollection)filterItemMap.get("org");
        DynamicObjectCollection metricMember = (DynamicObjectCollection)filterItemMap.get("metricmember");
        if (bodysystem == null || reporttype == null || periods == null || reportcurrency == null || mainReports == null || metricMember == null) {
            String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"FundPositionTableReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        List metricIds = metricMember.stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        header.setMetricIds(metricIds);
        String state = null != filterItemMap.get("internaloffsetstate") ? filterItemMap.get("internaloffsetstate").toString() : InternalOffsetStateType.BEFOREOFFSET.getNumber();
        header.setInternalOffsetState(state);
        header.setBodySystemId(Long.valueOf(bodysystem.getLong("id")));
        header.setReportTypeId(Long.valueOf(reporttype.getLong("id")));
        List periodIds = periods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        header.setPeriodId(periodIds);
        boolean isContainDeatilReport = (Boolean)filterItemMap.get("containdetailreporttype");
        header.setContainDetailReportType(isContainDeatilReport);
        if (Objects.nonNull(mainReports)) {
            List mainReportIds = mainReports.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrg(mainReportIds);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgAuthScope = ModelHelper.getOrgAuthScopeWithCheckManager((String)appId, (String)"fpm_report");
            if (!CollectionUtils.isEmpty((Collection)orgAuthScope)) {
                header.setOrg(orgAuthScope);
            }
        }
        String flow = (String)filterItemMap.get("flow");
        header.setFlow(flow);
        DynamicObjectCollection planAccts = (DynamicObjectCollection)filterItemMap.get("subjects");
        if (Objects.nonNull(planAccts)) {
            List subjectsIds = planAccts.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSubjects(subjectsIds);
        }
        int tSubjects = 1;
        if (header.getSubjects() == null || header.getSubjects().size() < 1) {
            QFilter tQFilter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            tQFilter.and("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber());
            DynamicObjectCollection tSubjectIds = QueryServiceHelper.query((String)"fpm_membersubject", (String)"id", (QFilter[])new QFilter[]{tQFilter});
            if (Objects.nonNull(tSubjectIds)) {
                tSubjects = tSubjectIds.size();
            }
        } else {
            tSubjects = header.getSubjects().size();
        }
        if (header.getOrg().size() * tSubjects > 10000) {
            String err = ResManager.loadKDString((String)"\u6240\u9700\u67e5\u8be2\u6570\u636e\u91cf\u884c\u6570\uff08\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u6570*\u8ba1\u5212\u79d1\u76ee\u6210\u5458\u6570\uff09\u4e0d\u53ef\u5927\u4e8e%s\u884c\uff1b\u8bf7\u68c0\u67e5\u201c\u7f16\u62a5\u4e3b\u4f53\u201d\u6216\u201c\u8ba1\u5212\u79d1\u76ee\u201d\u8fc7\u6ee4\u6761\u4ef6\uff0c\u51cf\u5c11\u9700\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"FundPositionTableReportPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(String.format(err, 10000)));
            return false;
        }
        DynamicObjectCollection currencys = (DynamicObjectCollection)filterItemMap.get("currency");
        if (Objects.nonNull(currencys)) {
            List currencyIds = currencys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCurrency(currencyIds);
        }
        header.setReportCurrency(Long.valueOf(reportcurrency.getLong("id")));
        String planversion = (String)filterItemMap.get("plannversion");
        header.setPlannversion(planversion);
        DynamicObjectCollection companys = (DynamicObjectCollection)filterItemMap.get("company");
        if (Objects.nonNull(companys)) {
            List companyIds = companys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCompany(companyIds);
        }
        boolean displaycurrency = (Boolean)filterItemMap.get("displaycurrency");
        header.setDisplaycurrency(displaycurrency);
        DynamicObjectCollection settlementmethods = (DynamicObjectCollection)filterItemMap.get("settlementmethod");
        if (Objects.nonNull(settlementmethods)) {
            List settlementmethodIds = settlementmethods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSettlementMethod(settlementmethodIds);
        }
        String amountunit = (String)this.getModel().getValue("amountunit");
        header.setAmountUnit(AmountUnit.getByNumber((String)amountunit));
        HashMap<String, List<Long>> customMember = new HashMap<String, List<Long>>(8);
        header.setCustomDimension(customMember);
        Object custom1 = filterItemMap.get("custommember1");
        Object custom2 = filterItemMap.get("custommember2");
        Object custom3 = filterItemMap.get("custommember3");
        if (Objects.isNull(custom1) && Objects.isNull(custom2) && Objects.isNull(custom3)) {
            return true;
        }
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember1"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember2"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember3"));
        return true;
    }

    private void handleCustomHeader(Map<String, List<Long>> customMember, DynamicObjectCollection custom) {
        if (!CollectionUtils.isEmpty((Collection)custom)) {
            DynamicObject dimension = (DynamicObject)((DynamicObject)custom.get(0)).get("dimension");
            List memberIds = custom.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            customMember.put(dimension.getString("number"), memberIds);
        }
    }

    private void handleCustomDimension() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"custommember1", "custommember2", "custommember3"});
        DynamicObject bodysystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (bodysystem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        String selectProp = "id,number,basedata,memberfrom,relbasedata";
        DynamicObject[] customDimension = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodysystem.getPkValue()), new QFilter("basedata", "=", (Object)DimsionEnums.CUSTOM.getNumber())});
        if (customDimension.length <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        int index = 1;
        for (DynamicObject dimension : customDimension) {
            String customName = "custommember" + index;
            String name = dimension.getString("name");
            String dimType = dimension.getString("basedata");
            Object dimId = dimension.getPkValue();
            BasedataEdit mulBasedataEdit = (BasedataEdit)this.getControl(customName);
            mulBasedataEdit.setCaption(new LocaleString(name));
            mulBasedataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", dimId).and("dimtype", "=", (Object)dimType).and("bodysystem", "=", bodysystem.getPkValue()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            String customName = "custommember" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{customName});
            this.getModel().setValue(customName, null);
        }
    }

    private List<Integer> getEmptyValRows() {
        return FpmPageCacheHelper.getCacheDatas((IFormView)this.getView(), (String)"emptyRows", Integer.class);
    }

    /*
     * Exception decompiling
     */
    private boolean checkSelectedDataBeforeLinkSearch() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Map<Long, ReportCalcVal>> getSelectedDim4SubReport(CacheCellMeta meta, boolean isRowDim, FormShowParameter formShowParameter) {
        int b2;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        HashMap<Long, Integer> selectedDimIdxMap = new HashMap<Long, Integer>(4);
        HashMap<Long, Boolean> dimIncludeSumMap = new HashMap<Long, Boolean>(4);
        boolean containDetailReportType = false;
        LinkedList queue = new LinkedList();
        int b1 = isRowDim ? spreadSelector.getStartRow() : spreadSelector.getStartCol();
        int n = b2 = isRowDim ? spreadSelector.getEndRow() : spreadSelector.getEndCol();
        if (isRowDim) {
            queue.addAll(meta.getRowDimTree().getRoot().getChildren());
        } else {
            queue.addAll(meta.getColDimTree().getRoot().getChildren());
        }
        while (!queue.isEmpty()) {
            int size = queue.size();
            Map<Object, Object> dimMemberMap = new HashMap(4);
            Boolean includeSum = Boolean.FALSE;
            ReportCalcValTreeNode parentNode = ((ReportCalcValTreeNode)queue.peek()).getParent();
            for (int i = 0; i < size; ++i) {
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = isRowDim ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n2 = a2 = isRowDim ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell()) continue;
                if (!CollectionUtils.isEmpty((Collection)curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (Objects.isNull(curr.getCalcVal().getValue()) && curr.getCalcVal().isSummary()) {
                    includeSum = Boolean.TRUE;
                    continue;
                }
                if (!Objects.nonNull(curr.getCalcVal().getValue())) continue;
                dimMemberMap.putIfAbsent((Long)curr.getCalcVal().getValue(), curr.getCalcVal());
            }
            if (CollectionUtils.isEmpty(dimMemberMap) && includeSum.booleanValue()) {
                dimMemberMap = parentNode.getChildren().stream().filter(node -> !node.getCalcVal().isReferenceCell()).filter(node -> Objects.nonNull(node.getCalcVal().getValue())).collect(Collectors.toMap(key -> (Long)key.getCalcVal().getValue(), val -> val.getCalcVal()));
            }
            if (CollectionUtils.isEmpty(dimMemberMap)) continue;
            Long dimensionId = ((ReportCalcVal)dimMemberMap.values().stream().findAny().get()).getDimensionId();
            if (Objects.nonNull(selectedDimIdxMap.get(dimensionId))) {
                containDetailReportType = true;
            } else {
                selectedDimNodeList.add(dimMemberMap);
                selectedDimIdxMap.forEach((k, v) -> selectedDimIdxMap.put((Long)k, (Integer)selectedDimIdxMap.get(k) + 1));
                selectedDimIdxMap.put(dimensionId, 0);
            }
            dimIncludeSumMap.put(dimensionId, includeSum);
        }
        Map existDimIncludeSumMap = (Map)formShowParameter.getCustomParam("dimIncludeSumMap");
        if (Objects.isNull(existDimIncludeSumMap)) {
            formShowParameter.setCustomParam("dimIncludeSumMap", dimIncludeSumMap);
        } else {
            existDimIncludeSumMap.putAll(dimIncludeSumMap);
            formShowParameter.setCustomParam("dimIncludeSumMap", (Object)existDimIncludeSumMap);
        }
        if (!isRowDim) {
            formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        }
        return selectedDimNodeList;
    }

    private void tipSelectedInvalidMetricIfNeed(DynamicObjectCollection selectedMetricMemberDyColl) {
        List metricMemberIds = selectedMetricMemberDyColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        boolean nonExistBaseMetricTypeIfAnalyseMetricNeed = TemplateInfoHelper.nonExistBaseMetricTypeIfAnalyseMetricNeed(metricMemberIds);
        if (nonExistBaseMetricTypeIfAnalyseMetricNeed) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807\u4e2d\u82e5\u542b\u8ba1\u7b97\u7c7b\u7684\u6307\u6807\u6210\u5458\uff0c\u9700\u8981\u5c06\u5bf9\u5e94\u7684\u8ba1\u7b97\u56e0\u5b50\u57fa\u7840\u5ea6\u91cf\u4e5f\u9009\u62e9\u4e0a\u3002", (String)"ReportLinkExecRecordPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void linkSearchAnalyseReport(SpreadEvent spreadEvent) {
        List colDimAllMemberList;
        CacheCellMeta cacheCellMeta;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        Map<Integer, Set<Integer>> currentColRows = this.getCurrentColRows(spreadSelector);
        if (currentColRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\u3002", (String)"ReportPlanSumPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        boolean noneCover = this.isCoverBaseMetrics(filterItemMap, cacheCellMeta = this.getCellDS().getMeta(), colDimAllMemberList = cacheCellMeta.getColDimTree().getRoot().getAllChildren());
        if (noneCover) {
            String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u542b\u201c\u8ba1\u5212\u989d\u5ea6\u3001\u9884\u5360\u7528\u989d\u5ea6\u3001\u5df2\u6267\u884c\u989d\u5ea6\u201d\u57fa\u7840\u5ea6\u91cf\u5728\u5185\u7684\u975e\u5c0f\u8ba1\u7684\u6570\u503c\u64cd\u4f5c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportLinkExecRecordPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        if (selectedEndRow - selectedStartRow > 0) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u884c\u7684\u8fde\u7eed\u5355\u5143\u683c\u8fdb\u884c\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportLinkExecRecordPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkanalysereport");
        DynamicObjectCollection reportOrgColl = (DynamicObjectCollection)this.getModel().getValue("org");
        Map reportOrgMap = reportOrgColl.stream().map(i -> i.getDynamicObject("fbasedataid")).collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (a, b) -> a));
        Long dimId = ((DynamicObject)reportOrgColl.get(0)).getDynamicObject("fbasedataid").getLong("dimension.id");
        List<Map<Long, ReportCalcVal>> selectedRowDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
        List<Map<Long, ReportCalcVal>> selectedColDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        formShowParameter.setCustomParam("filterDimMemberIds", this.getFilterDimMemberIds());
        List dimValList = selectedRowDimList.stream().map(Map::values).flatMap(Collection::stream).filter(obj -> dimId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toList());
        DynamicObject targetOrg = (DynamicObject)reportOrgMap.get(dimValList.get(0));
        String caption = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790-%1$s", (String)"ReportPlanSummaryPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), targetOrg.getString("name"));
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("org", dimValList);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("bodysystem", dataEntity.getDynamicObject("bodysystem").getPkValue());
        formShowParameter.setCustomParam("reporttype", dataEntity.getDynamicObject("reporttype").getPkValue());
        DynamicObjectCollection periodColl = dataEntity.getDynamicObjectCollection("period");
        List periodList = periodColl.stream().map(i -> i.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        formShowParameter.setCustomParam("period", periodList);
        formShowParameter.setCustomParam("amountunit", this.getModel().getValue("amountunit"));
        DynamicObject exRateTableDy = (DynamicObject)this.getView().getModel().getValue("exratetable");
        Optional.ofNullable(exRateTableDy).ifPresent(arg_0 -> ReportPlanExecAnalysPlugin.lambda$linkSearchAnalyseReport$53((FormShowParameter)formShowParameter, exRateTableDy, arg_0));
        Date exchangeRateDate = (Date)this.getView().getModel().getValue("exchangeratedate");
        Optional.ofNullable(exchangeRateDate).ifPresent(arg_0 -> ReportPlanExecAnalysPlugin.lambda$linkSearchAnalyseReport$54((FormShowParameter)formShowParameter, exchangeRateDate, arg_0));
        boolean containDetailReportType = (Boolean)filterItemMap.get("containdetailreporttype");
        formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("reportcurrency");
        formShowParameter.setCustomParam("reportcurrency", currencyObj.getPkValue());
        boolean displayCurrency = (Boolean)this.getModel().getValue("displaycurrency");
        formShowParameter.setCustomParam("distinctcurrency", (Object)displayCurrency);
        DynamicObjectCollection metricMember = (DynamicObjectCollection)this.getModel().getValue("metricmember");
        List metricIds = metricMember.stream().map(i -> i.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        formShowParameter.setCustomParam("metric", (Object)metricIds.toArray());
        String innerOffsetStatus = (String)this.getModel().getValue("internaloffsetstate");
        formShowParameter.setCustomParam("internaloffsetstate", (Object)innerOffsetStatus);
        formShowParameter.setCustomParam("planstatus", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue());
        formShowParameter.setCustomParam("billstatus", (Object)BillStatusEnum.AUDITED.getCode());
        formShowParameter.setCustomParam("parenttype", (Object)AnalysisReportType.PLANEXECANALYS.getNumber());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Map<Long, List<Long>> getFilterDimMemberIds() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        Map<Long, List<Long>> orgMap = this.getMultiBaseMemberId("org");
        result.putAll(orgMap);
        Map<Long, List<Long>> subjectMap = this.getMultiBaseMemberId("subjects");
        result.putAll(subjectMap);
        Map<Long, List<Long>> currencyMap = this.getMultiBaseMemberId("currency");
        result.putAll(currencyMap);
        Map<Long, List<Long>> companyMap = this.getMultiBaseMemberId("company");
        result.putAll(companyMap);
        Map<Long, List<Long>> settleMap = this.getMultiBaseMemberId("settlementmethod");
        result.putAll(settleMap);
        Map<Long, List<Long>> customOneMap = this.getMultiBaseMemberId("custommember1");
        Map<Long, List<Long>> customTwoMap = this.getMultiBaseMemberId("custommember2");
        Map<Long, List<Long>> customThreeMap = this.getMultiBaseMemberId("custommember3");
        result.putAll(customOneMap);
        result.putAll(customTwoMap);
        result.putAll(customThreeMap);
        return result;
    }

    private Map<Long, List<Long>> getMultiBaseMemberId(String colName) {
        DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(colName);
        if (CollectionUtils.isEmpty((Collection)memberColl)) {
            return new HashMap<Long, List<Long>>(1);
        }
        return memberColl.stream().map(i -> i.getDynamicObject("fbasedataid")).collect(Collectors.groupingBy(i -> i.getLong("dimension.id"), Collectors.mapping(i -> i.getLong("id"), Collectors.toList())));
    }

    private Map<Integer, Set<Integer>> getCurrentColRows(SpreadSelector spreadSelector) {
        int startRow = spreadSelector.getStartRow();
        int endRow = spreadSelector.getEndRow();
        int startCol = spreadSelector.getStartCol();
        int endCol = spreadSelector.getEndCol();
        HashMap<Integer, Set<Integer>> colRows = new HashMap<Integer, Set<Integer>>(4);
        for (int i = startCol; i <= endCol; ++i) {
            Set rows = colRows.computeIfAbsent(i, key -> new HashSet(8));
            for (int j = startRow; j <= endRow; ++j) {
                rows.add(j);
            }
        }
        return colRows;
    }

    private Map<String, Object> loadFilterItemMapCache() {
        ReportQueryParam reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        return reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (a, b) -> a));
    }

    private boolean isCoverBaseMetrics(Map<String, Object> filterItemMap, CacheCellMeta cacheCellMeta, List<ReportCalcValTreeNode> colDimAllMemberList) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartCol = spreadSelector.getStartCol();
        int selectedEndCol = spreadSelector.getEndCol();
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        HashSet metricTypeSet = Sets.newHashSet((Object[])new String[]{TemplateMetricType.PLANAMT.getCode(), TemplateMetricType.LOCKAMT.getCode(), TemplateMetricType.ACTMAT.getCode()});
        Set metricIdSet = ((DynamicObjectCollection)filterItemMap.get("metricmember")).stream().filter(dy -> metricTypeSet.contains(dy.getString("metricpresettype"))).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet metricColSet = new HashSet(2, 1.0f);
        colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> EmptyUtil.isNoEmpty((Object)calcVal.getValue())).filter(calcVal -> metricIdSet.contains(calcVal.getValue())).forEach(calcVal -> IntStream.rangeClosed(calcVal.getStartCol(), calcVal.getEndCol()).forEach(metricColSet::add));
        boolean noneCover = selectedStartRow < cacheCellMeta.getRowOffSet() || selectedEndRow > cacheCellMeta.getMaxRow();
        noneCover = noneCover || IntStream.rangeClosed(selectedStartCol, selectedEndCol).anyMatch(col -> !metricColSet.contains(col));
        return noneCover;
    }

    private static /* synthetic */ void lambda$linkSearchAnalyseReport$54(FormShowParameter formShowParameter, Date exchangeRateDate, Date date) {
        formShowParameter.setCustomParam("exchangeratedate", (Object)exchangeRateDate);
    }

    private static /* synthetic */ void lambda$linkSearchAnalyseReport$53(FormShowParameter formShowParameter, DynamicObject exRateTableDy, DynamicObject dy) {
        formShowParameter.setCustomParam("exratetable", exRateTableDy.getPkValue());
    }

    private static /* synthetic */ String lambda$checkSelectedDataBeforeLinkSearch$40() {
        return ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u201c\u8ba1\u5212\u989d\u5ea6\u3001\u9884\u5360\u7528\u989d\u5ea6\u3001\u5df2\u6267\u884c\u989d\u5ea6\u201d\u57fa\u7840\u5ea6\u91cf\u4e0b\u975e\u5c0f\u8ba1\u7684\u6570\u503c\u64cd\u4f5c\u8054\u67e5\u6267\u884c\u8bb0\u5f55\u3002", (String)"ReportLinkExecRecordPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
    }

    private static /* synthetic */ boolean lambda$checkSelectedDataBeforeLinkSearch$39(List summaryColInterval, int col) {
        return summaryColInterval.stream().anyMatch(interval -> interval[0] <= col && col <= interval[1]);
    }

    private static /* synthetic */ int[] lambda$checkSelectedDataBeforeLinkSearch$37(ReportCalcValTreeNode calcValTreeNode) {
        return new int[]{calcValTreeNode.getCalcVal().getStartCol(), calcValTreeNode.getCalcVal().getEndCol()};
    }

    private static /* synthetic */ boolean lambda$checkSelectedDataBeforeLinkSearch$36(ReportCalcValTreeNode calcValTreeNode) {
        return calcValTreeNode.isSummary();
    }

    private static /* synthetic */ boolean lambda$checkSelectedDataBeforeLinkSearch$35(List metricColInterval, int col) {
        return metricColInterval.stream().noneMatch(interval -> interval[0] <= col && col <= interval[1]);
    }
}

