/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ReportImportTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.task.ReportAsyncOpTask;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.utils.GlobalIdUtil;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.formplugin.helper.ReportImportJobHelper;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;

public class ReportPlanList
extends FpmFilterBaseList
implements IReportVerifyView {
    private boolean submitConfirmFlag = false;
    private IReportVerifyController verifyController;
    private static final int RECALCULATE_AMT_MAX_BILL_NUM = 50;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        block11 : switch (key = op.getOperateKey()) {
            case "submitop": {
                op.getOption().setVariableValue("ReportOpType", ReportOpType.OP_LIST.getNumber());
                String skipRuleVerify = op.getOption().getVariableValue("skipRuleVerify", "false");
                boolean needCheck = !Boolean.parseBoolean(skipRuleVerify);
                List reportIds = this.getSelectedRows().stream().map(d -> (Long)d.getPrimaryKeyValue()).collect(Collectors.toList());
                List verifyReports = this.getReportRepository().getReportForVerifyRule(reportIds);
                if (!this.beforeSubmitValidate(verifyReports, needCheck)) {
                    args.setCancel(true);
                    return;
                }
                if (!needCheck) break;
                IReportVerifyController verifyController = this.getReportVerifyController();
                List<ReportRuleCheckDTO> ruleChecks = this.initRuleCheckDTO(verifyReports);
                for (ReportRuleCheckDTO checkDTO : ruleChecks) {
                    verifyController.ruleCheck(checkDTO, args);
                    if (!args.isCancel()) continue;
                    break block11;
                }
                break;
            }
            case "trackdownchange": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8054\u67e5\u3002", (String)"ReportPlanList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "execbiasanalys": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u7b14\u8bb0\u5f55\u53d1\u8d77\u6267\u884c\u504f\u5dee\u5206\u6790\u3002", (String)"ReportPlanList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "exporttpl": {
                this.beforeExportPlanTempl(args);
                break;
            }
            case "importreport": {
                this.showImportForm();
                break;
            }
            case "beforerecalculateamt": 
            case "recalculateamt": 
            case "recalculateamttask": {
                this.beforeRecalculateAmt(args);
                break;
            }
            case "linksearchtask": {
                Long selectedId = this.getSelectedId();
                QFilter qFilter = new QFilter("objectid", "=", (Object)selectedId).and("objectentitynumber", "=", (Object)"fpm_report");
                List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"fpm_taskrecord", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
                if (EmptyUtil.isEmpty((Collection)primaryKeys)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_40", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_taskrecord").searchFormNumber("fpm_taskrecord").listFormId("bos_list").searchIds(primaryKeys).listForm("fpm_taskrecord").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_LIST_SHOW_DEFAULT).caption(ResManager.loadKDString((String)"\u8054\u67e5\u6267\u884c\u4efb\u52a1", (String)"ReportPlanList_41", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
                break;
            }
        }
    }

    public ReportRepository getReportRepository() {
        return new ReportRepository();
    }

    private boolean beforeSubmitValidate(List<VerifyReport> verifyReports, boolean needCheck) {
        if (verifyReports.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6700\u591a\u53ef\u652f\u6301\u9009\u62e9100\u6761\u8ba1\u5212\u7f16\u5236\u5355\u636e\u505a\u6279\u91cf\u63d0\u4ea4\u5904\u7406\u3002", (String)"ReportPlanPlugin_23", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> detAndUnPlanBillNoList = new ArrayList<String>(10);
        HashSet<Long> reportPeriodIds = new HashSet<Long>(1);
        HashSet<Long> reportTypeIds = new HashSet<Long>(1);
        for (VerifyReport report : verifyReports) {
            PeriodMember periodMember = report.getPeriodMember();
            Long reportPeriodId = periodMember.getId();
            Long reportTypeId = periodMember.getPeriodTypeId();
            boolean bool1 = reportPeriodIds.add(reportPeriodId);
            boolean bool2 = reportTypeIds.add(reportTypeId);
            if ((reportPeriodIds.size() > 1 || reportTypeIds.size() > 1) && (bool1 || bool2)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u540c\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u4ee5\u53ca\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u7684\u8d44\u91d1\u8ba1\u5212\u5355\u636e\u505a\u6279\u91cf\u63d0\u4ea4\u5904\u7406\u3002", (String)"ReportPlanPlugin_24", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (report.getInitflag().booleanValue()) continue;
            detAndUnPlanBillNoList.add(report.getNumber());
        }
        if (!this.submitConfirmFlag && !EmptyUtil.isEmpty(detAndUnPlanBillNoList) && needCheck) {
            this.getView().showConfirm("", String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u8ba1\u5212\u7f16\u5236\u8868\u201c%s\u201d\u5c1a\u672a\u586b\u62a5\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u63d0\u4ea4\u3002", (String)"ReportPlanPlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", detAndUnPlanBillNoList)), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("submitop", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private void beforeExportPlanTempl(BeforeDoOperationEventArgs args) {
        Set noDraffBillNos;
        String errMsg = null;
        if (args.getListSelectedData().size() > 300) {
            errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5931\u8d25\u3002\u6bcf\u4e2aExcel\u6587\u4ef6\u6700\u591a\u652f\u6301300\u4e2asheet\u5de5\u4f5c\u8868\uff0c\u6bcf\u4e2a\u9875\u9762\u7ec4\u5408\u5bf9\u5e94\u4e00\u5f20Excel\u5de5\u4f5c\u8868\u3002", (String)"ReportPlanList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List selectedIdList = selectedRows.stream().map(c -> (Long)c.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "billno", "reportperiod.id", "billstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIdList)});
        Set periodIds = reports.stream().filter(Objects::nonNull).map(report -> Optional.ofNullable(report.getLong("reportperiod.id")).orElseGet(() -> 0L)).collect(Collectors.toSet());
        if (periodIds.size() > 1) {
            errMsg = ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u6a21\u677f\u5931\u8d25\u3002\u4ec5\u652f\u6301\u540c\u4e00\u7f16\u62a5\u671f\u95f4\u7684\u8d44\u91d1\u8ba1\u5212\u7f16\u5236\u8868\u5bf9\u5e94\u7684\u6a21\u677f\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u9700\u8981\u5bfc\u51fa\u7684\u8d44\u91d1\u8ba1\u5212\u8868\u8303\u56f4\u3002", (String)"ReportPlanList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if ((noDraffBillNos = reports.stream().filter(Objects::nonNull).filter(c -> !BillStatus.STAGE.getNumber().equals(c.getString("billstatus"))).map(report -> report.getString("billno")).collect(Collectors.toSet())).size() > 0) {
            errMsg = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u51fa\u6a21\u677f\u3002\u6240\u9009\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u4f5c\u4e3a\u6a21\u677f\u3002\u8bf7\u786e\u8ba4\u9700\u8981\u5bfc\u51fa\u6a21\u677f\u7684\u8d44\u91d1\u8ba1\u5212\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanList_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", noDraffBillNos));
        }
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            args.setCancel(true);
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("submitop".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.submitConfirmFlag = true;
            this.getView().invokeOperation("submitop");
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_1_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_2_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff01\u8bf7\u786e\u8ba4\u989d\u5ea6\u91cd\u7b97\u65f6\u95f4\u6bb5\u5185\uff08\u9884\u4f30\u81f3\u5c11\u534a\u5c0f\u65f6\uff09\uff0c\u672c\u7ea7\u53ca\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u5f53\u671f\u7684\u5355\u636e\u5747\u4e0d\u4f1a\u53d1\u751f\u8ba1\u5212\u8c03\u6574\u5ba1\u6838\u3001\u9884\u5360\u53ca\u5b9e\u9645\u6570\u63a7\u5236\u5199\u5165\u7b49\u64cd\u4f5c\uff01", (String)"ReportPlanSumList_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            return;
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_2_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            this.getView().invokeOperation("recalculateamt");
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("submitlist".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (!EmptyUtil.isEmpty((Collection)allErrorOrValidateInfo)) {
                List errIdList = allErrorOrValidateInfo.stream().map(item -> Long.valueOf(item.getPkValue().toString())).collect(Collectors.toList());
                operationResult.getSuccessPkIds().removeAll(errIdList);
            }
            IListView view = (IListView)this.getView();
            if (!operationResult.isShowMessage()) {
                view.showSuccessNotification(operationResult.getMessage());
            }
            view.refresh();
        } else if ("adjust".equals(operateKey) && operationResult.isSuccess()) {
            this.showChangeRecordBill(operationResult);
        } else if ("trackdownchange".equals(operateKey) && operationResult.isSuccess()) {
            Object id = operationResult.getSuccessPkIds().get(0);
            this.showListOrOpenChild(id, (String)operationResult.getBillNos().get(id.toString()));
        } else if (Arrays.asList("execbiasanalys", "execbiasrecord").contains(operateKey) && operationResult.isSuccess()) {
            Map billNos = operationResult.getBillNos();
            for (String pkId : billNos.values()) {
                this.showExecBiasAnalysForm(Long.parseLong(pkId));
            }
        } else if ("exporttpl".equals(operateKey) && operationResult.isSuccess()) {
            String selectedIdList = this.getSelectedIds();
            this.exportPlanTempl(selectedIdList);
        }
    }

    private void exportPlanTempl(String ids) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("fpm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"ReportPlanPlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setTaskClassname("kd.tmc.fpm.business.task.ReportTemplateExportTask");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("ids", ids);
        params.put("tasktype", "number");
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exporttaskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u6a21\u677f\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"ReportPlanPlugin_16", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.tmc.fpm.business.task.ReportImportDataClickTask");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private String getSelectedIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReportTreeList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        StringBuilder numbers = new StringBuilder();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            numbers.append(',').append(listSelectedRow.getPrimaryKeyValue());
        }
        if (numbers.length() > 0) {
            numbers = new StringBuilder(numbers.substring(1));
        }
        return numbers.toString();
    }

    private void showExecBiasAnalysForm(Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("fpm_execbiasanalys");
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected String getAuthEntityName() {
        return "fpm_report";
    }

    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    @Override
    protected String getReportOrgProp() {
        return "reportorg";
    }

    @Override
    protected void customSearchClickFilter(List<Map<String, List<Object>>> customFilterList) {
        super.customSearchClickFilter(customFilterList);
        for (Map<String, List<Object>> map : customFilterList) {
            Date endDate;
            String fieldName = map.get("FieldName").size() > 0 ? map.get("FieldName").get(0).toString() : "";
            if (!fieldName.startsWith("declarestartdate")) continue;
            this.getPageCache().put("tipFlag", "false");
            if (map.get("Value").size() <= 1) continue;
            Object startDateStr = map.get("Value").get(0);
            Object endDateStr = map.get("Value").get(1);
            Date startDate = DateUtils.stringToDate((String)((String)startDateStr), (String)"yyyy-MM-dd");
            int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)(endDate = DateUtils.stringToDate((String)((String)endDateStr), (String)"yyyy-MM-dd")));
            if (diffDays <= 365) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u5f00\u59cb\u65e5\u671f\u81ea\u5b9a\u4e49\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7365\u5929\u3002", (String)"ReportPlanList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("tipFlag", "true");
            return;
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List authMemberOrgIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("authMemberOrgIds"), List.class);
        qFilters.add(new QFilter("reportorg", "in", (Object)authMemberOrgIds));
        if (this.getPageCache().get("tipFlag") != null && "true".equals(this.getPageCache().get("tipFlag"))) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
    }

    private void showChangeRecordBill(OperationResult operationResult) {
        Map parameter = operationResult.getInteractionContext().getCustShowParameter();
        String changeRecordIdStr = (String)parameter.get("planchangeid");
        if (!EmptyUtil.isEmpty((String)changeRecordIdStr)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)Long.parseLong(changeRecordIdStr));
            billShowParameter.setFormId("fpm_reportplan_adjust");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void showListOrOpenChild(Object reportId, String billNo) {
        DynamicObject[] changeRecordArr = TmcDataServiceHelper.load((String)"fpm_reportplan_adjust", (String)"id,billno,adjustreason,creator,createtime", (QFilter[])new QFilter[]{new QFilter("originalreportids", "like", (Object)("%" + reportId + "%"))});
        if (Objects.isNull(changeRecordArr) || changeRecordArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u5355\u636e\u3002", (String)"ReportPlanList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        String appId = "fpm";
        FormShowParameter currentFormParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(currentFormParameter) && !StringUtils.isEmpty((CharSequence)currentFormParameter.getAppId())) {
            appId = currentFormParameter.getAppId();
        }
        showParameter.setAppId(appId);
        showParameter.getCustomParams().put("checkRightAppId", appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(StringUtils.equalsIgnoreCase((CharSequence)"fpm", (CharSequence)appId) ? ShowType.MainNewTabPage : ShowType.Modal);
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("ENTITY_IDS", Arrays.stream(changeRecordArr).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        showParameter.setCustomParam("LIST_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_REPORT_CHANGE.getType().getName());
        showParameter.setCustomParam("param_from_link_search_child", (Object)true);
        String caption = ResManager.loadKDString((String)"\u5355\u636e(%s)\u4e0b\u67e5\u8c03\u6574\u5355", (String)"ReportPlanList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[]{billNo});
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    private List<ReportRuleCheckDTO> initRuleCheckDTO(List<VerifyReport> verifyReports) {
        boolean batchCommit = verifyReports.size() > 1;
        return ReportRuleCheckHelper.initRuleCheckDTO(verifyReports, this.getReportVerifyController(), null, batchCommit, Boolean.FALSE);
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            this.verifyController = new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    public void showErrMessage(List<String> list) {
    }

    public void showSuccessMessage(String s) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() != null) {
            switch (e.getActionId()) {
                case "exporttaskcloseback": {
                    this.exportTaskCloseBack(e);
                    break;
                }
                case "importData": {
                    this.handleImportCallBack(e);
                    break;
                }
                case "importDataCloseCallBack": {
                    this.afterImportCallBack(e);
                    break;
                }
                case "dataverify": {
                    this.dataVerify(e);
                    break;
                }
            }
        }
    }

    private boolean dataVerify(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (CollectionUtils.isEmpty((Map)returnData)) {
            return true;
        }
        String dataVerifyResult = returnData.get("dataVerifyResult").toString();
        List notifyDTOList = JSONArray.parseArray((String)dataVerifyResult, ReportVerifyRuleNotifyDTO.class);
        if (EmptyUtil.isEmpty((Collection)notifyDTOList)) {
            return true;
        }
        boolean isBatchCommit = notifyDTOList.stream().anyMatch(ReportVerifyRuleNotifyDTO::getBatchCommit);
        if (isBatchCommit) {
            return true;
        }
        boolean anyMatch = notifyDTOList.stream().anyMatch(item -> ReportVerifyCheckEffectEnum.DISABLE.getCode().equals(item.getCheckEffect().getCode()));
        if (!anyMatch) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("skipRuleVerify", "true");
            this.getView().invokeOperation("submitop", operateOption);
        }
        return false;
    }

    private void afterImportCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            Object taskinfoObj = result.get("taskinfo");
            if (EmptyUtil.isEmpty(taskinfoObj)) {
                return;
            }
            String taskInfoStr = (String)taskinfoObj;
            if (EmptyUtil.isEmpty((String)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                boolean success = (Boolean)mapData.get("success");
                if (!success) {
                    String errorMessage = (String)mapData.get("errorMessage");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5bfc\u5165\u6570\u636e\u4efb\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"ReportPlanList_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ReportPlanList_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    private void showImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_import");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"ReportPlanList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"fpm_import");
        formShowParameter.setFormConfig(formConfig);
        formShowParameter.addCustPlugin("kd.tmc.fpm.formplugin.report.ReportImportDataPlugin");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importData"));
        formShowParameter.setCustomParam("tipslabel", (Object)ResManager.loadKDString((String)"\u6ce8\uff1a\u5bfc\u5165\u6570\u636e\u9700\u8981\u57fa\u4e8e\u7cfb\u7edf\u6700\u65b0\u8ba1\u5212\u7f16\u5236\u6a21\u677f\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"ReportPlanList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("reportImportType", (Object)ReportImportTypeEnum.IMPORT_BATCH.getCode());
        this.getView().showForm(formShowParameter);
    }

    private void handleImportCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnMap;
        Object backData = closedCallBackEvent.getReturnData();
        if (backData != null && (returnMap = (Map)backData).containsKey("reportFileUrl") && returnMap.containsKey("customParams")) {
            JobFormInfo jobFormInfo = ReportImportJobHelper.getJobFormInfo(returnMap, this.getView());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importDataCloseCallBack");
            jobFormInfo.setCloseCallBack(closeCallBack);
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
    }

    private void exportTaskCloseBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        Object taskinfoObj = result.get("taskinfo");
        if (EmptyUtil.isEmpty(taskinfoObj)) {
            return;
        }
        String taskInfoStr = (String)taskinfoObj;
        if (EmptyUtil.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd()) {
            String data = taskInfo.getData();
            Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            boolean success = (Boolean)mapData.get("success");
            if (success) {
                String casesResult = (String)mapData.get("taskinfo");
                if (EmptyUtil.isNoEmpty((String)casesResult)) {
                    this.getView().download(casesResult);
                }
            } else {
                String error = (String)mapData.get("error");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5bfc\u5165\u6a21\u677f\u4efb\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"ReportPlanList_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), error));
            }
        }
    }

    private void beforeRecalculateAmt(BeforeDoOperationEventArgs args) {
        Object[] primaryKeys;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (Objects.equals(operateKey, "beforerecalculateamt")) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_1_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff0c\u8bf7\u5728\u4e0b\u73ed\u540e\u6216\u975e\u4e1a\u52a1\u529e\u7406\u9ad8\u5cf0\u671f\u8fdb\u884c\uff01\u6b64\u5916\uff0c\u9274\u4e8e\u8be5\u64cd\u4f5c\u5c06\u4f1a\u91cd\u7b97\u5bf9\u5e94\u8ba1\u5212\u8868\u5185\u7684\u5173\u8054\u6570\u636e\uff0c\u8bf7\u5148\u786e\u4fdd\u6240\u4f9d\u8d56\u7684\u672b\u7ea7\u6570\u636e\u6b63\u786e\u3002", (String)"ReportPlanSumList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            args.setCancel(true);
            return;
        }
        if (Objects.equals(operateKey, "recalculateamt")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeys.length > 50) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanList_22", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 50));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report", (String)"id,reportperiod.id,planstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeys)});
            Set reportPeriodIdSet = load.stream().map(dy -> dy.getLong("reportperiod.id")).collect(Collectors.toSet());
            if (reportPeriodIdSet.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanList_22", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 50));
                args.setCancel(true);
                return;
            }
            boolean noneMatchEnableReport = load.stream().noneMatch(dy -> ReportStatus.ENABLE == ReportStatus.getByVal((String)dy.getString("planstatus")));
            if (noneMatchEnableReport) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u751f\u6548\u7684\u8ba1\u5212\u8868\u6267\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"ReportPlanSumList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().invokeOperation("recalculateamttask");
        }
        if (Objects.equals(operateKey, "recalculateamttask")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            args.setCancel(true);
            this.asyncRecalculateAmt(Arrays.stream(primaryKeys).map(pk -> (Long)pk).collect(Collectors.toList()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u8ba1\u5212\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPlanSumList_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void asyncRecalculateAmt(List<Long> ids) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname(ReportAsyncOpTask.class.getName());
        jobInfo.setName(ResManager.loadKDString((String)"\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(GlobalIdUtil.genStringId());
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("ids", ids);
        params.put("entityNumber", "fpm_report");
        params.put("opKey", "recalculateamttask");
        params.put("pageId", this.getView().getPageId());
        params.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(ReportImportDataClickTask.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }
}

