/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.task.ReportAsyncOpTask;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.utils.GlobalIdUtil;

public class ReportPlanManageList
extends AbstractListPlugin {
    private static final String ISSELECT = "isSelect";
    private static final String TBLURGE = "tblurge";
    private static final String STEATIC = "C";
    private static final String REPULSE = "repulse";
    private static final int RECALCULATE_AMT_MAX_BILL_NUM = 50;

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "repulse": {
                if (!Objects.nonNull(opResult)) break;
                ValidateResultCollection validateResult = opResult.getValidateResult();
                Set pkIds = validateResult.getValidateErrors().stream().map(AbstractOperationResult::getAllErrorInfo).filter(EmptyUtil::isNoEmpty).flatMap(Collection::stream).map(OperateInfo::getPkValue).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
                opResult.getSuccessPkIds().removeAll(pkIds);
                break;
            }
            case "deletereport": {
                this.afterDeleteReport(opResult);
                break;
            }
            case "trackdownchange": {
                if (!opResult.isSuccess()) break;
                Object id = opResult.getSuccessPkIds().get(0);
                this.showListOrOpenChild(id, (String)opResult.getBillNos().get(id.toString()));
                break;
            }
            case "execbiasrecord": {
                if (!opResult.isSuccess()) break;
                Map billNos = opResult.getBillNos();
                for (String pkId : billNos.values()) {
                    this.showExecBiasAnalysForm(Long.parseLong(pkId));
                }
                break;
            }
            case "tblurge": {
                if (!opResult.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"ReportPlanManageList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "beforedeletereport": {
                this.beforeDeleteReport(args);
                break;
            }
            case "trackdownchange": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8054\u67e5\u3002", (String)"ReportPlanList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "execbiasanalys": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u7b14\u8bb0\u5f55\u53d1\u8d77\u6267\u884c\u504f\u5dee\u5206\u6790\u3002", (String)"ReportPlanList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "repulse": {
                if (this.hasDiffPeriod()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u3010\u4e0a\u62a5\u4e2d\u3011\u72b6\u6001\u7684\u4e3b\u8868\u8ba1\u5212\u7f16\u5236\u5355\u636e\u64cd\u4f5c\u6279\u91cf\u6253\u56de\u3002", (String)"ReportPlanList_30", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (Objects.equals(REPULSE, this.getPageCache().get(REPULSE))) {
                    this.getPageCache().remove(REPULSE);
                    return;
                }
                this.showRepulseOpinion();
                args.setCancel(true);
                break;
            }
            case "tblurge": {
                String skipShowForm = op.getOption().getVariableValue(ISSELECT, "false");
                if (!EmptyUtil.isNoEmpty((String)skipShowForm) || Boolean.parseBoolean(skipShowForm)) break;
                this.showMessageInform();
                args.setCancel(true);
                break;
            }
            case "beforerecalculateamt": 
            case "recalculateamt": 
            case "recalculateamttask": {
                this.beforeRecalculateAmt(args);
                break;
            }
        }
    }

    private boolean hasDiffPeriod() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Set reportIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String reportPeriodProp = String.join((CharSequence)".", "reportperiod", "id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)reportPeriodProp, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        Set reportPeriodIds = query.stream().map(dy -> dy.getLong(reportPeriodProp)).collect(Collectors.toSet());
        return reportPeriodIds.size() > 1;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("beforedeletereport".equals(messageBoxClosedEvent.getCallBackId()) && Objects.equals(messageBoxClosedEvent.getResult(), MessageBoxResult.Yes)) {
            this.getView().invokeOperation("deletereport");
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_1_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_2_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff01\u8bf7\u786e\u8ba4\u989d\u5ea6\u91cd\u7b97\u65f6\u95f4\u6bb5\u5185\uff08\u9884\u4f30\u81f3\u5c11\u534a\u5c0f\u65f6\uff09\uff0c\u672c\u7ea7\u53ca\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u5f53\u671f\u7684\u5355\u636e\u5747\u4e0d\u4f1a\u53d1\u751f\u8ba1\u5212\u8c03\u6574\u5ba1\u6838\u3001\u9884\u5360\u53ca\u5b9e\u9645\u6570\u63a7\u5236\u5199\u5165\u7b49\u64cd\u4f5c\uff01", (String)"ReportPlanSumList_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            return;
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_2_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            this.getView().invokeOperation("recalculateamt");
            return;
        }
    }

    private void showMessageInform() {
        Object[] selectTemplate = this.getSelectTemplate();
        if (selectTemplate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u50ac\u62a5\u3002", (String)"ReportPlanManageList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((Object[])selectTemplate, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report_process"));
        String repoName = dynamicObject[0].getString("reportperiod.name");
        Date date = dynamicObject[0].getDate("declaredeadline");
        HashSet<Long> uerId = new HashSet<Long>(16);
        Boolean isMessage = false;
        for (DynamicObject dy : dynamicObject) {
            if (!isMessage.booleanValue() && null == dy.get("currprocessor") && null == dy.get("informant")) {
                isMessage = true;
            }
            if (STEATIC.equals(dy.getString("billstatus"))) continue;
            uerId.add(dy.getLong("currprocessor.id"));
            uerId.add(dy.getLong("informant.id"));
        }
        uerId.removeIf(e -> e.equals(0L));
        if (!isMessage.booleanValue()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("reportperiod", repoName);
            operateOption.setVariableValue("declaredeadline", date.toString());
            operateOption.setVariableValue("messageids", SerializationUtils.toJsonString(new ArrayList(uerId)));
            operateOption.setVariableValue(ISSELECT, "true");
            this.getView().invokeOperation(TBLURGE, operateOption);
        } else {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("fpm_messageinform");
            String pageId = null == this.getView().getParentView() ? this.getView().getPageId() : this.getView().getParentView().getPageId();
            param.setRootPageId(pageId);
            param.setStatus(OperationStatus.EDIT);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("reportperiod", (Object)repoName);
            param.setCustomParam("declaredeadline", (Object)date);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TBLURGE));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (TBLURGE.equals(actionId) && null != returnData) {
            Map ret = (Map)closedCallBackEvent.getReturnData();
            OperateOption operateOption = OperateOption.create();
            ret.forEach((arg_0, arg_1) -> ((OperateOption)operateOption).setVariableValue(arg_0, arg_1));
            this.getView().invokeOperation(TBLURGE, operateOption);
        } else if (REPULSE.equals(actionId) && null != returnData && kd.bos.util.StringUtils.isNotEmpty((String)returnData.toString())) {
            this.getPageCache().put(REPULSE, REPULSE);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(REPULSE, returnData.toString());
            this.getView().invokeOperation(REPULSE, operateOption);
            IListView view = (IListView)this.getView();
            view.refresh();
        }
    }

    private Object[] getSelectTemplate() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() <= 0) {
            return null;
        }
        return rows.getPrimaryKeyValues();
    }

    private void showRepulseOpinion() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fpm_repulseopinion");
        String pageId = null == this.getView().getParentView() ? this.getView().getPageId() : this.getView().getParentView().getPageId();
        param.setRootPageId(pageId);
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCaption(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6253\u56de\u610f\u89c1", (String)"ReportPlanManageList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REPULSE));
        this.getView().showForm(param);
    }

    private void beforeDeleteReport(BeforeDoOperationEventArgs args) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("beforedeletereport", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8054\u52a8\u5220\u9664\u540c\u4e00\u7f16\u62a5\u4e3b\u4f53\u4e0b\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u5220\u9664\u3002", (String)"ReportPlanManageList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        args.setCancel(true);
    }

    private void afterDeleteReport(OperationResult operationResult) {
        if (Objects.isNull(operationResult) || CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            return;
        }
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private void showExecBiasAnalysForm(Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("fpm_execbiasanalys");
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showListOrOpenChild(Object reportId, String billNo) {
        DynamicObject[] changeRecordArr = TmcDataServiceHelper.load((String)"fpm_reportplan_adjust", (String)"id,billno,adjustreason,creator,createtime", (QFilter[])new QFilter[]{new QFilter("originalreportids", "like", (Object)("%" + reportId + "%"))});
        if (Objects.isNull(changeRecordArr) || changeRecordArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u5355\u636e\u3002", (String)"ReportPlanList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        String appId = "fpm";
        FormShowParameter currentFormParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(currentFormParameter) && !StringUtils.isEmpty((CharSequence)currentFormParameter.getAppId())) {
            appId = currentFormParameter.getAppId();
        }
        showParameter.setAppId(appId);
        showParameter.getCustomParams().put("checkRightAppId", appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(StringUtils.equalsIgnoreCase((CharSequence)"fpm", (CharSequence)appId) ? ShowType.MainNewTabPage : ShowType.Modal);
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("ENTITY_IDS", Arrays.stream(changeRecordArr).map(i -> i.getLong("id")).collect(Collectors.toList()));
        showParameter.setCustomParam("LIST_ENTITY_NAME", (Object)"fpm_reportplan_adjust");
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_REPORT_CHANGE.getType().getName());
        showParameter.setCustomParam("param_from_link_search_child", (Object)true);
        String caption = ResManager.loadKDString((String)"\u5355\u636e(%s)\u4e0b\u67e5\u8c03\u6574\u5355", (String)"ReportPlanList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[]{billNo});
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    private void beforeRecalculateAmt(BeforeDoOperationEventArgs args) {
        Object[] primaryKeys;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (Objects.equals(operateKey, "beforerecalculateamt")) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_1_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff0c\u8bf7\u5728\u4e0b\u73ed\u540e\u6216\u975e\u4e1a\u52a1\u529e\u7406\u9ad8\u5cf0\u671f\u8fdb\u884c\uff01\u6b64\u5916\uff0c\u9274\u4e8e\u8be5\u64cd\u4f5c\u5c06\u4f1a\u91cd\u7b97\u5bf9\u5e94\u8ba1\u5212\u8868\u5185\u7684\u5173\u8054\u6570\u636e\uff0c\u8bf7\u5148\u786e\u4fdd\u6240\u4f9d\u8d56\u7684\u672b\u7ea7\u6570\u636e\u6b63\u786e\u3002", (String)"ReportPlanSumList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            args.setCancel(true);
            return;
        }
        if (Objects.equals(operateKey, "recalculateamt")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeys.length > 50) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanList_22", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 50));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report", (String)"id,reportperiod.id,planstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeys)});
            Set reportPeriodIdSet = load.stream().map(dy -> dy.getLong("reportperiod.id")).collect(Collectors.toSet());
            if (reportPeriodIdSet.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanList_22", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 50));
                args.setCancel(true);
                return;
            }
            boolean noneMatchEnableReport = load.stream().noneMatch(dy -> ReportStatus.ENABLE == ReportStatus.getByVal((String)dy.getString("planstatus")));
            if (noneMatchEnableReport) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u751f\u6548\u7684\u8ba1\u5212\u8868\u6267\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"ReportPlanSumList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().invokeOperation("recalculateamttask");
        }
        if (Objects.equals(operateKey, "recalculateamttask")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            args.setCancel(true);
            this.asyncRecalculateAmt(Arrays.stream(primaryKeys).map(pk -> (Long)pk).collect(Collectors.toList()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u8ba1\u5212\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPlanSumList_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void asyncRecalculateAmt(List<Long> ids) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname(ReportAsyncOpTask.class.getName());
        jobInfo.setName(ResManager.loadKDString((String)"\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(GlobalIdUtil.genStringId());
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("ids", ids);
        params.put("entityNumber", "fpm_report");
        params.put("opKey", "recalculateamttask");
        params.put("pageId", this.getView().getPageId());
        params.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(ReportImportDataClickTask.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }
}

