/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fpm.formplugin.dync.AbstractTmcDynBillPlugin;
import kd.tmc.fpm.formplugin.dync.DynBillMutexLock;
import org.apache.commons.collections4.MapUtils;

@DynBillMutexLock(entityName="fpm_report", lockId="{billId}")
public class ReportPlanMutexPlugin
extends AbstractTmcDynBillPlugin {
    private static final Log logger = LogFactory.getLog(ReportPlanMutexPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        QFilter qFilter;
        List idList;
        String mainTableReportIdStr;
        boolean lockMainReport;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        if ("view".equals(pageType)) {
            return;
        }
        FormShowParameter sp = this.getView().getFormShowParameter();
        Long reportId = (Long)sp.getCustomParam("report_id");
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityNum = "fpm_report";
        String permItemEnum = "4715a0df000000ac";
        boolean hasEditPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)permItemEnum);
        if (!hasEditPermission) {
            return;
        }
        boolean matchRule = PermissionServiceHelper.matchDataRule((long)currUserId, (String)appId, (String)entityNum, (String)permItemEnum, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        if (!matchRule) {
            return;
        }
        this.setBillId(reportId.toString());
        DynamicObject dbData = QueryServiceHelper.queryOne((String)"fpm_report", (String)String.join((CharSequence)",", "template.id", "template.ismaintable", "reportperiod.id", "reportorg.id"), (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (dbData == null) {
            return;
        }
        long templateId = dbData.getLong("template.id");
        long periodId = dbData.getLong("reportperiod.id");
        long orgId = dbData.getLong("reportorg.id");
        boolean ismaintable = dbData.getBoolean("template.ismaintable");
        if (ismaintable && (lockMainReport = MutexServiceHelper.request((String)(mainTableReportIdStr = String.valueOf(reportId)), (String)"fpm_report", (String)"lockMainReport"))) {
            this.getPageCache().put("requestMainTableSuccessIds", mainTableReportIdStr);
        }
        if (!CollectionUtils.isEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])(qFilter = new QFilter("parenttemplate.id", "=", (Object)templateId).and("reportperiod", "=", (Object)periodId).and("reportorg", "=", (Object)orgId)).toArray(), null, (int)-1)))) {
            ArrayList<String> requestSuccessIds = new ArrayList<String>(10);
            Map request = MutexServiceHelper.batchRequest(idList.stream().map(Object::toString).collect(Collectors.toList()), (String)"fpm_report", (String)"lockSubReport");
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                requestSuccessIds.add(key);
            }
            this.getPageCache().put("requestSuccessIds", JSON.toJSONString(requestSuccessIds));
        }
        super.afterCreateNewData(e);
    }

    public void pageRelease(EventObject e) {
        String requestMainTableSuccessIds;
        String requestSuccessIdsStr = this.getPageCache().get("requestSuccessIds");
        List requestSuccessIds = JSONObject.parseArray((String)requestSuccessIdsStr, String.class);
        if (!CollectionUtils.isEmpty((Collection)requestSuccessIds)) {
            MutexServiceHelper.batchRelease((List)requestSuccessIds, (String)"fpm_report", (String)"lockSubReport");
        }
        if (!StringUtils.isEmpty((Object)(requestMainTableSuccessIds = this.getPageCache().get("requestMainTableSuccessIds")))) {
            MutexServiceHelper.release((String)requestMainTableSuccessIds, (String)"fpm_report", (String)"lockMainReport");
        }
    }

    @Override
    protected void doAction() {
    }

    @Override
    protected void doActionWithObjId(String dataId) {
        try (DataMutex dataMutex = DataMutex.create();){
            Map lockInfo = dataMutex.getLockInfo(dataId, "default_netctrl", "fpm_report");
            if (MapUtils.isEmpty((Map)lockInfo)) {
                this.showDefaultMessage();
                return;
            }
            String userid = (String)lockInfo.get("userid");
            if (StringUtils.isEmpty((Object)userid)) {
                this.showDefaultMessage();
                return;
            }
            Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong((String)lockInfo.get("userid")));
            if (MapUtils.isEmpty((Map)userInfo)) {
                this.showDefaultMessage();
                return;
            }
            Object name = userInfo.get("name");
            if (StringUtils.isEmpty(name)) {
                this.showDefaultMessage();
                return;
            }
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u7528\u6237\u3010%1$s\u3011\u5360\u7528\uff0c\u4ee5\u67e5\u770b\u7684\u65b9\u5f0f\u6253\u5f00\u3002", (String)"ReportPlanMutexPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msg, name));
            this.getView().getFormShowParameter().setCustomParam("pageType", (Object)"view");
            return;
        }
        catch (IOException e) {
            logger.warn("\u6253\u5f00\u9875\u9762\u67e5\u770b\u5360\u7528\u7528\u6237\u4fe1\u606f\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            this.showDefaultMessage();
            return;
        }
    }

    private void showDefaultMessage() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5360\u7528\uff0c\u4ee5\u67e5\u770b\u7684\u65b9\u5f0f\u6253\u5f00\u3002", (String)"ReportPlanMutexPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().getFormShowParameter().setCustomParam("pageType", (Object)"view");
    }
}

