/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportImportTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.BizReportQueryParam;
import kd.tmc.fpm.business.domain.model.report.BizReportRefreshParam;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SourceIdQueryParam;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.controller.IReportManageController;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IReportDataBizService;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.view.IReportManageView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.CellFormulaCmdChain;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColAutoFitCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColVisibleCmdChain;
import kd.tmc.fpm.business.spread.command.generator.CleanCellUpdateGenerator;
import kd.tmc.fpm.business.spread.command.generator.DefaultCellUpdateGenerator;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.command.generator.ShowBillStatusAndCellAcctInfoOnStatusBarGenerator;
import kd.tmc.fpm.business.spread.command.generator.UpdateCellInfoGenerator;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.export.excel.impl.ReportPlanFormsExportImpl;
import kd.tmc.fpm.business.spread.update.CellValueUpdateFactory;
import kd.tmc.fpm.business.spread.update.bean.CellUpdateResult;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FpmPageShowType;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.enums.TemplateSmartGetValSetEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.property.ReportPlanProp;
import kd.tmc.fpm.common.property.ReportProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.formplugin.helper.ReportImportJobHelper;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.FormulaCell;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.report.SheetUtils;
import org.apache.commons.collections4.MapUtils;

public class ReportPlanPlugin
extends AbstractSpreadPlugin
implements IReportManageView,
IReportVerifyView,
HyperLinkClickListener {
    private IReportManageController controller;
    private IReportVerifyController verifyController;
    private static final String FORM_VIEW = "FORM_VIEW";
    private static final String MAX_AMOUNT_CELL = "10000000000000";
    private static final String MIN_AMOUNT_CELL = "-10000000000000";
    private CellDataSource cellDS;
    private static final String REFRESHING = "REFRESHING";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("changeentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid lastEntry = (EntryGrid)this.getView().getControl("lastentry");
        lastEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid thisEntry = (EntryGrid)this.getView().getControl("thisentry");
        thisEntry.addHyperClickListener((HyperLinkClickListener)this);
        String mapperInfoStr = this.getView().getPageCache().get("page_dim_mapping_cache");
        String sysId = this.getView().getPageCache().get("system_id_cache");
        Map mapperInfo = (Map)FpmSerializeUtil.deserialize((String)mapperInfoStr, Map.class);
        if (Objects.isNull(mapperInfo)) {
            return;
        }
        Set entries = mapperInfo.entrySet();
        for (Map.Entry entry : entries) {
            BasedataEdit pageDim = (BasedataEdit)this.getControl((String)entry.getKey());
            pageDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                TemplateDim templateDim = (TemplateDim)entry.getValue();
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)Optional.ofNullable(sysId).map(Long::valueOf).orElseGet(() -> 0L));
                filter.and("dimension", "=", (Object)templateDim.getDimensionId());
                filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                filter.and("id", "in", (Object)templateDim.getMemberScope());
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
            });
        }
        this.filterControlInit();
        this.addClickListeners(new String[]{"openfilter"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter sp = this.getView().getFormShowParameter();
        if (sp.getCustomParam("report_id") instanceof Integer && EmptyUtil.isEmpty((Integer)((Integer)sp.getCustomParam("report_id")))) {
            sp = this.getView().getParentView().getFormShowParameter();
        }
        Long reportId = (Long)sp.getCustomParam("report_id");
        Object isSmartVersionObj = sp.getCustomParam("ISSMARTVER");
        Long systemId = (Long)sp.getCustomParam("system_id");
        boolean isSmartVersion = isSmartVersionObj != null && (Boolean)isSmartVersionObj != false;
        DynamicObject reportDy = this.initBaseInfo(reportId);
        if (systemId == null) {
            systemId = reportDy.getLong("bodysys.id");
        }
        if (reportId != null) {
            Object filterInfo = sp.getCustomParams().get("transParamFilterInfo");
            HashMap filterInfoMap = new HashMap();
            if (Objects.nonNull(filterInfo)) {
                ((Map)filterInfo).forEach((k, v) -> filterInfoMap.put(Long.valueOf(k.toString()), new ArrayList((List)v)));
            }
            BizReportQueryParam reportQueryParam = new BizReportQueryParam();
            reportQueryParam.setBodySysId(systemId);
            reportQueryParam.setReportId(reportId);
            reportQueryParam.setSmartVersion(isSmartVersion);
            reportQueryParam.setDimFilterMap(filterInfoMap);
            this.getOrCreateReportController().loadReportByParam(reportQueryParam);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityNum = "fpm_report";
        String permItemEnum = "4715a0df000000ac";
        boolean hasEditPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)permItemEnum);
        if (!hasEditPermission) {
            this.getView().getFormShowParameter().setCustomParam("pageType", (Object)FpmPageShowType.IN_REPORT_VIEW.getStatus());
        } else {
            boolean matchRule = PermissionServiceHelper.matchDataRule((long)currUserId, (String)appId, (String)entityNum, (String)permItemEnum, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
            if (!matchRule) {
                this.getView().getFormShowParameter().setCustomParam("pageType", (Object)FpmPageShowType.IN_REPORT_VIEW.getStatus());
            }
        }
        this.getPageCache().put("pageType", (String)this.getView().getFormShowParameter().getCustomParam("pageType"));
        this.permissionContr();
        Optional<Object> planStatusOpt = Optional.ofNullable(this.getView().getModel().getValue("planstatus"));
        ReportStatus planStatus = planStatusOpt.map(o -> ReportStatus.getByVal((String)o.toString())).orElseGet(null);
        List<ContextMenuItemsEnum> extraMenuItems = this.initMenuItem(reportDy, planStatus);
        this.executeSpreadCommand(planStatus, extraMenuItems);
        this.hideRowByMeta();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filterflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        this.initFilterMap();
    }

    private void executeSpreadCommand(ReportStatus planStatus, List<ContextMenuItemsEnum> extraMenuItems) {
        ISpreadCommand spreadCommand;
        ReportProcessStatus statusByVal = ReportProcessStatus.getStatusByVal((String)this.getModel().getDataEntity().getString("billstatus"));
        if (Objects.nonNull(statusByVal) && !ReportProcessStatus.isSave((ReportProcessStatus)statusByVal)) {
            ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
            hideItems.add(ContextMenuItemsEnum.PASTEALL);
            hideItems.add(ContextMenuItemsEnum.DELETEROWS);
            hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
            spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(this.getSpreadCommandInvoker());
        } else {
            spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        }
        String expStatus = ResManager.loadKDString((String)"\u5f02\u5e38\u72b6\u6001", (String)"ReportPlanPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        String billstatus = Optional.ofNullable(this.getView().getModel().getValue("billstatus")).map(o -> ReportProcessStatus.getNameByVal((String)o.toString())).orElseGet(() -> expStatus);
        String planStatusName = Optional.ofNullable(planStatus).map(ReportStatus::getName).orElse(expStatus);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new ShowBillStatusAndCellAcctInfoOnStatusBarGenerator().generatorChain(this.getSpreadCommandInvoker(), billstatus, planStatusName));
        spreadCommand.execCommand();
    }

    private void hideRowByMeta() {
        CacheCellMeta meta = this.getCellDS().getMeta();
        if (meta == null || CollectionUtils.isEmpty((Collection)meta.getHideRowSet())) {
            return;
        }
        RowAndColVisibleCmdChain rowAndColVisibleCmdChain = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), new ArrayList(meta.getHideRowSet()), null, Boolean.valueOf(false));
        rowAndColVisibleCmdChain.execCommand();
    }

    private List<ContextMenuItemsEnum> initMenuItem(DynamicObject reportDy, ReportStatus planStatus) {
        FormShowParameter formShowParameter;
        String pageType;
        DynamicObject templateDy = reportDy.getDynamicObject("template");
        String templateType = templateDy.getString("templatetype");
        boolean isMainTable = templateDy.getBoolean("ismaintable");
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataverify", "hideemptyrow"});
        }
        if (isMainTable) {
            extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHSUBREPORTRECORD);
        }
        if (!"linkSearchSub".equals(pageType = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("pageType"))) {
            if (Objects.nonNull(planStatus) && planStatus == ReportStatus.ENABLE && EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.FIXED.getValue())) {
                extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHEXECRECORD);
            }
            extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHINOUTCOLLECT);
        }
        return extraMenuItems;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.btnRule();
        this.visibaleForFromLinkChild();
        this.checkIfFromView();
        this.fillChangeRecord();
        this.fillThePeriodExecBiasAnalys();
        this.fillLastPeriodExecBiasAnalys();
        this.setViewVisible();
    }

    private void setViewVisible() {
        DynamicObjectCollection lastPeriodReports = this.getModel().getEntryEntity("lastentry");
        DynamicObjectCollection changeReports = this.getModel().getEntryEntity("changeentry");
        DynamicObjectCollection thisPeriodReports = this.getModel().getEntryEntity("thisentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)lastPeriodReports)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)changeReports)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)thisPeriodReports)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap211"});
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)lastPeriodReports) && EmptyUtil.isEmpty((DynamicObjectCollection)changeReports) && EmptyUtil.isEmpty((DynamicObjectCollection)thisPeriodReports)) {
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.right, true);
        }
        if (EmptyUtil.isEmpty(this.loadFilterDimList())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openfilter", "filterflex"});
        }
    }

    private void fillLastPeriodExecBiasAnalys() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        Long reportId = (Long)sp.getCustomParam("report_id");
        String selectFields = "bodysys.id,reportplantype,reportperiod.id,reportperiod.parent,reportperiod.reporttype,reportorg.id";
        DynamicObject report = QueryServiceHelper.queryOne((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        long reportPeriodId = report.getLong("reportperiod.id");
        long reportOrgId = report.getLong("reportorg.id");
        Object periodParentPkValue = report.get("reportperiod.parent");
        long reportTypeId = report.getLong("reportperiod.reporttype");
        long bodysysId = report.getLong("bodysys.id");
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)bodysysId).and("parent", "=", periodParentPkValue).and("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()).and("reporttype", "=", (Object)reportTypeId).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"startdate");
        int index = 0;
        int size = dimMembers.size();
        for (int i = 0; i < size; ++i) {
            Long pkId = ((DynamicObject)dimMembers.get(i)).getLong("id");
            if (!pkId.equals(reportPeriodId)) continue;
            index = i;
        }
        if (index < 1) {
            return;
        }
        DynamicObject lastDimMember = (DynamicObject)dimMembers.get(index - 1);
        List reportIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)bodysysId).and("reportorg", "=", (Object)reportOrgId).and("reportplantype", "=", (Object)report.getString("reportplantype")).and("reportperiod", "=", (Object)lastDimMember.getLong("id"))}, null, (int)-1);
        DynamicObjectCollection biasRecordArr = QueryServiceHelper.query((String)"fpm_execbiasanalys", (String)"id,billno,creator", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", (Object)reportIds)});
        IDataModel model = this.getModel();
        model.deleteEntryData("lastentry");
        for (DynamicObject biasRecord : biasRecordArr) {
            int newEntryRow = model.createNewEntryRow("lastentry");
            model.setValue("execbiasanalysid", (Object)biasRecord.getLong("id"), newEntryRow);
            model.setValue("execbiasanalysno", biasRecord.get("billno"), newEntryRow);
            model.setValue("execbiasanalyscreator", biasRecord.get("creator"), newEntryRow);
        }
        this.getView().updateView("lastentry");
    }

    private void fillThePeriodExecBiasAnalys() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        Long reportId = (Long)sp.getCustomParam("report_id");
        DynamicObjectCollection biasRecordArr = QueryServiceHelper.query((String)"fpm_execbiasanalys", (String)"id,billno,creator", (QFilter[])new QFilter[]{new QFilter("sourcebill", "=", (Object)reportId)});
        this.getModel().deleteEntryData("thisentry");
        for (DynamicObject biasRecord : biasRecordArr) {
            int newEntryRow = this.getModel().createNewEntryRow("thisentry");
            this.getModel().setValue("execbiasanalysid1", (Object)biasRecord.getLong("id"), newEntryRow);
            this.getModel().setValue("execbiasanalysno1", biasRecord.get("billno"), newEntryRow);
            this.getModel().setValue("execbiasanalyscreator1", biasRecord.get("creator"), newEntryRow);
        }
        this.getView().updateView("thisentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "submit": {
                op.getOption().setVariableValue("ReportOpType", ReportOpType.OP.getNumber());
                IReportVerifyController verifyController = this.getReportVerifyController();
                ReportRuleCheckDTO checkDTO = this.initRuleCheckDTO(verifyController, Boolean.TRUE);
                verifyController.ruleCheck(checkDTO, args);
                break;
            }
            case "refresh": {
                this.getPageCache().put(REFRESHING, REFRESHING);
                this.getOrCreateReportController().release();
                break;
            }
            case "linksearchchild": {
                this.checkHaveChild(args);
                break;
            }
            case "dataverify": {
                IReportVerifyController verifyController = this.getReportVerifyController();
                ReportRuleCheckDTO dataVerify = this.initRuleCheckDTO(verifyController, Boolean.FALSE);
                if (Objects.isNull(dataVerify)) break;
                ReportProcessStatus billStatus = ReportProcessStatus.getStatusByVal((String)String.valueOf(this.getModel().getValue("billstatus")));
                if (ReportProcessStatus.SAVE == billStatus) {
                    this.getView().invokeOperation("save");
                }
                this.getReportVerifyController().ruleCheck(dataVerify, args);
                args.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
        }
    }

    private void openSmartMappingRule() {
        Long systemId = this.getModel().getDataEntity(true).getLong("bodysys.id");
        DynamicObject dbDataObj = QueryServiceHelper.queryOne((String)"fpm_matchrule", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("businessbill", "=", (Object)"fpm_inoutcollect"), new QFilter("bodysys", "=", (Object)systemId), new QFilter("fetchpurpose", "=", (Object)MatchRuleFetchPurposeEnum.PLAN_REPORT.getCode()), new QFilter("enable", "=", (Object)"1")});
        if (dbDataObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u667a\u80fd\u7f16\u62a5\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3002", (String)"ReportPlanPlugin_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setAppId("fpm");
        showParameter.setFormId("fpm_matchrule");
        showParameter.setPkId(dbDataObj.get("id"));
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showInoutColl() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setAppId("fpm");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("fpm_inoutcollect");
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)"fpm_inoutcollect");
        String listFormId = formConfig.getListFormId();
        showParameter.setFormId(listFormId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSmartGetVersion() {
        Long reportId = this.getModel().getDataEntity().getLong("reportid");
        boolean exists = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("maindimentry.planreferenceamt", "!=", (Object)BigDecimal.ZERO), new QFilter("id", "=", (Object)reportId)});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String caption = this.getView().getFormShowParameter().getCaption();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("fpm_reportplan");
        showParameter.setCustomParam("report_id", (Object)reportId);
        showParameter.setCustomParam("ISSMARTVER", (Object)true);
        showParameter.setCustomParam("pageType", (Object)"view");
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff08%s\uff09\u8054\u67e5\u81ea\u52a8\u53d6\u503c\u7248\u672c", (String)"ReportPlanList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), caption));
        this.getView().showForm(showParameter);
    }

    private void trackUp() {
        Long reportId = this.getModel().getDataEntity().getLong("reportid");
        DynamicObjectCollection inOutColl = QueryServiceHelper.query((String)"fpm_inoutcollect", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.entry_relateplanreportid", "=", (Object)reportId)});
        if (CollectionUtils.isEmpty((Collection)inOutColl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = "fpm";
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_inoutcollect").searchFormNumber("fpm_inoutcollect").listFormId("bos_list").searchIds(inOutColl.stream().map(item -> item.get("id")).collect(Collectors.toList())).listForm("fpm_inoutcollect").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.DEFAULT_BILL_IMPL).linkSearch(true).caption(ResManager.loadKDString((String)"\u4e0a\u67e5\u91c7\u96c6\u5355", (String)"ReportPlanList_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).extendFunction(formShowParameter -> {
            formShowParameter.setAppId(appId);
            formShowParameter.getCustomParams().put("checkRightAppId", appId);
            return null;
        }).build()));
    }

    private void smartGetVal() {
        Long reportId = this.getModel().getDataEntity().getLong("reportid");
        DynamicObject dbData = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"templatebak", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        String smartValSetStr = dbData.getDynamicObject("templatebak").getString("smartgetvalset");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)smartValSetStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u914d\u7f6e\u667a\u80fd\u7f16\u5236\u53d6\u503c\u8bbe\u7f6e\u3002", (String)"ReportPlanPlugin_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        TemplateSmartGetValSetEnum templateSmartGetValSetEnum = TemplateSmartGetValSetEnum.get((String)smartValSetStr);
        String msg = "";
        if (templateSmartGetValSetEnum == TemplateSmartGetValSetEnum.FILLPLANAMT) {
            msg = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8986\u76d6\u66f4\u65b0\u8ba1\u5212\u8868\u4e2d\u5df2\u586b\u62a5\u7684\u8ba1\u5212\u989d\u5ea6\u6570\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\u3002", (String)"ReportPlanPlugin_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm("", msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("smartplangetval." + TemplateSmartGetValSetEnum.FILLPLANAMT, (IFormPlugin)this));
        } else if (templateSmartGetValSetEnum == TemplateSmartGetValSetEnum.REFERENCEVAL) {
            msg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u8054\u52a8\u66f4\u65b0\u586b\u62a5\u8ba1\u5212\u6570\uff0c\u82e5\u4e0d\u9700\u8981\uff0c\u5219\u4ec5\u66f4\u65b0\u8ba1\u5212\u53c2\u8003\u503c\u3002", (String)"ReportPlanPlugin_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm("", msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("smartplangetval." + TemplateSmartGetValSetEnum.REFERENCEVAL, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("deleterows".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                AskExecuteEvent event = (AskExecuteEvent)FpmSerializeUtil.deserialize((String)this.getView().getPageCache().get("deleterows"), AskExecuteEvent.class);
                this.getOrCreateReportController().deleteRows(event);
            }
        } else if (("smartplangetval." + TemplateSmartGetValSetEnum.FILLPLANAMT).equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getOrCreateReportController().smartGetVal(false);
            }
        } else if (("smartplangetval." + TemplateSmartGetValSetEnum.REFERENCEVAL).equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getOrCreateReportController().smartGetVal(true);
            } else if (MessageBoxResult.No.equals((Object)result)) {
                this.getOrCreateReportController().smartGetVal(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        Object isSmartVersionObj = this.getView().getFormShowParameter().getCustomParam("ISSMARTVER");
        boolean isSmartVersion = isSmartVersionObj != null && (Boolean)isSmartVersionObj != false;
        Long systemId = this.getModel().getDataEntity().getLong("bodysys.id");
        switch (opKey) {
            case "save": {
                this.getOrCreateReportController().saveReport();
                if (this.isDetail()) {
                    BizReportRefreshParam refreshParam = new BizReportRefreshParam(systemId, this.getPageDimMemberIds(), isSmartVersion);
                    refreshParam.setShowSuccessMessage(false);
                    this.getOrCreateReportController().refreshReport(refreshParam);
                    break;
                }
                this.amtColsAutoFix();
                break;
            }
            case "submit": {
                this.getOrCreateReportController().submitReport();
                if (this.isDetail()) {
                    BizReportRefreshParam refreshParam = new BizReportRefreshParam(systemId, this.getPageDimMemberIds(), isSmartVersion);
                    refreshParam.setShowSuccessMessage(false);
                    this.getOrCreateReportController().refreshReport(refreshParam);
                    break;
                }
                this.amtColsAutoFix();
                break;
            }
            case "unsubmit": {
                this.getOrCreateReportController().unSubmit();
                this.getOrCreateReportController().refreshReport(new BizReportRefreshParam(systemId, null, false));
                this.visibaleForFromLinkChild();
                this.checkIfFromView();
                this.hideRowByMeta();
                break;
            }
            case "refresh": {
                this.getOrCreateReportController().refreshReport(new BizReportRefreshParam(systemId, null, isSmartVersion));
                this.visibaleForFromLinkChild();
                this.checkIfFromView();
                this.hideRowByMeta();
                this.getPageCache().remove(REFRESHING);
                break;
            }
            case "audit": {
                this.getOrCreateReportController().audit();
                break;
            }
            case "unaudit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getOrCreateReportController().unAudit();
                this.getOrCreateReportController().refreshReport(new BizReportRefreshParam(systemId, null, false));
                this.visibaleForFromLinkChild();
                this.checkIfFromView();
                this.hideRowByMeta();
                break;
            }
            case "viewflowwork": {
                Long billId = Long.valueOf(this.getModel().getValue("reportid").toString());
                if (!WfConfigurationUtil.canRunWorkflow()) {
                    this.getView().showErrorNotification(WFErrorCode.workflowEngineNotConfiguration().getMessage());
                    break;
                }
                AbstractViewFlowchart vfc = new AbstractViewFlowchart();
                vfc.setBillId((Object)billId);
                vfc.setBillIdField("id");
                vfc.setEntityName("fpm_report");
                vfc.showFlowchart(this.getView());
                break;
            }
            case "linksearchchild": {
                this.showListOrOpenChild();
                break;
            }
            case "exportexcel": {
                Long reportId = this.getModel().getDataEntity().getLong("reportid");
                ReportPlanFormsExportImpl exportExcel = new ReportPlanFormsExportImpl(Collections.singleton(reportId));
                Tuple exportResult = exportExcel.export();
                if (((Boolean)exportResult.item1).booleanValue()) {
                    this.getView().download((String)exportResult.item2);
                    break;
                }
                this.showErrMessage(Collections.singletonList(exportResult.item2));
                break;
            }
            case "showmapset": {
                this.openSmartMappingRule();
                break;
            }
            case "smartplangetval": {
                this.smartGetVal();
                break;
            }
            case "trackupop": {
                this.trackUp();
                break;
            }
            case "showsmartgetversion": {
                this.showSmartGetVersion();
                break;
            }
            case "showinoutcoll": {
                this.showInoutColl();
                break;
            }
            case "queryreport": {
                this.linkSearchSubReportNeedQuery(isSmartVersion);
                this.rowAndColVisible();
                this.hideRowByMeta();
                break;
            }
            case "dataverify": {
                this.handleDataVerifyNotify(args);
                break;
            }
            case "importreport": {
                this.showImportForm();
                break;
            }
            case "exporttpl": {
                Long reportPkId = this.getModel().getDataEntity().getLong("reportid");
                if (EmptyUtil.isNoEmpty((Long)reportPkId)) {
                    this.exportPlanTempl(reportPkId);
                }
            }
            case "showemptyrow": {
                this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getCellDataSource().getAllEmptyValRows());
                break;
            }
            case "hideemptyrow": {
                this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getCellDataSource().getAllEmptyValRows());
                break;
            }
        }
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
    }

    private void linkSearchSubReportNeedQuery(boolean isSmartVersion) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        String needRequery = this.getPageCache().get("needrequery");
        if ("linkSearchSub".equals(pageType) && Boolean.parseBoolean(needRequery)) {
            Long reportId = (Long)formShowParameter.getCustomParam("report_id");
            Long systemId = this.getModel().getDataEntity(true).getLong("bodysys.id");
            BizReportQueryParam reportQueryParam = new BizReportQueryParam();
            reportQueryParam.setBodySysId(systemId);
            reportQueryParam.setReportId(reportId);
            reportQueryParam.setSmartVersion(isSmartVersion);
            this.getOrCreateReportController().loadReportByParam(reportQueryParam);
            this.visibaleForFromLinkChild();
            this.checkIfFromView();
            this.getPageCache().remove(REFRESHING);
            this.getPageCache().put("needrequery", "false");
        }
    }

    private boolean isDetail() {
        String templateType = this.getCache().get("templatetype");
        if (EmptyUtil.isNoEmpty((String)templateType)) {
            return TemplateType.isDetail((String)templateType);
        }
        Long billId = Long.valueOf(this.getModel().getValue("reportid").toString());
        DynamicObject report = QueryServiceHelper.queryOne((String)"fpm_report", (String)"templatebak.templatetype", (QFilter[])new QFilter("id", "=", (Object)billId).toArray());
        String templateTypeStr = report.getString("templatebak.templatetype");
        return TemplateType.getByNumber((String)templateTypeStr) != null && TemplateType.getByNumber((String)templateTypeStr).isDetail();
    }

    private void exportPlanTempl(Long reportId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("fpm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"ReportPlanPlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setTaskClassname("kd.tmc.fpm.business.task.ReportTemplateExportTask");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", String.valueOf(reportId));
        params.put("tasktype", "number");
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exporttaskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u6a21\u677f\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"ReportPlanPlugin_16", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.tmc.fpm.business.task.ReportImportDataClickTask");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "pagedim1": 
            case "pagedim2": {
                if (Objects.equals(REFRESHING, this.getPageCache().get(REFRESHING))) break;
                Object isSmartVersionObj = this.getView().getFormShowParameter().getCustomParam("ISSMARTVER");
                boolean isSmartVersion = isSmartVersionObj != null && (Boolean)isSmartVersionObj != false;
                this.getOrCreateReportController().refreshReport(new BizReportRefreshParam(Long.valueOf(this.getModel().getDataEntity().getLong("bodysys.id")), this.getPageDimMemberIds(), isSmartVersion));
                this.visibaleForFromLinkChild();
                this.checkIfFromView();
                this.rowAndColVisible();
                this.hideRowByMeta();
                break;
            }
        }
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", (Object)book.getSheet().getMaxRow());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", (Object)book.getSheet().getMaxCol());
    }

    public void updateCell(List<Cell> cells) {
        ISpreadCommand spreadCommand = new DefaultCellUpdateGenerator(true).generatorChain(this.getSpreadCommandInvoker(), cells);
        spreadCommand.execCommand();
    }

    public void cleanCell(List<Cell> cells) {
        ISpreadCommand spreadCommand = new CleanCellUpdateGenerator(false).generatorChain(this.getSpreadCommandInvoker(), cells);
        spreadCommand.execCommand();
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElse(""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "openfilter": {
                Label label = (Label)this.getView().getControl("openfilter");
                String openFilter = this.getView().getPageCache().get("open_filter");
                String open = ResManager.loadKDString((String)"\u5c55\u5f00\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                String close = ResManager.loadKDString((String)"\u6536\u8d77\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                if (EmptyUtil.isEmpty((String)openFilter) || open.equals(openFilter)) {
                    openFilter = close;
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"filterflex"});
                } else {
                    openFilter = open;
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filterflex"});
                }
                label.setText(openFilter);
                this.getView().getPageCache().put("open_filter", openFilter);
            }
        }
    }

    public void deleteRows(AskExecuteEvent event) {
        List rows = (List)event.getParams();
        String tipMsg = rows.contains(0) ? ResManager.loadKDString((String)"(\u6807\u5934\u884c\u4e0d\u5220\u9664)", (String)"ReportPlanPlugin_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : "";
        this.getView().getPageCache().put("deleterows", FpmSerializeUtil.serialize((Object)event));
        String rowsStr = rows.stream().map(o -> String.format("%s", o + 1)).collect(Collectors.joining(","));
        this.getView().showConfirm("", String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664%1$s\u884c%2$s\u5417?", (String)"ReportPlanPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rowsStr, tipMsg), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("deleterows", (IFormPlugin)this));
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void showWarnMessage(String warnMessage) {
        if (null != warnMessage) {
            this.getView().showTipNotification(warnMessage);
        }
    }

    public void cellFormulaUpdate(List<FormulaCell> formulaCells) {
        new CellFormulaCmdChain(this.getSpreadCommandInvoker(), null, formulaCells).execCommand();
    }

    public void cellValueUpdate(List<CellValueEvent> events) {
        super.cellValueUpdate(events);
        int maxRow = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class);
        int maxCol = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class);
        CellDataSource cellDS = this.getCellDS();
        events.removeIf(event -> !cellDS.checkBounds(event.getCell().getRow(), event.getCell().getCol()));
        List copyDataBaseCellSources = events.stream().filter(Objects::nonNull).filter(o -> {
            CacheCell cellByCoord = cellDS.getCell(o.getCell().getRow(), o.getCell().getCol());
            if (cellByCoord == null) {
                return false;
            }
            CellTypeEnum cellType = cellByCoord.getCellType();
            return cellType == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType;
        }).map(o -> new Cell(o.getCell().getRow(), o.getCell().getCol(), o.getNewValue())).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(copyDataBaseCellSources)) {
            this.getOrCreateReportController().copyDataHandle(copyDataBaseCellSources);
        }
        ArrayList<CellUpdateResult> cellUpdateResults = new ArrayList<CellUpdateResult>(events.size());
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c", (String)"ReportPlanPlugin_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        BigDecimal max = new BigDecimal(MAX_AMOUNT_CELL);
        BigDecimal min = new BigDecimal(MIN_AMOUNT_CELL);
        boolean hasErr = false;
        for (CellValueEvent event2 : events) {
            CellTypeEnum cellType;
            BigDecimal amount;
            Object newValue = event2.getNewValue();
            CacheCell originCell = cellDS.getCell(event2.getCell().getRow(), event2.getCell().getCol());
            if (originCell == null) {
                maxRow = Math.max(event2.getCell().getRow(), maxRow);
                maxCol = Math.max(event2.getCell().getCol(), maxCol);
                continue;
            }
            if (originCell.getCellType() == CellTypeEnum.AMOUNT && (NumberUtils.greaterEqualsThan((BigDecimal)(amount = CommonUtils.getBigDecimalValue((Object)newValue)), (BigDecimal)max) || NumberUtils.lessEqualsThan((BigDecimal)amount, (BigDecimal)min))) {
                sb.append("\u3010").append(ExcelUtils.xy2Pos((int)event2.getCell().getCol(), (int)event2.getCell().getRow())).append("\u3011").append(ResManager.loadKDString((String)"\u586b\u5165\u7684\u6570\u503c", (String)"ReportPlanPlugin_21", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).append(amount.toPlainString()).append("\u3001");
                event2.setNewValue(originCell.getValue());
                hasErr = true;
            }
            if ((cellType = originCell.getCellType()) == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType || originCell.isSummary()) continue;
            try {
                CellUpdateResult updateCellInfo = null;
                updateCellInfo = CellValueUpdateFactory.createCellValueUpdateInstance((CellValueEvent)event2, (Cell)originCell).update();
                cellUpdateResults.add(updateCellInfo);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<String> failureMsgs = cellUpdateResults.stream().filter(Objects::nonNull).filter(o -> EmptyUtil.isNoEmpty((String)o.getErrMsg())).map(CellUpdateResult::getErrMsg).collect(Collectors.toList());
        this.showErrMessage(failureMsgs);
        List updateCells = cellUpdateResults.stream().filter(Objects::nonNull).map(CellUpdateResult::getCell).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateCells)) {
            this.getOrCreateReportController().updateReportData(updateCells);
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", (Object)maxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", (Object)maxCol);
        if (hasErr) {
            sb.deleteCharAt(sb.length() - 1);
            sb.append(ResManager.loadKDString((String)"\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"ReportPlanPlugin_22", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(sb.toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getReturnData() != null) {
            switch (event.getActionId()) {
                case "spreadjs_f7winclose_callback": {
                    if (!this.updateCellValue(event)) break;
                    return;
                }
                case "dataverify": {
                    if (!this.dataVerify(event)) break;
                    return;
                }
                case "exporttaskcloseback": {
                    this.exportTaskCloseBack(event);
                    break;
                }
                case "importData": {
                    this.handleImportCallBack(event);
                    break;
                }
                case "importDataCloseCallBack": {
                    this.afterImportCallBack(event);
                }
            }
        } else {
            switch (event.getActionId()) {
                case "closeInOutCollectPanel": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
                    this.hideSplitPane();
                }
            }
        }
    }

    private boolean dataVerify(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (CollectionUtils.isEmpty((Map)returnData)) {
            return true;
        }
        String dataVerifyResult = returnData.get("dataVerifyResult").toString();
        List notifyDTOList = JSONArray.parseArray((String)dataVerifyResult, ReportVerifyRuleNotifyDTO.class);
        if (CollectionUtils.isEmpty((Collection)notifyDTOList)) {
            return true;
        }
        boolean commit = notifyDTOList.stream().anyMatch(ReportVerifyRuleNotifyDTO::getFromCommit);
        if (!commit) {
            return true;
        }
        boolean anyMatch = notifyDTOList.stream().anyMatch(item -> ReportVerifyCheckEffectEnum.DISABLE.getCode().equals(item.getCheckEffect().getCode()));
        if (!anyMatch) {
            this.getOrCreateReportController().submitReport();
            this.afterOpRefreshField("submit");
            this.rowAndColVisible();
            this.hideRowByMeta();
        }
        return false;
    }

    private boolean updateCellValue(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return true;
        }
        Long id = (Long)returnData.getPrimaryKeyValues()[0];
        Cell currCell = (Cell)FpmSerializeUtil.deserialize((String)this.getPageCache().get("cell_pagecache"), Cell.class);
        CacheCell cell = this.getCellDS().getCell(currCell.getRow(), currCell.getCol());
        DynamicObject selectDataDy = QueryServiceHelper.queryOne((String)cell.getWidgetValue().toString(), (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        cell.setDisplayValue((Object)selectDataDy.getString("name"));
        cell.setNewValue((Object)id);
        cell.setValue((Object)id);
        this.getOrCreateReportController().updateReportData(Collections.singletonList(cell));
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, false).generatorChain(this.getSpreadCommandInvoker(), Collections.singletonList(cell));
        spreadCommand.execCommand();
        return false;
    }

    private void exportTaskCloseBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        Object taskinfoObj = result.get("taskinfo");
        if (EmptyUtil.isEmpty(taskinfoObj)) {
            return;
        }
        String taskInfoStr = (String)taskinfoObj;
        if (EmptyUtil.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd()) {
            String data = taskInfo.getData();
            Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            boolean success = (Boolean)mapData.get("success");
            if (success) {
                String casesResult = (String)mapData.get("taskinfo");
                if (EmptyUtil.isNoEmpty((String)casesResult)) {
                    this.getView().download(casesResult);
                }
            } else {
                String error = (String)mapData.get("error");
                this.getView().showErrMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u4efb\u52a1\u5f02\u5e38\u3002", (String)"ReportPlanPlugin_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), error);
            }
        }
    }

    public void refreshPageDim(List<ReportCalcVal> reportCalcVals, boolean isChange, ReportTemplate reportTemplate) {
        HashMap<String, TemplateDim> mapper = new HashMap<String, TemplateDim>(16);
        List pageDimList = reportTemplate.getPageDimList();
        int count = 1;
        for (int i = 0; i < pageDimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)pageDimList.get(i);
            if (templateDim.getDimType() == DimensionType.ORG) continue;
            String pageDimSign = String.format("pagedim%s", count++);
            mapper.put(pageDimSign, templateDim);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pagedim1", "pagedim2"});
        block1: for (ReportCalcVal reportCalcVal : reportCalcVals) {
            Long id = Long.valueOf(reportCalcVal.getValue().toString());
            Set entrys = mapper.entrySet();
            for (Map.Entry entry : entrys) {
                String sign = (String)entry.getKey();
                List ids = ((TemplateDim)entry.getValue()).getMemberScope();
                DynamicObject reportorg = (DynamicObject)this.getModel().getValue("reportorg");
                if (!ids.contains(id)) continue;
                boolean bool = id.compareTo(Long.valueOf(reportorg.getPkValue().toString())) == 0;
                this.getView().setVisible(Boolean.valueOf(!bool), new String[]{sign});
                BasedataEdit control = (BasedataEdit)this.getControl(sign);
                control.setCaption(new LocaleString(((TemplateDim)entry.getValue()).getDimensionName() + "\uff1a"));
                if (isChange) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)sign, (Object)id);
                    continue block1;
                }
                this.getView().getModel().setValue(sign, (Object)id);
                continue block1;
            }
        }
        this.getView().getPageCache().put("page_dim_mapping_cache", FpmSerializeUtil.serialize(mapper));
        this.getView().getPageCache().put("system_id_cache", reportTemplate.getSystemId().toString());
    }

    public void refreshPageControl() {
        this.btnRule();
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.getOrCreateReportController().release();
    }

    private void btnRule() {
        SpreadCommandInvoker spreadCommandInvoker = this.getSpreadCommandInvoker();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        if (FpmPageShowType.isView((String)pageType) || FpmPageShowType.isInReportView((String)pageType)) {
            return;
        }
        Long billId = Long.valueOf(this.getModel().getValue("reportid").toString());
        DynamicObject reportDy = QueryServiceHelper.queryOne((String)"fpm_report", (String)"billstatus,templatebak.templatetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        String billStatus = reportDy.getString("billstatus");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"submit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"audit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"audit", "unaudit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"submit", "save", "smartplangetval", "importdata", "exporttpl"});
            String templateType = reportDy.getString("templatebak.templatetype");
            if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.FIXED.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"dataverify"});
            }
        } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            new LockSheetCmdChain(spreadCommandInvoker, Collections.singletonList("Sheet1"), true).execCommand();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"submit", "unaudit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"audit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"audit", "submit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unaudit", "save", "smartplangetval", "importdata", "exporttpl", "dataverify"});
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            new LockSheetCmdChain(spreadCommandInvoker, Collections.singletonList("Sheet1"), true).execCommand();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"audit", "submit", "unsubmit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"unaudit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"audit", "unaudit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit", "unsubmit", "save", "smartplangetval", "importdata", "exporttpl", "dataverify"});
        }
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        CellDataSource dataSource = new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId()));
        CacheCell cell = dataSource.getCell(args.getR(), args.getC());
        if (cell == null) {
            return;
        }
        CellTypeEnum cellType = cell.getCellType();
        List<Object> params = null;
        if (cellType == CellTypeEnum.F7WIDGET) {
            Object billSign = cell.getWidgetValue();
            if (billSign == null || billSign.toString().isEmpty()) {
                return;
            }
            params = this.queryBaseDataInfo(billSign, args);
        } else if (cellType == CellTypeEnum.DOWNBOXWIDGET || cellType == CellTypeEnum.MUTITYPEWIDGET) {
            Map comboxValues = (Map)cell.getWidgetValue();
            Set entries = comboxValues.entrySet();
            params = new ArrayList<Object>(comboxValues.size());
            for (Map.Entry entry : entries) {
                ArrayList<Object> param = new ArrayList<Object>();
                param.add(entry.getValue());
                param.add(entry.getValue());
                param.add(entry.getKey());
                params.add(param);
            }
        }
        HashMap<String, Object> f7Params = new HashMap<String, Object>();
        f7Params.put("data", params);
        f7Params.put("r", args.getR());
        f7Params.put("c", args.getC());
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.invokeControlMethod(this.getSpreadKey(), "setLookupData", new Object[]{f7Params});
    }

    private List<Object> queryBaseDataInfo(Object billSign, LookUpDataArgs args) {
        ArrayList<Object> result = new ArrayList<Object>(20);
        String nameProperty = "name";
        String numberProperty = "number";
        if (!Arrays.asList(DetailDimType.BANK_CATE.getExtVal(), DetailDimType.BUSINESS_PARTNER.getExtVal()).contains(billSign)) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)billSign.toString());
            nameProperty = basedataEntityType.getNameProperty();
            numberProperty = basedataEntityType.getNumberProperty();
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)nameProperty) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)numberProperty)) {
            return result;
        }
        List f7Filters = ((ReportManageController)this.getOrCreateReportController()).getF7Filter(args.getR(), args.getC(), args.getValue().trim());
        if (Arrays.asList("bd_supplier", "bos_user", "bos_org", "bd_customer").contains((String)billSign)) {
            f7Filters.add(new QFilter("enable", "=", (Object)"1"));
            f7Filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        DynamicObjectCollection elements = QueryServiceHelper.query((String)billSign.toString(), (String)String.join((CharSequence)",", "id", nameProperty, numberProperty), (QFilter[])f7Filters.toArray(new QFilter[0]), (String)"", (int)20);
        for (DynamicObject element : elements) {
            ArrayList<String> param = new ArrayList<String>(3);
            param.add(element.getString("id"));
            param.add(element.getString(numberProperty));
            param.add(element.getString(nameProperty));
            result.add(param);
        }
        return result;
    }

    public void spreadF7Click(int row, int col) {
        CellDataSource dataSource = new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId()));
        CacheCell cell = dataSource.getCell(row, col);
        if (cell == null) {
            return;
        }
        String billSign = Optional.ofNullable(cell.getWidgetValue()).map(o -> o.toString()).orElseGet(() -> null);
        if (EmptyUtil.isEmpty((String)billSign)) {
            return;
        }
        ListShowParameter spreadJSF7ListForm = ShowFormHelper.createShowListForm((String)billSign, (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "spreadjs_f7winclose_callback");
        spreadJSF7ListForm.setCloseCallBack(callBack);
        List filters = spreadJSF7ListForm.getListFilterParameter().getQFilters();
        List f7Filters = ((ReportManageController)this.getOrCreateReportController()).getF7Filter(row, col, null);
        if (!Arrays.asList(DetailDimType.BANK_CATE.getExtVal(), DetailDimType.BUSINESS_PARTNER.getExtVal()).contains(billSign)) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)billSign);
            String nameProperty = basedataEntityType.getNameProperty();
            String numberProperty = basedataEntityType.getNumberProperty();
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)nameProperty) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)numberProperty)) {
                f7Filters.add(new QFilter("1", "!=", (Object)1));
            }
        }
        if (Arrays.asList("bd_supplier", "bos_user", "bos_org", "bd_customer").contains(billSign)) {
            f7Filters.add(new QFilter("enable", "=", (Object)"1"));
            f7Filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        filters.addAll(f7Filters);
        this.getView().showForm((FormShowParameter)spreadJSF7ListForm);
        Cell finalCell = new Cell();
        finalCell.setRow(row);
        finalCell.setCol(col);
        this.getPageCache().put("cell_pagecache", FpmSerializeUtil.serialize((Object)finalCell));
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        if (EmptyUtil.isEmpty((String)arg.getName()) && EmptyUtil.isEmpty((String)arg.getNumber())) {
            return;
        }
        Cell cell = new Cell();
        cell.setRowAndCol(arg.getR(), arg.getC());
        cell.setDisplayValue((Object)arg.getName());
        Object value = arg.getId();
        value = !Long.valueOf(value.toString()).equals(0L) ? value : arg.getNumber();
        cell.setNewValue(value);
        cell.setValue(value);
        this.getOrCreateReportController().updateReportData(Collections.singletonList(cell));
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, false).generatorChain(this.getSpreadCommandInvoker(), Collections.singletonList(cell));
        spreadCommand.execCommand();
    }

    protected IReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new ReportManageController((IReportManageView)this);
        }
        return this.controller;
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            this.verifyController = new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    private DynamicObject initBaseInfo(Long reportId) {
        Date exchangeratedate;
        DynamicObjectCollection curMemberCol;
        IDataModel dataModel = this.getView().getModel();
        dataModel.setValue("reportid", (Object)String.valueOf(reportId));
        DynamicObject reportDy = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)(String.join((CharSequence)",", ReportProp.getBillHeadProp()) + "," + "template" + "," + "returncomments" + "," + "company"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        if (Objects.isNull(reportDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u5236\u8868\u5df2\u88ab\u5220\u9664\u3002", (String)"ReportPlanPlugin_26", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        dataModel.setValue("returncomments", (Object)reportDy.getString("returncomments"));
        dataModel.setValue("bodysys", (Object)reportDy.getDynamicObject("bodysys"));
        dataModel.setValue("reportorg", (Object)reportDy.getDynamicObject("reportorg"));
        dataModel.setValue("reportperiod", (Object)reportDy.getDynamicObject("reportperiod"));
        dataModel.setValue("name", (Object)reportDy.getString("name"));
        Object informant = reportDy.get("informant");
        if (informant != null) {
            dataModel.setValue("creator", reportDy.get("informant"));
        }
        if ((curMemberCol = reportDy.getDynamicObjectCollection("currencyrange")) != null && curMemberCol.size() != 0) {
            dataModel.setValue("currencyrange", (Object)curMemberCol);
        }
        dataModel.setValue("company", (Object)reportDy.getDynamicObject("company"));
        DynamicObject exchangeTable = reportDy.getDynamicObject("exratetable");
        if (exchangeTable != null) {
            dataModel.setValue("exratetable", (Object)exchangeTable.getString("name"));
        }
        if ((exchangeratedate = reportDy.getDate("exchangeratedate")) != null) {
            dataModel.setValue("exchangeratedate", (Object)exchangeratedate);
        }
        DynamicObject templateDy = reportDy.getDynamicObject("templatebak");
        String amtUnit = templateDy.getString("amountunit");
        dataModel.setValue("amtunits", (Object)amtUnit);
        if (AmountUnitEnum.FROMPARENT.getValue().equals(amtUnit)) {
            DynamicObject parentTemplate = reportDy.getDynamicObject("parenttemplate");
            dataModel.setValue("amtunits", (Object)parentTemplate.getString("amountunit"));
        }
        boolean isMainTable = templateDy.getBoolean("ismaintable");
        this.getView().setVisible(Boolean.valueOf(isMainTable), new String[]{"linksearchchild"});
        String reportType = isMainTable ? "0" : "1";
        dataModel.setValue("reporttype", (Object)reportType);
        dataModel.setValue("billstatus", reportDy.get("billstatus"));
        dataModel.setValue("planstatus", reportDy.get("planstatus"));
        dataModel.setValue("zeroreport", reportDy.get("zeroreport"));
        return reportDy;
    }

    private void permissionContr() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        if (FpmPageShowType.isWrite((String)pageType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"save", "submit", "audit", "moreaction", "smartplangetval"});
        } else if (FpmPageShowType.isLinkSearchSub((String)pageType)) {
            Container fieldContainer;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "audit", "moreaction", "smartplangetval", "addattach"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"linkquery", "addattach"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            if (Objects.nonNull(splitContainer)) {
                splitContainer.setCollapse("splitpanelap1", true);
            }
            if (Objects.nonNull(fieldContainer = (Container)this.getControl("fieldsetpanelap"))) {
                fieldContainer.setCollapse(true);
            }
        } else if (FpmPageShowType.isInReportView((String)pageType)) {
            boolean isSmartVersion;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "audit", "importdata", "smartplangetval", "showmapset", "showinoutcoll"});
            Object isSmartVersionObj = this.getView().getFormShowParameter().getCustomParam("ISSMARTVER");
            boolean bl = isSmartVersion = isSmartVersionObj != null && (Boolean)isSmartVersionObj != false;
            if (isSmartVersion) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"linkquery"});
            }
        } else {
            boolean isSmartVersion;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "audit", "moreaction", "smartplangetval", "addattach"});
            Object isSmartVersionObj = this.getView().getFormShowParameter().getCustomParam("ISSMARTVER");
            boolean bl = isSmartVersion = isSmartVersionObj != null && (Boolean)isSmartVersionObj != false;
            if (isSmartVersion) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"linkquery", "addattach"});
            }
        }
    }

    private List<Long> getPageDimMemberIds() {
        Long pageDimId2;
        ArrayList<Long> pageDimMemberIds = new ArrayList<Long>(2);
        Long reportOrgId = this.getView().getModel().getDataEntity(true).getLong("reportorg.id");
        pageDimMemberIds.add(reportOrgId);
        Long pageDimId1 = Optional.ofNullable((DynamicObject)this.getView().getModel().getValue("pagedim1")).map(num -> Long.valueOf(num.getPkValue().toString())).orElseGet(() -> null);
        if (pageDimId1 != null) {
            pageDimMemberIds.add(pageDimId1);
        }
        if ((pageDimId2 = Optional.ofNullable((DynamicObject)this.getView().getModel().getValue("pagedim2")).map(num -> Long.valueOf(num.getPkValue().toString())).orElseGet(() -> null)) != null) {
            pageDimMemberIds.add(pageDimId2);
        }
        return pageDimMemberIds;
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    private void afterOpRefreshField(String opName) {
        IDataModel dataModel = this.getView().getModel();
        Long reportId = Optional.ofNullable(this.getView().getModel().getValue("reportid")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        if (reportId.compareTo(0L) == 0) {
            return;
        }
        DynamicObject reportDy = TmcDataServiceHelper.loadSingle((Object)reportId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report"));
        Object informant = reportDy.get("informant");
        if (informant != null) {
            dataModel.setValue("creator", reportDy.get("informant"));
        }
    }

    private void checkHaveChild(BeforeDoOperationEventArgs args) {
        Long reportId = Long.valueOf(this.getModel().getValue("reportid").toString());
        DynamicObject reportMain = TmcDataServiceHelper.loadSingle((Object)reportId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report"));
        DynamicObject[] ids = this.getSubReport(reportMain);
        if (Objects.isNull(ids) || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"ReportPlanPlugin_25", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private DynamicObject[] getSubReport(DynamicObject reportMain) {
        DynamicObject bodySysDy = reportMain.getDynamicObject("bodysys");
        DynamicObject templateDy = reportMain.getDynamicObject("templatebak");
        if (Objects.isNull(bodySysDy) || Objects.isNull(templateDy)) {
            return null;
        }
        Long reportOrgId = reportMain.getLong("reportorg.id");
        DynamicObject reportOrg = TmcDataServiceHelper.loadSingle((Object)reportOrgId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        if (Objects.isNull(reportOrg)) {
            return null;
        }
        DynamicObjectCollection periodObjColl = reportMain.getDynamicObjectCollection("periodlist");
        List periodObjArr = periodObjColl.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] periodMemberIdArr = TmcDataServiceHelper.load((String)DimsionEnums.PERIOD.getMetadata(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", periodObjArr), new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()), new QFilter("bodysystem", "=", bodySysDy.getPkValue())});
        Object[] memIdArr = Arrays.stream(periodMemberIdArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] periodMemberArr = TmcDataServiceHelper.load((Object[])memIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DimsionEnums.PERIOD.getMetadata()));
        Optional<DynamicObject> optional = Arrays.stream(periodMemberArr).sorted(Comparator.comparing(ReportPlanPlugin::getPeriodCompareDate)).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        DynamicObject periodDy = optional.get();
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("parenttemplate.id", "=", (Object)templateDy.getLong("templateid")), new QFilter("reportperiod", "=", periodDy.getPkValue()), new QFilter("reportorg", "=", reportOrg.getPkValue())});
        return ids;
    }

    private void showListOrOpenChild() {
        Long reportId = Long.valueOf(this.getModel().getValue("reportid").toString());
        DynamicObject reportMain = TmcDataServiceHelper.loadSingle((Object)reportId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report"));
        DynamicObject[] ids = this.getSubReport(reportMain);
        if (Objects.isNull(ids) || ids.length == 0) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        String appId = "fpm";
        FormShowParameter currentFormParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(currentFormParameter) && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)currentFormParameter.getAppId())) {
            appId = currentFormParameter.getAppId();
        }
        showParameter.setAppId(appId);
        showParameter.getCustomParams().put("checkRightAppId", appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)"fpm", (CharSequence)appId) ? ShowType.MainNewTabPage : ShowType.Modal);
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("param_from_link_search_child", (Object)Boolean.TRUE);
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)"fpm_reportplan");
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)"fpm_report");
        showParameter.setCustomParam("ENTITY_IDS", Arrays.stream(ids).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        showParameter.setCustomParam("LIST_ENTITY_NAME", (Object)"fpm_report");
        showParameter.setCustomParam("LIST_FORM_ID", (Object)"bos_treelist");
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_SUB_REPORT.getType().getName());
        showParameter.setCustomParam("param_from_link_search_child", (Object)Boolean.TRUE);
        String caption = ResManager.loadKDString((String)"\u5355\u636e(%s)\u8054\u67e5\u5b50\u8868", (String)"ReportPlanPlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[]{reportMain.getString("billno")});
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    private static Date getPeriodCompareDate(DynamicObject dynamicObject) {
        return dynamicObject.getDate("startdate");
    }

    private void visibaleForFromLinkChild() {
        Boolean fromLinkSearchSubReport;
        String pageType;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean fromLinkSearchChild = (Boolean)formShowParameter.getCustomParam("param_from_link_search_child");
        if (Objects.nonNull(fromLinkSearchChild) && fromLinkSearchChild.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "submit", "audit", "addattach", "moreaction", "smartplangetval"});
        }
        if ("linkSearchSub".equals(pageType = (String)formShowParameter.getCustomParam("pageType"))) {
            this.getPageCache().put("needrequery", "true");
        }
        if (Objects.nonNull(fromLinkSearchSubReport = (Boolean)formShowParameter.getCustomParam("fromLinkSearchSubReport")) && fromLinkSearchSubReport.booleanValue()) {
            Container fieldContainer;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "audit", "moreaction", "smartplangetval", "addattach"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"linkquery", "addattach"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            if (Objects.nonNull(splitContainer)) {
                splitContainer.setCollapse("splitpanelap1", true);
            }
            if (Objects.nonNull(fieldContainer = (Container)this.getControl("fieldsetpanelap"))) {
                fieldContainer.setCollapse(true);
            }
        }
    }

    private void checkIfFromView() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        if (FpmPageShowType.isView((String)pageType) || FpmPageShowType.isInReportView((String)pageType)) {
            this.getView().getPageCache().put(FORM_VIEW, "Y");
        }
        if (Objects.equals(this.getView().getPageCache().get(FORM_VIEW), "Y")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "submit", "audit", "smartplangetval"});
        }
    }

    private void fillChangeRecord() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        Long reportId = (Long)sp.getCustomParam("report_id");
        DynamicObjectCollection changeRecordArr = QueryServiceHelper.query((String)"fpm_reportplan_adjust", (String)"id,billno,adjustreason,creator,modifytime", (QFilter[])new QFilter[]{new QFilter("originalreportids", "like", (Object)("%" + reportId + "%"))});
        IDataModel model = this.getModel();
        model.deleteEntryData("changeentry");
        for (DynamicObject changeRecord : changeRecordArr) {
            int newEntryRow = model.createNewEntryRow("changeentry");
            model.setValue("changeid", (Object)changeRecord.getLong("id"), newEntryRow);
            model.setValue("changeno", changeRecord.get("billno"), newEntryRow);
            model.setValue("changecreator", (Object)changeRecord.getLong("creator"), newEntryRow);
            model.setValue("changecreatdate", changeRecord.get("modifytime"), newEntryRow);
            model.setValue("changereason", kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)changeRecord.getString("adjustreason")) ? "-" : changeRecord.get("adjustreason"), newEntryRow);
        }
        this.getView().updateView("changeentry");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (hyperLinkClickEvent.getFieldName()) {
            case "changeno": {
                Object changeId = this.getModel().getValue("changeid", rowIndex);
                if (StringUtils.isEmpty((Object)changeId)) break;
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setPkId(changeId);
                billShowParameter.setFormId("fpm_reportplan_adjust");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
            case "execbiasanalysno1": {
                Object thisExecBiasId = this.getModel().getValue("execbiasanalysid1", rowIndex);
                if (thisExecBiasId == null) break;
                BillShowParameter parameter = new BillShowParameter();
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setFormId("fpm_execbiasanalys");
                parameter.setPkId(thisExecBiasId);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "execbiasanalysno": {
                Object lastExecBiasId = this.getModel().getValue("execbiasanalysid", rowIndex);
                if (lastExecBiasId == null) break;
                BillShowParameter parameter = new BillShowParameter();
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setFormId("fpm_execbiasanalys");
                parameter.setPkId(lastExecBiasId);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private void filterControlInit() {
        ReportPlanProp.FILTER_PROP_LIST.forEach(prop -> this.getView().setVisible(Boolean.FALSE, new String[]{prop}));
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        Long systemId = reportTemplate.getSystemId();
        List<TemplateDim> filterDimList = this.loadFilterDimList();
        int colFilterIndex = 1;
        int rowFilterIndex = 1;
        for (TemplateDim templateDim : filterDimList) {
            String controlKey = "";
            if (templateDim.getLocation() == DimLocation.COL) {
                controlKey = String.format("filter_col_0%s", colFilterIndex++);
            } else {
                if (templateDim.getLocation() != DimLocation.ROW) continue;
                controlKey = String.format("filter_row_0%s", rowFilterIndex++);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"queryreport"});
            BasedataEdit filterDim = (BasedataEdit)this.getControl(controlKey);
            filterDim.setCaption(new LocaleString(templateDim.getDimensionName() + "\uff1a"));
            filterDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
                filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                filter.and("dimension", "=", (Object)templateDim.getDimensionId());
                if (templateDim.getDimType() == DimensionType.PERIOD) {
                    List<Long> currentPeriodChildList = this.getPeriodFilterMemberListByPageCache(reportDataManager.getSystem(), templateDim);
                    filter.and("id", "in", currentPeriodChildList);
                } else {
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                }
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
            });
        }
    }

    private void rowAndColVisible() {
        List needHideList;
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        if (reportTemplate.getTemplateType().isDetail()) {
            FundPlanSystem fundPlanSystem = reportDataManager.getSystem();
            this.detailReportRowVisible(fundPlanSystem, reportTemplate);
            return;
        }
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List rowDimList = reportTemplate.getRowDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        List filterColDimList = reportTemplate.getColDimList().stream().filter(item -> !item.isViDim()).filter(TemplateDim::isFilterDim).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObjectCollection firstRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_01");
        DynamicObjectCollection secondRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_02");
        ArrayList<Integer> needHideColList = new ArrayList<Integer>(16);
        ArrayList<Integer> needHideRowList = new ArrayList<Integer>(16);
        if (!CollectionUtils.isEmpty(filterColDimList)) {
            int i = 0;
            ArrayList<Predicate<ReportCalcVal>> hideColPredicateListByFilterCol = new ArrayList<Predicate<ReportCalcVal>>(filterColDimList.size());
            while (i < filterColDimList.size() && i < ReportPlanProp.FIX_TEMP_COL_PROP_LIST.size()) {
                DynamicObjectCollection currFilterMemberDyColl = this.getModel().getDataEntity(true).getDynamicObjectCollection((String)ReportPlanProp.FIX_TEMP_COL_PROP_LIST.get(i));
                Predicate<ReportCalcVal> currHideColPredicateByFilterCol = reportCalcVal -> false;
                if (CollectionUtils.isEmpty((Collection)currFilterMemberDyColl)) {
                    ++i;
                    hideColPredicateListByFilterCol.add(currHideColPredicateByFilterCol);
                    continue;
                }
                Set currFilterMemberIdSet = currFilterMemberDyColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(currFilterMemberIdSet)) {
                    boolean hasDetailPeriod;
                    TemplateDim currFilterTplDim = (TemplateDim)filterColDimList.get(i);
                    Long currFilterDimId = currFilterTplDim.getDimensionId();
                    int currFilterColDimMaxRow = currColDimValList.stream().filter(item -> Objects.equals(currFilterDimId, item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0);
                    int currFilterColDimMinRow = currColDimValList.stream().filter(item -> Objects.equals(currFilterDimId, item.getDimensionId())).mapToInt(ReportCalcVal::getRow).min().orElse(0);
                    if (currFilterTplDim.getDimType() == DimensionType.PERIOD && (hasDetailPeriod = this.hasDetailPeriodByPageCache(reportDataManager.getSystem()))) {
                        currFilterMemberDyColl.stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> item.getDynamicObject("parent")).filter(Objects::nonNull).map(item -> item.getLong("id")).filter(item -> item > 0L).forEach(currFilterMemberIdSet::add);
                    }
                    currHideColPredicateByFilterCol = reportCalcVal -> currFilterDimId.equals(reportCalcVal.getDimensionId()) && !currFilterMemberIdSet.contains(reportCalcVal.getValue()) && currFilterColDimMinRow <= reportCalcVal.getRow() && currFilterColDimMaxRow >= reportCalcVal.getRow();
                }
                hideColPredicateListByFilterCol.add(currHideColPredicateByFilterCol);
                ++i;
            }
            needHideList = currColDimValList.stream().filter(item -> !item.isReferenceCell()).filter(item -> item.getValue() != null).filter(item -> {
                for (Predicate predicate : hideColPredicateListByFilterCol) {
                    if (!predicate.test(item)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            HashSet<Integer> needHideColSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal2 : needHideList) {
                needHideColSet.add(reportCalcVal2.getCol());
                for (i = 1; i < reportCalcVal2.getColSpan(); ++i) {
                    needHideColSet.add(reportCalcVal2.getCol() + i);
                }
            }
            needHideColList = new ArrayList(needHideColSet);
        }
        if (!CollectionUtils.isEmpty((Collection)firstRowIdList) || !CollectionUtils.isEmpty((Collection)secondRowIdList)) {
            List firstRowDimIdList = firstRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            List secondRowDimIdList = secondRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            needHideList = currRowDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstRowDimIdList) && !firstRowDimIdList.contains(item.getValue()) && ((TemplateDim)rowDimList.get(0)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondRowDimIdList) && !secondRowDimIdList.contains(item.getValue()) && ((TemplateDim)rowDimList.get(1)).getDimensionId().equals(item.getDimensionId()))).collect(Collectors.toList());
            HashSet<Integer> needHidRowSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal2 : needHideList) {
                needHidRowSet.add(reportCalcVal2.getRow());
                for (int i = 1; i < reportCalcVal2.getRowSpan(); ++i) {
                    needHidRowSet.add(reportCalcVal2.getRow() + i);
                }
            }
            needHideRowList = new ArrayList(needHidRowSet);
        }
        this.setRowAndColVisible(needHideRowList, needHideColList);
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    private ReportRuleCheckDTO initRuleCheckDTO(IReportVerifyController verifyController, Boolean commit) {
        FormShowParameter sp = this.getView().getFormShowParameter();
        Long reportId = (Long)sp.getCustomParam("report_id");
        String reportManagerJson = this.getCache().get("reportdatamanager_cache");
        List verifyReports = new ReportRepository().getReportForVerifyRule(Collections.singletonList(reportId));
        List<ReportRuleCheckDTO> ruleChecks = ReportRuleCheckHelper.initRuleCheckDTO(verifyReports, verifyController, reportManagerJson, Boolean.FALSE, commit);
        return EmptyUtil.isEmpty(ruleChecks) ? null : ruleChecks.get(0);
    }

    private void handleDataVerifyNotify(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)operationResult.getMessage())) {
            this.showSuccessMessage(operationResult.getMessage());
            return;
        }
        InteractionContext interactionContext = operationResult.getInteractionContext();
        if (null == interactionContext) {
            return;
        }
        Map customShowParameter = interactionContext.getCustShowParameter();
        if (CollectionUtils.isEmpty((Map)customShowParameter)) {
            return;
        }
        customShowParameter.put("fromCommit", String.valueOf(false));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        this.getView().showForm(parameter);
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    public void refreshFields(Map<String, Object> map) {
        boolean isChange = this.getModel().getDataChanged();
        this.getModel().beginInit();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.getModel().setValue(entry.getKey(), entry.getValue());
            this.getView().updateView(entry.getKey());
        }
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        Long reportId = reportDataManager.getReportId();
        boolean exists = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId).and(new QFilter("zeroreport", "=", (Object)"1"))});
        this.getModel().setValue("zeroreport", (Object)exists);
        this.getView().updateView("zeroreport");
        this.getModel().endInit();
        this.getModel().setDataChanged(isChange);
    }

    public void linkSearchExecRecord(SpreadEvent spreadEvent) {
        List<Map<Long, ReportCalcVal>> selectedColDimList;
        List<Map<Long, ReportCalcVal>> selectedRowDimList;
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        if (!this.checkSelectedDataBeforeLinkSearch(reportTemplate.getTemplateType())) {
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkexecrecord");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("bodysystem", dataEntity.getDynamicObject("bodysys").getPkValue());
        DynamicObject periodDy = dataEntity.getDynamicObject("reportperiod");
        formShowParameter.setCustomParam("reporttype", periodDy.getDynamicObject("reporttype").getPkValue());
        formShowParameter.setCustomParam("org", Collections.singletonList(dataEntity.getDynamicObject("reportorg").getPkValue()));
        formShowParameter.setCustomParam("period", Collections.singletonList(periodDy.getPkValue()));
        formShowParameter.setCustomParam("amountunit", this.getModel().getValue("amtunits"));
        formShowParameter.setCustomParam("pageDimMemberIds", this.getPageDimMemberIds());
        if (reportTemplate.getTemplateType() == TemplateType.FIXED) {
            selectedRowDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
            selectedColDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        } else {
            selectedRowDimList = this.getDetailTempSelectedDim4LinkSearch(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
            selectedColDimList = this.getDetailTempSelectedDim4LinkSearch(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        }
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("report_id");
        formShowParameter.setCustomParam("reportId", (Object)reportId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void linkSearchInOutCollect(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataRequire()) {
            return;
        }
        String templateTypeProp = "templatebak.templatetype";
        String isMainTableProp = "templatebak.ismaintable";
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("report_id");
        DynamicObject reportDy = QueryServiceHelper.queryOne((String)"fpm_report", (String)String.join((CharSequence)",", "id", "initflag", "templatebak.id", templateTypeProp, isMainTableProp), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        String templateType = reportDy.getString(templateTypeProp);
        TemplateType templateTypeEnum = TemplateType.getByNumber((String)templateType);
        boolean isMainTable = reportDy.getBoolean(isMainTableProp);
        boolean initialFlag = reportDy.getBoolean("initflag");
        List<Object> inOutCollectBillPks = new LinkedList();
        if (isMainTable || templateTypeEnum == TemplateType.FIXED) {
            inOutCollectBillPks = this.getSourceIdsBySelectedDimCombination(isMainTable, templateTypeEnum);
        }
        if (!initialFlag || templateTypeEnum == TemplateType.DETAIL) {
            inOutCollectBillPks.addAll(this.getSelectedCellSourceIds());
        }
        if (CollectionUtils.isEmpty(inOutCollectBillPks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean billExistFlag = TmcDataServiceHelper.exists((String)"fpm_inoutcollect", (QFilter[])new QFilter("id", "in", inOutCollectBillPks).toArray());
        if (!billExistFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6536\u652f\u8ba1\u5212\u6c60\u91c7\u96c6\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanList_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setReportCellLabel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_inoutcollect").searchFormNumber("fpm_inoutcollect").listFormId("bos_list").searchIds(new ArrayList<Object>(inOutCollectBillPks)).listForm("fpm_inoutcollect").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_IN_OUT_COLLECT).linkSearch(true).extendFunction(formShowParameter -> {
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap6");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeInOutCollectPanel"));
            StyleCss styleCss = Optional.ofNullable(formShowParameter.getOpenStyle().getInlineStyleCss()).orElseGet(StyleCss::new);
            styleCss.setHeight("98%");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            return null;
        }).build()));
        this.showSplitPane();
    }

    public void linkSearchSubReportRecord(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataRequire()) {
            return;
        }
        String msg = "";
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        List dimensionIdList = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType().isSubjectDim()).map(TemplateDim::getDimensionId).collect(Collectors.toList());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List reportDataList = ReportHelper.getFixReportSelectedDimCombinationData((CacheCellMeta)this.getCellDS().getMeta(), (DynamicObject)dataEntity, (SpreadSelector)this.getSpreadSelector(), Arrays.asList("pagedim1", "pagedim2"));
        List accountSettings = reportTemplate.getAccountSettings();
        Map subjectAccountMap = accountSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity()));
        List selectSubjectRangeAccounts = reportDataList.stream().map(ReportData::getDimValList).flatMap(Collection::stream).map(subjectAccountMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(selectSubjectRangeAccounts)) {
            msg = ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        Set memberIds = TemplateInfoHelper.buildAllBySetting(selectSubjectRangeAccounts);
        Set childTemplateIdSet = TemplateInfoHelper.buildAllChildTemplateIdByAccount((Collection)memberIds, (List)accountSettings);
        if (CollectionUtils.isEmpty((Collection)childTemplateIdSet)) {
            msg = ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        if (NumberUtils.greaterThan((Integer)childTemplateIdSet.size(), (Integer)1)) {
            msg = ResManager.loadKDString((String)"\u6279\u91cf\u8054\u67e5\u7684\u5355\u5143\u683c\u9700\u5173\u8054\u540c\u4e00\u4e2a\u5b50\u8868\uff0c\u4e14\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\uff0c\u8bf7\u786e\u8ba4\u8054\u67e5\u8303\u56f4\u3002", (String)"ReportPlanList_21", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        Long subjectId = (Long)dimensionIdList.get(0);
        Long reportOrgId = dataEntity.getLong("reportorg.id");
        long periodId = dataEntity.getLong(String.join((CharSequence)".", "reportperiod", "id"));
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("templatebak.id", "in", (Object)childTemplateIdSet.toArray()), new QFilter("reportperiod", "=", (Object)periodId), new QFilter("reportorg", "=", (Object)reportOrgId)}, null, (int)20);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            msg = ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray()), new QFilter("maindimentry.id", ">", (Object)0L)});
        if (!exists) {
            msg = ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        this.setReportCellLabel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
        Long templateId = (Long)childTemplateIdSet.iterator().next();
        DynamicObject templateBak = QueryServiceHelper.queryOne((String)"fpm_template_bak", (String)"templatetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (templateBak == null) {
            msg = ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        Map<Long, List<Object>> filterMap = null;
        TemplateType templateType = TemplateType.getByNumber((String)templateBak.getString("templatetype"));
        if (Objects.nonNull(templateType) && templateType.isDetail()) {
            filterMap = this.buildFilterMap(reportDataList, memberIds, subjectId);
        }
        FormShowParameter linkSearchFormShow = LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_reportplan").searchFormNumber("fpm_report").searchIds(ids).linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_SUB_REPORT_RECORD).linkSearch(true).extendFunction(formShowParameter -> {
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap6");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeInOutCollectPanel"));
            StyleCss styleCss = Optional.ofNullable(formShowParameter.getOpenStyle().getInlineStyleCss()).orElseGet(StyleCss::new);
            styleCss.setHeight("98%");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            return null;
        }).build());
        linkSearchFormShow.setCustomParam("transParamFilterInfo", filterMap);
        this.getView().showForm(linkSearchFormShow);
        this.showSplitPane();
    }

    public ReportDataManagerV2 getReportDataManagerV2() {
        return ReportDataManagerFactoryV2.getReportDataManagerV2((IPageCache)this.getPageCache());
    }

    private Map<Long, List<Object>> buildFilterMap(List<ReportData> reportDataList, Set<Long> memberIds, Long subjectId) {
        HashMap<Long, Set> filterInfoMap = new HashMap<Long, Set>(8);
        HashMap<Long, List<Object>> finalFilterMap = new HashMap<Long, List<Object>>(filterInfoMap.size());
        filterInfoMap.put(subjectId, memberIds);
        reportDataList.forEach(item -> {
            List dimList = item.getDimList();
            List dimValList = item.getDimValList();
            int index = 0;
            for (TemplateDim templateDim : dimList) {
                if (subjectId.equals(templateDim.getDimensionId())) {
                    ++index;
                    continue;
                }
                Set objects = filterInfoMap.getOrDefault(templateDim.getDimensionId(), new HashSet(10));
                if (filterInfoMap.containsKey(templateDim.getDimensionId())) {
                    objects.add((Long)dimValList.get(index));
                } else {
                    objects.add((Long)dimValList.get(index));
                    filterInfoMap.put(templateDim.getDimensionId(), objects);
                }
                ++index;
            }
        });
        filterInfoMap.forEach((key, value) -> {
            List cfr_ignored_0 = finalFilterMap.put((Long)key, new ArrayList(value));
        });
        return finalFilterMap;
    }

    private void showImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_import");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"ReportPlanList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"fpm_import");
        formShowParameter.setFormConfig(formConfig);
        formShowParameter.addCustPlugin("kd.tmc.fpm.formplugin.report.ReportImportDataPlugin");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importData"));
        formShowParameter.setCustomParam("tipslabel", (Object)ResManager.loadKDString((String)"\u6ce8\uff1a\u5bfc\u5165\u6570\u636e\u9700\u8981\u57fa\u4e8e\u7cfb\u7edf\u6700\u65b0\u8ba1\u5212\u7f16\u5236\u6a21\u677f\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"ReportPlanList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("reportImportType", (Object)ReportImportTypeEnum.IMPORT_SINGLE.getCode());
        this.getView().showForm(formShowParameter);
    }

    private void handleImportCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnMap;
        Object backData = closedCallBackEvent.getReturnData();
        if (backData != null && (returnMap = (Map)backData).containsKey("reportFileUrl") && returnMap.containsKey("customParams")) {
            JobFormInfo jobFormInfo = ReportImportJobHelper.getJobFormInfo(returnMap, this.getView());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importDataCloseCallBack");
            jobFormInfo.setCloseCallBack(closeCallBack);
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
    }

    private void afterImportCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            Object taskinfoObj = result.get("taskinfo");
            if (EmptyUtil.isEmpty(taskinfoObj)) {
                return;
            }
            String taskInfoStr = (String)taskinfoObj;
            if (EmptyUtil.isEmpty((String)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                boolean success = (Boolean)mapData.get("success");
                if (!success) {
                    String errorMessage = (String)mapData.get("errorMessage");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5bfc\u5165\u6570\u636e\u4efb\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"ReportPlanList_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ReportPlanList_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean checkSelectedDataBeforeLinkSearch(TemplateType templateType) {
        IntPredicate selectedRemarkColPredicate;
        IntPredicate selectedSummaryColPredicate;
        boolean colCover;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartCol = spreadSelector.getStartCol();
        int selectedEndCol = spreadSelector.getEndCol();
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        List colDimAllMemberList = cacheCellMeta.getColDimTree().getRoot().getAllChildren();
        int metricColDimStartIdx = -1;
        int metricColDimEndIdx = -1;
        if (templateType == TemplateType.FIXED) {
            metricColDimStartIdx = colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(ReportCalcVal::isMetric).mapToInt(ReportCalcVal::getStartCol).min().getAsInt();
            metricColDimEndIdx = colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(ReportCalcVal::isMetric).mapToInt(ReportCalcVal::getEndCol).max().getAsInt();
        } else if (templateType == TemplateType.DETAIL) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Long systemId = (Long)dataEntity.getDynamicObject("bodysys").getPkValue();
            QFilter planAmtDimFilter = new QFilter("bodysys", "=", (Object)systemId).and("detaildimtype", "=", (Object)DetailDimType.PLAN_AMOUNT.name()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            DynamicObject[] planAmtDimArr = TmcDataServiceHelper.load((String)"fpm_detailplanfields", (String)"id", (QFilter[])planAmtDimFilter.toArray());
            Long planAmtDimId = Arrays.stream(planAmtDimArr).map(dim -> dim.getLong("id")).findAny().get();
            metricColDimStartIdx = colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> Objects.nonNull(calcVal.getDimensionId())).filter(calcVal -> calcVal.getDimensionId().compareTo(planAmtDimId) == 0).mapToInt(ReportCalcVal::getStartCol).min().getAsInt();
            metricColDimEndIdx = colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> Objects.nonNull(calcVal.getDimensionId())).filter(calcVal -> calcVal.getDimensionId().compareTo(planAmtDimId) == 0).mapToInt(ReportCalcVal::getEndCol).max().getAsInt();
        } else {
            return false;
        }
        String tipSupplier = ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u201c\u975e\u5c0f\u8ba1\u201d\u7684\u8ba1\u5212\u989d\u5ea6\u5355\u5143\u683c\u64cd\u4f5c\u8054\u67e5\u6267\u884c\u8bb0\u5f55", (String)"ReportLinkExecRecordPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        boolean rowCover = selectedStartRow >= cacheCellMeta.getRowOffSet() && selectedEndRow <= cacheCellMeta.getMaxRow();
        boolean bl = colCover = selectedStartCol >= metricColDimStartIdx && selectedEndCol <= metricColDimEndIdx;
        if (!rowCover || !colCover) {
            this.getView().showTipNotification(tipSupplier);
            return false;
        }
        ReportCalcTree rowDimTree = this.getCellDS().getMeta().getRowDimTree();
        List rowDimAllMemberList = Objects.nonNull(rowDimTree) ? rowDimTree.getRoot().getAllChildren() : new ArrayList(0);
        IntPredicate selectedSummaryRowPredicate = ReportHelper.getSummaryRowPredicate(rowDimAllMemberList);
        if (!this.validateSelectedDataCell(tipSupplier, selectedSummaryRowPredicate, (selectedSummaryColPredicate = ReportHelper.getSummaryColPredicate((List)colDimAllMemberList)).or(selectedRemarkColPredicate = ReportHelper.getRemarkColPredicate((List)colDimAllMemberList)))) {
            return false;
        }
        tipSupplier = ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u4e00\u6b21\u6700\u591a\u53ef\u652f\u6301\u9009\u62e910\u4e2a\u5355\u5143\u683c\u6570\u503c\u8fdb\u884c\u8054\u67e5\u6267\u884c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportLinkExecRecordPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        return this.validateSelectedDataCellSize(tipSupplier, 10);
    }

    private List<Long> getSelectedCellSourceIds() {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Long> sourceIdList = new LinkedList<Long>();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                CacheCell cacheCell = this.getCellDS().getCell(i, j);
                if (CollectionUtils.isEmpty((Collection)cacheCell.getSourceIdList())) continue;
                sourceIdList.addAll(cacheCell.getSourceIdList());
            }
        }
        return sourceIdList;
    }

    private void setReportCellLabel() {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        StringBuilder builder = new StringBuilder();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                String pos = ExcelUtils.xy2Pos((int)j, (int)i);
                builder.append(pos);
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.getModel().setValue("reportcell", (Object)builder.toString());
    }

    private boolean checkSelectedDataRequire() {
        IntPredicate selectedRemarkColPredicate;
        List colDimAllMemberList;
        IntPredicate selectedSummaryColPredicate;
        String tipMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u5c0f\u8ba1\u884c/\u5217\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u7684\u8ba1\u5212\u989d\u5ea6\u8fdb\u884c\u8054\u67e5", (String)"ReportPlanList_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (!this.validateSelectedDataInDataBlock(tipMsg)) {
            return false;
        }
        ReportCalcTree rowDimTree = this.getCellDS().getMeta().getRowDimTree();
        List rowDimAllMemberList = Objects.nonNull(rowDimTree) ? rowDimTree.getRoot().getAllChildren() : new ArrayList(0);
        IntPredicate selectedSummaryRowPredicate = ReportHelper.getSummaryRowPredicate(rowDimAllMemberList);
        if (!this.validateSelectedDataCell(tipMsg, selectedSummaryRowPredicate, (selectedSummaryColPredicate = ReportHelper.getSummaryColPredicate((List)(colDimAllMemberList = this.getCellDS().getMeta().getColDimTree().getRoot().getAllChildren()))).or(selectedRemarkColPredicate = ReportHelper.getRemarkColPredicate((List)colDimAllMemberList)))) {
            return false;
        }
        tipMsg = ResManager.loadKDString((String)"\u6279\u91cf\u8054\u67e5\u5355\u5143\u683c\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\uff0c\u8bf7\u786e\u8ba4\u8054\u67e5\u8303\u56f4\u3002", (String)"ReportPlanList_18", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        return this.validateSelectedDataCellSize(tipMsg, 10);
    }

    private boolean validateSelectedDataInDataBlock(String message) {
        boolean colCover;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        boolean rowCover = spreadSelector.getStartRow() >= cacheCellMeta.getRowOffSet() && spreadSelector.getEndRow() <= cacheCellMeta.getMaxRow();
        boolean bl = colCover = spreadSelector.getStartCol() >= cacheCellMeta.getColOffSet() && spreadSelector.getEndCol() <= cacheCellMeta.getMaxCol();
        if (!rowCover || !colCover) {
            this.getView().showTipNotification(message);
            return false;
        }
        return true;
    }

    private boolean validateSelectedDataCell(String msg, IntPredicate rowPredicate, IntPredicate colPredicate) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                if (!rowPredicate.test(i) && !colPredicate.test(j)) continue;
                this.getView().showTipNotification(msg);
                return false;
            }
        }
        return true;
    }

    private boolean validateSelectedDataCellSize(String tipSupplier, int maxSelectedSize) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedCellSize = (spreadSelector.getEndRow() - spreadSelector.getStartRow() + 1) * (spreadSelector.getEndCol() - spreadSelector.getStartCol() + 1);
        if (selectedCellSize > maxSelectedSize) {
            this.getView().showTipNotification(tipSupplier);
            return false;
        }
        return true;
    }

    private List<Map<Long, ReportCalcVal>> getFixTemplateSelectedDim4LinkSearch(CacheCellMeta meta, boolean isRowDim, FormShowParameter formShowParameter) {
        int b2;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        HashMap<Long, Integer> selectedDimIdxMap = new HashMap<Long, Integer>(4);
        HashMap<Long, Boolean> dimIncludeSumMap = new HashMap<Long, Boolean>(4);
        boolean containDetailReportType = false;
        LinkedList queue = new LinkedList();
        int b1 = isRowDim ? spreadSelector.getStartRow() : spreadSelector.getStartCol();
        int n = b2 = isRowDim ? spreadSelector.getEndRow() : spreadSelector.getEndCol();
        if (isRowDim) {
            queue.addAll(meta.getRowDimTree().getRoot().getChildren());
        } else {
            queue.addAll(meta.getColDimTree().getRoot().getChildren());
        }
        while (!queue.isEmpty()) {
            int size = queue.size();
            Map<Object, Object> dimMemberMap = new HashMap(4);
            Boolean includeSum = Boolean.FALSE;
            ReportCalcValTreeNode parentNode = ((ReportCalcValTreeNode)queue.peek()).getParent();
            for (int i = 0; i < size; ++i) {
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = isRowDim ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n2 = a2 = isRowDim ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell()) continue;
                if (!CollectionUtils.isEmpty((Collection)curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (Objects.isNull(curr.getCalcVal().getValue()) && curr.getCalcVal().isSummary()) {
                    includeSum = Boolean.TRUE;
                    continue;
                }
                if (!Objects.nonNull(curr.getCalcVal().getValue())) continue;
                dimMemberMap.putIfAbsent((Long)curr.getCalcVal().getValue(), curr.getCalcVal());
            }
            if (CollectionUtils.isEmpty(dimMemberMap) && includeSum.booleanValue()) {
                dimMemberMap = parentNode.getChildren().stream().filter(node -> !node.getCalcVal().isReferenceCell()).filter(node -> Objects.nonNull(node.getCalcVal().getValue())).collect(Collectors.toMap(key -> (Long)key.getCalcVal().getValue(), val -> val.getCalcVal()));
            }
            if (CollectionUtils.isEmpty(dimMemberMap)) continue;
            Long dimensionId = ((ReportCalcVal)dimMemberMap.values().stream().findAny().get()).getDimensionId();
            if (Objects.nonNull(selectedDimIdxMap.get(dimensionId))) {
                containDetailReportType = true;
            } else {
                selectedDimNodeList.add(dimMemberMap);
                selectedDimIdxMap.forEach((k, v) -> selectedDimIdxMap.put((Long)k, (Integer)selectedDimIdxMap.get(k) + 1));
                selectedDimIdxMap.put(dimensionId, 0);
            }
            dimIncludeSumMap.put(dimensionId, includeSum);
        }
        Map existDimIncludeSumMap = (Map)formShowParameter.getCustomParam("dimIncludeSumMap");
        if (Objects.isNull(existDimIncludeSumMap)) {
            formShowParameter.setCustomParam("dimIncludeSumMap", dimIncludeSumMap);
        } else {
            existDimIncludeSumMap.putAll(dimIncludeSumMap);
            formShowParameter.setCustomParam("dimIncludeSumMap", (Object)existDimIncludeSumMap);
        }
        if (!isRowDim) {
            formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        }
        return selectedDimNodeList;
    }

    private List<Map<Long, ReportCalcVal>> getDetailTempSelectedDim4LinkSearch(CacheCellMeta meta, boolean isRowDim, FormShowParameter formShowParameter) {
        if (!isRowDim) {
            return new LinkedList<Map<Long, ReportCalcVal>>();
        }
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        List colDimAllMemberList = meta.getColDimTree().getRoot().getAllChildren();
        for (ReportCalcValTreeNode calcValTreeNode : colDimAllMemberList) {
            if (Objects.isNull(calcValTreeNode.getCalcVal()) || Objects.isNull(calcValTreeNode.getCalcVal().getDimensionId())) continue;
            HashMap<Long, ReportCalcVal> dimMemberMap = new HashMap<Long, ReportCalcVal>(4);
            for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
                CacheCell cacheCell;
                if (EmptyUtil.isEmpty((Collection)((Collection)meta.getRowNonEmptyValMap().get(i))) || !((cacheCell = this.getCellDS().getCell(i, calcValTreeNode.getCol())).getValue() instanceof Long)) continue;
                Long dimVal = (Long)cacheCell.getValue();
                ReportCalcVal reportCalcVal = new ReportCalcVal();
                reportCalcVal.setDimensionId(calcValTreeNode.getCalcVal().getDimensionId());
                reportCalcVal.setValue((Object)dimVal);
                dimMemberMap.put(dimVal, reportCalcVal);
            }
            selectedDimNodeList.add(dimMemberMap);
        }
        return selectedDimNodeList;
    }

    private List<Long> getSourceIdsBySelectedDimCombination(boolean isMainTable, TemplateType templateTypeEnum) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SourceIdQueryParam queryParam = new SourceIdQueryParam();
        Long systemId = dataEntity.getLong(String.join((CharSequence)".", "bodysys", "id"));
        queryParam.setSystemId(systemId);
        queryParam.setReportOrgId(Long.valueOf(dataEntity.getLong(String.join((CharSequence)".", "reportorg", "id"))));
        queryParam.setReportPeriodId(Long.valueOf(dataEntity.getLong(String.join((CharSequence)".", "reportperiod", "id"))));
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("report_id");
        queryParam.setReportId(reportId);
        queryParam.setMainTable(isMainTable);
        queryParam.setTemplateType(templateTypeEnum);
        List reportDataList = ReportHelper.getFixReportSelectedDimCombinationData((CacheCellMeta)this.getCellDS().getMeta(), (DynamicObject)dataEntity, (SpreadSelector)this.getSpreadSelector(), Arrays.asList("pagedim1", "pagedim2"));
        queryParam.setReportDataList(reportDataList);
        queryParam.setTemplateUseType(TemplateUseType.PLANING);
        IReportDataBizService iReportDataBizService = (IReportDataBizService)FpmServiceFactory.getBizService(IReportDataBizService.class);
        FpmOperateResult operateResult = iReportDataBizService.getSmartGetSourceIds(queryParam);
        if (operateResult.isSuccess()) {
            return (List)operateResult.getData();
        }
        return new ArrayList<Long>(0);
    }

    private void detailReportRowVisible(FundPlanSystem system, ReportTemplate reportTemplate) {
        boolean enableCombine = TemplateInfoHelper.hasEnableCombine((ReportTemplate)reportTemplate);
        List filterDimList = reportTemplate.getColDimList().stream().filter(tplDim -> !tplDim.isViDim()).filter(TemplateDim::isFilterDim).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        HashMap subjectFlowMap = new HashMap(8, 1.0f);
        HashMap prop2MemberIdMap = new HashMap(8, 1.0f);
        HashMap<String, Long> prop2DimIdMap = new HashMap<String, Long>(8, 1.0f);
        HashMap<String, String> prop2DimTypeMap = new HashMap<String, String>(8, 1.0f);
        for (int i = 0; i < filterDimList.size() && i < ReportPlanProp.FILTER_COL_PROP_LIST.size(); ++i) {
            String filterColProp = (String)ReportPlanProp.FILTER_COL_PROP_LIST.get(i);
            DynamicObjectCollection filterColMemberDyColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(filterColProp);
            Set filterColMemberIdSet = filterColMemberDyColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set subjectFlowList = filterColMemberDyColl.stream().map(item -> item.getDynamicObject("fbasedataid")).filter(Objects::nonNull).filter(item -> DimsionEnums.SUBJECT.getNumber().equals(item.getString("dimtype"))).map(item -> item.getString("flow")).filter(Objects::nonNull).map(FlowType::getByNumber).filter(Objects::nonNull).map(FlowType::getVirtualId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(filterColMemberIdSet)) continue;
            prop2MemberIdMap.put(filterColProp, filterColMemberIdSet);
            subjectFlowMap.put(filterColProp, subjectFlowList);
            prop2DimIdMap.put(filterColProp, ((TemplateDim)filterDimList.get(i)).getDimensionId());
            prop2DimTypeMap.put(filterColProp, ((TemplateDim)filterDimList.get(i)).getDimType().getNumber());
        }
        if (MapUtils.isEmpty(prop2MemberIdMap) && MapUtils.isEmpty(prop2DimIdMap)) {
            this.setRowAndColVisible(new ArrayList<Integer>(0), new ArrayList<Integer>(0));
            if (enableCombine) {
                this.setTotalRowsAmount(new HashSet<Integer>(0));
            }
            return;
        }
        boolean hasDetailPeriod = this.hasDetailPeriodByPageCache(system);
        int headRow = reportTemplate.getDataStartRow(hasDetailPeriod);
        int dataStartRow = reportTemplate.getTotalRow() + headRow;
        int dataMaxRow = dataStartRow + reportTemplate.getMaxLineCount() - 1;
        HashSet filterColDimIdSet = new HashSet(prop2DimIdMap.values());
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Map<Long, List<ReportCalcVal>> dimId2ColNodeMap = currColDimValList.stream().filter(item -> filterColDimIdSet.contains(item.getDimensionId())).filter(item -> item.getValue() != null).collect(Collectors.groupingBy(ReportCalcVal::getDimensionId));
        Set expandDimIdSet = reportTemplate.getColDimList().stream().filter(TemplateDim::isExpand).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        HashSet<Integer> needHideRowList = new HashSet<Integer>(10);
        int[] emptyRowArr = new int[dataMaxRow + 1];
        int lastNonEmptyRow = -1;
        for (int row2 = dataStartRow; row2 <= dataMaxRow; ++row2) {
            if (this.isEmptyRowIfDetailReport(row2, currColDimValList)) {
                emptyRowArr[row2] = 1;
                continue;
            }
            lastNonEmptyRow = row2;
            boolean isHideRow = false;
            for (Map.Entry prop2DimIdEntry : prop2DimIdMap.entrySet()) {
                if (isHideRow) break;
                boolean memberAnyMatch = false;
                Long dimId = (Long)prop2DimIdEntry.getValue();
                List<ReportCalcVal> colNodeList = dimId2ColNodeMap.get(dimId);
                Set filterMemberIdSet = (Set)prop2MemberIdMap.get(prop2DimIdEntry.getKey());
                for (ReportCalcVal colNode : colNodeList) {
                    Object cellVal;
                    if (expandDimIdSet.contains(colNode.getDimensionId())) {
                        cellVal = colNode.getValue();
                    } else {
                        int col = colNode.getCol();
                        CacheCell currDimValCell = this.getCellDS().getCell(row2, col);
                        cellVal = Objects.nonNull(currDimValCell) ? currDimValCell.getValue() : null;
                    }
                    if (!(memberAnyMatch = Objects.nonNull(cellVal) && filterMemberIdSet.contains(cellVal))) continue;
                    break;
                }
                isHideRow = !memberAnyMatch;
            }
            if (!isHideRow) continue;
            needHideRowList.add(row2);
        }
        if (lastNonEmptyRow >= 0) {
            IntStream.range(0, lastNonEmptyRow).filter(row -> emptyRowArr[row] == 1).forEach(needHideRowList::add);
        }
        OptionalInt subjectCol4ViewNetFlowRow = this.getSubjectColIfNetFlowTotalRowExist(reportTemplate, system, meta.getColDimTree());
        for (int row3 = headRow; row3 < dataStartRow; ++row3) {
            boolean isHideRow = false;
            for (Map.Entry prop2DimIdEntry : prop2DimIdMap.entrySet()) {
                if (isHideRow) break;
                String dimType = (String)prop2DimTypeMap.get(prop2DimIdEntry.getKey());
                DimsionEnums dimensionType = DimsionEnums.getDimsionByNumber((String)dimType);
                if (DimsionEnums.SUBJECT != dimensionType && DimsionEnums.CURRENCY != dimensionType) continue;
                boolean memberAnyMatch = false;
                Long dimId = (Long)prop2DimIdEntry.getValue();
                List<ReportCalcVal> colNodeList = dimId2ColNodeMap.get(dimId);
                Set flowVirtualIds = (Set)subjectFlowMap.get(prop2DimIdEntry.getKey());
                Set filterMemberIdSet = (Set)prop2MemberIdMap.get(prop2DimIdEntry.getKey());
                for (ReportCalcVal colNode : colNodeList) {
                    Object cellVal;
                    int col = colNode.getCol();
                    if (!CollectionUtils.isEmpty((Collection)flowVirtualIds)) {
                        CacheCell currDimValCell = this.getCellDS().getCell(row3, col + 1);
                        cellVal = Objects.nonNull(currDimValCell) ? currDimValCell.getValue() : null;
                        memberAnyMatch = cellVal != null && flowVirtualIds.contains(Long.valueOf(cellVal.toString()));
                    } else if (!CollectionUtils.isEmpty((Collection)filterMemberIdSet)) {
                        CacheCell currDimValCell;
                        Object cellVal2 = expandDimIdSet.contains(colNode.getDimensionId()) ? colNode.getValue() : (Objects.nonNull(currDimValCell = this.getCellDS().getCell(row3, col)) ? currDimValCell.getValue() : null);
                        boolean bl = memberAnyMatch = cellVal2 != null && filterMemberIdSet.contains(Long.valueOf(cellVal2.toString()));
                    }
                    if (!memberAnyMatch && DimsionEnums.CURRENCY != dimensionType && subjectCol4ViewNetFlowRow.isPresent()) {
                        CacheCell flowColCellInNetFlowRow = this.getCellDS().getCell(row3, subjectCol4ViewNetFlowRow.getAsInt() + 1);
                        cellVal = flowColCellInNetFlowRow != null ? flowColCellInNetFlowRow.getValue() : null;
                        boolean bl = memberAnyMatch = cellVal != null && Objects.equals(FlowType.NETINFLOW.getVirtualId(), Long.valueOf(cellVal.toString()));
                    }
                    if (!memberAnyMatch) continue;
                    break;
                }
                isHideRow = !memberAnyMatch;
            }
            if (!isHideRow) continue;
            needHideRowList.add(row3);
        }
        this.setRowAndColVisible(new ArrayList<Integer>(needHideRowList), new ArrayList<Integer>(0));
        if (enableCombine) {
            this.setTotalRowsAmount(needHideRowList);
        }
    }

    private OptionalInt getSubjectColIfNetFlowTotalRowExist(ReportTemplate reportTemplate, FundPlanSystem system, ReportCalcTree colDimTree) {
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        boolean hasEnableNetInFlowTotalRow = TemplateInfoHelper.hasEnableNetInFlowTotalRow((ReportTemplate)reportTemplate, (Dimension)subjectDim);
        if (!hasEnableNetInFlowTotalRow) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ReportHelper.getSubjectColIfNeedUpdateSubjectFlow((ReportTemplate)reportTemplate, (ReportCalcTree)colDimTree));
    }

    private void setTotalRowsAmount(Set<Integer> needHideRowList) {
        CellDataSource dataSource = this.getCellDS();
        List amountCacheCells = dataSource.getAllCell().stream().filter(item -> !needHideRowList.contains(item.getRow())).filter(item -> !item.isSummary()).filter(item -> item.getCellType() == CellTypeEnum.AMOUNT).collect(Collectors.toList());
        this.getOrCreateReportController().clearTotalRows();
        if (!CollectionUtils.isEmpty(amountCacheCells)) {
            List cells = amountCacheCells.stream().map(item -> item).collect(Collectors.toList());
            this.getOrCreateReportController().updateTotalRows(cells);
        }
    }

    private void setRowAndColVisible(List<Integer> needHideRowList, List<Integer> needHideColList) {
        String hideColsStr = this.getPageCache().get("HIDECOLS");
        String hideRowsStr = this.getPageCache().get("HIDEROWS");
        if (!StringUtils.isEmpty((Object)hideColsStr) || !StringUtils.isEmpty((Object)hideRowsStr)) {
            List colS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideColsStr)) {
                colS = JSONArray.parseArray((String)hideColsStr, Integer.class);
            }
            List rowS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideRowsStr)) {
                rowS = JSONArray.parseArray((String)hideRowsStr, Integer.class);
            }
            RowAndColVisibleCmdChain showSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), rowS, colS, Boolean.valueOf(true));
            showSpreadCommand.execCommand();
        }
        if (!CollectionUtils.isEmpty(needHideRowList) || !CollectionUtils.isEmpty(needHideColList)) {
            RowAndColVisibleCmdChain hideSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), needHideRowList, needHideColList, Boolean.valueOf(false));
            hideSpreadCommand.execCommand();
            this.getPageCache().put("HIDECOLS", JSON.toJSONString(needHideColList));
            this.getPageCache().put("HIDEROWS", JSON.toJSONString(needHideRowList));
        }
    }

    private boolean isEmptyRowIfDetailReport(int row, List<ReportCalcVal> colDimValLeafList) {
        for (ReportCalcVal colNode : colDimValLeafList) {
            int col = colNode.getCol();
            CacheCell currDimValCell = this.getCellDS().getCell(row, col);
            if (!Objects.nonNull(currDimValCell) || !EmptyUtil.isNoEmpty((Object)currDimValCell.getValue())) continue;
            return false;
        }
        return true;
    }

    private List<TemplateDim> loadFilterDimList() {
        ReportDataManagerV2 reportDataManager = this.getReportDataManagerV2();
        if (reportDataManager == null) {
            return new ArrayList<TemplateDim>(0);
        }
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        return reportTemplate.getAllTemplateDim().stream().filter(TemplateDim::isFilterDim).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
    }

    public void hideSplitPane() {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap1");
        if (Objects.nonNull(splitContainer)) {
            splitContainer.setCollapse("splitpanelap3", true);
        }
    }

    public void showSplitPane() {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap1");
        if (Objects.nonNull(splitContainer)) {
            splitContainer.setCollapse("splitpanelap3", false);
        }
    }

    private void initFilterMap() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter)) {
            return;
        }
        Object filterInfo = this.getView().getFormShowParameter().getCustomParams().get("transParamFilterInfo");
        Map filterInfoMap = null;
        String needRequery = this.getPageCache().get("needrequery");
        if (Objects.nonNull(filterInfo) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)needRequery) || Objects.nonNull(filterInfo) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)needRequery) && Boolean.parseBoolean(needRequery)) {
            filterInfoMap = (Map)filterInfo;
        }
        List<TemplateDim> filterDimList = this.loadFilterDimList();
        int colFilterIndex = 1;
        int rowFilterIndex = 1;
        for (TemplateDim templateDim : filterDimList) {
            List memberIds;
            String controlKey = "";
            if (templateDim.getLocation() == DimLocation.COL) {
                controlKey = String.format("filter_col_0%s", colFilterIndex++);
            } else {
                if (templateDim.getLocation() != DimLocation.ROW) continue;
                controlKey = String.format("filter_row_0%s", rowFilterIndex++);
            }
            if (filterInfoMap == null || CollectionUtils.isEmpty((Collection)(memberIds = (List)filterInfoMap.get(templateDim.getDimensionId())))) continue;
            this.getModel().setValue(controlKey, (Object)memberIds.toArray());
        }
    }

    private boolean hasDetailPeriodByPageCache(FundPlanSystem system) {
        Long periodTypeId = this.getModel().getDataEntity(true).getLong("reportperiod.reporttype.id");
        ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(periodTypeId);
        return reportPeriodType.getDetailPeriodType() != null;
    }

    private List<Long> getPeriodFilterMemberListByPageCache(FundPlanSystem system, TemplateDim periodTplDim) {
        Long periodTypeId = this.getModel().getDataEntity(true).getLong("reportperiod.reporttype.id");
        ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(periodTypeId);
        Dimension periodDim = system.getMainDimensionByDimensionId(periodTplDim.getDimensionId());
        Map periodMemberMap = periodDim.getAllDimMemberList(PeriodMember.class).stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        List periodMemberList = periodTplDim.getMemberScope().stream().map(periodMemberMap::get).collect(Collectors.toList());
        PeriodMember periodMember = (PeriodMember)periodMemberList.get(0);
        List<Object> memberList = periodMemberList;
        List<Object> rollPeriodMembers = new ArrayList(0);
        if (!reportPeriodType.isRollIncludeDetailPeriod()) {
            memberList = Collections.singletonList(periodMember);
            rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
        }
        ArrayList<Long> currenPeriodChildList = Objects.isNull(reportPeriodType.getDetailPeriodType()) ? new ArrayList<Long>(Collections.singletonList(periodMember.getId())) : memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
        currenPeriodChildList.addAll(rollPeriodMembers);
        return currenPeriodChildList;
    }

    private void amtColsAutoFix() {
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        if (Objects.isNull(meta)) {
            return;
        }
        HashSet amtCols = new HashSet(16);
        List colDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        colDimValList.stream().filter(reportCalcVal -> reportCalcVal.isMetric()).forEach(reportCalcVal -> IntStream.rangeClosed(reportCalcVal.getStartCol(), reportCalcVal.getEndCol()).forEach(amtCols::add));
        if (!amtCols.isEmpty()) {
            RowAndColAutoFitCmdChain spreadCommand = new RowAndColAutoFitCmdChain(this.getSpreadCommandInvoker(), null, new ArrayList(amtCols), 0, 0);
            spreadCommand.execCommand();
        }
    }
}

