/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.export.excel.impl.ReportPlanSearchAnalyseFormsExportImpl;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.property.ReportPlanSearchAnalyseProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.domain.report.ReportSearchCache;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.lang3.StringUtils;

public class ReportPlanSearchAnalysePlugin
extends AbstractSpreadPlugin
implements SearchListener,
IAnalysisReportManageView {
    private IAnalysisReportManageController controller;
    private CellDataSource cellDS;

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    protected IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    public void initialize() {
        super.initialize();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.addSearchListener((SearchListener)this);
        ReportPlanSearchAnalyseProp.F7_SIGN_LIST.forEach(key -> ((BasedataEdit)this.getControl((String)key)).addBeforeF7SelectListener(this.getBeforeF7SelectListener()));
        ReportPlanSearchAnalyseProp.F7_SIGN_LIST.forEach(key -> ((BasedataEdit)this.getControl((String)key)).addAfterF7SelectListener(this.getAfterF7SelectListener()));
        ReportSearchCache searchCache = this.getReportDataManagerV2();
        if (Objects.isNull(searchCache)) {
            return;
        }
        this.presetCustomDimensionVisible(searchCache.getSystem(), searchCache, false);
    }

    public void afterCreateNewData(EventObject e) {
        String billStatus;
        String planStatus;
        String innerOffsetStatus;
        List metricIds;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter.getParentPageId()) || Objects.isNull(formShowParameter.getCustomParams()) || formShowParameter.getCustomParams().size() < 1) {
            return;
        }
        String parentViewType = (String)formShowParameter.getCustomParam("parenttype");
        this.getModel().setValue("parenttype", (Object)parentViewType);
        this.getModel().setValue("bodysystem", formShowParameter.getCustomParam("bodysystem"));
        this.getModel().setValue("reporttype", formShowParameter.getCustomParam("reporttype"));
        ArrayList periodIds = new ArrayList((Collection)formShowParameter.getCustomParam("period"));
        this.getModel().setValue("period", (Object)periodIds.toArray());
        DynamicObject reportType = this.getModel().getDataEntity().getDynamicObject("reporttype");
        String detailReportType = reportType.getString("orgreporttype");
        boolean containDetail = EmptyUtil.isNoEmpty((String)detailReportType.trim());
        this.getView().setEnable(Boolean.valueOf(containDetail), new String[]{"containdetailreporttype"});
        boolean containDetailType = (Boolean)formShowParameter.getCustomParam("containdetailreporttype");
        this.getModel().setValue("containdetailreporttype", (Object)containDetailType);
        String amountUnit = (String)formShowParameter.getCustomParam("amountunit");
        this.getModel().setValue("amountunit", (Object)amountUnit);
        Optional.ofNullable(formShowParameter.getCustomParam("exratetable")).ifPresent(id -> this.getModel().setValue("exratetable", id));
        Optional.ofNullable(formShowParameter.getCustomParam("exchangeratedate")).ifPresent(exchangeRateDate -> this.getModel().setValue("exchangeratedate", exchangeRateDate));
        this.getModel().setValue("dimtype", (Object)DimsionEnums.ORG.getNumber());
        ReportSearchCache searchCache = this.getReportDataManagerV2();
        if (Objects.isNull(searchCache)) {
            return;
        }
        FundPlanSystem system = searchCache.getSystem();
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        this.handleDimensionByLocation("org", orgDim, searchCache);
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        this.handleDimensionByLocation("subjects", subjectDim, searchCache);
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        this.handleDimensionByLocation("period", periodDim, searchCache);
        Map selectedPageDimList = (Map)formShowParameter.getCustomParam("filterDimMemberIds");
        this.getModel().setValue("reportcurrency", formShowParameter.getCustomParam("reportcurrency"));
        Dimension currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
        List currencyIds = (List)selectedPageDimList.get(currencyDim.getId());
        if (!CollectionUtils.isEmpty((Collection)currencyIds)) {
            this.getModel().setValue("currency", (Object)currencyIds.toArray());
        }
        if (!CollectionUtils.isEmpty((Collection)(metricIds = (List)formShowParameter.getCustomParam("metric")))) {
            this.getModel().setValue("metric", (Object)metricIds.toArray());
        }
        if (StringUtils.isNotEmpty((CharSequence)(innerOffsetStatus = (String)formShowParameter.getCustomParam("internaloffsetstate")))) {
            this.getModel().setValue("internaloffsetstate", (Object)innerOffsetStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)(planStatus = (String)formShowParameter.getCustomParam("planstatus")))) {
            this.getModel().setValue("planstatus", (Object)planStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)(billStatus = (String)formShowParameter.getCustomParam("billstatus")))) {
            this.getModel().setValue("billstatus", (Object)billStatus);
        }
        ArrayList extraMenuItems = new ArrayList(1);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
        ReportTemplate reportTemplate = searchCache.getTemplate();
        DimLocation currencyLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)currencyDim.getId());
        this.getView().setVisible(Boolean.valueOf(currencyLocation != null && currencyLocation.inPage()), new String[]{"Currency"});
        this.initSearchDimType(system);
        this.presetSearchDimTypeVisible(formShowParameter, system, reportTemplate);
        this.presetCustomDimensionVisible(system, searchCache, true);
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    private void presetSearchDimTypeVisible(FormShowParameter formShowParameter, FundPlanSystem system, ReportTemplate reportTemplate) {
        List customDimensions;
        Dimension settleDim;
        Dimension companyDim;
        String analyseType = (String)formShowParameter.getCustomParam("parenttype");
        AnalysisReportType analysisReportType = AnalysisReportType.getByNumber((String)analyseType);
        if (analysisReportType != null && analysisReportType.isSynthesisAnalysis()) {
            companyDim = system.getMainDimensionByDimType(DimensionType.COMPANY);
            if (companyDim != null) {
                DimLocation companyDimLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)companyDim.getId());
                this.getView().setVisible(Boolean.valueOf(!companyDimLocation.inPage()), new String[]{"Company"});
            }
            if ((settleDim = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE)) != null) {
                DimLocation settleDimLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)settleDim.getId());
                this.getView().setVisible(Boolean.valueOf(!settleDimLocation.inPage()), new String[]{"Settlement Method"});
            }
            if (!CollectionUtils.isEmpty((Collection)(customDimensions = system.getCustomDimensionByDimType()))) {
                customDimensions.forEach(i -> {
                    DimLocation dimLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)i.getId());
                    this.getView().setVisible(Boolean.valueOf(dimLocation != null && !dimLocation.inPage()), new String[]{i.getNumber()});
                });
            }
        }
        if (analysisReportType != null && analysisReportType.isExecuteAnalysis()) {
            companyDim = system.getMainDimensionByDimType(DimensionType.COMPANY);
            if (companyDim != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"Company"});
            }
            if ((settleDim = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE)) != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"Settlement Method"});
            }
            if (!CollectionUtils.isEmpty((Collection)(customDimensions = system.getCustomDimensionByDimType()))) {
                customDimensions.forEach(i -> this.getView().setVisible(Boolean.valueOf(true), new String[]{i.getNumber()}));
            }
        }
    }

    private void initSearchDimType(FundPlanSystem system) {
        List dimList = system.getDimList();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dimList.size());
        for (Dimension dimension : dimList) {
            boolean isSearchDimType;
            boolean bl = isSearchDimType = dimension.getDimType().isOrgDim() || dimension.getDimType().isSubjectDim() || dimension.getDimType().isCurrencyDim() || dimension.getDimType().isSettlementType() || dimension.getDimType().isCompany() || dimension.getDimType().isCustomDim();
            if (isSearchDimType) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(dimension.getNumber());
                comboItem.setCaption(new LocaleString(dimension.getName()));
                comboItems.add(comboItem);
            }
            if (!dimension.getDimType().isSettlementType() && !dimension.getDimType().isCompany() && !dimension.getDimType().isCustomDim()) continue;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{dimension.getNumber()});
        }
        ((ComboEdit)this.getControl("dimtype")).setComboItems(comboItems);
    }

    public void handleDimensionByLocation(String column, Dimension dimension, ReportSearchCache searchCache) {
        boolean dimInRow;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map selectedPageDimList = (Map)formShowParameter.getCustomParam("filterDimMemberIds");
        List selectedRowDimList = (List)formShowParameter.getCustomParam("selectedRowDimList");
        List selectedColDimList = (List)formShowParameter.getCustomParam("selectedColDimList");
        Long dimensionId = dimension.getId();
        Map dimMemberMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ReportTemplate reportTemplate = searchCache.getTemplate();
        List pageDimList = reportTemplate.getPageDimList();
        List pageDim = pageDimList.stream().filter(i -> NumberUtils.equals((Long)dimensionId, (Long)i.getDimensionId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pageDim)) {
            boolean optionalDim;
            List dimValList = selectedPageDimList.getOrDefault(dimensionId, new ArrayList(1));
            HashSet dimValSet = new HashSet(dimValList);
            TemplateDim templateDim = (TemplateDim)pageDim.get(0);
            List memberScopeList = templateDim.getMemberScope().stream().map(dimMemberMap::get).collect(Collectors.toList());
            boolean bl = optionalDim = dimension.getDimType().isCustomDim() || dimension.getDimType().isSettlementType() || dimension.getDimType().isCompany();
            if (optionalDim && CollectionUtils.isEmpty(dimValSet)) {
                return;
            }
            if (optionalDim) {
                List filterScope = memberScopeList.stream().filter(i -> CollectionUtils.isEmpty((Collection)dimValSet) || dimValSet.contains(i.getId())).map(DimMember::getId).collect(Collectors.toList());
                this.getModel().setValue(column, (Object)filterScope.toArray());
                return;
            }
            memberScopeList.stream().filter(i -> CollectionUtils.isEmpty((Collection)dimValSet) || dimValSet.contains(i.getId())).min(Comparator.comparing(DimMember::getLevel)).ifPresent(member -> this.getModel().setValue(column, (Object)new Object[]{member.getId()}));
            return;
        }
        List rowDimList = reportTemplate.getRowDimList();
        List rowDim = rowDimList.stream().filter(i -> NumberUtils.equals((Long)dimensionId, (Long)i.getDimensionId())).collect(Collectors.toList());
        boolean bl = dimInRow = !CollectionUtils.isEmpty(rowDim);
        if (dimInRow) {
            Set dimValSet = selectedRowDimList.stream().map(Map::values).flatMap(Collection::stream).map(jsonObject -> (ReportCalcVal)jsonObject.toJavaObject(ReportCalcVal.class)).filter(obj -> dimensionId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toSet());
            this.getModel().setValue(column, (Object)dimValSet.toArray());
            return;
        }
        List colDimList = reportTemplate.getColDimList();
        List colDim = colDimList.stream().filter(i -> NumberUtils.equals((Long)dimensionId, (Long)i.getDimensionId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(colDim)) {
            Set dimValSet = selectedColDimList.stream().map(Map::values).flatMap(Collection::stream).map(jsonObject -> (ReportCalcVal)jsonObject.toJavaObject(ReportCalcVal.class)).filter(obj -> dimensionId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toSet());
            String searchDimType = (String)this.getModel().getValue("dimtype");
            boolean equalSearchDimType = StringUtils.equals((CharSequence)dimension.getNumber(), (CharSequence)searchDimType);
            if (equalSearchDimType) {
                TemplateDim templateDim = (TemplateDim)colDim.get(0);
                List memberScopeList = templateDim.getMemberScope().stream().map(dimMemberMap::get).collect(Collectors.toList());
                List filterScope = memberScopeList.stream().filter(i -> CollectionUtils.isEmpty((Collection)dimValSet) || dimValSet.contains(i.getId())).collect(Collectors.toList());
                Integer minLevel = filterScope.stream().map(DimMember::getLevel).min(Comparator.comparing(i -> i)).orElse(0);
                Map<Integer, List<DimMember>> selectLevelMemberMap = filterScope.stream().sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.groupingBy(DimMember::getLevel));
                List<DimMember> dimMembers = selectLevelMemberMap.get(minLevel);
                this.getModel().setValue(column, (Object)new Object[]{dimMembers.get(0).getId()});
            } else {
                this.getModel().setValue(column, (Object)dimValSet.toArray());
            }
        }
    }

    private void presetCustomDimensionVisible(FundPlanSystem system, ReportSearchCache searchCache, boolean initValue) {
        List customDimensions;
        Dimension settleDim;
        Dimension companyDim = system.getMainDimensionByDimType(DimensionType.COMPANY);
        if (companyDim != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
            if (initValue) {
                this.handleDimensionByLocation("company", companyDim, searchCache);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"company"});
        }
        if ((settleDim = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE)) != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"settlementmethod"});
            if (initValue) {
                this.handleDimensionByLocation("settlementmethod", settleDim, searchCache);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"settlementmethod"});
        }
        if (CollectionUtils.isEmpty((Collection)(customDimensions = system.getCustomDimensionByDimType()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"custommember1", "custommember2", "custommember3"});
        int index = 1;
        for (Dimension dimension : customDimensions) {
            String customName = "custommember" + index;
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(customName);
            basedataEdit.setCaption(new LocaleString(dimension.getName()));
            basedataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", (Object)dimension.getId()).and("dimtype", "=", (Object)dimension.getDimType().getNumber()).and("bodysystem", "=", (Object)system.getId()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
            basedataEdit.addAfterF7SelectListener(item -> {
                String baseDataType = ((Control)item.getSource()).getKey();
                ReportTemplate reportTemplate = searchCache.getTemplate();
                ReportQueryParam reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
                Map<String, Object> filterItemMap = this.getFilterMap(reportQueryParam);
                DimLocation customLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)dimension.getId());
                if (customLocation.inRow()) {
                    DynamicObject targetObj;
                    Object oldValue = filterItemMap.get(baseDataType);
                    if (oldValue instanceof DynamicObjectCollection) {
                        DynamicObjectCollection coll = (DynamicObjectCollection)oldValue;
                        targetObj = (DynamicObject)coll.get(0);
                    } else {
                        targetObj = (DynamicObject)oldValue;
                    }
                    Dimension customDim = system.getMainDimensionByDimensionId(Long.valueOf(targetObj.getLong("dimension.id")));
                    String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(tips, customDim.getName()));
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)baseDataType, (Object)oldValue);
                }
            });
            this.getPageCache().put(customName, dimension.getId().toString());
            if (initValue) {
                this.handleDimensionByLocation(customName, dimension, searchCache);
            }
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            String customName = "custommember" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{customName});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String analyseType = (String)formShowParameter.getCustomParam("parenttype");
        AnalysisReportType analysisReportType = AnalysisReportType.getByNumber((String)analyseType);
        if (analysisReportType != null && analysisReportType.isSynthesisAnalysis()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"distinctcurrency"});
        }
    }

    public void refreshBook(Book book) {
        if (null == book) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(invoker, book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        spreadCommand.execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void refreshAnalysisBook(Book book) {
    }

    public IPageCache getCache() {
        return this.getView().getParentView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate reportTemplate) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object oldValue = changedata.getOldValue();
        Object newValue = changedata.getNewValue();
        switch (propName) {
            case "dimtype": {
                ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
                reportFilter.search();
                break;
            }
            case "metric": {
                this.tipSelectedInvalidMetricIfNeed((DynamicObjectCollection)newValue, oldValue);
                break;
            }
        }
    }

    public void search(SearchEvent searchEvent) {
        AnalysisHeader tAnalysisHeader;
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        boolean success = this.getAnalysisHeader(reportQueryParam, tAnalysisHeader = new AnalysisHeader());
        if (!success) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hideemptyrow", "print"});
            return;
        }
        this.getOrCreateReportController().loadAnalysisReport(AnalysisReportType.LINK_SEARCH_ANALYSE, tAnalysisHeader);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxcol");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxrow");
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElse(""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "hideemptyrow": {
                this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getCellDS().getAllEmptyValRows());
                break;
            }
            case "showemptyrow": {
                this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getCellDS().getAllEmptyValRows());
                break;
            }
            case "exportexcel": {
                AnalysisHeader header = new AnalysisHeader();
                boolean success = this.getAnalysisHeader(null, header);
                if (!success) {
                    return;
                }
                ReportPlanSearchAnalyseFormsExportImpl exportExcel = new ReportPlanSearchAnalyseFormsExportImpl(header, this.getView().getFormShowParameter());
                Tuple exportResult = exportExcel.export();
                if (((Boolean)exportResult.item1).booleanValue()) {
                    this.getView().download((String)exportResult.item2);
                    break;
                }
                this.showErrMessage(Collections.singletonList(exportResult.item2));
                break;
            }
            case "print": {
                this.getSpreadCommandInvoker().print();
                break;
            }
        }
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader header) {
        int queryDataSize;
        Map<String, Object> filterItemMap;
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        if (!this.checkBeforeSearch(filterItemMap = this.getFilterMap(reportQueryParam))) {
            return false;
        }
        DynamicObjectCollection organisations = (DynamicObjectCollection)filterItemMap.get("org");
        int n = queryDataSize = EmptyUtil.isEmpty((DynamicObjectCollection)organisations) ? 1 : organisations.size();
        if (queryDataSize > 10000) {
            // empty if block
        }
        this.warpHeader(filterItemMap, header);
        return true;
    }

    public Map<String, Object> getFilterMap(ReportQueryParam reportQueryParam) {
        if (reportQueryParam == null) {
            return null;
        }
        return reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (a, b) -> a));
    }

    private boolean checkBeforeSearch(Map<String, Object> filterItemMap) {
        DimLocation location;
        Object settleDim;
        DimLocation location2;
        Dimension companyDim;
        Dimension currencyDim;
        DimLocation location3;
        Dimension orgDim;
        DimLocation location4;
        Dimension subjectDim;
        DimLocation location5;
        ReportSearchCache searchCache = this.getReportDataManagerV2();
        if (Objects.isNull(searchCache)) {
            return false;
        }
        FundPlanSystem system = searchCache.getSystem();
        ReportTemplate reportTemplate = searchCache.getTemplate();
        DynamicObjectCollection subjects = (DynamicObjectCollection)filterItemMap.get("subjects");
        if ((subjects == null || subjects.size() < 1) && ((location5 = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)(subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS)).getId())).inPage() || location5.inRow())) {
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), subjectDim.getName());
            this.showErrMessage(Collections.singletonList(tips));
            return false;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)filterItemMap.get("org");
        if ((orgs == null || orgs.size() < 1) && ((location4 = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)(orgDim = system.getMainDimensionByDimType(DimensionType.ORG)).getId())).inPage() || location4.inRow())) {
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), orgDim.getName());
            this.showErrMessage(Collections.singletonList(tips));
            return false;
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)filterItemMap.get("currency");
        if ((currency == null || currency.size() < 1) && (location3 = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)(currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY)).getId())).inRow()) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5e01\u79cd\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(tips));
            return false;
        }
        DynamicObjectCollection company = (DynamicObjectCollection)filterItemMap.get("company");
        if ((company == null || company.size() < 1) && (companyDim = system.getMainDimensionByDimType(DimensionType.COMPANY)) != null && (location2 = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)companyDim.getId())).inRow()) {
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), companyDim.getName());
            this.showErrMessage(Collections.singletonList(tips));
            return false;
        }
        DynamicObjectCollection settle = (DynamicObjectCollection)filterItemMap.get("settlementmethod");
        if ((settle == null || settle.size() < 1) && (settleDim = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE)) != null && (location = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)settleDim.getId())).inRow()) {
            String string = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), settleDim.getName());
            this.showErrMessage(Collections.singletonList(string));
            return false;
        }
        for (Object keySign : ReportPlanSearchAnalyseProp.CUSTOMER_SIGN_LIST) {
            DimLocation location6;
            Dimension customDim;
            String customDimId;
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)filterItemMap.get(keySign);
            if (dynamicObjectCollection != null && dynamicObjectCollection.size() >= 1 || StringUtils.isEmpty((CharSequence)(customDimId = this.getPageCache().get((String)keySign))) || (customDim = system.getMainDimensionByDimensionId(Long.valueOf(Long.parseLong(customDimId)))) == null || !(location6 = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)customDim.getId())).inRow()) continue;
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), customDim.getName());
            this.showErrMessage(Collections.singletonList(tips));
            return false;
        }
        ArrayList errMsg = new ArrayList(10);
        for (Map.Entry entry : ReportPlanSearchAnalyseProp.MUST_INPUT_SIGN_MAP.entrySet()) {
            Object obj = filterItemMap.get(entry.getKey());
            if (obj != null) continue;
            errMsg.add(entry.getValue());
        }
        if (errMsg.size() != 0) {
            String err = String.format(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a", (String)"SynthesisQueryReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errMsg));
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        return true;
    }

    private void warpHeader(Map<String, Object> filterItemMap, AnalysisHeader header) {
        DynamicObject bodySystem = (DynamicObject)filterItemMap.get("bodysystem");
        DynamicObject reportType = (DynamicObject)filterItemMap.get("reporttype");
        DynamicObjectCollection periods = (DynamicObjectCollection)filterItemMap.get("period");
        DynamicObject reportCurrency = (DynamicObject)filterItemMap.get("reportcurrency");
        DynamicObjectCollection organisations = (DynamicObjectCollection)filterItemMap.get("org");
        DynamicObjectCollection companies = (DynamicObjectCollection)filterItemMap.get("company");
        DynamicObjectCollection settlements = (DynamicObjectCollection)filterItemMap.get("settlementmethod");
        DynamicObjectCollection subjects = (DynamicObjectCollection)filterItemMap.get("subjects");
        DynamicObjectCollection currency = (DynamicObjectCollection)filterItemMap.get("currency");
        DynamicObjectCollection metricMember = (DynamicObjectCollection)filterItemMap.get("metric");
        String internalOffsetState = (String)filterItemMap.get("internaloffsetstate");
        boolean isContainDetailReport = (Boolean)filterItemMap.get("containdetailreporttype");
        boolean distinctCurrency = (Boolean)filterItemMap.get("distinctcurrency");
        String amountUnit = (String)this.getModel().getValue("amountunit");
        String searchDimType = (String)this.getModel().getValue("dimtype");
        header.setDimType(searchDimType);
        header.setBodySystemId(Long.valueOf(bodySystem.getLong("id")));
        header.setReportTypeId(Long.valueOf(reportType.getLong("id")));
        List periodIds = periods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        header.setPeriodId(periodIds);
        header.setContainDetailReportType(isContainDetailReport);
        if (Objects.nonNull(organisations)) {
            List orgIds = organisations.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrg(orgIds);
        }
        if (Objects.nonNull(subjects)) {
            List subjectsIds = subjects.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSubjects(subjectsIds);
        }
        if (Objects.nonNull(currency)) {
            List currencyIds = currency.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCurrency(currencyIds);
        }
        if (Objects.nonNull(companies)) {
            List companyIds = companies.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCompany(companyIds);
        }
        if (Objects.nonNull(settlements)) {
            List settlementIds = settlements.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSettlementMethod(settlementIds);
        }
        header.setCustomDimension(this.handleCustomHeader(filterItemMap));
        if (Objects.nonNull(reportCurrency)) {
            header.setReportCurrency(Long.valueOf(reportCurrency.getLong("id")));
        }
        List metricIds = metricMember.stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        header.setMetricIds(metricIds);
        header.setDisplaycurrency(distinctCurrency);
        header.setAmountUnit(AmountUnit.getByNumber((String)amountUnit));
        header.setCustomDimension(this.handleCustomHeader(filterItemMap));
        header.setInternalOffsetState(internalOffsetState);
        String planStatus = (String)filterItemMap.get("planstatus");
        String billStatus = (String)filterItemMap.get("billstatus");
        header.setBillStateList(Arrays.stream(billStatus.split(",")).filter(StringUtils::isNotEmpty).map(c -> (BillState)ITypeEnum.getByNumber((String)c, BillState.class)).collect(Collectors.toList()));
        header.setReportStatusList(Arrays.stream(planStatus.split(",")).filter(StringUtils::isNotEmpty).map(ReportStatus::getByVal).collect(Collectors.toList()));
        ReportSearchCache searchCache = this.getReportDataManagerV2();
        if (Objects.isNull(searchCache)) {
            return;
        }
        header.setParentViewTemplate(searchCache.getTemplate());
        String parentViewType = (String)this.getModel().getValue("parenttype");
        header.setParentAnalyseReportType(AnalysisReportType.getByNumber((String)parentViewType));
    }

    private List<Long> getSumPlanOrgAllMember(Long systemId, Long sumPlanOrgId) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and("id", "<>", (Object)sumPlanOrgId).and("parent", ">", (Object)0L);
        DynamicObjectCollection orgDyColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,parent.id", (QFilter[])qFilter.toArray());
        HashMap<Long, List> parent2SubOrgMap = new HashMap<Long, List>(8, 1.0f);
        for (DynamicObject orgDy : orgDyColl) {
            Long parentOrgId = orgDy.getLong("parent.id");
            Long orgId = orgDy.getLong("id");
            List subOrgList = parent2SubOrgMap.computeIfAbsent(parentOrgId, val -> new LinkedList());
            subOrgList.add(orgId);
        }
        ArrayList<Long> validOrgIds = new ArrayList<Long>(10);
        validOrgIds.add(sumPlanOrgId);
        ArrayDeque<Long> stack = new ArrayDeque<Long>();
        stack.addLast(sumPlanOrgId);
        while (!stack.isEmpty()) {
            Long curParentOrgId = (Long)stack.pollLast();
            if (!parent2SubOrgMap.containsKey(curParentOrgId)) continue;
            List curSubOrgIdList = (List)parent2SubOrgMap.get(curParentOrgId);
            validOrgIds.addAll(curSubOrgIdList);
            stack.addAll(curSubOrgIdList);
        }
        return validOrgIds;
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    private HashMap<String, List<Long>> handleCustomHeader(Map<String, Object> filterItemMap) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(ReportPlanSearchAnalyseProp.CUSTOMER_SIGN_LIST.size());
        for (String keySign : ReportPlanSearchAnalyseProp.CUSTOMER_SIGN_LIST) {
            DynamicObjectCollection custom = (DynamicObjectCollection)filterItemMap.get(keySign);
            if (CollectionUtils.isEmpty((Collection)custom)) continue;
            DynamicObject dimension = (DynamicObject)((DynamicObject)custom.get(0)).get("dimension");
            List memberIds = custom.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            result.put(dimension.getString("number"), memberIds);
        }
        return result;
    }

    public BeforeF7SelectListener getBeforeF7SelectListener() {
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
                String baseDataType = basedataEdit.getKey();
                ReportSearchCache searchCache = ReportPlanSearchAnalysePlugin.this.getReportDataManagerV2();
                if (Objects.isNull(searchCache)) {
                    return 1.qFilterResultBuilder().build();
                }
                FundPlanSystem system = searchCache.getSystem();
                ReportTemplate reportTemplate = searchCache.getTemplate();
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                switch (baseDataType) {
                    case "metric": {
                        showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"TemplateManageBasePlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                        List metricIds = (List)ReportPlanSearchAnalysePlugin.this.getView().getFormShowParameter().getCustomParam("metric");
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber()).and("id", "in", (Object)metricIds)).build();
                    }
                    case "org": {
                        return this.handleDimFilter(baseDataType, system, reportTemplate);
                    }
                    case "subjects": {
                        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("dimension.id", "=", (Object)subjectDim.getId()))).build();
                    }
                    case "currency": {
                        Dimension currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("dimension.id", "=", (Object)currencyDim.getId()))).build();
                    }
                    case "company": {
                        Dimension company = system.getMainDimensionByDimType(DimensionType.COMPANY);
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("dimension.id", "=", (Object)company.getId()))).build();
                    }
                    case "settlementmethod": {
                        Dimension settleDim = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE);
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("dimension.id", "=", (Object)settleDim.getId()))).build();
                    }
                    case "reportcurrency": {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId())).build();
                    }
                }
                return 1.qFilterResultBuilder().build();
            }

            private TmcBaseBeforeF7SelectListener.QFilterResult handleDimFilter(String baseDataType, FundPlanSystem system, ReportTemplate reportTemplate) {
                String dimType = (String)ReportPlanSearchAnalysePlugin.this.getModel().getValue("dimtype");
                boolean isSearchType = StringUtils.equals((CharSequence)baseDataType, (CharSequence)dimType);
                DimensionType dimensionType = DimensionType.getDimsionByNumber((String)baseDataType);
                if (Objects.isNull(dimensionType)) {
                    return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId())).build();
                }
                Dimension dimension = system.getMainDimensionByDimType(dimensionType);
                DimLocation location = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)dimension.getId());
                if (dimensionType.isOrgDim()) {
                    List searchIds = (List)ReportPlanSearchAnalysePlugin.this.getView().getFormShowParameter().getCustomParam("org");
                    if (location.inRow() || location.inPage()) {
                        ArrayList orgIds = new ArrayList(16);
                        searchIds.forEach(i -> {
                            List sumPlanOrgAllMember = ReportPlanSearchAnalysePlugin.this.getSumPlanOrgAllMember(system.getId(), i);
                            if (!CollectionUtils.isEmpty((Collection)sumPlanOrgAllMember)) {
                                orgIds.addAll(sumPlanOrgAllMember);
                            }
                        });
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("id", "in", orgIds))).build();
                    }
                    if (location.inCol() && isSearchType) {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId()).and(new QFilter("id", "in", (Object)searchIds))).build();
                    }
                }
                return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)system.getId())).build();
            }
        };
    }

    private AfterF7SelectListener getAfterF7SelectListener() {
        return new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                int selectRows = afterF7SelectEvent.getListSelectedRowCollection().size();
                if (selectRows <= 1) {
                    return;
                }
                ReportQueryParam reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(ReportPlanSearchAnalysePlugin.this.getView().getPageId());
                Map<String, Object> filterItemMap = ReportPlanSearchAnalysePlugin.this.getFilterMap(reportQueryParam);
                ReportSearchCache searchCache = ReportPlanSearchAnalysePlugin.this.getReportDataManagerV2();
                if (Objects.isNull(searchCache)) {
                    return;
                }
                FundPlanSystem system = searchCache.getSystem();
                ReportTemplate reportTemplate = searchCache.getTemplate();
                String baseDataType = ((Control)afterF7SelectEvent.getSource()).getKey();
                DimensionType dimensionType = DimensionType.getDimsionByNumber((String)baseDataType);
                switch (baseDataType) {
                    case "org": 
                    case "subjects": {
                        Dimension dimension = system.getMainDimensionByDimType(dimensionType);
                        DimLocation location = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)dimension.getId());
                        if (!location.inPage() && !location.inRow()) break;
                        String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                        ReportPlanSearchAnalysePlugin.this.getView().showTipNotification(String.format(tips, dimension.getName()));
                        Object oldValue = filterItemMap.get(baseDataType);
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)ReportPlanSearchAnalysePlugin.this.getModel(), (String)baseDataType, (Object)oldValue);
                        break;
                    }
                    case "currency": {
                        Dimension currency = system.getMainDimensionByDimType(dimensionType);
                        DimLocation currencyLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)currency.getId());
                        if (!currencyLocation.inRow()) break;
                        String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5e01\u79cd\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                        ReportPlanSearchAnalysePlugin.this.getView().showTipNotification(tips);
                        Object oldValue = filterItemMap.get(baseDataType);
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)ReportPlanSearchAnalysePlugin.this.getModel(), (String)baseDataType, (Object)oldValue);
                        break;
                    }
                    case "company": {
                        DynamicObject targetObj;
                        Dimension company = system.getMainDimensionByDimType(DimensionType.COMPANY);
                        DimLocation companyLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)company.getId());
                        if (!companyLocation.inRow()) break;
                        Object oldValue = filterItemMap.get(baseDataType);
                        if (oldValue instanceof DynamicObjectCollection) {
                            DynamicObjectCollection coll = (DynamicObjectCollection)oldValue;
                            targetObj = (DynamicObject)coll.get(0);
                        } else {
                            targetObj = (DynamicObject)oldValue;
                        }
                        Dimension customDim = system.getMainDimensionByDimensionId(Long.valueOf(targetObj.getLong("dimension.id")));
                        String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                        ReportPlanSearchAnalysePlugin.this.getView().showTipNotification(String.format(tips, customDim.getName()));
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)ReportPlanSearchAnalysePlugin.this.getModel(), (String)baseDataType, (Object)oldValue);
                        break;
                    }
                    case "settlementmethod": {
                        DynamicObject targetObj;
                        Dimension settleType = system.getMainDimensionByDimType(DimensionType.SETTLEMENT_TYPE);
                        DimLocation settleTypeLocation = TemplateInfoHelper.getLocationByTemplate((ReportTemplate)reportTemplate, (Long)settleType.getId());
                        if (!settleTypeLocation.inRow()) break;
                        Object oldValue = filterItemMap.get(baseDataType);
                        if (oldValue instanceof DynamicObjectCollection) {
                            DynamicObjectCollection coll = (DynamicObjectCollection)oldValue;
                            targetObj = (DynamicObject)coll.get(0);
                        } else {
                            targetObj = (DynamicObject)oldValue;
                        }
                        Dimension customDim = system.getMainDimensionByDimensionId(Long.valueOf(targetObj.getLong("dimension.id")));
                        String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a%1$s\u6210\u5458\u8fdb\u884c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportPlanSearchAnalysePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                        ReportPlanSearchAnalysePlugin.this.getView().showTipNotification(String.format(tips, customDim.getName()));
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)ReportPlanSearchAnalysePlugin.this.getModel(), (String)baseDataType, (Object)oldValue);
                        break;
                    }
                }
            }
        };
    }

    private ReportSearchCache getReportDataManagerV2() {
        ReportSearchCache currentCacheModel;
        String parentViewType = "";
        try {
            parentViewType = (String)this.getModel().getValue("parenttype");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((CharSequence)parentViewType)) {
            parentViewType = (String)this.getView().getFormShowParameter().getCustomParam("parenttype");
        }
        String jsonKey = String.format("%s_analysereportdatamanager_cache", parentViewType);
        String currentCacheKey = this.getView().getPageId() + jsonKey;
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            String currentCache = this.getPageCache().get(currentCacheKey);
            if (StringUtils.isNotEmpty((CharSequence)currentCache)) {
                return (ReportSearchCache)FpmSerializeUtil.deserialize((String)currentCache, ReportSearchCache.class);
            }
            return null;
        }
        String parentManagerJson = parentView.getPageCache().get(jsonKey);
        if (StringUtils.isEmpty((CharSequence)parentManagerJson)) {
            String currentCache = this.getPageCache().get(currentCacheKey);
            if (StringUtils.isNotEmpty((CharSequence)currentCache)) {
                return (ReportSearchCache)FpmSerializeUtil.deserialize((String)currentCache, ReportSearchCache.class);
            }
            return null;
        }
        ReportDataManagerV2 parentManager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)parentManagerJson, ReportDataManagerV2.class);
        String currentCache = this.getPageCache().get(currentCacheKey);
        if (StringUtils.isEmpty((CharSequence)currentCache)) {
            currentCacheModel = new ReportSearchCache();
            currentCacheModel.setPageId(this.getView().getPageId());
            currentCacheModel.setSystem(parentManager.getSystem());
            currentCacheModel.setTemplate(parentManager.getReportTemplate());
            String serializeCache = FpmSerializeUtil.serialize((Object)currentCacheModel);
            this.getPageCache().put(currentCacheKey, serializeCache);
        } else {
            currentCacheModel = (ReportSearchCache)FpmSerializeUtil.deserialize((String)currentCache, ReportSearchCache.class);
        }
        return currentCacheModel;
    }

    private void tipSelectedInvalidMetricIfNeed(DynamicObjectCollection selectedMetricMemberDyColl, Object oldValue) {
        List metricMemberIds = selectedMetricMemberDyColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        boolean nonExistBaseMetricTypeIfAnalyseMetricNeed = TemplateInfoHelper.nonExistBaseMetricTypeIfAnalyseMetricNeed(metricMemberIds);
        if (nonExistBaseMetricTypeIfAnalyseMetricNeed) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807\u4e2d\u82e5\u542b\u8ba1\u7b97\u7c7b\u7684\u6307\u6807\u6210\u5458\uff0c\u9700\u8981\u5c06\u5bf9\u5e94\u7684\u8ba1\u7b97\u56e0\u5b50\u57fa\u7840\u5ea6\u91cf\u4e5f\u9009\u62e9\u4e0a\u3002", (String)"SynthesisQueryReportPlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"metric", (Object)oldValue);
        }
    }
}

