/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.CheckSubLimitType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.SourceIdQueryParam;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.sumplan.EvaluateAmtParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecordCount;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.ISumPlanManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.controller.impl.SumPlanManageController;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.IReportDataBizService;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.mvc.view.ISumPlanManageView;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColVisibleCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.command.generator.UpdateCellInfoGenerator;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.export.excel.impl.SumPlanFormsExportImpl;
import kd.tmc.fpm.business.spread.update.CellValueUpdateFactory;
import kd.tmc.fpm.business.spread.update.bean.CellUpdateResult;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.SumPlanLoadType;
import kd.tmc.fpm.common.enums.SummaryConfigCheckSubLimitEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.utils.report.ReportPlanSumShowUtil;
import kd.tmc.fpm.utils.report.ReportPlanSumUtil;
import kd.tmc.fpm.utils.report.SheetUtils;

public class ReportPlanSumPlugin
extends AbstractSpreadPlugin
implements ISumPlanManageView,
IReportVerifyView,
IAnalysisReportManageView {
    private static final Log logger = LogFactory.getLog(ReportPlanSumPlugin.class);
    private ISumPlanManageController sumPlanManageController;
    private static final String INIT_REPORT_FIRST = "INIT_REPORT_FIRST";
    private static final String OLD_REPORT_ID = "OLD_REPORT_ID";
    private static final String OLD_REPORT_TEMPLATE_ID = "OLD_REPORT_TEMPLATE_ID";
    private ReportPlanSumShowUtil reportPlanSumShowUtil = new ReportPlanSumShowUtil();
    private final ITemplateRepository templateRepository = new TemplateRepository();
    private IAnalysisReportManageController analysisReportManageController;
    private IReportVerifyController verifyController;
    private static final String OFFSETRECORD = "offsetrecord";
    private static final String RECORDS = "records";
    private static final String FROM_REFRESH = "FROM_REFRESH";
    private boolean loadSumReportSuccess = false;
    private CellDataSource cellDS;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refreshreport", "refreshimg", "openfilter", "noreportplanbillcnt", "noreportllsumbillcnt", "reportplanbillcnt", "reportllsumbillcnt"});
        this.addItemClickListeners(new String[]{"bar_submit"});
        this.addCardEntryListener();
        this.initPageDimF7();
        this.filterControlInit();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            Object id = this.getModel().getDataEntity().getPkValue();
            Object[] pkId = new Object[]{id};
            switch (operateKey) {
                case "savesumplan": {
                    this.switchParamLoadChangeReport(SumPlanLoadType.REFRESH, true);
                    break;
                }
                case "upsearch": {
                    this.reportPlanSumShowUtil.showReport(this.getView(), pkId);
                    break;
                }
                case "interioroffset": {
                    Long sumId = Optional.ofNullable(this.getModel().getDataEntity().getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
                    this.getOrCreateReportController().interiorOffset(sumId);
                    break;
                }
                case "offsetrecord": {
                    this.reportPlanSumShowUtil.showRecord(this.getView(), pkId);
                    break;
                }
                case "records": {
                    this.reportPlanSumShowUtil.showRecords(this.getView(), pkId);
                }
                case "unaudit": 
                case "audit": 
                case "unsubmit": {
                    this.refreshSpreadJsButton();
                    break;
                }
                case "submitsumplan": {
                    this.submitSumPlan();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
                case "dataverify": {
                    this.handleDataVerifyNotify(afterDoOperationEventArgs);
                    break;
                }
                case "showemptyrow": {
                    this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getEmptyValRows());
                    break;
                }
                case "hideemptyrow": {
                    this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getEmptyValRows());
                }
            }
        }
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
    }

    private void saveIfNeed() {
        String status = (String)this.getModel().getValue("billstatus");
        if (!Objects.equals(status, BillStatus.STAGE.getNumber())) {
            return;
        }
        try (TXHandle ignored = TX.required();){
            this.saveRemark();
            if (this.needSave()) {
                this.getOrCreateReportController().save();
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportPlanSumPlugin_30", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void saveRemark() {
        String remark = StringHelper.getStringValue((Object)this.getModel().getValue("remark"));
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        new DataSaveServiceImpl().updateAndCheckResult(() -> "update t_fpm_reportplansum set fremark=? where fid=?", Collections.singletonList(pkValue), (a, b) -> {
            b.add(remark);
            b.add(a);
        });
    }

    private boolean needSave() {
        IReportDataManagerV2 managerFromCache = this.getOrCreateReportController().getManagerFromCache();
        Long reportId = this.getModel().getDataEntity(true).getLong("originalreportids");
        if (!Objects.equals(managerFromCache.getReportId(), reportId)) {
            return false;
        }
        ReportTemplate reportTemplate = managerFromCache.getReportTemplate();
        DynamicObject reportTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
        Object reportTypeId = reportTypeDy.getPkValue();
        Optional<TemplateReportType> first = reportTemplate.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportTypeId(), reportTypeId)).findFirst();
        if (!first.isPresent()) {
            return false;
        }
        TemplateReportType templateReportType = first.get();
        List auxiliaryFieldList = templateReportType.getAuxiliaryFieldList();
        Optional<AuxiliaryField> any = auxiliaryFieldList.stream().filter(a -> a.getUseType() == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS).findAny();
        return any.isPresent() || EmptyUtil.isNoEmpty((Object)reportTemplate.getRemarkFieldList());
    }

    private void refreshSpreadJsButton() {
        Optional<Long> reportId = Arrays.stream((Object[])Optional.ofNullable(this.getModel().getDataEntity().getString("originalreportids")).map(ids -> ids.split(",")).get()).map(Long::valueOf).findFirst();
        if (reportId.isPresent()) {
            String selectFields = String.join((CharSequence)",", "templatebak", "name", "id", "planstatus");
            DynamicObject report = TmcDataServiceHelper.loadSingle((Object)reportId.get(), (String)"fpm_report", (String)selectFields);
            this.initSpreadJSComponent(report);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSumPlanParamInfo();
        boolean innerstatus = this.getModel().getDataEntity().getBoolean("offsetornot");
        String innerStatusStr = innerstatus ? "2" : "1";
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"innerstatus", (Object)innerStatusStr);
        this.selectReport();
        if (!this.loadSumReportSuccess) {
            return;
        }
        this.initAnalysisReportCard();
        String sign = this.getCache().get("org_field_name");
        if (EmptyUtil.isNoEmpty((String)sign)) {
            DynamicObject reportOrg = (DynamicObject)this.getModel().getValue("reportorg");
            this.getView().getModel().setValue(sign, (Object)reportOrg.getLong("id"));
        }
        this.getView().getPageCache().put("innerStatusChange", "false");
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
    }

    private void selectReport() {
        Long sumPlanId = Optional.ofNullable(this.getModel().getDataEntity().getPkValue()).map(o -> Long.valueOf(o.toString())).orElse(0L);
        SumPlanLoadType sumPlanLoadType = SumPlanLoadType.LOAD;
        if (Objects.equals(FROM_REFRESH, this.getCache().get(FROM_REFRESH))) {
            sumPlanLoadType = SumPlanLoadType.REFRESH;
            this.getCache().remove(FROM_REFRESH);
        }
        this.getOrCreateReportController().load(sumPlanId, this.getSystemId(), sumPlanLoadType);
        if (!this.loadSumReportSuccess) {
            return;
        }
        this.showOrNotApprovalAmtColBySummaryConfig();
        this.rowAndColVisible(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        IReportVerifyController verifyController = this.getReportVerifyController();
        block7 : switch (key) {
            case "submitsumplan": {
                List<ReportRuleCheckDTO> dataVerifySubmitRuleFilter = this.initRuleCheckDTO(verifyController, Boolean.TRUE);
                if (CollectionUtils.isEmpty(dataVerifySubmitRuleFilter)) break;
                for (ReportRuleCheckDTO checkDTO : dataVerifySubmitRuleFilter) {
                    verifyController.ruleCheck(checkDTO, args);
                    if (!args.isCancel()) continue;
                    break block7;
                }
                break;
            }
            case "dataverify": {
                args.setCancel(true);
                List<ReportRuleCheckDTO> dataVerifyRuleFilter = this.initRuleCheckDTO(verifyController, Boolean.FALSE);
                if (CollectionUtils.isEmpty(dataVerifyRuleFilter)) break;
                if (this.checkRequire()) {
                    this.getView().invokeOperation("savesumplan");
                }
                for (ReportRuleCheckDTO checkDTO : dataVerifyRuleFilter) {
                    verifyController.ruleCheck(checkDTO, args);
                }
                break;
            }
            case "refresh": {
                this.getCache().put(FROM_REFRESH, FROM_REFRESH);
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                if (!Objects.equals(this.getPageCache().get(key), key)) {
                    this.getPageCache().put(key, key);
                    args.setCancel(true);
                    this.getView().invokeOperation(key);
                    this.getView().invokeOperation("refresh");
                }
                this.getPageCache().remove(key);
                break;
            }
        }
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "refreshreport": 
            case "refreshimg": {
                this.refreshReport();
                break;
            }
            case "openfilter": {
                this.openFilter();
                break;
            }
            case "noreportplanbillcnt": {
                this.openReportPlanCardLink("noreportplanbillids");
                break;
            }
            case "noreportllsumbillcnt": {
                this.openReportPlanSumCardLink("noreportllsumbillids");
                break;
            }
            case "reportplanbillcnt": {
                this.openReportPlanCardLink("reportplanbillids");
                break;
            }
            case "reportllsumbillcnt": {
                this.openReportPlanSumCardLink("reportllsumbillids");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (changeKey) {
            case "custompagemember1": 
            case "custompagemember2": 
            case "custompagemember3": 
            case "innerstatus": {
                Object oldValue;
                this.switchReportIfTemplateIdEmpty();
                if (changeKey.equals("innerstatus") && !Objects.equals(newValue, oldValue = changeData[0].getOldValue())) {
                    this.getView().getPageCache().put("innerStatusChange", "true");
                }
            }
            case "detailperiod": 
            case "amountunit": 
            case "cardreportname": 
            case "cardreportnumber": 
            case "cardreportid": {
                this.getModel().setDataChanged(false);
                break;
            }
            case "offsetornot": {
                int count = this.getModel().getEntryRowCount("card_entryentity");
                for (int i = 0; i < count; ++i) {
                    this.getModel().setValue("cardreportinnerstatus", (Object)((Boolean)newValue != false ? "1" : "0"), i);
                }
                break;
            }
            case "showlimit": {
                this.getView().getPageCache().put("showLimitChange", String.valueOf(this.getModel().getValue("showlimit")));
            }
        }
    }

    public void refreshPageDim(List<ReportCalcVal> reportCalcVals, boolean isChange, ReportTemplate reportTemplate) {
        Map<String, TemplateDim> mapper = this.getPropToTemplateDimMap(reportTemplate);
        this.getView().setVisible(Boolean.FALSE, new String[]{"custompagemember1", "custompagemember2", "custompagemember3"});
        block0: for (ReportCalcVal reportCalcVal : reportCalcVals) {
            Long dimensionId = reportCalcVal.getDimensionId();
            Long memberId = Long.valueOf(reportCalcVal.getValue().toString());
            Set<Map.Entry<String, TemplateDim>> entrySet = mapper.entrySet();
            for (Map.Entry<String, TemplateDim> entry : entrySet) {
                String sign = entry.getKey();
                TemplateDim templateDim = entry.getValue();
                List memberScope = templateDim.getMemberScope();
                if (!memberScope.contains(memberId)) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{sign});
                BasedataEdit control = (BasedataEdit)this.getControl(sign);
                control.setCaption(new LocaleString(templateDim.getDimensionName()));
                if (templateDim.getDimType() == DimensionType.ORG && Objects.equals(dimensionId, templateDim.getDimensionId())) {
                    this.getCache().put("org_field_name", sign);
                }
                if (isChange) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)sign, (Object)memberId);
                } else {
                    this.getView().getModel().setValue(sign, (Object)memberId);
                }
                this.getModel().setDataChanged(false);
                continue block0;
            }
        }
        this.getView().getPageCache().put("page_dim_mapping_cache", FpmSerializeUtil.serialize(mapper));
        this.getView().getPageCache().put("system_id_cache", reportTemplate.getSystemId().toString());
    }

    public SumPlanHeader getReferIndex(boolean needApprovedAmt) {
        SumPlanHeader sumPlanHeader = new SumPlanHeader();
        String innerStatus = (String)this.getModel().getValue("innerstatus");
        if (EmptyUtil.isNoEmpty((String)innerStatus)) {
            sumPlanHeader.setDataStatus(Integer.parseInt(innerStatus));
        }
        if (needApprovedAmt) {
            sumPlanHeader.setShowApprovedAmt((Boolean)this.getModel().getValue("showlimit"));
        }
        List<Long> pageDimMemberIds = this.getPageDimMemberIds();
        sumPlanHeader.setPageDimMemberIds(pageDimMemberIds);
        return sumPlanHeader;
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate reportTemplate) {
        if (EmptyUtil.isEmpty((Object)reportTemplate)) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6ca1\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u52a0\u8f7d\u9884\u89c8\u3002", (String)"ReportPlanSumPlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        this.initFilterVisibleFalse();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8"});
        Label label = (Label)this.getView().getControl("openfilter");
        String close = ResManager.loadKDString((String)"\u6536\u8d77\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        label.setText(close);
        this.getView().getPageCache().put("open_filter", close);
        Long systemId = reportTemplate.getSystemId();
        List filterDimList = reportTemplate.getAllTemplateDim().stream().filter(TemplateDim::isFilterDim).filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        HashMap<String, TemplateDim> mapperInfo = new HashMap<String, TemplateDim>(16);
        List<String> list = Arrays.asList("filter_row_01", "filter_row_02", "filter_col_01", "filter_col_02", "filter_col_03", "filter_01", "filter_02");
        Integer index = 0;
        for (TemplateDim templateDim : filterDimList) {
            String controlKey = list.get(index);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            mapperInfo.put(controlKey, templateDim);
            this.getView().setVisible(Boolean.TRUE, new String[]{controlKey});
            BasedataEdit filterDim = (BasedataEdit)this.getControl(controlKey);
            filterDim.setCaption(new LocaleString(templateDim.getDimensionName() + "\uff1a"));
            filterDim.addBeforeF7SelectListener(this.getFilterBeforeF7SelectListener(systemId, templateDim));
        }
        this.getPageCache().put("filter", FpmSerializeUtil.serialize(mapperInfo));
    }

    public void approvedAmount(Set<String> reportIds, String cells) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_fixamtevaluate");
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u6838\u5b9a\u4e0b\u7ea7", (String)"ReportPlanSumPlugin_40", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).append('(').append(((DynamicObject)this.getModel().getValue("reportorg")).getString("name")).append('-').append(((DynamicObject)this.getModel().getValue("reportperiod")).getString("name")).append(')');
        showParameter.setCaption(sb.toString());
        EvaluateAmtParam evaluateAmtParam = new EvaluateAmtParam();
        evaluateAmtParam.setEvaluateCell(cells);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("card_entryentity");
        DynamicObject cardEntry = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        evaluateAmtParam.setEvaluateReport(cardEntry.getString("cardreportname"));
        evaluateAmtParam.setEvaluateReportId(Long.valueOf(cardEntry.getLong("cardreportid")));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        evaluateAmtParam.setNumber(this.getValue(String.class, "billno"));
        evaluateAmtParam.setAmtUnit(AmountUnitEnum.ONE.getValue());
        evaluateAmtParam.setRateDate(this.getValue(Date.class, "exchangeratedate"));
        evaluateAmtParam.setRateTableId(this.getValue(Long.class, "exratetable"));
        evaluateAmtParam.setReportDataIdList(new ArrayList<String>(reportIds));
        evaluateAmtParam.setReportPeriodId(this.getValue(Long.class, "reportperiod"));
        evaluateAmtParam.setSumRecordId((Long)dataEntity.getPkValue());
        evaluateAmtParam.setReportTypeId((Long)dataEntity.getDynamicObject("reporttype").getPkValue());
        evaluateAmtParam.setSumType(dataEntity.getString("summarytype"));
        evaluateAmtParam.setSumReportOrgId((Long)dataEntity.getDynamicObject("reportorg").getPkValue());
        evaluateAmtParam.setSystemId((Long)dataEntity.getDynamicObject("bodysys").getPkValue());
        showParameter.setCustomParam(EvaluateAmtParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)evaluateAmtParam));
        this.getPageCache().put("possible:approved:amount:flag", Boolean.TRUE.toString());
        this.getView().showForm(showParameter);
    }

    public void refreshCnt(SumPlanRecordCount sumPlanRecordCount) {
        this.getModel().setValue("reportnum", (Object)sumPlanRecordCount.getNoSumPlanOrgCnt());
        this.getModel().setValue("plannum", (Object)sumPlanRecordCount.getNoReportPlanBillCnt());
        this.getModel().setValue("nextnum", (Object)sumPlanRecordCount.getNoReportLLSumBillCnt());
        this.getModel().setValue("sbplannum", (Object)sumPlanRecordCount.getReportPlanBillCnt());
        this.getModel().setValue("sbnextnum", (Object)sumPlanRecordCount.getReportLLSumBillCnt());
        this.getModel().setValue("subplannum", (Object)sumPlanRecordCount.getSubPlanNum());
        this.getModel().setValue("subsumplannum", (Object)sumPlanRecordCount.getSubSumPlanNum());
        this.getModel().setValue("reportedplannum", (Object)sumPlanRecordCount.getReportedPlanNum());
        this.getModel().setValue("unreportedplannum", (Object)sumPlanRecordCount.getUnReportedPlanNum());
        this.getModel().setValue("noreportplanbillids", (Object)sumPlanRecordCount.getNoReportPlanBillIds());
        this.getModel().setValue("noreportllsumbillids", (Object)sumPlanRecordCount.getNoReportLLSumBillIds());
        this.getModel().setValue("reportplanbillids", (Object)sumPlanRecordCount.getReportPlanBillIds());
        this.getModel().setValue("reportllsumbillids", (Object)sumPlanRecordCount.getReportLLSumBillIds());
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u52a0\u8f7d\u9884\u89c8\u3002", (String)"ReportPlanSumPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        this.markFlagOfCol(book);
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        this.dealCellStyle(book.getSheet().getCellList());
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.execCommand();
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", book.getSheet().getCols().stream().max(Integer::compareTo).get());
        Map<Integer, List<Cell>> rowCellMap = book.getSheet().getCellList().stream().filter(o -> o.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.groupingBy(cell -> cell.getRow()));
        List rows = rowCellMap.entrySet().stream().filter(o -> !((List)o.getValue()).stream().anyMatch(cell -> EmptyUtil.isNoEmpty((Object)cell.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"emptyRows", rows);
        String templateId = (String)this.getModel().getValue("cardreporttemplateid");
        if (StringUtils.isNotEmpty((CharSequence)templateId)) {
            spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
            spreadCommand.execCommand();
        }
    }

    public void refreshAnalysisBook(Book book) {
        if (null == book) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u52a0\u8f7d\u9884\u89c8\u3002", (String)"ReportPlanSumPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        spreadCommand.execCommand();
        Map<Integer, List<Cell>> rowCellMap = book.getSheet().getCellList().stream().filter(o -> o.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.groupingBy(Cell::getRow));
        List rows = rowCellMap.entrySet().stream().filter(o -> ((List)o.getValue()).stream().noneMatch(cell -> EmptyUtil.isNoEmpty((Object)cell.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"emptyRows", rows);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void updateCell(List<Cell> cells) {
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, true).generatorChain(this.getSpreadCommandInvoker(), cells);
        spreadCommand.execCommand();
    }

    public void cellValueUpdate(List<CellValueEvent> events) {
        super.cellValueUpdate(events);
        int maxRow = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", Integer.class);
        int maxCol = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", Integer.class);
        CellDataSource cellDS = this.getCellDS();
        events.removeIf(event -> !cellDS.checkBounds(event.getCell().getRow(), event.getCell().getCol()));
        ArrayList<CellUpdateResult> cellUpdateResults = new ArrayList<CellUpdateResult>(events.size());
        for (CellValueEvent event2 : events) {
            CacheCell originCell = cellDS.getCell(event2.getCell().getRow(), event2.getCell().getCol());
            if (EmptyUtil.isEmpty((Object)originCell)) {
                maxRow = Math.max(event2.getCell().getRow(), maxRow);
                maxCol = Math.max(event2.getCell().getCol(), maxCol);
                continue;
            }
            CellTypeEnum cellType = originCell.getCellType();
            if (cellType == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType || originCell.isSummary()) continue;
            try {
                CellUpdateResult updateCellInfo = CellValueUpdateFactory.createCellValueUpdateInstance((CellValueEvent)event2, (Cell)originCell).update();
                cellUpdateResults.add(updateCellInfo);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<String> failureMsgs = cellUpdateResults.stream().filter(Objects::nonNull).filter(o -> EmptyUtil.isNoEmpty((String)o.getErrMsg())).map(CellUpdateResult::getErrMsg).collect(Collectors.toList());
        this.showErrMessage(failureMsgs);
        List updateCells = cellUpdateResults.stream().filter(Objects::nonNull).map(CellUpdateResult::getCell).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateCells)) {
            this.getOrCreateReportController().updateReportData(updateCells);
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxrow_cache", (Object)maxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"currenttable_maxcol_cache", (Object)maxCol);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.getOrCreateReportController().release();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("dataverify".equals(key)) {
            Map returnData = (Map)event.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnData)) {
                return;
            }
            String dataVerifyResult = returnData.get("dataVerifyResult").toString();
            List notifyDTOList = JSONArray.parseArray((String)dataVerifyResult, ReportVerifyRuleNotifyDTO.class);
            if (CollectionUtils.isEmpty((Collection)notifyDTOList)) {
                return;
            }
            boolean commit = notifyDTOList.stream().anyMatch(ReportVerifyRuleNotifyDTO::getFromCommit);
            if (!commit) {
                return;
            }
            boolean anyMatch = notifyDTOList.stream().anyMatch(item -> ReportVerifyCheckEffectEnum.DISABLE.getCode().equals(item.getCheckEffect().getCode()));
            if (!anyMatch) {
                Integer plannum = (Integer)this.getModel().getValue("plannum");
                Integer nextnum = (Integer)this.getModel().getValue("nextnum");
                String billno = (String)this.getModel().getValue("billno");
                if (this.isAllowSubmit() && plannum + nextnum > 0) {
                    String notifyMessage = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5904\u7406\u5355\u3010%1$s\u3011\u5f53\u524d\u672a\u4e0a\u62a5\u5355\u636e\u6570\u91cf\u4e3a%2$s\u5f20\uff0c\u4e14\u63d0\u4ea4\u540e\u4e0b\u7ea7\u7f16\u5236\u4e3b\u4f53\u5c06\u65e0\u6cd5\u7ee7\u7eed\u62a5\u9001\u672c\u671f\u8ba1\u5212\u989d\u5ea6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ReportPlanSumPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), billno, plannum + nextnum);
                    this.getView().showConfirm("", notifyMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("submit", (IFormPlugin)this));
                } else {
                    this.getView().invokeOperation("submit");
                    this.getView().invokeOperation("refresh");
                }
            }
        } else if ("closeInOutCollectPanel".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
        }
    }

    public void deleteRows(AskExecuteEvent event) {
        super.deleteRows(event);
        List rows = (List)event.getParams();
        String rowsStr = rows.stream().map(o -> String.format("%s", o + 1)).collect(Collectors.joining(","));
        this.getView().getPageCache().put("deleteRows", FpmSerializeUtil.serialize((Object)event));
        this.getView().showConfirm("", String.format(ResManager.loadKDString((String)"\u8868\u5934\u884c\u4e0d\u80fd\u5220\u9664\uff0c\u786e\u5b9a\u5220\u9664%s\u884c\u5417\uff1f", (String)"ReportPlanPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rowsStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("deleteRows", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (Objects.equals(callBackId, "submit")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().invokeOperation("submit");
                this.getView().invokeOperation("refresh");
            }
        } else if (Objects.equals(callBackId, "load_sumreport_fail_callback")) {
            this.getView().close();
        }
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void showWarnMessage(String warnMessage) {
        if (null != warnMessage) {
            this.getView().showTipNotification(warnMessage);
        }
    }

    public void switchParamLoadChangeReport(SumPlanLoadType sumPlanLoadType, boolean sameReportIdNeedRefresh) {
        Long sumPlanId = Optional.ofNullable(this.getModel().getValue("id")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        String oldReportId = this.getPageCache().get(OLD_REPORT_ID);
        this.getPageCache().put(OLD_REPORT_TEMPLATE_ID, null);
        String reportIdStr = this.getReportId();
        if (!sameReportIdNeedRefresh && Objects.equals(reportIdStr, oldReportId)) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)reportIdStr)) {
            return;
        }
        if (sumPlanLoadType == SumPlanLoadType.SWITCH) {
            this.getOrCreateReportController().release();
        } else {
            this.saveIfNeed();
        }
        this.getOrCreateReportController().load(sumPlanId, this.getSystemId(), sumPlanLoadType);
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
        this.rowAndColVisible(false);
    }

    public void switchParamLoadChange(String option, boolean sameReportIdNeedRefresh) {
        String oldTemplateId = this.getPageCache().get(OLD_REPORT_TEMPLATE_ID);
        this.getPageCache().put(OLD_REPORT_ID, null);
        String reportTemplateIdStr = this.getReportTemplateId();
        if (!sameReportIdNeedRefresh && StringUtils.equals((CharSequence)reportTemplateIdStr, (CharSequence)oldTemplateId)) {
            return;
        }
        if (EmptyUtil.isEmpty((String)reportTemplateIdStr)) {
            return;
        }
        this.saveIfNeed();
        Long templateId = Optional.ofNullable(reportTemplateIdStr).map(o -> Long.valueOf(o)).orElseGet(() -> 0L);
        this.getOrCreateReportManageController().loadAnalysisTemplate(templateId);
        if (!sameReportIdNeedRefresh) {
            this.setDefFilter();
        }
        this.search();
    }

    public void approvedAmount(SpreadEvent spreadEvent) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        Map<Integer, Set<Integer>> currentColRows = this.getCurrentColRows(spreadSelector);
        if (currentColRows.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"ReportPlanSumPlugin_41", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        CellDataSource cellDataSource = this.getCellDataSource();
        CacheCellMeta meta = cellDataSource.getMeta();
        List<CacheCell> realCurrentData = this.getRealCurrentData(currentColRows, cellDataSource);
        if (EmptyUtil.isEmpty(realCurrentData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c", (String)"ReportPlanSumPlugin_42", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        List currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        if (!this.checkCanApproval(realCurrentData)) {
            return;
        }
        Set<String> reportDataIdSet = this.getReportIdStrSet(realCurrentData);
        int minRow = currColDimValList.stream().map(ReportCalcVal::getRow).max(Comparator.comparing(Integer::intValue)).get() + 1;
        int startRow = spreadSelector.getStartRow();
        startRow = startRow > minRow ? startRow : minRow;
        StringBuilder sb = new StringBuilder();
        int startCol = spreadSelector.getStartCol();
        int endCol = spreadSelector.getEndCol();
        for (int i = startRow; i <= spreadSelector.getEndRow(); ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                sb.append(ExcelUtils.xy2Pos((int)j, (int)i)).append('\u3001');
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.approvedAmount(reportDataIdSet, sb.toString());
    }

    public SpreadSelector getSpreadSelector() {
        return super.getSpreadSelector();
    }

    public void refreshFields(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.getModel().setValue(entry.getKey(), entry.getValue());
        }
    }

    public void loadCallback(boolean loadSuccess, List<String> messageList) {
        this.loadSumReportSuccess = loadSuccess;
        if (!loadSuccess) {
            String errorMsg = messageList.stream().reduce((a, b) -> a + '\n' + b).orElse("");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("load_sumreport_fail_callback", (IFormPlugin)this));
        }
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    protected IAnalysisReportManageController getOrCreateReportManageController() {
        if (null == this.analysisReportManageController) {
            this.analysisReportManageController = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.analysisReportManageController;
    }

    protected ISumPlanManageController getOrCreateReportController() {
        if (null == this.sumPlanManageController) {
            this.sumPlanManageController = new SumPlanManageController((ISumPlanManageView)this);
        }
        return this.sumPlanManageController;
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            this.verifyController = new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    private void initPageDimF7() {
        String mapperInfoStr = this.getView().getPageCache().get("page_dim_mapping_cache");
        String sysId = this.getView().getPageCache().get("system_id_cache");
        Map mapperInfo = (Map)FpmSerializeUtil.deserialize((String)mapperInfoStr, Map.class);
        String filters = this.getPageCache().get("filter");
        if (EmptyUtil.isNoEmpty((String)filters)) {
            mapperInfo.putAll((Map)FpmSerializeUtil.deserialize((String)filters, Map.class));
        }
        if (EmptyUtil.isEmpty((Object)mapperInfo)) {
            return;
        }
        Set entries = mapperInfo.entrySet();
        Long systemId = Long.valueOf(sysId);
        for (Map.Entry entry : entries) {
            BasedataEdit pageDim = (BasedataEdit)this.getControl((String)entry.getKey());
            pageDim.addBeforeF7SelectListener(this.getPageDimBeforeF7SelectListener((TemplateDim)entry.getValue(), systemId));
        }
    }

    private BeforeF7SelectListener getPageDimBeforeF7SelectListener(TemplateDim templateDim, Long systemId) {
        DynamicObject reportOrgDy = (DynamicObject)this.getModel().getValue("reportorg");
        Long reportOrgId = (Long)reportOrgDy.getPkValue();
        DynamicObject reportTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
        IReportDataManagerV2 managerFromCache = this.getOrCreateReportController().getManagerFromCache();
        ReportTemplate reportTemplate = managerFromCache.getReportTemplate();
        Map templateDimMap = reportTemplate.getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        return beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("bodysystem", "=", (Object)Optional.ofNullable(systemId).orElseGet(() -> 0L));
            filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
            filter.and("dimension", "=", (Object)templateDim.getDimensionId());
            List<Object> memberScope = new ArrayList(templateDim.getMemberScope());
            if (templateDim.getLocation() == DimLocation.PAGE && templateDim.getDimType() == DimensionType.CURRENCY) {
                showParameter.setMultiSelect(false);
            }
            if (templateDim.getScopeType() == TemplateDimMemScopeType.SELECT_WHEN_VIEWING && templateDimMap.containsKey(templateDim.getDimensionId())) {
                memberScope.addAll(((TemplateDim)templateDimMap.get(templateDim.getDimensionId())).getMemberScope());
            }
            if (templateDim.getDimType() == DimensionType.ORG) {
                Set<Long> reportOrgIds = ReportPlanSumUtil.getOrgChildren(this.getModel().getDataEntity(), reportOrgId);
                reportOrgIds.add(reportOrgId);
                if (templateDim.getScopeType() == TemplateDimMemScopeType.SELECT_WHEN_VIEWING) {
                    memberScope.addAll(reportOrgIds);
                } else {
                    memberScope.retainAll(reportOrgIds);
                }
                if (EmptyUtil.isEmpty(memberScope)) {
                    memberScope.addAll(reportOrgIds);
                }
            }
            if (templateDim.getDimType() == DimensionType.PERIOD) {
                memberScope = ReportPlanSumUtil.getPeriodFilterMemberList(this.getReport());
            }
            if (!CollectionUtils.isEmpty(memberScope)) {
                filter.and("id", "in", memberScope);
            }
            logger.info("\u7ef4\u5ea6\uff1a{} \u8fc7\u6ee4\u6210\u5458\uff1a{},\u8fc7\u6ee4\u6761\u4ef6:{}", new Object[]{templateDim.getDimType().getNumber(), memberScope, filter});
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
        };
    }

    private void addCardEntryListener() {
        final CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        cardEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                int[] selectRows = cardEntry.getSelectRows();
                if (selectRows.length != 1) {
                    cardEntry.clearEntryState();
                    cardEntry.selectCard(Integer.valueOf(row));
                    return;
                }
                DynamicObjectCollection entryEntity = ReportPlanSumPlugin.this.getModel().getEntryEntity("card_entryentity");
                Long reportId = ((DynamicObject)entryEntity.get(row)).getLong("cardreportid");
                if (reportId == 0L) {
                    Long templateId = ((DynamicObject)entryEntity.get(row)).getLong("cardreporttemplateid");
                    if (templateId == 0L) {
                        return;
                    }
                    String reportTemplateId = ((DynamicObject)entryEntity.get(selectRows[0])).getString("cardreporttemplateid");
                    String currentTemplateId = ReportPlanSumPlugin.this.getPageCache().get(ReportPlanSumPlugin.OLD_REPORT_TEMPLATE_ID);
                    if (!(StringUtils.isEmpty((CharSequence)reportTemplateId) && StringUtils.isEmpty((CharSequence)currentTemplateId) || !StringUtils.equals((CharSequence)reportTemplateId, (CharSequence)currentTemplateId))) {
                        return;
                    }
                    ReportPlanSumPlugin.this.clearData();
                    DynamicObject template = TmcDataServiceHelper.loadSingleFromCache((Object)templateId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_template_bak"));
                    ReportPlanSumPlugin.this.initSpreadComponent(template);
                    ReportPlanSumPlugin.this.getPageCache().put(ReportPlanSumPlugin.INIT_REPORT_FIRST, "N");
                    ReportPlanSumPlugin.this.switchParamLoadChange("name", false);
                    return;
                }
                String selectFields = String.join((CharSequence)",", "templatebak", "name", "id", "planstatus");
                DynamicObject report = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_report", (String)selectFields);
                ReportPlanSumPlugin.this.initSpreadJSComponent(report);
                if (Objects.equals(ReportPlanSumPlugin.this.getPageCache().get(ReportPlanSumPlugin.INIT_REPORT_FIRST), "Y")) {
                    ReportPlanSumPlugin.this.getPageCache().put(ReportPlanSumPlugin.INIT_REPORT_FIRST, "N");
                    return;
                }
                ReportPlanSumPlugin.this.switchParamLoadChangeReport(SumPlanLoadType.SWITCH, false);
                ReportPlanSumPlugin.this.getPageCache().remove("filter");
                ReportPlanSumPlugin.this.rowAndColVisible(false);
            }
        });
    }

    private void submitSumPlan() {
        this.saveIfNeed();
        Integer planNum = (Integer)this.getModel().getValue("plannum");
        Integer nextNum = (Integer)this.getModel().getValue("nextnum");
        String billNo = (String)this.getModel().getValue("billno");
        if (this.isAllowSubmit() && planNum + nextNum > 0) {
            String notifyMessage = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5904\u7406\u5355\u3010%1$s\u3011\u5f53\u524d\u672a\u4e0a\u62a5\u5355\u636e\u6570\u91cf\u4e3a%2$s\u5f20\uff0c\u4e14\u63d0\u4ea4\u540e\u4e0b\u7ea7\u7f16\u5236\u4e3b\u4f53\u5c06\u65e0\u6cd5\u7ee7\u7eed\u62a5\u9001\u672c\u671f\u8ba1\u5212\u989d\u5ea6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ReportPlanSumPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), billNo, planNum + nextNum);
            this.getView().showConfirm("", notifyMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("submit", (IFormPlugin)this));
        } else {
            this.getView().invokeOperation("submit");
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean isAllowSubmit() {
        DynamicObject reportType = (DynamicObject)this.getModel().getValue("reporttype");
        Long pkValue = (Long)reportType.getPkValue();
        Long systemId = (Long)((DynamicObject)this.getModel().getValue("bodysys")).getPkValue();
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and(new QFilter(reportTypeProp, "=", (Object)pkValue)).and("enable", "=", (Object)"1");
        DynamicObject query = QueryServiceHelper.queryOne((String)"fpm_summaryconfig", (String)"allowsubmit", (QFilter[])new QFilter[]{qFilter});
        if (query == null) {
            logger.warn("\u627e\u4e0d\u5230\u6c47\u603b\u53c2\u6570\uff0c\u7f16\u62a5\u7c7b\u578b\uff1a{}", (Object)pkValue);
            return true;
        }
        return query.getBoolean("allowsubmit");
    }

    private void exportExcel() {
        Long reportId = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObjectCollection templates = this.getModel().getDataEntity().getDynamicObjectCollection("attachtpl");
        HashMap headerMap = new HashMap(1);
        HashMap<Long, AnalysisHeader> templateMap = new HashMap<Long, AnalysisHeader>(templates.size());
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            AnalysisHeader header = new AnalysisHeader();
            DynamicObject template = (DynamicObject)iterator.next();
            DynamicObject templateDy = template.getDynamicObject("fbasedataid");
            Long templateId = templateDy.getLong("id");
            boolean isSuccess = this.getAnalysisHeader(header, templateId);
            if (!isSuccess) continue;
            templateMap.put(templateId, header);
        }
        headerMap.put(reportId, templateMap);
        SumPlanHeader sumPlanHeader = this.getReferIndex(true);
        HashMap<Long, SumPlanHeader> reportHeaderMap = new HashMap<Long, SumPlanHeader>(1);
        reportHeaderMap.put(reportId, sumPlanHeader);
        List<Long> pageDimS = this.getPageDimMemberIds();
        HashMap<Long, List<Long>> pageDimMemberIdMap = new HashMap<Long, List<Long>>(1);
        pageDimMemberIdMap.put(reportId, pageDimS);
        SumPlanFormsExportImpl exportExcel = new SumPlanFormsExportImpl(Collections.singleton(reportId), reportHeaderMap, headerMap, pageDimMemberIdMap);
        Tuple exportResult = exportExcel.export();
        if (((Boolean)exportResult.item1).booleanValue()) {
            this.getView().download((String)exportResult.item2);
        } else {
            this.showErrMessage(Collections.singletonList(exportResult.item2));
        }
    }

    private void openFilter() {
        Label label = (Label)this.getView().getControl("openfilter");
        String openFilter = this.getView().getPageCache().get("open_filter");
        String open = ResManager.loadKDString((String)"\u5c55\u5f00\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        String close = ResManager.loadKDString((String)"\u6536\u8d77\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (EmptyUtil.isEmpty((String)openFilter) || open.equals(openFilter)) {
            openFilter = close;
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8"});
        } else {
            openFilter = open;
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap8"});
        }
        label.setText(openFilter);
        this.getView().getPageCache().put("open_filter", openFilter);
    }

    private void refreshReport() {
        String templateId;
        boolean innerStatusChangeBoolean = false;
        String innerStatusChange = this.getView().getPageCache().get("innerStatusChange");
        if (StringUtils.isNotEmpty((CharSequence)innerStatusChange)) {
            innerStatusChangeBoolean = Boolean.parseBoolean(innerStatusChange);
        }
        if (StringUtils.isEmpty((CharSequence)(templateId = (String)this.getModel().getValue("cardreporttemplateid")))) {
            Boolean possibleApprovedAmtFlag = Boolean.valueOf(this.getPageCache().get("possible:approved:amount:flag"));
            if (!innerStatusChangeBoolean && !possibleApprovedAmtFlag.booleanValue()) {
                this.rowAndColVisible(true);
                return;
            }
            String showLimitChange = this.getView().getPageCache().get("showLimitChange");
            if (!StringUtils.isEmpty((CharSequence)showLimitChange)) {
                this.getModel().setValue("showlimit", (Object)Boolean.valueOf(showLimitChange));
            }
            this.selectReport();
            this.getView().getPageCache().put("innerStatusChange", "false");
            return;
        }
        DynamicObject template = TmcDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(templateId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_template_bak"));
        this.initSpreadComponent(template);
        this.getPageCache().put(INIT_REPORT_FIRST, "N");
        this.switchParamLoadChange("name", true);
        this.getView().getPageCache().put("innerStatusChange", "false");
    }

    private void initAnalysisReportCard() {
        DynamicObjectCollection templates = this.getModel().getDataEntity().getDynamicObjectCollection("attachtpl");
        DynamicObjectCollection cardEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("card_entryentity");
        boolean dataChanged = this.getModel().getDataChanged();
        String innerStatus = this.getModel().getDataEntity().getBoolean("offsetornot") ? "1" : "0";
        for (DynamicObject template : templates) {
            DynamicObject templateDy = template.getDynamicObject("fbasedataid");
            DynamicObject dynamicObject = cardEntryEntity.addNew();
            dynamicObject.set("cardreportname", (Object)templateDy.getString("name"));
            dynamicObject.set("cardreportinnerstatus", (Object)innerStatus);
            dynamicObject.set("cardreportreporttype", (Object)ResManager.loadKDString((String)"\u7edf\u8ba1\u8868", (String)"ReportPlanSumPlugin_43", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            dynamicObject.set("cardreporttemplateid", (Object)templateDy.getString("id"));
        }
        this.getModel().setDataChanged(dataChanged);
        this.getView().updateView("card_entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        cardEntry.selectCard(Integer.valueOf(0));
        this.getModel().setValue("reportcount", (Object)this.getModel().getEntryRowCount("card_entryentity"));
    }

    private void showOrNotApprovalAmtColBySummaryConfig() {
        Long reportTypeId;
        SumPlanRepository sumPlanRepository = new SumPlanRepository();
        Long systemId = (Long)this.getModel().getDataEntity().getDynamicObject("bodysys").getPkValue();
        List sumPlanParamConfigList = sumPlanRepository.loadSumConfigBySystem(systemId, Collections.singleton(reportTypeId = (Long)this.getModel().getDataEntity().getDynamicObject("reporttype").getPkValue()), true);
        if (EmptyUtil.isEmpty((Collection)sumPlanParamConfigList)) {
            return;
        }
        boolean showLimit = false;
        SumPlanParamConfig sumPlanParamConfig = (SumPlanParamConfig)sumPlanParamConfigList.get(0);
        Long reportOrgId = (Long)this.getModel().getDataEntity().getDynamicObject("reportorg").getPkValue();
        List configInfoList = sumPlanParamConfig.getConfigInfoList();
        for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
            CheckSubLimitType checkSubLimitType;
            if (!Objects.equals(sumPlanParamConfigInfo.getOrgMemberId(), reportOrgId) || CheckSubLimitType.SUM_AND_CHECK_MAIN_LIMIT != (checkSubLimitType = sumPlanParamConfigInfo.getCheckSubLimitType())) continue;
            showLimit = true;
            break;
        }
        String planStatus = this.getModel().getDataEntity().getString("planstatus");
        if (ReportPlanStatusEnum.EFFECTIVE.getValue().equals(planStatus)) {
            if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("showLimitChange"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showlimit", (Object)"0");
                this.getView().getPageCache().put("showlimit", "0");
                this.getView().getPageCache().put("showLimitChange", String.valueOf(this.getModel().getValue("showlimit")));
            }
        } else if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("showLimitChange")) || Objects.equals("true", this.getView().getPageCache().get("showLimitChange"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showlimit", (Object)(showLimit ? "1" : "0"));
            this.getView().getPageCache().put("showlimit", showLimit ? "1" : "0");
            this.getView().getPageCache().put("showLimitChange", String.valueOf(this.getModel().getValue("showlimit")));
        }
        this.getView().getPageCache().put("visible:showlimit", Boolean.valueOf(showLimit).toString());
        this.getView().setVisible(Boolean.valueOf(showLimit), new String[]{"showlimit"});
    }

    private void updateApprovalButton() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("card_entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        Long reportId = dynamicObject.getLong("cardreportid");
        String selectFields = String.join((CharSequence)",", "templatebak", "name", "id", "planstatus");
        DynamicObject report = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_report", (String)selectFields);
        this.initSpreadJSComponent(report);
    }

    private void openReportPlanSumCardLink(String prop) {
        String noReportSumIdStr = (String)this.getModel().getValue(prop);
        Set<Long> reportSumIds = StringUtils.isEmpty((CharSequence)noReportSumIdStr) ? Collections.emptySet() : Arrays.stream(noReportSumIdStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        this.showReportPlan(reportSumIds);
    }

    private void openReportPlanCardLink(String prop) {
        String reportIdStr = (String)this.getModel().getValue(prop);
        List<Long> reportIds = StringUtils.isEmpty((CharSequence)reportIdStr) ? Collections.emptyList() : Arrays.stream(reportIdStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
        this.showHyperList(reportIds);
    }

    private void switchReport() {
        String reportId = (String)this.getModel().getValue("cardreportid");
        if (EmptyUtil.isEmpty((String)reportId)) {
            return;
        }
        this.switchParamLoadChangeReport(SumPlanLoadType.LOAD, true);
    }

    private boolean checkRequire() {
        String status = this.getModel().getDataEntity().getString("billstatus");
        return Objects.equals(status, BillStatus.STAGE.getNumber());
    }

    private void switchReportIfTemplateIdEmpty() {
        String templateId = (String)this.getModel().getValue("cardreporttemplateid");
        if (StringUtils.isEmpty((CharSequence)templateId)) {
            this.switchReport();
            this.rowAndColVisible(false);
        }
    }

    private Map<String, TemplateDim> getPropToTemplateDimMap(ReportTemplate reportTemplate) {
        HashMap<String, TemplateDim> mapper = new HashMap<String, TemplateDim>(16);
        List pageDimList = reportTemplate.getPageDimList();
        int count = 1;
        for (int i = 0; i < pageDimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)pageDimList.get(i);
            String pageDimSign = String.format("custompagemember%s", count++);
            mapper.put(pageDimSign, templateDim);
        }
        return mapper;
    }

    private BeforeF7SelectListener getFilterBeforeF7SelectListener(Long systemId, TemplateDim templateDim) {
        return beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
            filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
        };
    }

    private void initFilterVisibleFalse() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"custompagemember1", "custompagemember2", "custompagemember3"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_col_01", "filter_col_02", "filter_col_03", "filter_row_01", "filter_row_02", "filter_01", "filter_02", "showlimit"});
    }

    private void initSumPlanParamInfo() {
        Optional<String> originReportIdsOP = Optional.ofNullable(this.getModel().getDataEntity().getString("originalreportids"));
        if (!originReportIdsOP.isPresent()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u7684\u4e3b\u8868", (String)"ReportPlanSumPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String reportIds = originReportIdsOP.get();
        List originalReportIdList = StringUtils.isEmpty((CharSequence)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        String selectFields = String.join((CharSequence)",", "templatebak", "name", "id", "planstatus");
        DynamicObject[] reports = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", originalReportIdList)});
        DynamicObject defaultReportDy = this.initCardEntryEntityAndGetDefaultReport(reports);
        this.getPageCache().put(OLD_REPORT_ID, defaultReportDy.getPkValue().toString());
        this.getView().setVisible(Boolean.FALSE, new String[]{"detailperiod", "flexpanelap8"});
        DynamicObject reportType = (DynamicObject)this.getModel().getValue("reporttype");
        String detailReportType = reportType.getString("orgreporttype");
        if (EmptyUtil.isNoEmpty((String)detailReportType.trim())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"detailperiod"});
        }
        DynamicObject template = defaultReportDy.getDynamicObject("templatebak");
        String amount = template.getString("amountunit");
        this.getView().setEnable(Boolean.FALSE, new String[]{"amountunit"});
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amountunit", (Object)amount);
        if (!"C".equals(this.getModel().getDataEntity().getString("billstatus"))) {
            this.getOrCreateReportController().countSumPlan((Long)this.getModel().getDataEntity().getPkValue());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
        this.initSpreadJSComponent(defaultReportDy);
    }

    private DynamicObject initCardEntryEntityAndGetDefaultReport(DynamicObject[] reports) {
        DynamicObjectCollection cardEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("card_entryentity");
        cardEntryEntity.clear();
        List reportList = Arrays.stream(reports).sorted(Comparator.comparing(this::getReportScore)).collect(Collectors.toList());
        boolean dataChanged = this.getModel().getDataChanged();
        String innerStatus = this.getModel().getDataEntity().getBoolean("offsetornot") ? "1" : "0";
        for (int i = 0; i < reportList.size(); ++i) {
            DynamicObject report = (DynamicObject)reportList.get(i);
            DynamicObject templateDy = report.getDynamicObject("templatebak");
            boolean isMainTable = templateDy.getBoolean("ismaintable");
            this.getView().setVisible(Boolean.valueOf(isMainTable), new String[]{"linksearchchild"});
            String reportType = isMainTable ? ResManager.loadKDString((String)"\u4e3b\u8868", (String)"ReportPlanSumPlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b50\u8868", (String)"ReportPlanSumPlugin_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            DynamicObject dynamicObject = cardEntryEntity.addNew();
            dynamicObject.set("cardreportname", (Object)report.getString("name"));
            dynamicObject.set("cardreportinnerstatus", (Object)innerStatus);
            dynamicObject.set("cardreportreporttype", (Object)reportType);
            dynamicObject.set("cardreportid", (Object)report.getString("id"));
        }
        this.getModel().setDataChanged(dataChanged);
        DynamicObject defaultReportDy = (DynamicObject)reportList.get(0);
        this.getView().updateView("card_entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        this.getPageCache().put(INIT_REPORT_FIRST, "Y");
        cardEntry.selectCard(Integer.valueOf(0));
        this.getModel().setValue("reportcount", (Object)this.getModel().getEntryRowCount("card_entryentity"));
        return defaultReportDy;
    }

    private int getReportScore(DynamicObject report) {
        if (Objects.equals(report.getString("id"), this.getModel().getDataEntity().getString("mainreportid"))) {
            return 0;
        }
        return 1;
    }

    private void clearData() {
        this.getModel().setValue("filter_col_01", null);
        this.getModel().setValue("filter_col_02", null);
        this.getModel().setValue("filter_col_03", null);
        this.getModel().setValue("filter_row_01", null);
        this.getModel().setValue("filter_row_02", null);
        this.getModel().setValue("filter_01", null);
        this.getModel().setValue("filter_02", null);
    }

    private void setDefFilter() {
        String filters = this.getPageCache().get("filter");
        Map deserialize = (Map)FpmSerializeUtil.deserialize((String)filters, Map.class);
        String org = this.getPageCache().get("org");
        DynamicObject sumPlanRecord = this.getModel().getDataEntity();
        deserialize.entrySet().stream().filter(e -> EmptyUtil.isNoEmpty((Integer)((TemplateDim)e.getValue()).getDefaultFilter().size())).forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)org) && ((TemplateDim)e.getValue()).getDimType() == DimensionType.ORG) {
                this.getModel().setValue((String)e.getKey(), (Object)new Object[]{Long.valueOf(org)});
                this.getPageCache().remove("org");
            } else {
                TemplateDim templateDim = (TemplateDim)e.getValue();
                List<Long> defaultFilter = ReportPlanSumUtil.getFilterMember(templateDim, sumPlanRecord);
                defaultFilter = Objects.isNull(defaultFilter) ? Collections.emptyList() : defaultFilter;
                this.getModel().setValue((String)e.getKey(), (Object)defaultFilter.toArray());
            }
        });
        deserialize.entrySet().stream().filter(e -> ((TemplateDim)e.getValue()).getDimType() == DimensionType.ORG).filter(e -> EmptyUtil.isEmpty((Collection)((TemplateDim)e.getValue()).getDefaultFilter())).forEach(e -> {
            List<Long> defaultFilter = ReportPlanSumUtil.getFilterMember((TemplateDim)e.getValue(), sumPlanRecord);
            this.getModel().setValue((String)e.getKey(), (Object)defaultFilter.toArray());
        });
        Report report = this.getReport();
        TemplateType templateType = report.getTemplate().getTemplateType();
        for (Map.Entry entry : deserialize.entrySet()) {
            TemplateDim value = (TemplateDim)entry.getValue();
            if (value.getDimType() != DimensionType.PERIOD) continue;
            if (templateType.isDetail()) {
                this.getModel().setValue((String)entry.getKey(), (Object)report.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).toArray());
                continue;
            }
            DimLocation location = value.getLocation();
            if (DimLocation.COL == location) {
                this.getModel().setValue((String)entry.getKey(), (Object)ReportPlanSumUtil.getPeriodFilterMemberList(this.getReport()).toArray());
                continue;
            }
            this.getModel().setValue((String)entry.getKey(), (Object)report.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).toArray());
        }
        this.getView().updateView("splitpanelap1");
    }

    private boolean getAnalysisHeader(AnalysisHeader header, Long analysisTemplateId) {
        if (!ReportPlanSumUtil.checkRequiredField(this.getModel().getDataEntity())) {
            String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"FundPositionTableReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        DynamicObject sumPlan = this.getModel().getDataEntity();
        ReportPlanSumUtil.fillHeader(header, sumPlan);
        ReportTemplate analysisTemplate = this.templateRepository.loadTemplateBak(analysisTemplateId);
        String currentTemplateId = (String)this.getModel().getValue("cardreporttemplateid");
        Set<Long> filterMemberSet = EmptyUtil.isNoEmpty((String)currentTemplateId) && Objects.equals(analysisTemplateId, Long.valueOf(currentTemplateId)) ? ReportPlanSumUtil.getFilterConditions(sumPlan) : ReportPlanSumUtil.getFilterConditions(analysisTemplate, sumPlan);
        ReportTemplate reportTemplate = this.getOrCreateReportController().getManagerFromCache().getReportTemplate();
        ReportPlanSumUtil.fillMembers(filterMemberSet, header, reportTemplate, analysisTemplate, sumPlan);
        DynamicObject org = sumPlan.getDynamicObject("reportorg");
        if (CollectionUtils.isEmpty((Collection)header.getOrg())) {
            this.getPageCache().put("org", String.valueOf(org.getLong("id")));
            header.setOrg(Collections.singletonList(org.getLong("id")));
        }
        int subjectSize = ReportPlanSumUtil.getSubjectSize(header, sumPlan);
        if (header.getOrg().size() * subjectSize > ReportPlanSumUtil.MAX_QUERY_ROW_COUNT) {
            String err = ResManager.loadKDString((String)"\u6240\u9700\u67e5\u8be2\u6570\u636e\u91cf\u884c\u6570\uff08\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u6570*\u8ba1\u5212\u79d1\u76ee\u6210\u5458\u6570\uff09\u4e0d\u53ef\u5927\u4e8e%s\u884c\uff1b\u8bf7\u68c0\u67e5\u201c\u7f16\u62a5\u4e3b\u4f53\u201d\u6216\u201c\u8ba1\u5212\u79d1\u76ee\u201d\u8fc7\u6ee4\u6761\u4ef6\uff0c\u51cf\u5c11\u9700\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"FundPositionTableReportPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(String.format(err, ReportPlanSumUtil.MAX_QUERY_ROW_COUNT)));
            return false;
        }
        return true;
    }

    private void search() {
        String templateId = (String)this.getModel().getValue("cardreporttemplateid");
        if (EmptyUtil.isEmpty((String)templateId)) {
            return;
        }
        AnalysisHeader header = new AnalysisHeader();
        boolean isSuccess = this.getAnalysisHeader(header, Long.parseLong(templateId));
        if (!isSuccess) {
            return;
        }
        this.getOrCreateReportManageController().loadSumPlanAnalysisReport(Long.valueOf(Long.parseLong(templateId)), header);
    }

    private String getReportTemplateId() {
        String currentTemplateId;
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return "0";
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
        String reportTemplateId = ((DynamicObject)entryEntity.get(selectRows[0])).getString("cardreporttemplateid");
        if (!Objects.equals(reportTemplateId, currentTemplateId = this.getPageCache().get(OLD_REPORT_TEMPLATE_ID))) {
            this.getPageCache().put(OLD_REPORT_TEMPLATE_ID, reportTemplateId);
        }
        return reportTemplateId;
    }

    private String getReportId() {
        String currentReportId;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("card_entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("card_entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return "0";
        }
        String reportId = ((DynamicObject)entryEntity.get(selectRows[0])).getString("cardreportid");
        if (!Objects.equals(reportId, currentReportId = this.getPageCache().get(OLD_REPORT_ID))) {
            this.getPageCache().put(OLD_REPORT_ID, reportId);
        }
        return reportId;
    }

    private Long getSystemId() {
        DynamicObject systemDyObj = (DynamicObject)this.getModel().getValue("bodysys");
        return systemDyObj.getLong("id");
    }

    private List<Long> getPageDimMemberIds() {
        Long pageMember3;
        Long pageMember2;
        ArrayList<Long> pageDimS = new ArrayList<Long>(2);
        Long pageMember1 = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("custompagemember1")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
        if (EmptyUtil.isNoEmpty((Long)pageMember1)) {
            pageDimS.add(pageMember1);
        }
        if (EmptyUtil.isNoEmpty((Long)(pageMember2 = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("custompagemember2")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null)))) {
            pageDimS.add(pageMember2);
        }
        if (EmptyUtil.isNoEmpty((Long)(pageMember3 = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("custompagemember3")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null)))) {
            pageDimS.add(pageMember3);
        }
        return pageDimS;
    }

    private void showReportPlan(Set<Long> reportSumIds) {
        if (EmptyUtil.isEmpty(reportSumIds)) {
            return;
        }
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_reportplansum").searchFormNumber("fpm_reportplansum").listFormId("bos_treelist").searchIds(new ArrayList<Object>(reportSumIds)).listForm("fpm_reportplansum").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_SUM_PLAN_RECORD).linkSearch(true).caption(ResManager.loadKDString((String)"\u8054\u67e5\u4e0b\u7ea7\u6c47\u603b\u5355\u636e", (String)"ReportPlanSumPlugin_44", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
    }

    private void showHyperList(List<Long> reportIds) {
        if (EmptyUtil.isEmpty(reportIds)) {
            return;
        }
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_report_process").searchFormNumber("fpm_report_process").listFormId("bos_treelist").searchIds(new ArrayList<Object>(reportIds)).listForm("fpm_report_process").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_SUM_PLAN_RECORD).linkSearch(true).caption(ResManager.loadKDString((String)"\u8054\u67e5\u8ba1\u5212\u7f16\u5236\u5355\u636e", (String)"ReportPlanSumPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
    }

    private void initSpreadJSComponent(DynamicObject report) {
        ISpreadCommand spreadCommand;
        ReportProcessStatus statusByVal;
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_col_01", "filter_col_02", "filter_col_03", "filter_row_01", "filter_row_02", "filter_01", "filter_02"});
        this.getModel().setValue("filter_col_01", null);
        this.getModel().setValue("filter_col_02", null);
        this.getModel().setValue("filter_col_03", null);
        this.getModel().setValue("filter_row_01", null);
        this.getModel().setValue("filter_row_02", null);
        this.getModel().setValue("filter_01", null);
        this.getModel().setValue("filter_02", null);
        String visibleShowLimit = this.getView().getPageCache().get("visible:showlimit");
        if (Boolean.parseBoolean(visibleShowLimit)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"showlimit"});
        }
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        DynamicObject templateDy = report.getDynamicObject("templatebak");
        String templateType = templateDy.getString("templatetype");
        if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
            extraMenuItems.add(ContextMenuItemsEnum.DELETECOMMENT);
            extraMenuItems.add(ContextMenuItemsEnum.EDITCOMMENT);
        }
        this.initApprovedAmountButtonIfNeed(extraMenuItems);
        extraMenuItems.add(ContextMenuItemsEnum.QUERYSUBREPORTRECORD);
        String planStatus = report.getString("planstatus");
        Boolean isMainTable = templateDy.getBoolean("ismaintable");
        if (EmptyUtil.isNoEmpty((String)planStatus) && ReportPlanStatusEnum.EFFECTIVE.getValue().equals(planStatus) && EmptyUtil.isNoEmpty((Object)isMainTable) && isMainTable.booleanValue()) {
            extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHEXECRECORD);
        }
        if (EmptyUtil.isNoEmpty((Object)isMainTable) && isMainTable.booleanValue()) {
            extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHINOUTCOLLECT);
        }
        if (Objects.nonNull(statusByVal = ReportProcessStatus.getStatusByVal((String)this.getModel().getDataEntity().getString("billstatus"))) && !ReportProcessStatus.isSave((ReportProcessStatus)statusByVal)) {
            ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
            hideItems.add(ContextMenuItemsEnum.PASTEALL);
            hideItems.add(ContextMenuItemsEnum.DELETEROWS);
            hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
            spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(this.getSpreadCommandInvoker());
        } else {
            spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        }
        spreadCommand.execCommand();
    }

    private void initSpreadComponent(DynamicObject template) {
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        String templateType = template.getString("templatetype");
        if (EmptyUtil.isNoEmpty((String)templateType) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
            extraMenuItems.add(ContextMenuItemsEnum.DELETECOMMENT);
            extraMenuItems.add(ContextMenuItemsEnum.EDITCOMMENT);
        }
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
    }

    private void initApprovedAmountButtonIfNeed(List<ContextMenuItemsEnum> extraMenuItems) {
        if (!Objects.equals(this.getModel().getValue("billstatus"), BillStatusEnum.STAGE.getCode())) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(formShowParameter) && formShowParameter.getStatus() == OperationStatus.VIEW) {
            return;
        }
        DynamicObject reportOrg = (DynamicObject)this.getModel().getValue("reportorg");
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        DynamicObject reportType = (DynamicObject)this.getModel().getValue("reporttype");
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid");
        String selectFields = String.join((CharSequence)",", "name", String.join((CharSequence)".", "treeentryentity", "sum_reportorg"), String.join((CharSequence)".", "treeentryentity", "sum_ischecksublimit"));
        DynamicObject summaryConfig = TmcDataServiceHelper.loadSingle((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys", "=", bodySys.getPkValue()).and(reportTypeProp, "in", Collections.singletonList(reportType.getPkValue())).and("enable", "=", (Object)"1")});
        if (EmptyUtil.isEmpty((DynamicObject)summaryConfig)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u6ca1\u6709\u53ef\u7528\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanSumPlugin_16", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), bodySys.getString("name"), reportType.getString("name")));
            return;
        }
        DynamicObjectCollection sumTreeEntity = summaryConfig.getDynamicObjectCollection("treeentryentity");
        Optional<DynamicObject> first = sumTreeEntity.stream().filter(dy -> Objects.equals(dy.getDynamicObject("sum_reportorg").getPkValue(), reportOrg.getPkValue())).findFirst();
        if (!first.isPresent()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u3010%3$s\u3011\u4e2d\u6ca1\u6709\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u3010%4$s\u3011\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanSumPlugin_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), bodySys.getString("name"), reportType.getString("name"), summaryConfig.getString("name"), reportOrg.getString("name")));
            return;
        }
        DynamicObject dynamicObject = first.get();
        String checkSubLimit = dynamicObject.getString("sum_ischecksublimit");
        if (Objects.equals(checkSubLimit, SummaryConfigCheckSubLimitEnum.ONLY_SUM_AUDIT.getValue())) {
            return;
        }
        extraMenuItems.add(ContextMenuItemsEnum.APPROVEDAMOUNT);
    }

    private void dealCellStyle(List<Cell> cells) {
        Map<String, Set<Integer>> markColMap = this.markFlagOfCol(null);
        Set<Integer> sumPlanCols = markColMap.get(PlanChangeReferIndex.ADJUSTAMT.getValue());
        Set<Integer> adjustedAvaAmtCols = markColMap.get(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue());
        cells = cells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.toList());
        for (Cell cell2 : cells) {
            BigDecimal val;
            CellStyleInfo styleInfo = cell2.getStyleInfo();
            int col = cell2.getCol();
            if (cell2.getCellType() != CellTypeEnum.AMOUNT) continue;
            Object value = cell2.getValue();
            if (EmptyUtil.isEmpty((Object)value) || new BigDecimal(value.toString()).compareTo(BigDecimal.ZERO) == 0) {
                styleInfo.setFrc("#999999");
                continue;
            }
            if (sumPlanCols.contains(col)) {
                if (!EmptyUtil.isNoEmpty((String)value.toString())) continue;
                String color = "#000000";
                BigDecimal val2 = new BigDecimal(value.toString());
                if (val2.compareTo(BigDecimal.ZERO) == 0) {
                    color = "#999999";
                } else {
                    styleInfo.setBkc("#DFE6FA");
                }
                styleInfo.setFrc(color);
                continue;
            }
            if (!adjustedAvaAmtCols.contains(col) || !EmptyUtil.isNoEmpty((String)value.toString()) || (val = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) >= 0) continue;
            styleInfo.setFrc("#ef4136");
        }
    }

    private Map<String, Set<Integer>> markFlagOfCol(Book book) {
        if (EmptyUtil.isNoEmpty((Object)book)) {
            HashMap<String, Set<Integer>> markMap = new HashMap<String, Set<Integer>>(16);
            List colDimsLst = book.getSheet().getCellList().stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.COLDIMS).collect(Collectors.toList());
            Set adjustAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.ADJUSTAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.ADJUSTAMT.getValue(), adjustAmtCols);
            Set adjustedAvaAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue(), adjustedAvaAmtCols);
            Set afterAdjAmtCols = colDimsLst.stream().filter(cell -> cell.getDisplayValue().toString().trim().equals(PlanChangeReferIndex.AFTERADJUSTAMT.getName())).map(Cell::getCol).collect(Collectors.toSet());
            markMap.put(PlanChangeReferIndex.AFTERADJUSTAMT.getValue(), afterAdjAmtCols);
            this.getView().getPageCache().put("cellColMarkInfo", FpmSerializeUtil.serialize(markMap));
            return markMap;
        }
        return (Map)FpmSerializeUtil.deserialize((String)this.getView().getPageCache().get("cellColMarkInfo"), Map.class);
    }

    private void filterControlInit() {
        String value = (String)this.getModel().getValue("cardreporttemplateid");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return;
        }
        this.initMainTableFilter();
    }

    private void initMainTableFilter() {
        IReportDataManagerV2 reportDataManager = this.getOrCreateReportController().getManagerFromCache();
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        Long systemId = reportTemplate.getSystemId();
        List filterDimList = reportTemplate.getAllTemplateDim().stream().filter(item -> !item.isViDim()).filter(item -> item.getDimType() != DimensionType.METRIC).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        for (TemplateDim templateDim : filterDimList) {
            String controlKey = "";
            if (templateDim.getLocation() == DimLocation.COL) {
                controlKey = String.format("filter_col_0%s", templateDim.getLevel());
            } else {
                if (templateDim.getLocation() != DimLocation.ROW) continue;
                controlKey = String.format("filter_row_0%s", templateDim.getLevel());
            }
            if (!templateDim.isFilterDim()) continue;
            logger.info("\u8fc7\u6ee4\u6761\u4ef6\u5b57\u6bb5\u6807\u8bc6\uff1a{}", (Object)controlKey);
            this.getView().setVisible(Boolean.TRUE, new String[]{controlKey});
            BasedataEdit filterDim = (BasedataEdit)this.getControl(controlKey);
            if (EmptyUtil.isEmpty((Object)filterDim)) continue;
            filterDim.setCaption(new LocaleString(EmptyUtil.isEmpty((String)templateDim.getDimensionName()) ? "" : templateDim.getDimensionName() + "\uff1a"));
            filterDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
                filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                filter.and("dimension", "=", (Object)templateDim.getDimensionId());
                if (templateDim.getDimType() == DimensionType.PERIOD) {
                    List<Long> currenPeriodChildList = ReportPlanSumUtil.getPeriodFilterMemberList(this.getReport());
                    filter.and("id", "in", currenPeriodChildList);
                } else {
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                }
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
            });
        }
    }

    private Report getReport() {
        return ReportPlanSumUtil.getReport(this.getModel().getDataEntity(true));
    }

    private void rowAndColVisible(boolean showSuccess) {
        IReportDataManagerV2 managerFromCache = this.getOrCreateReportController().getManagerFromCache();
        ReportTemplate reportTemplate = managerFromCache.getReportTemplate();
        if (reportTemplate.getTemplateType() == TemplateType.DETAIL) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hideemptyrow"});
        }
        List<Integer> needHideColList = this.getColNeedHiddenByFilter(managerFromCache);
        List<Integer> needHideRowList = this.getRowNeedHiddenByFilter(managerFromCache);
        this.hiddenByCache();
        this.hiddenIfNeedAndRefreshCache(needHideColList, needHideRowList);
        if (showSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ReportPlanSumPlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void hiddenIfNeedAndRefreshCache(List<Integer> needHideColList, List<Integer> needHideRowList) {
        if (CollectionUtils.isEmpty(needHideRowList) && CollectionUtils.isEmpty(needHideColList)) {
            return;
        }
        RowAndColVisibleCmdChain hideSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), needHideRowList, needHideColList, Boolean.FALSE);
        hideSpreadCommand.execCommand();
        this.getPageCache().put("HIDECOLS", JSON.toJSONString(needHideColList));
        this.getPageCache().put("HIDEROWS", JSON.toJSONString(needHideRowList));
    }

    private void hiddenByCache() {
        String hideColsStr = this.getPageCache().get("HIDECOLS");
        String hideRowsStr = this.getPageCache().get("HIDEROWS");
        if (EmptyUtil.isEmpty((String)hideColsStr) || EmptyUtil.isEmpty((String)hideRowsStr)) {
            return;
        }
        List colS = new ArrayList(16);
        if (EmptyUtil.isNotEmpty((CharSequence)hideColsStr)) {
            colS = JSONArray.parseArray((String)hideColsStr, Integer.class);
        }
        List rowS = new ArrayList(16);
        if (EmptyUtil.isNotEmpty((CharSequence)hideRowsStr)) {
            rowS = JSONArray.parseArray((String)hideRowsStr, Integer.class);
        }
        RowAndColVisibleCmdChain showSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), rowS, colS, Boolean.TRUE);
        showSpreadCommand.execCommand();
    }

    private List<Integer> getRowNeedHiddenByFilter(IReportDataManagerV2 reportDataManager) {
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        List rowDimList = reportTemplate.getRowDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Predicate<ReportCalcVal> rowFilter = null;
        for (TemplateDim templateDim : rowDimList) {
            if (!templateDim.isFilterDim()) continue;
            int level = templateDim.getLevel();
            String filterProp = String.format("filter_row_0%s", level);
            DynamicObjectCollection filterColDy = dataEntity.getDynamicObjectCollection(filterProp);
            Set<Long> filterRowMemberIdSet = filterColDy.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(filterRowMemberIdSet)) continue;
            Predicate<ReportCalcVal> rowMemberFilter = this.getFilterMemberIdFilter(reportCalcVal -> true, filterRowMemberIdSet, templateDim);
            rowFilter = rowFilter == null ? rowMemberFilter : rowFilter.or(rowMemberFilter);
        }
        if (rowFilter == null) {
            return Collections.emptyList();
        }
        List needHideList = currRowDimValList.stream().filter(rowFilter::test).collect(Collectors.toList());
        HashSet<Integer> needHideRowSet = new HashSet<Integer>(needHideList.size());
        for (ReportCalcVal reportCalcVal2 : needHideList) {
            needHideRowSet.add(reportCalcVal2.getRow());
            for (int i = 1; i < reportCalcVal2.getRowSpan(); ++i) {
                needHideRowSet.add(reportCalcVal2.getRow() + i);
            }
        }
        return new ArrayList<Integer>(needHideRowSet);
    }

    private List<Integer> getColNeedHiddenByFilter(IReportDataManagerV2 reportDataManager) {
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        List colDimList = reportTemplate.getColDimList().stream().filter(item -> !item.isViDim()).filter(item -> item.getDimType() != DimensionType.METRIC).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Predicate<ReportCalcVal> metricFilter = this.getMetricFilterByShowOrNotApproval(reportDataManager, currColDimValList);
        ArrayList needHideList = new ArrayList(16);
        for (TemplateDim templateDim : colDimList) {
            if (!templateDim.isFilterDim()) continue;
            int level = templateDim.getLevel();
            String filterProp = String.format("filter_col_0%s", level);
            Integer maxRow = currColDimValList.stream().filter(item -> templateDim.getDimensionId().equals(item.getDimensionId())).map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(0);
            DynamicObjectCollection filterColDy = dataEntity.getDynamicObjectCollection(filterProp);
            Set<Long> filterColMemberIdSet = filterColDy.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (templateDim.getDimType() == DimensionType.PERIOD) {
                List selectedFilterTreeNodeList = meta.getColDimTree().getRoot().getAllChildren().stream().filter(treeNode -> filterColMemberIdSet.contains(treeNode.getValue())).collect(Collectors.toList());
                for (ReportCalcValTreeNode treeNode2 : selectedFilterTreeNodeList) {
                    boolean existDetailPeriod;
                    boolean existParentPeriod;
                    boolean bl = existParentPeriod = Objects.nonNull(treeNode2.getParent()) && Objects.nonNull(treeNode2.getParent().getCalcVal()) && Objects.equals(treeNode2.getParent().getCalcVal().getDimensionId(), templateDim.getDimensionId());
                    if (existParentPeriod) {
                        filterColMemberIdSet.add((Long)treeNode2.getParent().getCalcVal().getValue());
                    }
                    if (!(existDetailPeriod = !CollectionUtils.isEmpty((Collection)treeNode2.getChildren()) && treeNode2.getChildren().stream().map(ReportCalcValTreeNode::getCalcVal).allMatch(reportCalcVal -> Objects.equals(reportCalcVal.getDimensionId(), templateDim.getDimensionId())))) continue;
                    treeNode2.getChildren().stream().map(ReportCalcValTreeNode::getCalcVal).map(ReportCalcVal::getValue).map(o -> (Long)o).forEach(filterColMemberIdSet::add);
                }
            }
            if (EmptyUtil.isEmpty(filterColMemberIdSet)) continue;
            metricFilter = metricFilter.or(this.getFilterMemberIdFilter(reportCalcVal -> reportCalcVal.getRow() <= maxRow, filterColMemberIdSet, templateDim));
        }
        List hideList = currColDimValList.stream().filter(metricFilter::test).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(hideList)) {
            needHideList.addAll(hideList);
        }
        HashSet<Integer> needHideColSet = new HashSet<Integer>(needHideList.size());
        for (ReportCalcVal reportCalcVal2 : needHideList) {
            needHideColSet.add(reportCalcVal2.getCol());
            for (int i = 1; i < reportCalcVal2.getColSpan(); ++i) {
                needHideColSet.add(reportCalcVal2.getCol() + i);
            }
        }
        return new ArrayList<Integer>(needHideColSet);
    }

    private Predicate<ReportCalcVal> getMetricFilterByShowOrNotApproval(IReportDataManagerV2 reportDataManager, List<ReportCalcVal> currColDimValList) {
        FundPlanSystem system = reportDataManager.getSystem();
        Dimension metricDimension = system.getMainDimensionByDimType(DimensionType.METRIC);
        Map<TemplateMetricType, MetricMember> metricMemberMap = metricDimension.getAllDimMemberList().stream().map(MetricMember.class::cast).collect(Collectors.toMap(MetricMember::getTemplateMetricType, Function.identity(), (a, b) -> a));
        Boolean showLimit = (Boolean)this.getModel().getValue("showlimit");
        Predicate<ReportCalcVal> metricColFilter = showLimit == false ? this.getApprovalColFilter(metricMemberMap, metricDimension.getId()) : this.getFilterByTemplateMetricTypes(metricMemberMap, metricDimension.getId(), TemplateMetricType.PLANAMT);
        Set metricColSet = currColDimValList.stream().filter(metricColFilter::test).map(ReportCalcVal::getCol).collect(Collectors.toSet());
        Integer metricMaxRow = currColDimValList.stream().filter(ReportCalcVal::isMetric).map(ReportCalcVal::getRow).max(Integer::compareTo).get();
        return reportCalcVal -> metricColSet.contains(reportCalcVal.getCol()) && reportCalcVal.getRow() == metricMaxRow.intValue() && !reportCalcVal.isReferenceCell();
    }

    private Predicate<ReportCalcVal> getFilterMemberIdFilter(Predicate<ReportCalcVal> predicate, Set<Long> filterColMemberIdSet, TemplateDim templateDim) {
        return reportCalcVal -> predicate.test((ReportCalcVal)reportCalcVal) && Objects.equals(templateDim.getDimensionId(), reportCalcVal.getDimensionId()) && !filterColMemberIdSet.contains(reportCalcVal.getValue());
    }

    private Predicate<ReportCalcVal> getApprovalColFilter(Map<TemplateMetricType, MetricMember> metricMemberMap, Long metricDimId) {
        return this.getFilterByTemplateMetricTypes(metricMemberMap, metricDimId, TemplateMetricType.REPORTPLANAMT, TemplateMetricType.ORIGINALPLANAMT);
    }

    private Predicate<ReportCalcVal> getFilterByTemplateMetricTypes(Map<TemplateMetricType, MetricMember> metricMemberMap, Long metricDimId, TemplateMetricType ... templateMetricTypes) {
        Set metricIdSet = Arrays.stream(templateMetricTypes).map(metricMemberMap::get).filter(Objects::nonNull).map(DimMember::getId).collect(Collectors.toSet());
        return reportCalcVal -> Objects.equals(metricDimId, reportCalcVal.getDimensionId()) && metricIdSet.contains(reportCalcVal.getValue());
    }

    private <T> T getValue(Class<T> clazz, String prop) {
        Object value = this.getModel().getValue(prop);
        if (DynamicObject.class.isInstance(value)) {
            DynamicObject dy = (DynamicObject)value;
            return (T)dy.getPkValue();
        }
        return (T)value;
    }

    private Map<Integer, Set<Integer>> getCurrentColRows(SpreadSelector spreadSelector) {
        int startRow = spreadSelector.getStartRow();
        int endRow = spreadSelector.getEndRow();
        int startCol = spreadSelector.getStartCol();
        int endCol = spreadSelector.getEndCol();
        HashMap<Integer, Set<Integer>> colRows = new HashMap<Integer, Set<Integer>>(4);
        for (int i = startCol; i <= endCol; ++i) {
            Set rows = colRows.computeIfAbsent(i, key -> new HashSet(8));
            for (int j = startRow; j <= endRow; ++j) {
                rows.add(j);
            }
        }
        return colRows;
    }

    private List<CacheCell> getRealCurrentData(Map<Integer, Set<Integer>> colRows, CellDataSource cellDataSource) {
        ArrayList<CacheCell> cacheCellList = new ArrayList<CacheCell>(16);
        for (Map.Entry<Integer, Set<Integer>> entry : colRows.entrySet()) {
            Set<Integer> rows = entry.getValue();
            Integer col = entry.getKey();
            cacheCellList.addAll(rows.stream().map(row -> cellDataSource.getCell(row.intValue(), col.intValue())).collect(Collectors.toList()));
        }
        return cacheCellList;
    }

    private boolean checkCanApproval(List<CacheCell> realCurrentData) {
        Optional<CacheCell> first = realCurrentData.stream().filter(CacheCell::isSummary).findFirst();
        if (first.isPresent()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u6570\u636e\u4e2d\u7684\u5b58\u5728\u6c47\u603b\u5217\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanSumPlugin_18", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        IReportDataManagerV2 manager = this.getOrCreateReportController().getManagerFromCache();
        ReportTemplate reportTemplate = manager.getReportTemplate();
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List allTemplateDim = reportTemplate.getAllTemplateDim();
        TemplateDim templateDimOrg = allTemplateDim.stream().filter(td -> td.getDimType() == DimensionType.ORG).findFirst().get();
        DimLocation location = templateDimOrg.getLocation();
        DynamicObject sumReportOrg = (DynamicObject)this.getModel().getValue("reportorg");
        List<ReportCalcVal> currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List<ReportCalcVal> currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        switch (location) {
            case PAGE: {
                List currPageDimValList = meta.getPageCalcValList();
                Set orgMemberIds = currPageDimValList.stream().filter(rc -> Objects.equals(rc.getDimensionId(), templateDimOrg.getDimensionId())).map(ReportCalcVal::getValue).collect(Collectors.toSet());
                if (orgMemberIds.contains(sumReportOrg.getPkValue())) break;
                FundPlanSystem system = manager.getSystem();
                List allDimMemberList = system.getMainDimensionByDimType(DimensionType.ORG).getAllDimMemberList();
                Object next = orgMemberIds.iterator().next();
                DimMember dimMember = allDimMemberList.stream().filter(dm -> Objects.equals(next, dm.getId())).findFirst().get();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u7684\u6570\u636e\u8fdb\u884c\u6838\u5b9a\uff0c\u5f53\u524d\u9875\u9762\u7ef4\u3010%s\u3011\u4e0d\u662f\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff0c\u8bf7\u5207\u6362\u9875\u9762\u7ef4\u5230\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u518d\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_19", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dimMember.getName()}));
                return false;
            }
            case COL: {
                int col;
                List colOrgDimList = currColDimValList.stream().filter(rc -> Objects.equals(rc.getDimensionId(), templateDimOrg.getDimensionId())).collect(Collectors.toList());
                HashMap<Integer, Object> colOrgMap = new HashMap<Integer, Object>(colOrgDimList.size());
                for (ReportCalcVal src : colOrgDimList) {
                    for (int i = col = src.getCol(); i < col + src.getColSpan(); ++i) {
                        colOrgMap.put(i, src.getValue());
                    }
                }
                for (CacheCell cacheCell : realCurrentData) {
                    col = cacheCell.getCol();
                    Object memberId = colOrgMap.get(col);
                    if (Objects.equals(memberId, sumReportOrg.getPkValue())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u7684\u6570\u636e\u8fdb\u884c\u6838\u5b9a\uff0c\u8bf7\u9009\u62e9\u5217\u7ef4\u4e3a\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u3010%s\u3011\u7684\u6570\u636e\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_20", (String)"tmc-fpm-formplugin", (Object[])new Object[]{sumReportOrg.getString("name")}));
                    return false;
                }
                break;
            }
            case ROW: {
                int row;
                List rowOrgDimList = currRowDimValList.stream().filter(rc -> Objects.equals(rc.getDimensionId(), templateDimOrg.getDimensionId())).collect(Collectors.toList());
                HashMap<Integer, Object> rowOrgMap = new HashMap<Integer, Object>(rowOrgDimList.size());
                for (ReportCalcVal src : rowOrgDimList) {
                    for (int i = row = src.getRow(); i < row + src.getRowSpan(); ++i) {
                        rowOrgMap.put(i, src.getValue());
                    }
                }
                for (CacheCell cacheCell : realCurrentData) {
                    row = cacheCell.getRow();
                    Object memberId = rowOrgMap.get(row);
                    if (Objects.equals(memberId, sumReportOrg.getPkValue())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u7684\u6570\u636e\u8fdb\u884c\u6838\u5b9a\uff0c\u8bf7\u9009\u62e9\u884c\u7ef4\u4e3a\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u3010%s\u3011\u7684\u6570\u636e\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_21", (String)"tmc-fpm-formplugin", (Object[])new Object[]{sumReportOrg.getString("name")}));
                    return false;
                }
                break;
            }
        }
        return this.checkFormulaAndSummary(manager, reportTemplate, currRowDimValList, currColDimValList, realCurrentData);
    }

    private boolean checkFormulaAndSummary(IReportDataManagerV2 manager, ReportTemplate reportTemplate, List<ReportCalcVal> currRowDimValList, List<ReportCalcVal> currColDimValList, List<CacheCell> realCurrentData) {
        TemplateType templateType = reportTemplate.getTemplateType();
        if (templateType == TemplateType.DETAIL) {
            return true;
        }
        List accountSettings = reportTemplate.getAccountSettings();
        if (EmptyUtil.isEmpty((Collection)accountSettings)) {
            return true;
        }
        HashMap<Long, ReportInputType> inputTypeMap = new HashMap<Long, ReportInputType>(32);
        this.getAllFormulaAndSummarySubject(inputTypeMap, accountSettings, null);
        TemplateDim templateDimSubject = reportTemplate.getRowDimList().stream().filter(td -> td.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        List subjectDimList = currRowDimValList.stream().filter(cr -> Objects.equals(cr.getDimensionId(), templateDimSubject.getDimensionId())).collect(Collectors.toList());
        HashMap<Integer, Object> rowSubjectMap = new HashMap<Integer, Object>(subjectDimList.size());
        for (ReportCalcVal src : subjectDimList) {
            int row;
            for (int i = row = src.getRow(); i < row + src.getRowSpan(); ++i) {
                rowSubjectMap.put(i, src.getValue());
            }
        }
        TemplateDim templateDimPeriod = reportTemplate.getColDimList().stream().filter(td -> td.getDimType() == DimensionType.PERIOD).findFirst().get();
        List periodDimList = currColDimValList.stream().filter(cr -> Objects.equals(cr.getDimensionId(), templateDimPeriod.getDimensionId())).collect(Collectors.toList());
        HashMap<Integer, Object> colPeriodMap = new HashMap<Integer, Object>(periodDimList.size());
        for (ReportCalcVal src : periodDimList) {
            int col;
            for (int i = col = src.getCol(); i < col + src.getColSpan(); ++i) {
                colPeriodMap.put(i, src.getValue());
            }
        }
        FundPlanSystem system = manager.getSystem();
        Dimension dimension = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Map subjectMemberMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        Set beginOfTermMemberSet = dimension.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && accountMember.getPeriodDirection() == PeriodDirection.BEGINNING).map(DimMember::getId).collect(Collectors.toSet());
        Report report = this.getReport();
        List sortedPeriodList = report.getCurrentAllPeriodMembers().stream().map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        PeriodMember firstPeriodMember = (PeriodMember)sortedPeriodList.get(0);
        for (CacheCell cacheCell : realCurrentData) {
            Object periodId;
            int row = cacheCell.getRow();
            Object subjectId = rowSubjectMap.get(row);
            DimMember dimMember = (DimMember)subjectMemberMap.get(subjectId);
            if (EmptyUtil.isNoEmpty(beginOfTermMemberSet) && beginOfTermMemberSet.contains(subjectId) && !Objects.equals(periodId = colPeriodMap.get(cacheCell.getCol()), firstPeriodMember.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u79d1\u76ee\u3010%s\u3011\u4e3a\u975e\u7b2c\u4e00\u4e2a\u671f\u95f4\u7684\u671f\u521d\u79d1\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_22", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dimMember.getName()}));
                return false;
            }
            ReportInputType reportInputType = (ReportInputType)inputTypeMap.get(subjectId);
            if (!EmptyUtil.isNoEmpty((Object)reportInputType)) continue;
            if (reportInputType == ReportInputType.SUMMARY || reportInputType == ReportInputType.FORMULA) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u79d1\u76ee\u3010%s\u3011\u4e3a\u6c47\u603b\u9879\u6216\u516c\u5f0f\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_23", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dimMember.getName()}));
                return false;
            }
            if (reportInputType != ReportInputType.DETAIL_INPUT) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u79d1\u76ee\u3010%s\u3011\u660e\u7ec6\u586b\u62a5\uff0c\u8bf7\u5207\u6362\u5230\u5bf9\u5e94\u5b50\u8868\u518d\u8fdb\u884c\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumPlugin_24", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dimMember.getName()}));
            return false;
        }
        return true;
    }

    private void getAllFormulaAndSummarySubject(Map<Long, ReportInputType> inputTypeMap, List<TemplateAccountSetting> accountSettings, Predicate<ReportInputType> predicate) {
        if (EmptyUtil.isEmpty(accountSettings)) {
            return;
        }
        if (predicate == null) {
            predicate = t -> false;
        }
        for (TemplateAccountSetting as : accountSettings) {
            ReportInputType inputType = as.getInputType();
            if (EmptyUtil.isNoEmpty(predicate) && EmptyUtil.isNoEmpty((Object)inputType) && predicate.test(inputType)) continue;
            inputTypeMap.put(as.getAccountMemId(), inputType);
            List children = as.getChildren();
            this.getAllFormulaAndSummarySubject(inputTypeMap, children, predicate);
        }
    }

    private Set<String> getReportIdStrSet(List<CacheCell> realCurrentData) {
        HashSet<String> reportDataIdSet = new HashSet<String>(16);
        for (CacheCell cacheCell : realCurrentData) {
            Object dataId = cacheCell.getDataId();
            if (!List.class.isInstance(dataId)) continue;
            List dataIdList = (List)dataId;
            String reportDataIdStr = dataIdList.stream().sorted(Comparator.comparing(Long::longValue)).map(String::valueOf).collect(Collectors.joining(","));
            reportDataIdSet.add(reportDataIdStr);
        }
        return reportDataIdSet;
    }

    private List<ReportRuleCheckDTO> initRuleCheckDTO(IReportVerifyController verifyController, boolean commit) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String managerJson = this.getCache().get("sumplanbill_reportdata_manager_cache");
        return ReportRuleCheckHelper.initRuleCheckDTOForSumPlan(Collections.singletonList(dataEntity), verifyController, managerJson, Boolean.FALSE, commit);
    }

    private void handleDataVerifyNotify(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!StringUtils.isEmpty((CharSequence)operationResult.getMessage())) {
            this.showSuccessMessage(operationResult.getMessage());
            return;
        }
        InteractionContext interactionContext = operationResult.getInteractionContext();
        if (null == interactionContext) {
            return;
        }
        Map customShowParameter = interactionContext.getCustShowParameter();
        if (CollectionUtils.isEmpty((Map)customShowParameter)) {
            return;
        }
        customShowParameter.put("fromCommit", String.valueOf(false));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        this.getView().showForm(parameter);
    }

    private List<Integer> getEmptyValRows() {
        String reportId = this.getReportId();
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (EmptyUtil.isEmpty((String)reportId) || "0".equals(reportId)) {
            List emptyRows = FpmPageCacheHelper.getCacheDatas((IFormView)this.getView(), (String)"emptyRows", Integer.class);
            if (EmptyUtil.isNoEmpty((Object)emptyRows)) {
                rows.addAll(emptyRows);
            }
        } else {
            rows.addAll(this.getCellDataSource().getAllEmptyValRows());
        }
        return rows;
    }

    public void querySubReportRecord(SpreadEvent spreadEvent) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        Map<Integer, Set<Integer>> currentColRows = this.getCurrentColRows(spreadSelector);
        if (currentColRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\u3002", (String)"ReportPlanSumPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        CellDataSource cellDataSource = this.getCellDataSource();
        CacheCellMeta meta = cellDataSource.getMeta();
        if (!this.checkSelectedDataBeforeQuery(meta)) {
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_plansumsubreport");
        DynamicObject reportOrgDy = (DynamicObject)this.getModel().getValue("reportorg");
        DynamicObject reportPeriodDy = (DynamicObject)this.getModel().getValue("reportperiod");
        String caption = String.format(ResManager.loadKDString((String)"\u8054\u67e5\u4e0b\u7ea7\u8bb0\u5f55\uff1a%1$s\uff08%2$s\uff09", (String)"ReportPlanSumPlugin_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), reportOrgDy.getString("name"), reportPeriodDy.getString("name"));
        formShowParameter.setCaption(caption);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("pageDimMemberIds", this.getPageDimMemberIds());
        formShowParameter.setCustomParam("bodysys", dataEntity.getDynamicObject("bodysys").getPkValue());
        formShowParameter.setCustomParam("reporttype", dataEntity.getDynamicObject("reporttype").getPkValue());
        formShowParameter.setCustomParam("reportorg", dataEntity.getDynamicObject("reportorg").getPkValue());
        formShowParameter.setCustomParam("reportperiod", dataEntity.getDynamicObject("reportperiod").getPkValue());
        formShowParameter.setCustomParam("amountunit", this.getModel().getValue("amountunit"));
        formShowParameter.setCustomParam("innerstatus", (Object)this.getModel().getDataEntity().getString("innerstatus"));
        formShowParameter.setCustomParam("showlimit", this.getModel().getValue("showlimit"));
        formShowParameter.setCustomParam("originalreportids", (Object)this.getModel().getDataEntity().getLong("originalreportids"));
        formShowParameter.setCustomParam("reportSumRecordId", (Object)this.getModel().getDataEntity().getLong("id"));
        DynamicObject exRateTableDy = (DynamicObject)this.getView().getModel().getValue("exratetable");
        Optional.ofNullable(exRateTableDy).ifPresent(arg_0 -> ReportPlanSumPlugin.lambda$querySubReportRecord$81((FormShowParameter)formShowParameter, exRateTableDy, arg_0));
        Date exchangeRateDate = (Date)this.getView().getModel().getValue("exchangeratedate");
        Optional.ofNullable(exchangeRateDate).ifPresent(arg_0 -> ReportPlanSumPlugin.lambda$querySubReportRecord$82((FormShowParameter)formShowParameter, exchangeRateDate, arg_0));
        List<Map<Long, ReportCalcVal>> selectedRowDimList = this.getSelectedDim4SubReport(meta, true, (FormShowParameter)formShowParameter);
        List<Map<Long, ReportCalcVal>> selectedColDimList = this.getSelectedDim4SubReport(meta, false, (FormShowParameter)formShowParameter);
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        DynamicObject reportType = dataEntity.getDynamicObject("reporttype");
        String detailReportType = reportType.getString("orgreporttype");
        boolean containDetailReportType = EmptyUtil.isNoEmpty((String)detailReportType.trim());
        formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        DynamicObjectCollection currencyRangeList = dataEntity.getDynamicObjectCollection("currencyrange");
        List currencyRangePkList = currencyRangeList.stream().map(currency -> (Long)currency.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        formShowParameter.setCustomParam("currencyrange", currencyRangePkList);
        IReportDataManagerV2 managerFromCache = this.getOrCreateReportController().getManagerFromCache();
        FundPlanSystem fundPlanSystem = managerFromCache.getSystem();
        ReportTemplate reportTemplate = managerFromCache.getReportTemplate();
        Set visibleMainDimIdSet = reportTemplate.getAllTemplateDim().stream().filter(TemplateDim::isVisible).filter(tpl -> tpl.getDimType().isMainDimensionType()).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        List hideDimIds = fundPlanSystem.getDimList().stream().filter(dimension -> dimension.getDimType().isMainDimensionType()).map(Dimension::getId).filter(dimId -> !visibleMainDimIdSet.contains(dimId)).collect(Collectors.toList());
        formShowParameter.setCustomParam("hideDimIds", hideDimIds);
        formShowParameter.setCustomParam("sumReportTemplateJson", (Object)FpmSerializeUtil.serialize((Object)reportTemplate));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void linkSearchExecRecord(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataBeforeLinkSearch()) {
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkexecrecord");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("bodysystem", dataEntity.getDynamicObject("bodysys").getPkValue());
        formShowParameter.setCustomParam("reporttype", dataEntity.getDynamicObject("reporttype").getPkValue());
        formShowParameter.setCustomParam("org", Collections.singletonList(dataEntity.getDynamicObject("reportorg").getPkValue()));
        formShowParameter.setCustomParam("period", Collections.singletonList(dataEntity.getDynamicObject("reportperiod").getPkValue()));
        formShowParameter.setCustomParam("amountunit", this.getModel().getValue("amountunit"));
        List<Map<Long, ReportCalcVal>> selectedRowDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
        List<Map<Long, ReportCalcVal>> selectedColDimList = this.getSelectedDim4SubReport(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        formShowParameter.setCustomParam("pageDimMemberIds", this.getPageDimMemberIds());
        formShowParameter.setCustomParam("reportId", (Object)Long.valueOf(dataEntity.getString("originalreportids")));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void linkSearchInOutCollect(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataBeforeLinkSearchInOutCollect()) {
            return;
        }
        List<Long> inOutCollectBillPks = this.getSourceIdsBySelectedDimCombination();
        if (CollectionUtils.isEmpty(inOutCollectBillPks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean billExistFlag = TmcDataServiceHelper.exists((String)"fpm_inoutcollect", (QFilter[])new QFilter("id", "in", inOutCollectBillPks).toArray());
        if (!billExistFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6536\u652f\u8ba1\u5212\u6c60\u91c7\u96c6\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanList_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setReportCellLabel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap10"});
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_inoutcollect").searchFormNumber("fpm_inoutcollect").listFormId("bos_list").searchIds(new ArrayList<Object>(inOutCollectBillPks)).listForm("fpm_inoutcollect").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_IN_OUT_COLLECT).linkSearch(true).extendFunction(formShowParameter -> {
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap19");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeInOutCollectPanel"));
            StyleCss styleCss = Optional.ofNullable(formShowParameter.getOpenStyle().getInlineStyleCss()).orElseGet(() -> new StyleCss());
            styleCss.setHeight("100%");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            return null;
        }).build()));
    }

    /*
     * Exception decompiling
     */
    private boolean checkSelectedDataBeforeQuery(CacheCellMeta meta) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Map<Long, ReportCalcVal>> getSelectedDim4SubReport(CacheCellMeta meta, boolean isRowDim, FormShowParameter formShowParameter) {
        int b2;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        HashMap<Long, Integer> selectedDimIdxMap = new HashMap<Long, Integer>(4);
        HashMap<Long, Boolean> dimIncludeSumMap = new HashMap<Long, Boolean>(4);
        boolean containDetailReportType = false;
        LinkedList queue = new LinkedList();
        int b1 = isRowDim ? spreadSelector.getStartRow() : spreadSelector.getStartCol();
        int n = b2 = isRowDim ? spreadSelector.getEndRow() : spreadSelector.getEndCol();
        if (isRowDim) {
            queue.addAll(meta.getRowDimTree().getRoot().getChildren());
        } else {
            queue.addAll(meta.getColDimTree().getRoot().getChildren());
        }
        while (!queue.isEmpty()) {
            int size = queue.size();
            Map<Object, Object> dimMemberMap = new HashMap(4);
            Boolean includeSum = Boolean.FALSE;
            ReportCalcValTreeNode parentNode = ((ReportCalcValTreeNode)queue.peek()).getParent();
            for (int i = 0; i < size; ++i) {
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = isRowDim ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n2 = a2 = isRowDim ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell()) continue;
                if (!CollectionUtils.isEmpty((Collection)curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (Objects.isNull(curr.getCalcVal().getValue()) && curr.getCalcVal().isSummary()) {
                    includeSum = Boolean.TRUE;
                    continue;
                }
                if (!Objects.nonNull(curr.getCalcVal().getValue())) continue;
                dimMemberMap.putIfAbsent((Long)curr.getCalcVal().getValue(), curr.getCalcVal());
            }
            if (CollectionUtils.isEmpty(dimMemberMap) && includeSum.booleanValue()) {
                dimMemberMap = parentNode.getChildren().stream().filter(node -> !node.getCalcVal().isReferenceCell()).filter(node -> Objects.nonNull(node.getCalcVal().getValue())).collect(Collectors.toMap(key -> (Long)key.getCalcVal().getValue(), val -> val.getCalcVal()));
            }
            if (CollectionUtils.isEmpty(dimMemberMap)) continue;
            Long dimensionId = ((ReportCalcVal)dimMemberMap.values().stream().findAny().get()).getDimensionId();
            if (Objects.nonNull(selectedDimIdxMap.get(dimensionId))) {
                containDetailReportType = true;
            } else {
                selectedDimNodeList.add(dimMemberMap);
                selectedDimIdxMap.forEach((k, v) -> selectedDimIdxMap.put((Long)k, (Integer)selectedDimIdxMap.get(k) + 1));
                selectedDimIdxMap.put(dimensionId, 0);
            }
            dimIncludeSumMap.put(dimensionId, includeSum);
        }
        Map existDimIncludeSumMap = (Map)formShowParameter.getCustomParam("dimIncludeSumMap");
        if (Objects.isNull(existDimIncludeSumMap)) {
            formShowParameter.setCustomParam("dimIncludeSumMap", dimIncludeSumMap);
        } else {
            existDimIncludeSumMap.putAll(dimIncludeSumMap);
            formShowParameter.setCustomParam("dimIncludeSumMap", (Object)existDimIncludeSumMap);
        }
        if (!isRowDim) {
            formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        }
        return selectedDimNodeList;
    }

    private boolean validateSelectRowOrColValid(DimLocation location, ReportCalcValTreeNode root, List<Predicate<ReportCalcValTreeNode>> filterList) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList queue = new LinkedList();
        int b1 = location == DimLocation.ROW ? spreadSelector.getStartRow() : spreadSelector.getStartCol();
        int b2 = location == DimLocation.ROW ? spreadSelector.getEndRow() : spreadSelector.getEndCol();
        queue.addAll(root.getChildren());
        while (!queue.isEmpty()) {
            int size = queue.size();
            boolean result = true;
            for (int i = 0; i < size; ++i) {
                Optional<Predicate> nonPassFilter;
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = location == DimLocation.ROW ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n = a2 = location == DimLocation.ROW ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell()) continue;
                if (!CollectionUtils.isEmpty((Collection)curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (!(nonPassFilter = filterList.stream().filter(filter -> filter.test(curr)).findAny()).isPresent()) continue;
                result = false;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    private boolean checkSelectedDataBeforeLinkSearch() {
        int[] nArray;
        boolean inDataBlock;
        CacheCellMeta meta = this.getCellDS().getMeta();
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartCol = spreadSelector.getStartCol();
        int selectedEndCol = spreadSelector.getEndCol();
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        boolean bl = inDataBlock = selectedStartRow >= meta.getRowOffSet() && selectedEndRow <= meta.getMaxRow() && selectedStartCol >= meta.getColOffSet() && selectedEndCol <= meta.getMaxCol();
        if (!inDataBlock) {
            this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u201c\u975e\u5c0f\u8ba1\u201d\u7684\u8ba1\u5212\u989d\u5ea6\u5355\u5143\u683c\u64cd\u4f5c\u8054\u67e5\u6267\u884c\u8bb0\u5f55", (String)"ReportLinkExecRecordPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
            return false;
        }
        Optional<ReportCalcValTreeNode> remarkColNodeOpt = meta.getColDimTree().getLeafList().stream().filter(calcValTreeNode -> calcValTreeNode.isRemark()).findAny();
        if (remarkColNodeOpt.isPresent()) {
            int[] nArray2 = new int[2];
            nArray2[0] = remarkColNodeOpt.get().getCol();
            nArray = nArray2;
            nArray2[1] = remarkColNodeOpt.get().getColEnd();
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = -1;
            nArray = nArray3;
            nArray3[1] = -1;
        }
        int[] remarkColInterval = nArray;
        for (int i = selectedStartRow; i <= selectedEndRow; ++i) {
            for (int j = selectedStartCol; j <= selectedEndCol; ++j) {
                CacheCell cacheCell = this.getCellDS().getCell(i, j);
                if (!cacheCell.isSummary() && (j < remarkColInterval[0] || j > remarkColInterval[1])) continue;
                this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u201c\u975e\u5c0f\u8ba1\u201d\u7684\u8ba1\u5212\u989d\u5ea6\u5355\u5143\u683c\u64cd\u4f5c\u8054\u67e5\u6267\u884c\u8bb0\u5f55", (String)"ReportLinkExecRecordPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
                return false;
            }
        }
        int selectedCellSize = (selectedEndRow - selectedStartRow + 1) * (selectedEndCol - selectedStartCol + 1);
        if (selectedCellSize > 10) {
            this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u4e00\u6b21\u6700\u591a\u53ef\u652f\u6301\u9009\u62e910\u4e2a\u5355\u5143\u683c\u6570\u503c\u8fdb\u884c\u8054\u67e5\u6267\u884c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportLinkExecRecordPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private void setReportCellLabel() {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        StringBuilder builder = new StringBuilder();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                String pos = ExcelUtils.xy2Pos((int)j, (int)i);
                builder.append(pos);
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.getModel().setValue("reportcell", (Object)builder.toString());
    }

    private boolean checkSelectedDataBeforeLinkSearchInOutCollect() {
        Supplier<String> tipSupplier = () -> ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u5c0f\u8ba1\u884c/\u5217\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u7684\u8ba1\u5212\u989d\u5ea6\u8fdb\u884c\u8054\u67e5", (String)"ReportPlanList_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (!this.validateSelectedDataInDataBlock(tipSupplier)) {
            return false;
        }
        Predicate<CacheCell> nonSummaryAndNonRemark = cacheCell -> !cacheCell.isSummary() && cacheCell.getCellDimType() == CellDimTypeEnum.DATADIMS;
        if (!this.validateSelectedDataCell(tipSupplier, nonSummaryAndNonRemark)) {
            return false;
        }
        tipSupplier = () -> ResManager.loadKDString((String)"\u6279\u91cf\u8054\u67e5\u5355\u5143\u683c\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\uff0c\u8bf7\u786e\u8ba4\u8054\u67e5\u8303\u56f4\u3002", (String)"ReportPlanList_18", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        return this.validateSelectedDataCellSize(tipSupplier, 10);
    }

    private boolean validateSelectedDataInDataBlock(Supplier<String> tipSupplier) {
        boolean colCover;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        boolean rowCover = spreadSelector.getStartRow() >= cacheCellMeta.getRowOffSet() && spreadSelector.getEndRow() <= cacheCellMeta.getMaxRow();
        boolean bl = colCover = spreadSelector.getStartCol() >= cacheCellMeta.getColOffSet() && spreadSelector.getEndCol() <= cacheCellMeta.getMaxCol();
        if (!rowCover || !colCover) {
            this.showErrMessage(Collections.singletonList(tipSupplier.get()));
            return false;
        }
        return true;
    }

    private boolean validateSelectedDataCell(Supplier<String> tipSupplier, Predicate<CacheCell> predicate) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                CacheCell cacheCell = this.getCellDS().getCell(i, j);
                if (predicate.test(cacheCell)) continue;
                this.showErrMessage(Collections.singletonList(tipSupplier.get()));
                return false;
            }
        }
        return true;
    }

    private boolean validateSelectedDataCellSize(Supplier<String> tipSupplier, int maxSelectedSize) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedCellSize = (spreadSelector.getEndRow() - spreadSelector.getStartRow() + 1) * (spreadSelector.getEndCol() - spreadSelector.getStartCol() + 1);
        if (selectedCellSize > maxSelectedSize) {
            this.showErrMessage(Collections.singletonList(tipSupplier.get()));
            return false;
        }
        return true;
    }

    private List<Long> getSourceIdsBySelectedDimCombination() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SourceIdQueryParam queryParam = new SourceIdQueryParam();
        Long systemId = dataEntity.getLong(String.join((CharSequence)".", "bodysys", "id"));
        queryParam.setSystemId(systemId);
        queryParam.setReportOrgId(Long.valueOf(dataEntity.getLong(String.join((CharSequence)".", "reportorg", "id"))));
        queryParam.setReportPeriodId(Long.valueOf(dataEntity.getLong(String.join((CharSequence)".", "reportperiod", "id"))));
        queryParam.setReportTypeId(Long.valueOf(dataEntity.getLong(String.join((CharSequence)".", "reporttype", "id"))));
        List<String> pageDimFields = Arrays.asList("custompagemember1", "custompagemember2", "custompagemember3");
        List reportDataList = ReportHelper.getFixReportSelectedDimCombinationData((CacheCellMeta)this.getCellDS().getMeta(), (DynamicObject)dataEntity, (SpreadSelector)this.getSpreadSelector(), pageDimFields);
        queryParam.setReportDataList(reportDataList);
        queryParam.setTemplateUseType(TemplateUseType.SUMMARY);
        queryParam.setTemplateType(TemplateType.FIXED);
        queryParam.setReportId(Long.valueOf(dataEntity.getLong("originalreportids")));
        IReportDataBizService iReportDataBizService = (IReportDataBizService)FpmServiceFactory.getBizService(IReportDataBizService.class);
        FpmOperateResult operateResult = iReportDataBizService.getSmartGetSourceIds(queryParam);
        if (operateResult.isSuccess()) {
            return (List)operateResult.getData();
        }
        return new ArrayList<Long>(0);
    }

    private static /* synthetic */ boolean lambda$checkSelectedDataBeforeQuery$92(ReportCalcValTreeNode treeNode) {
        return Objects.isNull(treeNode.getCalcVal().getValue()) && treeNode.getCalcVal().isSummary();
    }

    private static /* synthetic */ boolean lambda$checkSelectedDataBeforeQuery$91(ReportCalcValTreeNode treeNode) {
        return Objects.isNull(treeNode.getCalcVal().getValue()) && treeNode.getCalcVal().isSummary() && Objects.equals(treeNode.getCalcVal().getDimensionId(), 0L);
    }

    private static /* synthetic */ int lambda$checkSelectedDataBeforeQuery$90(int[] colDim1, int[] colDim2) {
        if (colDim1[0] == colDim2[0]) {
            return colDim2[1] - colDim1[1];
        }
        return colDim1[0] - colDim2[1];
    }

    private static /* synthetic */ void lambda$querySubReportRecord$82(FormShowParameter formShowParameter, Date exchangeRateDate, Date date) {
        formShowParameter.setCustomParam("exchangeratedate", (Object)exchangeRateDate);
    }

    private static /* synthetic */ void lambda$querySubReportRecord$81(FormShowParameter formShowParameter, DynamicObject exRateTableDy, DynamicObject dy) {
        formShowParameter.setCustomParam("exratetable", exRateTableDy.getPkValue());
    }
}

