/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.SubjectFlowType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.SourceIdQueryParam;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.service.IReportDataBizService;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.export.excel.impl.SumSubReportFormsExportImpl;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.enums.PlanAmtVersionEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.property.SumPlanSubReportProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.lang3.StringUtils;

public class ReportPlanSumSubReportSpreadPlugin
extends AbstractSpreadPlugin
implements BeforeF7SelectListener,
SearchListener,
IAnalysisReportManageView {
    private IAnalysisReportManageController controller;
    private CellDataSource cellDS;

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    protected IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    public void initialize() {
        super.initialize();
        this.initialRegisterListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter.getParentPageId()) || Objects.isNull(formShowParameter.getCustomParams()) || formShowParameter.getCustomParams().size() < 1) {
            return;
        }
        this.getModel().setValue("bodysys", formShowParameter.getCustomParam("bodysys"));
        BasedataEdit currPageDimField = (BasedataEdit)this.getControl("main_dim_member");
        currPageDimField.setCaption(new LocaleString(DimsionEnums.ORG.getName()));
        this.getPageCache().put("main_dim_member", DimsionEnums.ORG.getNumber());
        this.getPageCache().put("reportperiod", formShowParameter.getCustomParam("reportperiod").toString());
        this.initialPageDimFilter();
        this.initialRowDimFilter();
        this.initialColDimFilter();
        this.initialHideDimFilter();
        this.getPageCache().put("showlimit", formShowParameter.getCustomParam("showlimit").toString());
        this.getPageCache().put("dimIncludeSumMap", JSON.toJSONString((Object)formShowParameter.getCustomParam("dimIncludeSumMap")));
        String amountUnit = (String)formShowParameter.getCustomParam("amountunit");
        this.getModel().setValue("amountunit", (Object)amountUnit);
        Optional.ofNullable(formShowParameter.getCustomParam("exratetable")).ifPresent(id -> this.getModel().setValue("exratetable", id));
        Optional.ofNullable(formShowParameter.getCustomParam("exchangeratedate")).ifPresent(exchangeRateDate -> this.getModel().setValue("exchangeratedate", exchangeRateDate));
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4"});
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHINOUTCOLLECT);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
        List reportPlanSumCurrencyRangePkList = (List)this.getView().getFormShowParameter().getCustomParam("currencyrange");
        this.getPageCache().put("currencyrange", JSON.toJSONString((Object)reportPlanSumCurrencyRangePkList));
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "main_dim_member": 
            case "filter_01": 
            case "filter_02": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, null);
                break;
            }
            case "custompagemember1": 
            case "custompagemember2": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimLocation.PAGE);
                break;
            }
            case "filter_row_01": 
            case "filter_row_02": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimLocation.ROW);
                break;
            }
            case "filter_col_01": 
            case "filter_col_02": 
            case "filter_col_03": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimLocation.COL);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        switch (event.getActionId()) {
            case "closeInOutCollectPanel": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4"});
                break;
            }
        }
    }

    public void linkSearchInOutCollect(SpreadEvent spreadEvent) {
        if (!this.checkSelectedDataBeforeLinkSearchInOutCollect()) {
            return;
        }
        List<Long> inOutCollectBillPks = this.getSourceIdsBySelectedDimCombination();
        if (kd.bos.util.CollectionUtils.isEmpty(inOutCollectBillPks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"ReportPlanList_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean billExistFlag = TmcDataServiceHelper.exists((String)"fpm_inoutcollect", (QFilter[])new QFilter("id", "in", inOutCollectBillPks).toArray());
        if (!billExistFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6536\u652f\u8ba1\u5212\u6c60\u91c7\u96c6\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanList_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setReportCellLabel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap4"});
        this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_inoutcollect").searchFormNumber("fpm_inoutcollect").listFormId("bos_list").searchIds(new ArrayList<Object>(inOutCollectBillPks)).listForm("fpm_inoutcollect").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_IN_OUT_COLLECT).linkSearch(true).extendFunction(formShowParameter -> {
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap7");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeInOutCollectPanel"));
            StyleCss styleCss = Optional.ofNullable(formShowParameter.getOpenStyle().getInlineStyleCss()).orElseGet(() -> new StyleCss());
            styleCss.setHeight("100%");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            return null;
        }).build()));
    }

    private void initMultipleListFilterVal4F7Select(BeforeF7SelectEvent beforeF7SelectEvent, DimLocation dimLocation) {
        String jsonStr;
        DimsionEnums dimEnum;
        Long dimId;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String dimType = this.getPageCache().get(fieldKey);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long systemId = (Long)formShowParameter.getCustomParam("bodysys");
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)dimType).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        String dimIdStr = this.getPageCache().get(String.format("sumplan:subreport:prop:dimid:%s", fieldKey));
        Long l = dimId = StringUtils.isNotEmpty((CharSequence)dimIdStr) ? Long.valueOf(dimIdStr) : null;
        if (Objects.nonNull(dimId)) {
            qFilter.and("dimension", "=", (Object)dimId);
        }
        if (DimsionEnums.ORG == (dimEnum = DimsionEnums.getDimsionByNumber((String)dimType))) {
            Long sumPlanOrgId = (Long)formShowParameter.getCustomParam("reportorg");
            List<Long> validOrgIds = this.getSumPlanOrgAllMember(systemId, sumPlanOrgId);
            qFilter.and("id", "in", validOrgIds);
        } else if (DimsionEnums.CURRENCY == dimEnum) {
            List reportPlanSumCurrencyRangePkList = (List)formShowParameter.getCustomParam("currencyrange");
            qFilter.and("id", "in", (Object)reportPlanSumCurrencyRangePkList);
        } else if (DimsionEnums.PERIOD == dimEnum && DimLocation.COL == dimLocation) {
            List<Long> originalReportPeriodIds = this.getSumPlanOriginalReportPeriodIds();
            qFilter.and("id", "in", originalReportPeriodIds);
        } else if (DimLocation.COL == dimLocation && StringUtils.isNotEmpty((CharSequence)(jsonStr = (String)formShowParameter.getCustomParam("sumReportTemplateJson"))) && Objects.nonNull(dimId)) {
            ReportTemplate reportTemplate = (ReportTemplate)FpmSerializeUtil.deserialize((String)jsonStr, ReportTemplate.class);
            List colTplDimMemberScope = reportTemplate.getColDimList().stream().filter(tpl -> Objects.equals(tpl.getDimensionId(), dimId)).map(TemplateDim::getMemberScope).flatMap(Collection::stream).collect(Collectors.toList());
            qFilter.and("id", "in", colTplDimMemberScope);
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void refreshBook(Book book) {
        if (null == book) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(invoker, book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        spreadCommand.execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void refreshAnalysisBook(Book book) {
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate reportTemplate) {
    }

    public void search(SearchEvent searchEvent) {
        AnalysisHeader tAnalysisHeader;
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        boolean success = this.getAnalysisHeader(reportQueryParam, tAnalysisHeader = new AnalysisHeader());
        if (!success) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hideemptyrow", "bar_print"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"hideemptyrow", "bar_print"});
        this.getOrCreateReportController().loadSumPlanSubReport(tAnalysisHeader);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxcol");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxrow");
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElse(""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "hideemptyrow": {
                this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getCellDS().getAllEmptyValRows());
                break;
            }
            case "showemptyrow": {
                this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getCellDS().getAllEmptyValRows());
                break;
            }
            case "exportexcel": {
                AnalysisHeader header = new AnalysisHeader();
                boolean success = this.getAnalysisHeader(null, header);
                if (!success) {
                    return;
                }
                FpmPageCacheService cacheService = new FpmPageCacheService(this.getPageCache().getPageId());
                this.getCache().getAll().forEach((arg_0, arg_1) -> ReportPlanSumSubReportSpreadPlugin.lambda$afterDoOperation$6((IFpmPageCacheService)cacheService, arg_0, arg_1));
                SumSubReportFormsExportImpl exportExcel = new SumSubReportFormsExportImpl(header, (IFpmPageCacheService)cacheService);
                Tuple exportResult = exportExcel.export();
                if (((Boolean)exportResult.item1).booleanValue()) {
                    this.getView().download((String)exportResult.item2);
                    break;
                }
                this.showErrMessage(Collections.singletonList(exportResult.item2));
                break;
            }
            case "print": {
                this.getSpreadCommandInvoker().print();
                break;
            }
        }
    }

    private void initialRegisterListener() {
        for (String prop : SumPlanSubReportProp.DIM_MEMBER_FILTER_FIELD_LIST) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(prop);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
    }

    private void initialPageDimFilter() {
        for (String customPageMemberField : SumPlanSubReportProp.customPageMemberFieldList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{customPageMemberField});
            ((FieldEdit)this.getView().getControl(customPageMemberField)).setMustInput(false);
        }
        List pageDimMemberIds = (List)this.getView().getFormShowParameter().getCustomParam("pageDimMemberIds");
        int left = 0;
        int right = 0;
        while (left < pageDimMemberIds.size() && right < SumPlanSubReportProp.customPageMemberFieldList.size()) {
            DynamicObject dimMemberDy = TmcDataServiceHelper.loadSingleFromCache(pageDimMemberIds.get(left), (String)"fpm_member", (String)String.join((CharSequence)",", "id", "dimtype", "dimension.id"));
            String dimType = dimMemberDy.getString("dimtype");
            DimsionEnums dimTypeEnum = DimsionEnums.getDimsionByNumber((String)dimType);
            if (DimsionEnums.ORG == dimTypeEnum || DimsionEnums.METRIC == dimTypeEnum) {
                ++left;
                continue;
            }
            String prop = (String)SumPlanSubReportProp.customPageMemberFieldList.get(right);
            this.getModel().setValue(prop, pageDimMemberIds.get(left));
            this.getView().setVisible(Boolean.TRUE, new String[]{prop});
            ((FieldEdit)this.getView().getControl(prop)).setMustInput(true);
            Long dimId = dimMemberDy.getLong("dimension.id");
            BasedataEdit currPageDimField = (BasedataEdit)this.getControl(prop);
            currPageDimField.setCaption(new LocaleString(this.getCaption(dimTypeEnum, dimId)));
            this.getPageCache().put(prop, dimTypeEnum.getNumber());
            this.getPageCache().put(String.format("sumplan:subreport:prop:dimid:%s", prop), String.valueOf(dimId));
            this.pageCacheMapDim2Field(dimTypeEnum.getNumber(), prop);
            this.getPageCache().put(String.format("sumplan:subreport:dim:location:%s", dimId), DimLocation.PAGE.toString());
            ++left;
            ++right;
        }
    }

    private void initialRowDimFilter() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_row_01", "filter_row_02"});
        List selectedRowDimList = (List)this.getView().getFormShowParameter().getCustomParam("selectedRowDimList");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)selectedRowDimList)) {
            int idx = 1;
            for (Map rowDimValMap : selectedRowDimList) {
                String pkValStr = (String)rowDimValMap.keySet().stream().findAny().get();
                DynamicObject dimMemberDy = TmcDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(pkValStr), (String)"fpm_member", (String)String.join((CharSequence)",", "id", "dimtype", "dimension.id"));
                String dimType = dimMemberDy.getString("dimtype");
                DimsionEnums dimTypeEnum = DimsionEnums.getDimsionByNumber((String)dimType);
                if (DimsionEnums.ORG == dimTypeEnum || DimsionEnums.METRIC == dimTypeEnum) continue;
                if (idx > 2) break;
                String fieldKey = String.format("filter_row_0%s", idx);
                this.getModel().setValue(fieldKey, (Object)rowDimValMap.keySet().stream().map(Long::valueOf).toArray());
                this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
                Long dimId = dimMemberDy.getLong("dimension.id");
                BasedataEdit filterDim = (BasedataEdit)this.getControl(fieldKey);
                filterDim.setCaption(new LocaleString(this.getCaption(dimTypeEnum, dimId)));
                this.getPageCache().put(fieldKey, dimTypeEnum.getNumber());
                this.getPageCache().put(String.format("sumplan:subreport:prop:dimid:%s", fieldKey), String.valueOf(dimId));
                this.pageCacheMapDim2Field(dimTypeEnum.getNumber(), fieldKey);
                this.getPageCache().put(String.format("sumplan:subreport:dim:location:%s", dimId), DimLocation.ROW.toString());
                this.getPageCache().put(String.format("sumplan:subreport:dim:level:%s", dimId), String.valueOf(idx));
                ++idx;
            }
            this.getPageCache().put("sumplan:subreport:dim:max:level", String.valueOf(idx - 1));
        }
    }

    private void initialColDimFilter() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_col_01", "filter_col_02", "filter_col_03"});
        List selectedColDimList = (List)this.getView().getFormShowParameter().getCustomParam("selectedColDimList");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)selectedColDimList)) {
            int idx = 1;
            for (Map colDimValMap : selectedColDimList) {
                String pkValStr = (String)colDimValMap.keySet().stream().findAny().get();
                DynamicObject dimMemberDy = TmcDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(pkValStr), (String)"fpm_member", (String)String.join((CharSequence)",", "id", "dimtype", "dimension.id"));
                String dimType = dimMemberDy.getString("dimtype");
                DimsionEnums dimTypeEnum = DimsionEnums.getDimsionByNumber((String)dimType);
                if (DimsionEnums.ORG == dimTypeEnum || DimsionEnums.METRIC == dimTypeEnum) continue;
                if (idx > 3) break;
                String fieldKey = String.format("filter_col_0%s", idx);
                this.getModel().setValue(fieldKey, (Object)colDimValMap.keySet().stream().map(Long::valueOf).toArray());
                this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
                Long dimId = dimMemberDy.getLong("dimension.id");
                BasedataEdit filterDim = (BasedataEdit)this.getControl(fieldKey);
                filterDim.setCaption(new LocaleString(this.getCaption(dimTypeEnum, dimId)));
                this.getPageCache().put(fieldKey, dimTypeEnum.getNumber());
                this.getPageCache().put(String.format("sumplan:subreport:prop:dimid:%s", fieldKey), String.valueOf(dimId));
                this.pageCacheMapDim2Field(dimTypeEnum.getNumber(), fieldKey);
                this.getPageCache().put(String.format("sumplan:subreport:dim:location:%s", dimId), DimLocation.COL.toString());
                this.getPageCache().put(String.format("sumplan:subreport:dim:level:%s", dimId), String.valueOf(idx));
                ++idx;
            }
            if (Objects.isNull(this.getPageCache().get(DimsionEnums.METRIC.getNumber()))) {
                Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam("bodysys");
                QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("basedata", "=", (Object)DimsionEnums.METRIC.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
                DynamicObject metricDimDy = QueryServiceHelper.queryOne((String)"fpm_dimension", (String)"id", (QFilter[])qFilter.toArray());
                Long metricDimId = metricDimDy.getLong("id");
                this.getPageCache().put(String.format("sumplan:subreport:dim:location:%s", metricDimId), DimLocation.COL.toString());
                this.getPageCache().put(String.format("sumplan:subreport:dim:level:%s", metricDimId), String.valueOf(idx));
            }
        }
    }

    private void initialHideDimFilter() {
        for (String otherDimField : SumPlanSubReportProp.HIDE_DIM_FILTER_FIELD_LIST) {
            this.getView().setVisible(Boolean.FALSE, new String[]{otherDimField});
            ((FieldEdit)this.getView().getControl(otherDimField)).setMustInput(false);
        }
        List hideDimIds = (List)this.getView().getFormShowParameter().getCustomParam("hideDimIds");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)hideDimIds)) {
            for (int idx = 0; idx < hideDimIds.size() && idx < SumPlanSubReportProp.HIDE_DIM_FILTER_FIELD_LIST.size(); ++idx) {
                String prop = (String)SumPlanSubReportProp.HIDE_DIM_FILTER_FIELD_LIST.get(idx);
                this.getView().setVisible(Boolean.TRUE, new String[]{prop});
                Long dimId = (Long)hideDimIds.get(idx);
                DynamicObject dimDy = TmcDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"fpm_dimension", (String)String.join((CharSequence)",", "name", "basedata"));
                BasedataEdit filterDim = (BasedataEdit)this.getControl(prop);
                filterDim.setCaption(new LocaleString(dimDy.getString("name")));
                String dimType = dimDy.getString("basedata");
                this.getPageCache().put(prop, dimType);
                this.getPageCache().put(String.format("sumplan:subreport:prop:dimid:%s", prop), String.valueOf(dimId));
                this.pageCacheMapDim2Field(dimType, prop);
            }
        }
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader tAnalysisHeader) {
        String settlementMethodField;
        String companyField;
        String currencyField;
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        List tFilterItems = reportQueryParam.getFilter().getFilterItems();
        Map<String, Object> tFilterItemMap = tFilterItems.stream().filter(v -> v.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (a, b) -> a));
        for (String pageDimField : SumPlanSubReportProp.customPageMemberFieldList) {
            String pageDimType = this.getPageCache().get(pageDimField);
            if (EmptyUtil.isEmpty((String)pageDimType) || !Objects.isNull(tFilterItemMap.get(pageDimField))) continue;
            this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"ReportPlanSummaryPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
            return false;
        }
        DynamicObject bodySystemDy = (DynamicObject)tFilterItemMap.get("bodysys");
        Long systemId = bodySystemDy.getLong("id");
        tAnalysisHeader.setBodySystemId(systemId);
        ArrayList reportOrgIds = this.getBaseDataVal4AnalysisHeader(tFilterItemMap, "main_dim_member");
        reportOrgIds = kd.bos.util.CollectionUtils.isEmpty(reportOrgIds) ? new ArrayList(0) : reportOrgIds;
        tAnalysisHeader.setOrg(reportOrgIds);
        tAnalysisHeader.setSumReportOrg((Long)this.getView().getFormShowParameter().getCustomParam("reportorg"));
        int queryDataSize = EmptyUtil.isEmpty(reportOrgIds) ? 1 : reportOrgIds.size();
        List<String> customRowDimFields = Arrays.asList("filter_row_01", "filter_row_02");
        ArrayList<DimsionEnums> errMsgParamList = new ArrayList<DimsionEnums>(4);
        errMsgParamList.add(DimsionEnums.ORG);
        for (String rowDimField : customRowDimFields) {
            String rowDimType = this.getPageCache().get(rowDimField);
            if (EmptyUtil.isEmpty((String)rowDimType)) continue;
            DimsionEnums rowDimEnum = DimsionEnums.getDimsionByNumber((String)rowDimType);
            errMsgParamList.add(rowDimEnum);
            List<Long> rowDimFieldValues = this.getBaseDataVal4AnalysisHeader(tFilterItemMap, rowDimField);
            if (EmptyUtil.isEmpty(rowDimFieldValues)) {
                QFilter qFilter = new QFilter("bodysystem", "=", bodySystemDy.getPkValue()).and("dimtype", "=", (Object)rowDimType);
                DynamicObjectCollection rowDimMemberColl = QueryServiceHelper.query((String)rowDimEnum.getMetadata(), (String)"id", (QFilter[])qFilter.toArray());
                queryDataSize = EmptyUtil.isEmpty((DynamicObjectCollection)rowDimMemberColl) ? queryDataSize : queryDataSize * rowDimMemberColl.size();
                continue;
            }
            queryDataSize *= rowDimFieldValues.size();
        }
        if (queryDataSize > 10000) {
            String errMsgParam1 = errMsgParamList.stream().map(DimsionEnums::getName).collect(Collectors.joining("*"));
            String errMsgParam2 = errMsgParamList.stream().map(DimsionEnums::getName).collect(Collectors.joining("\u3001", "\u201c", "\u201d"));
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6240\u9700\u67e5\u8be2\u6570\u636e\u91cf\u884c\u6570\uff08%1$s\u6210\u5458\u6570\u4e0d\u53ef\u5927\u4e8e%2$s\u884c\uff09\uff1b\u8bf7\u68c0\u67e5%3$s\u8fc7\u6ee4\u6761\u4ef6\uff0c\u51cf\u5c11\u9700\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"ReportPlanSumSubReportSpreadPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMsgParam1, 10000, errMsgParam2);
            this.showErrMessage(Collections.singletonList(errorMsg));
            return false;
        }
        String dimType = (String)tFilterItemMap.get("dimtype");
        tAnalysisHeader.setDimType(dimType);
        Long reportTypePk = (Long)this.getView().getFormShowParameter().getCustomParam("reporttype");
        tAnalysisHeader.setReportTypeId(reportTypePk);
        tAnalysisHeader.setPlannversion(PlanAmtVersionEnum.EFFECTIVEVERSION.getValue());
        String amountUnit = (String)this.getView().getFormShowParameter().getCustomParam("amountunit");
        tAnalysisHeader.setAmountUnit(AmountUnit.getByNumber((String)amountUnit));
        tAnalysisHeader.setReportSumId((Long)this.getView().getFormShowParameter().getCustomParam("originalreportids"));
        tAnalysisHeader.setReportSumRecordId((Long)this.getView().getFormShowParameter().getCustomParam("reportSumRecordId"));
        tAnalysisHeader.setInternalOffsetState((String)this.getView().getFormShowParameter().getCustomParam("innerstatus"));
        tAnalysisHeader.setFlow(SubjectFlowType.NONLIMIT.getNumber());
        tAnalysisHeader.setContainDetailReportType(((Boolean)this.getView().getFormShowParameter().getCustomParam("containdetailreporttype")).booleanValue());
        tAnalysisHeader.setDisplaycurrency(false);
        Long exchangeRateTableId = (Long)this.getView().getFormShowParameter().getCustomParam("exratetable");
        Optional.ofNullable(exchangeRateTableId).ifPresent(id -> tAnalysisHeader.setExchangeRateTableId(id));
        String exchangeRateDateStr = (String)this.getView().getFormShowParameter().getCustomParam("exchangeratedate");
        Optional.ofNullable(exchangeRateDateStr).ifPresent(str -> tAnalysisHeader.setExchangeRateDate(DateUtils.stringToDate((String)str, (String)"yyyy-MM-dd HH:mm:ss")));
        String periodField = this.getPageCache().get(DimsionEnums.PERIOD.getNumber());
        if (Objects.nonNull(periodField) && Objects.nonNull(tFilterItemMap.get(periodField))) {
            tAnalysisHeader.setPeriodId(this.getBaseDataVal4AnalysisHeader(tFilterItemMap, periodField));
        } else {
            tAnalysisHeader.setPeriodId(this.getSumPlanOriginalReportPeriodIds());
        }
        String subjectField = this.getPageCache().get(DimsionEnums.SUBJECT.getNumber());
        if (Objects.nonNull(subjectField) && Objects.nonNull(tFilterItemMap.get(subjectField))) {
            tAnalysisHeader.setSubjects(this.getBaseDataVal4AnalysisHeader(tFilterItemMap, subjectField));
        }
        if (Objects.nonNull(currencyField = this.getPageCache().get(DimsionEnums.CURRENCY.getNumber())) && Objects.nonNull(tFilterItemMap.get(currencyField))) {
            List<Long> currencyIds = this.getBaseDataVal4AnalysisHeader(tFilterItemMap, currencyField);
            tAnalysisHeader.setCurrency(currencyIds);
        }
        if (Objects.nonNull(companyField = this.getPageCache().get(DimsionEnums.COMPANY.getNumber())) && Objects.nonNull(tFilterItemMap.get(companyField))) {
            tAnalysisHeader.setCompany(this.getBaseDataVal4AnalysisHeader(tFilterItemMap, companyField));
        }
        if (Objects.nonNull(settlementMethodField = this.getPageCache().get(DimsionEnums.SETLTMENT.getNumber())) && Objects.nonNull(tFilterItemMap.get(settlementMethodField))) {
            tAnalysisHeader.setSettlementMethod(this.getBaseDataVal4AnalysisHeader(tFilterItemMap, settlementMethodField));
        }
        tAnalysisHeader.setCustomDimension(this.dealCustomDim4Header(tFilterItemMap, systemId));
        return true;
    }

    private void pageCacheMapDim2Field(String dimNumber, String field) {
        if (DimsionEnums.CUSTOM.getNumber().equals(dimNumber)) {
            String customDimFieldJson = this.getPageCache().get(dimNumber);
            List<String> customDimFields = Objects.isNull(customDimFieldJson) ? new ArrayList(3) : JSON.parseArray((String)customDimFieldJson, String.class);
            customDimFields.add(field);
            this.getPageCache().put(dimNumber, JSON.toJSONString(customDimFields));
            return;
        }
        this.getPageCache().put(dimNumber, field);
    }

    private List<Long> getBaseDataVal4AnalysisHeader(Map<String, Object> tFilterItemMap, String field) {
        if (SumPlanSubReportProp.customPageMemberFieldList.contains(field)) {
            DynamicObject dynamicObject = (DynamicObject)tFilterItemMap.get(field);
            if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                return new ArrayList<Long>(0);
            }
            ArrayList<Long> fieldValues = new ArrayList<Long>(1);
            fieldValues.add((Long)dynamicObject.getPkValue());
            return fieldValues;
        }
        DynamicObjectCollection multiBaseDataColl = (DynamicObjectCollection)tFilterItemMap.get(field);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)multiBaseDataColl)) {
            return new ArrayList<Long>(0);
        }
        return multiBaseDataColl.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
    }

    private List<Long> getSumPlanOriginalReportPeriodIds() {
        Long originalReportId = (Long)this.getView().getFormShowParameter().getCustomParam("originalreportids");
        String prop = "periodlist.fbasedataid.id";
        DynamicObjectCollection reportPeriodDyColl = QueryServiceHelper.query((String)"fpm_report_process", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)originalReportId)});
        return reportPeriodDyColl.stream().map(dy -> dy.getLong(prop)).collect(Collectors.toList());
    }

    private List<Long> getSumPlanOrgAllMember(Long systemId, Long sumPlanOrgId) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and("id", "<>", (Object)sumPlanOrgId).and("parent", ">", (Object)0L);
        DynamicObjectCollection orgDyColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,parent.id", (QFilter[])qFilter.toArray());
        HashMap<Long, List> parent2SubOrgMap = new HashMap<Long, List>(8, 1.0f);
        for (DynamicObject orgDy : orgDyColl) {
            Long parentOrgId = orgDy.getLong("parent.id");
            Long orgId = orgDy.getLong("id");
            List subOrgList = parent2SubOrgMap.computeIfAbsent(parentOrgId, val -> new LinkedList());
            subOrgList.add(orgId);
        }
        ArrayList<Long> validOrgIds = new ArrayList<Long>(10);
        validOrgIds.add(sumPlanOrgId);
        ArrayDeque<Long> stack = new ArrayDeque<Long>();
        stack.addLast(sumPlanOrgId);
        while (!stack.isEmpty()) {
            Long curParentOrgId = (Long)stack.pollLast();
            if (!parent2SubOrgMap.containsKey(curParentOrgId)) continue;
            List curSubOrgIdList = (List)parent2SubOrgMap.get(curParentOrgId);
            validOrgIds.addAll(curSubOrgIdList);
            stack.addAll(curSubOrgIdList);
        }
        return validOrgIds;
    }

    private String getCaption(DimsionEnums dimType, Long dimId) {
        if (Objects.equals(DimsionEnums.CURRENCY, dimType)) {
            return ResManager.loadKDString((String)"\u6c47\u603b\u5e01\u79cd", (String)"ReportPlanSumSubReportSpreadPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        DynamicObject dimDy = TmcDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"fpm_dimension", (String)"name");
        return dimDy.getString("name");
    }

    private Map<String, List<Long>> dealCustomDim4Header(Map<String, Object> tFilterItemMap, Long systemId) {
        String customDimFieldJson = this.getPageCache().get(DimsionEnums.CUSTOM.getNumber());
        if (Objects.isNull(customDimFieldJson)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Long>> customMember = new HashMap<String, List<Long>>(8);
        QFilter memberFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimensionType.CUSTOM.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        String dimensionIdProp = String.join((CharSequence)".", "dimension", "id");
        DynamicObjectCollection allCustomMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", dimensionIdProp), (QFilter[])memberFilter.toArray());
        QFilter dimFilter = new QFilter("bodysystem", "=", (Object)systemId).and("basedata", "=", (Object)DimensionType.CUSTOM.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        DynamicObjectCollection allCustomDimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])dimFilter.toArray());
        List customDimFields = JSON.parseArray((String)customDimFieldJson, String.class);
        for (String customDimField : customDimFields) {
            String dimNumber;
            Long dimId;
            Long curDimVal;
            if (Objects.isNull(tFilterItemMap.get(customDimField))) continue;
            List<Long> memberIds = new ArrayList<Long>(5);
            if (SumPlanSubReportProp.customPageMemberFieldList.contains(customDimField)) {
                DynamicObject customDimValDy = (DynamicObject)tFilterItemMap.get(customDimField);
                curDimVal = customDimValDy.getLong("id");
                dimId = allCustomMemberColl.stream().filter(member -> {
                    Long memberId = member.getLong("id");
                    return memberId.compareTo(curDimVal) == 0;
                }).map(member -> member.getLong(dimensionIdProp)).findAny().get();
                dimNumber = allCustomDimColl.stream().filter(dim -> {
                    Long curDimId = dim.getLong("id");
                    return curDimId.compareTo(dimId) == 0;
                }).map(dim -> dim.getString("number")).findAny().get();
                memberIds.add(customDimValDy.getLong("id"));
            } else {
                DynamicObjectCollection customDimValList = (DynamicObjectCollection)tFilterItemMap.get(customDimField);
                curDimVal = ((DynamicObject)customDimValList.get(0)).getLong("id");
                dimId = allCustomMemberColl.stream().filter(member -> {
                    Long memberId = member.getLong("id");
                    return memberId.compareTo(curDimVal) == 0;
                }).map(member -> member.getLong(dimensionIdProp)).findAny().get();
                dimNumber = allCustomDimColl.stream().filter(dim -> {
                    Long curDimId = dim.getLong("id");
                    return curDimId.compareTo(dimId) == 0;
                }).map(dim -> dim.getString("number")).findAny().get();
                memberIds = customDimValList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            }
            customMember.put(dimNumber, memberIds);
        }
        return customMember;
    }

    private void setReportCellLabel() {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        StringBuilder builder = new StringBuilder();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                String pos = ExcelUtils.xy2Pos((int)j, (int)i);
                builder.append(pos);
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.getModel().setValue("reportcell", (Object)builder.toString());
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    private boolean checkSelectedDataBeforeLinkSearchInOutCollect() {
        IntPredicate selectedSummaryColPredicate;
        Supplier<String> tipSupplier = () -> ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u5c0f\u8ba1\u884c/\u5217\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u7684\u8ba1\u5212\u989d\u5ea6\u8fdb\u884c\u8054\u67e5", (String)"ReportPlanList_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (!this.validateSelectedDataInDataBlock(tipSupplier)) {
            return false;
        }
        IntPredicate selectedSummaryRowPredicate = ReportHelper.getSummaryRowPredicate((List)this.getCellDS().getMeta().getRowDimTree().getRoot().getAllChildren());
        if (!this.validateSelectedDataCell(tipSupplier, selectedSummaryRowPredicate, selectedSummaryColPredicate = ReportHelper.getSummaryColPredicate((List)this.getCellDS().getMeta().getColDimTree().getRoot().getAllChildren()))) {
            return false;
        }
        tipSupplier = () -> ResManager.loadKDString((String)"\u6279\u91cf\u8054\u67e5\u5355\u5143\u683c\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\uff0c\u8bf7\u786e\u8ba4\u8054\u67e5\u8303\u56f4\u3002", (String)"ReportPlanList_18", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        return this.validateSelectedDataCellSize(tipSupplier, 10);
    }

    private boolean validateSelectedDataInDataBlock(Supplier<String> tipSupplier) {
        boolean colCover;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        boolean rowCover = spreadSelector.getStartRow() >= cacheCellMeta.getRowOffSet() && spreadSelector.getEndRow() <= cacheCellMeta.getMaxRow();
        boolean bl = colCover = spreadSelector.getStartCol() >= cacheCellMeta.getColOffSet() && spreadSelector.getEndCol() <= cacheCellMeta.getMaxCol();
        if (!rowCover || !colCover) {
            this.showErrMessage(Collections.singletonList(tipSupplier.get()));
            return false;
        }
        return true;
    }

    private boolean validateSelectedDataCell(Supplier<String> tipSupplier, IntPredicate rowPredicate, IntPredicate colPredicate) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                if (!rowPredicate.test(i) && !colPredicate.test(j)) continue;
                this.showErrMessage(Collections.singletonList(tipSupplier.get()));
                return false;
            }
        }
        return true;
    }

    private boolean validateSelectedDataCellSize(Supplier<String> tipSupplier, int maxSelectedSize) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedCellSize = (spreadSelector.getEndRow() - spreadSelector.getStartRow() + 1) * (spreadSelector.getEndCol() - spreadSelector.getStartCol() + 1);
        if (selectedCellSize > maxSelectedSize) {
            this.showErrMessage(Collections.singletonList(tipSupplier.get()));
            return false;
        }
        return true;
    }

    private List<Long> getSourceIdsBySelectedDimCombination() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SourceIdQueryParam queryParam = new SourceIdQueryParam();
        Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam("bodysys");
        queryParam.setSystemId(systemId);
        Long sumPlanOrgId = (Long)this.getView().getFormShowParameter().getCustomParam("reportorg");
        queryParam.setReportOrgId(sumPlanOrgId);
        Long reportPeriodId = (Long)this.getView().getFormShowParameter().getCustomParam("reportperiod");
        queryParam.setReportPeriodId(reportPeriodId);
        Long reportTypePk = (Long)this.getView().getFormShowParameter().getCustomParam("reporttype");
        queryParam.setReportTypeId(reportTypePk);
        List reportDataList = ReportHelper.getFixReportSelectedDimCombinationData((CacheCellMeta)this.getCellDS().getMeta(), (DynamicObject)dataEntity, (SpreadSelector)this.getSpreadSelector(), (List)SumPlanSubReportProp.customPageMemberFieldList);
        queryParam.setReportDataList(reportDataList);
        queryParam.setTemplateUseType(TemplateUseType.ANALYSIS);
        queryParam.setTemplateType(TemplateType.FIXED);
        queryParam.setReportId((Long)this.getView().getFormShowParameter().getCustomParam("originalreportids"));
        IReportDataBizService iReportDataBizService = (IReportDataBizService)FpmServiceFactory.getBizService(IReportDataBizService.class);
        FpmOperateResult operateResult = iReportDataBizService.getSmartGetSourceIds(queryParam);
        if (operateResult.isSuccess()) {
            return (List)operateResult.getData();
        }
        return new ArrayList<Long>(0);
    }

    private static /* synthetic */ void lambda$afterDoOperation$6(IFpmPageCacheService cacheService, String k, String v) {
        cacheService.put(k, v);
    }
}

