/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.export.excel.impl.SummaryFormsExportImpl;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.PlanVersionEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class ReportPlanSummaryPlugin
extends AbstractSpreadPlugin
implements SearchListener,
IAnalysisReportManageView {
    private IAnalysisReportManageController controller;

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxcol");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxrow");
    }

    public void initialize() {
        super.initialize();
        this.initF7();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("exportexcel".equals(opKey)) {
            AnalysisHeader header = new AnalysisHeader();
            boolean success = this.getAnalysisHeader(null, header);
            if (!success) {
                return;
            }
            SummaryFormsExportImpl exportExcel = new SummaryFormsExportImpl(header);
            Tuple exportResult = exportExcel.export();
            if (((Boolean)exportResult.item1).booleanValue()) {
                this.getView().download((String)exportResult.item2);
            } else {
                this.showErrMessage(Collections.singletonList(exportResult.item2));
            }
        } else if ("refresh".equals(opKey)) {
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
        } else if ("print".equals(opKey)) {
            this.getSpreadCommandInvoker().print();
        } else if ("showemptyrow".equals(opKey)) {
            this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getEmptyValRows());
        } else if ("hideemptyrow".equals(opKey)) {
            this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getEmptyValRows());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        new InitialToolbarAndRightKeyItemGenerator(null, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_plansummary");
        if (EmptyUtil.isNoEmpty((Long)systemId)) {
            this.initBodySystem(systemId);
        }
    }

    private void initBodySystem(Object bodysysId) {
        Optional<DynamicObject> rerporttype;
        DynamicObject bodysystem = BusinessDataServiceHelper.loadSingle((Object)bodysysId, (String)"fpm_bodysysmanage");
        if (bodysystem == null) {
            return;
        }
        this.getModel().setValue("bodysystem", bodysystem.getPkValue());
        DynamicObjectCollection dimtypes = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("number", "not in", (Object)new Object[]{DimensionType.PERIOD.getNumber(), DimensionType.CURRENCY.getNumber(), DimensionType.SUBJECTS.getNumber(), DimensionType.METRIC.getNumber()})}, (String)"id");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(0);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company", "settlementmethod"});
        for (DynamicObject dimtype : dimtypes) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(dimtype.getString("number"));
            comboItem.setCaption(new LocaleString(dimtype.getString("name")));
            comboItems.add(comboItem);
            if (DimensionType.COMPANY.getNumber().equals(comboItem.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
                continue;
            }
            if (!DimensionType.SETTLEMENT_TYPE.getNumber().equals(comboItem.getValue())) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"settlementmethod"});
        }
        ((ComboEdit)this.getControl("dimtype")).setComboItems(comboItems);
        if (comboItems.size() > 0) {
            this.getModel().setValue("dimtype", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
        if ((rerporttype = bodysystem.getDynamicObjectCollection("applyrereportentry").stream().filter(item -> "enable".equals(item.getString("rereporttypestatus"))).map(item -> item.getDynamicObject("rerporttype")).findFirst()).isPresent()) {
            this.getModel().setValue("reporttype", rerporttype.get().getPkValue());
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            filter.and("reporttype", "=", rerporttype.get().getPkValue());
            filter.and("periodtype", "=", (Object)rerporttype.get().getString("orgreportcycle"));
            filter.and("startdate", "<=", (Object)new Date());
            DynamicObjectCollection periodMems = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"longnumber desc");
            if (periodMems != null && periodMems.size() > 0) {
                this.getModel().setValue("period", (Object)new Long[]{((DynamicObject)periodMems.get(0)).getLong("id")});
            }
        }
        DynamicObject targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", bodysystem.getDynamicObject("currency").getPkValue()), new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()), new QFilter("bodysystem", "=", bodysystem.getPkValue())});
        this.getModel().setValue("reportcurrency", (Object)Optional.ofNullable(targetCurrency).map(o -> o.getLong("id")).orElseGet(() -> null));
    }

    private void initF7() {
        IDataModel model = this.getModel();
        BasedataEdit bodysystemEdit = (BasedataEdit)this.getControl("bodysystem");
        bodysystemEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter systemAuthFilter = ModelHelper.getSystemAuthWithCheckManagerFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_plansummary");
            showParameter.getListFilterParameter().setFilter(systemAuthFilter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportTypeEdit = (BasedataEdit)this.getControl("reporttype");
        reportTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            List rerporttypeids = bodysystem.getDynamicObjectCollection("applyrereportentry").stream().map(v -> v.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", rerporttypeids);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject reporttype = (DynamicObject)model.getValue("reporttype");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            if (reporttype == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u62a5\u7c7b\u578b\u3002", (String)"ReportPlanSummaryPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            filter.and("reporttype", "=", reporttype.getPkValue());
            if (PeriodType.MONTH_WEEK.getNumber().equals(reporttype.getString("orgreportcycle"))) {
                filter.and("periodtype", "in", (Object)new Object[]{PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
            } else {
                filter.and("periodtype", "in", (Object)new Object[]{reporttype.getString("orgreportcycle")});
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            filter.and(ModelHelper.getOrgAuthWithCheckManagerFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_plansummary"));
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit subjectsEdit = (BasedataEdit)this.getControl("subjects");
        subjectsEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String flow = (String)model.getValue("flow");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            ArrayList<String> flows = new ArrayList<String>(3);
            flows.add(flow);
            if (FlowEnum.NONLIMIT.getValue().equals(flow)) {
                flows.add(FlowEnum.INFLOW.getValue());
                flows.add(FlowEnum.OUTFLOW.getValue());
            }
            filter.and("flow", "in", flows);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        currencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportCurrencyEdit = (BasedataEdit)this.getControl("reportcurrency");
        reportCurrencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit companyEdit = (BasedataEdit)this.getControl("company");
        companyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit settlementmethodEdit = (BasedataEdit)this.getControl("settlementmethod");
        settlementmethodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
        this.handleCustomDimension();
    }

    public IReportView getView() {
        return (IReportView)super.getView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        Object oldValue = changedata.getOldValue();
        if (oldValue != newValue) {
            if ("bodysystem".equals(propName)) {
                if (newValue == null) {
                    return;
                }
                this.getModel().setValue("reporttype", null);
                this.getModel().setValue("period", null);
                this.getModel().setValue("org", null);
                this.getModel().setValue("flow", (Object)FlowEnum.NONLIMIT.getValue());
                this.getModel().setValue("subjects", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("company", null);
                this.getModel().setValue("settlementmethod", null);
                this.getModel().setValue("containdetailreporttype", (Object)false);
                this.getModel().setValue("plannversion", (Object)PlanVersionEnum.NEW_VERSION.getValue());
                DynamicObject bodysystem = (DynamicObject)newValue;
                this.initBodySystem(bodysystem.getPkValue());
                this.getModel().setValue("custommember1", null);
                this.getModel().setValue("custommember2", null);
                this.getModel().setValue("custommember3", null);
                this.handleCustomDimension();
                DefaultModelHelper.save((Long)bodysystem.getPkValue());
            } else if ("dimtype".equals(propName)) {
                FlowEnum[] flows = new FlowEnum[]{FlowEnum.INFLOW, FlowEnum.OUTFLOW, FlowEnum.NONLIMIT};
                if (DimensionType.SUBJECTS.getNumber().equals(newValue)) {
                    flows = new FlowEnum[]{FlowEnum.BALANCE, FlowEnum.INFLOW, FlowEnum.OUTFLOW, FlowEnum.NONLIMIT};
                }
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
                for (FlowEnum dimtype : flows) {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setValue(dimtype.getValue());
                    comboItem.setCaption(new LocaleString(dimtype.getName()));
                    comboItems.add(comboItem);
                }
                ((ComboEdit)this.getControl("flow")).setComboItems(comboItems);
                this.getModel().setValue("flow", (Object)FlowEnum.NONLIMIT.getValue());
            } else if ("reporttype".equals(propName)) {
                DynamicObject reporttype = (DynamicObject)newValue;
                DynamicObject bodysystem = (DynamicObject)this.getModel().getValue("bodysystem");
                if (bodysystem == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"ReportPlanSummaryPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
                if (reporttype == null) {
                    return;
                }
                QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("reporttype", "=", reporttype.getPkValue());
                filter.and("periodtype", "=", (Object)reporttype.getString("orgreportcycle"));
                filter.and("startdate", "<=", (Object)new Date());
                filter.and("enable", "=", (Object)true);
                DynamicObjectCollection periodMems = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"longnumber desc");
                if (periodMems != null && periodMems.size() > 0) {
                    this.getModel().setValue("period", (Object)new Long[]{((DynamicObject)periodMems.get(0)).getLong("id")});
                } else {
                    this.getModel().setValue("period", null);
                }
            } else if ("flow".equals(propName)) {
                if (!FlowEnum.NONLIMIT.getValue().equals(newValue)) {
                    DynamicObjectCollection subjectList = new DynamicObjectCollection();
                    for (DynamicObject subject : (DynamicObjectCollection)this.getModel().getValue("subjects")) {
                        if (!subject.getString("fbasedataid.flow").equals(newValue)) continue;
                        subjectList.add((Object)subject);
                    }
                    if (subjectList.size() < 1) {
                        subjectList = null;
                    }
                    this.getModel().setValue("subjects", (Object)subjectList);
                }
            } else if ("amountunit".equals(propName)) {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.addSearchListener((SearchListener)this);
                control.search();
            }
        }
    }

    public void search(SearchEvent evt) {
        AnalysisHeader tAnalysisHeader;
        ReportQueryParam reportQueryParam = evt.getRepotParam();
        boolean success = this.getAnalysisHeader(reportQueryParam, tAnalysisHeader = new AnalysisHeader());
        if (!success) {
            return;
        }
        this.getOrCreateReportController().loadAnalysisReport(AnalysisReportType.MULTI, tAnalysisHeader);
        this.getModel().setValue("amountunit", (Object)tAnalysisHeader.getAmountUnit().getNumber());
        this.getModel().setValue("exratetable", (Object)tAnalysisHeader.getExchangeRateTableId());
        this.getModel().setValue("exchangeratedate", (Object)tAnalysisHeader.getExchangeRateDate());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "exportexcel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"print"});
    }

    protected IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    public void refreshBook(Book book) {
        if (null == book) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(invoker, book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        spreadCommand.execCommand();
        Map<Integer, List<Cell>> rowCellMap = book.getSheet().getCellList().stream().filter(o -> o.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.groupingBy(Cell::getRow));
        List rows = rowCellMap.entrySet().stream().filter(o -> ((List)o.getValue()).stream().noneMatch(cell -> EmptyUtil.isNoEmpty((Object)cell.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"emptyRows", rows);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void refreshAnalysisBook(Book book) {
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate template) {
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader tAnalysisHeader) {
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        List tFilterItems = reportQueryParam.getFilter().getFilterItems();
        Map<String, Object> tFilterItemMap = tFilterItems.stream().filter(v -> v.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, o -> o.getValue(), (a, b) -> a));
        DynamicObject bodysystem = (DynamicObject)tFilterItemMap.get("bodysystem");
        String dimtype = (String)tFilterItemMap.get("dimtype");
        DynamicObject reporttype = (DynamicObject)tFilterItemMap.get("reporttype");
        DynamicObjectCollection period = (DynamicObjectCollection)tFilterItemMap.get("period");
        DynamicObject reportcurrency = (DynamicObject)tFilterItemMap.get("reportcurrency");
        String plannversion = (String)tFilterItemMap.get("plannversion");
        DynamicObjectCollection org = (DynamicObjectCollection)tFilterItemMap.get("org");
        if (bodysystem == null || dimtype == null || reporttype == null || period == null || reportcurrency == null || plannversion == null || org == null) {
            this.showErrMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"ReportPlanSummaryPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
            return false;
        }
        tAnalysisHeader.setBodySystemId(Long.valueOf(bodysystem.getLong("id")));
        List periodIds = period.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        tAnalysisHeader.setPeriodId(periodIds);
        String amountunit = (String)this.getModel().getValue("amountunit");
        tAnalysisHeader.setAmountUnit(AmountUnit.getByNumber((String)amountunit));
        String flow = (String)tFilterItemMap.get("flow");
        boolean containdetailreporttype = (Boolean)tFilterItemMap.get("containdetailreporttype");
        boolean displaycurrency = (Boolean)tFilterItemMap.get("displaycurrency");
        DynamicObjectCollection subjects = (DynamicObjectCollection)tFilterItemMap.get("subjects");
        DynamicObjectCollection currency = (DynamicObjectCollection)tFilterItemMap.get("currency");
        DynamicObjectCollection company = (DynamicObjectCollection)tFilterItemMap.get("company");
        DynamicObjectCollection settlementmethod = (DynamicObjectCollection)tFilterItemMap.get("settlementmethod");
        String state = null != tFilterItemMap.get("internaloffsetstate") ? tFilterItemMap.get("internaloffsetstate").toString() : InternalOffsetStateType.BEFOREOFFSET.getNumber();
        tAnalysisHeader.setInternalOffsetState(state);
        tAnalysisHeader.setDimType(dimtype);
        tAnalysisHeader.setFlow(flow);
        tAnalysisHeader.setPlannversion(plannversion);
        tAnalysisHeader.setReportTypeId(Long.valueOf(reporttype.getLong("id")));
        tAnalysisHeader.setReportCurrency(Long.valueOf(reportcurrency.getLong("id")));
        tAnalysisHeader.setContainDetailReportType(containdetailreporttype);
        tAnalysisHeader.setDisplaycurrency(displaycurrency);
        if (Objects.nonNull(org)) {
            List orgIds = org.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            tAnalysisHeader.setOrg(orgIds);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgAuthScope = ModelHelper.getOrgAuthScopeWithCheckManager((String)appId, (String)"fpm_report");
            if (!CollectionUtils.isEmpty((Collection)orgAuthScope)) {
                tAnalysisHeader.setOrg(orgAuthScope);
            }
        }
        if (Objects.nonNull(subjects)) {
            List subjectsIds = subjects.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            tAnalysisHeader.setSubjects(subjectsIds);
        }
        if (Objects.nonNull(currency)) {
            List currencyIds = currency.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            tAnalysisHeader.setCurrency(currencyIds);
        }
        if (Objects.nonNull(company)) {
            List companyIds = company.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            tAnalysisHeader.setCompany(companyIds);
        }
        if (Objects.nonNull(settlementmethod)) {
            List settlementmethodIds = settlementmethod.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            tAnalysisHeader.setSettlementMethod(settlementmethodIds);
        }
        this.fillCustomMap(tAnalysisHeader, tFilterItemMap, bodysystem);
        return true;
    }

    private void fillCustomMap(AnalysisHeader tAnalysisHeader, Map<String, Object> tFilterItemMap, DynamicObject bodysystem) {
        Object custom1 = tFilterItemMap.get("custommember1");
        Object custom2 = tFilterItemMap.get("custommember2");
        Object custom3 = tFilterItemMap.get("custommember3");
        if (Objects.isNull(custom1) && Objects.isNull(custom2) && Objects.isNull(custom3)) {
            return;
        }
        String selectProp = "id,number,basedata,memberfrom,relbasedata";
        DynamicObject[] customDimension = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodysystem.getPkValue()), new QFilter("basedata", "=", (Object)DimsionEnums.CUSTOM.getNumber())});
        if (customDimension.length <= 0) {
            return;
        }
        Map dimMap = Arrays.stream(customDimension).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        Set<Long> dimIds = dimMap.keySet().stream().map(i -> Long.valueOf(i.toString())).collect(Collectors.toSet());
        QFilter memberQuery = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("dimension", "in", dimIds).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] memberObjs = BusinessDataServiceHelper.load((String)"fpm_member", (String)"id,dimension", (QFilter[])new QFilter[]{memberQuery});
        if (memberObjs.length <= 0) {
            return;
        }
        HashMap<String, List<Long>> customMember = new HashMap<String, List<Long>>(8);
        Map<Object, List<DynamicObject>> memberMap = Arrays.stream(memberObjs).collect(Collectors.groupingBy(i -> i.getLong("dimension.id")));
        dimIds.forEach(id -> {
            DynamicObject dim = (DynamicObject)dimMap.get(id);
            List members = (List)memberMap.get(id);
            if (!CollectionUtils.isEmpty((Collection)members)) {
                List memIds = members.stream().map(i -> i.getLong("id")).collect(Collectors.toList());
                customMember.put(dim.getString("number"), memIds);
            }
        });
        this.handleCustomHeader(customMember, (DynamicObjectCollection)tFilterItemMap.get("custommember1"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)tFilterItemMap.get("custommember2"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)tFilterItemMap.get("custommember3"));
        tAnalysisHeader.setCustomDimension(customMember);
    }

    private void handleCustomHeader(Map<String, List<Long>> customMember, DynamicObjectCollection custom) {
        if (!CollectionUtils.isEmpty((Collection)custom)) {
            DynamicObject dimension = (DynamicObject)((DynamicObject)custom.get(0)).get("dimension");
            List memberIds = custom.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            customMember.put(dimension.getString("number"), memberIds);
        }
    }

    private void handleCustomDimension() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"custommember1", "custommember2", "custommember3"});
        DynamicObject bodysystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (bodysystem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        String selectProp = "id,number,basedata,memberfrom,relbasedata";
        DynamicObject[] customDimension = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodysystem.getPkValue()), new QFilter("basedata", "=", (Object)DimsionEnums.CUSTOM.getNumber())});
        if (customDimension.length <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        int index = 1;
        for (DynamicObject dimension : customDimension) {
            String customName = "custommember" + index;
            String name = dimension.getString("name");
            String dimType = dimension.getString("basedata");
            Object dimId = dimension.getPkValue();
            BasedataEdit mulBasedataEdit = (BasedataEdit)this.getControl(customName);
            mulBasedataEdit.setCaption(new LocaleString(name));
            mulBasedataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", dimId).and("dimtype", "=", (Object)dimType).and("bodysystem", "=", bodysystem.getPkValue()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            String customName = "custommember" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{customName});
            this.getModel().setValue(customName, null);
        }
    }

    private List<Integer> getEmptyValRows() {
        return FpmPageCacheHelper.getCacheDatas((IFormView)this.getView(), (String)"emptyRows", Integer.class);
    }
}

