/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.sumplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.report.EvalReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecordMore;
import kd.tmc.fpm.business.domain.model.sumplan.EvaluateAmtDetailParam;
import kd.tmc.fpm.business.domain.model.sumplan.EvaluateAmtParam;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.controller.IEvaluateAmtController;
import kd.tmc.fpm.business.mvc.controller.impl.EvaluateAmtControllerImpl;
import kd.tmc.fpm.business.mvc.service.dto.EvalLoadParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtInfoResultDTO;
import kd.tmc.fpm.business.mvc.view.IEvaluateView;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.property.EvaluateAmtProp;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.lang3.tuple.Pair;

public class EvaluateAmtPlugin
extends AbstractFormPlugin
implements IEvaluateView {
    private IEvaluateAmtController evaluateAmtController;
    private static final String TREE_TAB = "  ";
    private static final String MUTEX_LOCK_CACHE_KEY = "MUTEX_LOCK_CACHE_KEY";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadData();
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                int row = evt.getRow();
                if (row == -1) {
                    return;
                }
                DynamicObjectCollection entryEntity = EvaluateAmtPlugin.this.getModel().getEntryEntity("entryentity");
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                boolean needLoad = dynamicObject.getBoolean("entry_needload");
                if (needLoad) {
                    Long sumRecordId = (Long)EvaluateAmtPlugin.this.getModel().getValue("sumrecordid");
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entry_summarycurrencymap");
                    List currencyIds = EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection) ? Collections.emptyList() : dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
                    EvaluateAmtPlugin.this.getOrCreate().loadWaitApprovedAmountAmtInfo(WaitApprovedAmountAmtDTO.builder().sumRecordId(sumRecordId).allSubOrgId(EvaluateAmtPlugin.this.getAllSubReportOrgIds()).reportDataIdStr(dynamicObject.getString("entry_sumreportdataids")).approvalId(Long.valueOf(dynamicObject.getLong("entry_sumapprovalid"))).currencyIds(currencyIds).currencyId((Long)dynamicObject.getDynamicObject("entry_currency").getPkValue()).build());
                }
            }
        });
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
        subEntryGrid.addHyperClickListener(hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject sumEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("entryentity").get(currentIndex);
            DynamicObject dynamicObject = (DynamicObject)sumEntry.getDynamicObjectCollection("subentryentity").get(rowIndex);
            String fillWay = dynamicObject.getString("eval_fillway");
            if (Objects.equals(fillWay, ReportInputType.DETAIL_INPUT.getNumber())) {
                this.openDetailForm(sumEntry, Collections.singletonList(dynamicObject));
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "batchevaldetail": {
                this.batchEvalDetail();
                break;
            }
            case "refresh": {
                this.loadData();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (EmptyUtil.isNoEmpty((Object)operationResult) && !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": {
                ApprovedAmountRecord amountRecord = this.getApprovedAmountRecord();
                this.getOrCreate().save(amountRecord);
            }
        }
    }

    public void initialize(ApprovedAmountRecordMore record) {
        ApprovedAmountRecord amountRecord = record.getRecord();
        if (this.isFromSearch()) {
            this.initHead(amountRecord);
        }
        List subReportOrgIdS = record.getAllSubOrgIds();
        this.getModel().setValue("subreportorg", (Object)subReportOrgIdS.toArray());
        Report sumPlanReport = record.getSumPlanReport();
        ReportTemplate template = sumPlanReport.getTemplate();
        List allTemplateDim = template.getAllTemplateDim();
        Map customDimSeqMap = record.getCustomDimSeqMap();
        Set dimNumberSet = allTemplateDim.stream().filter(templateDim -> !templateDim.isDetailDim()).map(templateDim -> {
            if (templateDim.getDimType().isCustomDim()) {
                return templateDim.getDimType().getNumber() + "_" + customDimSeqMap.get(templateDim.getDimensionId());
            }
            return templateDim.getDimType().getNumber();
        }).collect(Collectors.toSet());
        List reportDataList = record.getReportDataList();
        List amountAmtInfoList = amountRecord.getAmountAmtInfoList();
        Map amtInfoMap = EmptyUtil.isEmpty((Collection)amountAmtInfoList) ? Collections.emptyMap() : amountAmtInfoList.stream().collect(Collectors.toMap(ApprovedAmountAmtInfo::getReportDataId, Function.identity()));
        this.getModel().deleteEntryData("entryentity");
        if (EmptyUtil.isEmpty((Collection)reportDataList)) {
            return;
        }
        Map currencyListMap = record.getCurrencyListMap();
        int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", reportDataList.size());
        int index = 0;
        HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(8);
        AmountUnitEnum approvedDefaultAmtUnitEnum = AmountUnitEnum.get((String)((String)this.getModel().getValue("amtunit")));
        for (EvalReportData reportData : reportDataList) {
            List dimList = reportData.getDimList();
            List dimValList = reportData.getDimValList();
            int rowIndex = index;
            this.setEntryMemberField(visibleMap, num -> dimNumberSet.contains(num), dimList, dimValList, EvaluateAmtProp.SUM_ENTRY_DIM_TYPE_FIELD_MAP, record.getCustomDimSeqMap(), pair -> this.getModel().setValue((String)pair.getLeft(), pair.getRight(), rows[rowIndex]));
            ApprovedAmountAmtInfo approvedAmountAmtInfo = (ApprovedAmountAmtInfo)amtInfoMap.get(reportData.getApprovalReportDataId());
            Long currencyId = (Long)reportData.getDimValByDimType(DimensionType.CURRENCY, null);
            List currencyList = currencyListMap.getOrDefault(currencyId, new ArrayList(2));
            if (!currencyList.contains(currencyId)) {
                currencyList.add(currencyId);
            }
            if (EmptyUtil.isNoEmpty((Object)currencyList)) {
                this.getModel().setValue("entry_summarycurrencymap", (Object)currencyList.toArray(new Long[0]), rows[index]);
            }
            this.getModel().setValue("entry_sumapprovalid", (Object)reportData.getApprovalReportDataId(), rows[index]);
            this.getModel().setValue("entry_sumreportdataids", (Object)reportData.getReportDataIdStr(), rows[index]);
            this.getModel().setValue("entry_needload", (Object)Boolean.TRUE, rows[index]);
            AmountUnitEnum dataAmtUnitEnum = AmountUnit.convert((AmountUnit)reportData.getAmountUnit());
            BigDecimal reportPlanAmt = AmountUtil.convert((AmountUnitEnum)dataAmtUnitEnum, (AmountUnitEnum)approvedDefaultAmtUnitEnum, (BigDecimal)reportData.getReportPlanAmt());
            this.getModel().setValue("entry_reportamt", (Object)reportPlanAmt, rows[index]);
            BigDecimal evaluateAmt = EmptyUtil.isEmpty((Object)approvedAmountAmtInfo) ? reportData.getOriginalPlanAmt() : approvedAmountAmtInfo.getApprovedAmt();
            evaluateAmt = AmountUtil.convert((AmountUnitEnum)dataAmtUnitEnum, (AmountUnitEnum)approvedDefaultAmtUnitEnum, (BigDecimal)evaluateAmt);
            this.getModel().setValue("entry_evaluateamt", (Object)evaluateAmt, rows[index++]);
        }
        for (String filed : EvaluateAmtProp.SUM_ENTRY_DIM_TYPE_FIELD_MAP.values()) {
            if (Objects.equals(Boolean.TRUE, visibleMap.get(filed))) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{filed});
        }
        Long systemId = ((DynamicObject)this.getModel().getValue("bodysys")).getLong("id");
        DynamicObjectCollection dimDyColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "name", "basedata"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId)});
        this.setCustomDimFieldName(EvaluateAmtProp.SUM_ENTRY_DIM_TYPE_FIELD_MAP, dimDyColl, record.getCustomDimSeqMap());
        this.getView().updateView("entryentity");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().invokeOperation("refresh");
        this.getView().updateView("subentryentity");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "batchevaldetail": {
                this.reloadSubEntry();
            }
        }
    }

    public void initializeSubEntry(List<WaitApprovedAmountAmtInfoResultDTO> resultList) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(currentRowIndex);
        DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("subentryentity");
        for (int i = dynamicObjectCollection.size() - 1; i >= 0; --i) {
            this.getModel().deleteEntryRow("subentryentity", i);
        }
        BigDecimal totalEvalAmt = BigDecimal.ZERO;
        Map<Long, DynamicObject> subMemberLevelMap = this.getSubMemberObjectMap();
        List<WaitApprovedAmountAmtInfoResultDTO> sortedResult = resultList.stream().sorted(Comparator.comparing(this::getScore)).collect(Collectors.toList());
        HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(8);
        totalEvalAmt = this.addSubEntry(currentRowIndex, totalEvalAmt, subMemberLevelMap, sortedResult, visibleMap);
        this.getModel().setValue("entry_evaluateamt", (Object)totalEvalAmt, currentRowIndex);
        this.getModel().setValue("entry_needload", (Object)Boolean.FALSE, currentRowIndex);
        this.getView().updateView("entry_evaluateamt", currentRowIndex);
        Long systemId = ((DynamicObject)this.getModel().getValue("bodysys")).getLong("id");
        DynamicObjectCollection dimDyColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "name", "basedata"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId)});
        this.setSubEntryDimTypeFieldVisible(visibleMap, dimDyColl, EmptyUtil.isEmpty(resultList) ? this.loadCustomDimSeqMap(systemId) : resultList.get(0).getCustomDimSeqMap());
        this.setCustomDimFieldName(EvaluateAmtProp.EVAL_ENTRY_DIM_TYPE_FIELD_MAP, dimDyColl, EmptyUtil.isEmpty(resultList) ? this.loadCustomDimSeqMap(systemId) : resultList.get(0).getCustomDimSeqMap());
    }

    public boolean isFromSearch() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String from = (String)formShowParameter.getCustomParam("from");
        return Objects.equals(from, "linkSearch");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "eval_evaluateamt": {
                this.upperSum(e);
            }
        }
    }

    public void showErrMessage(List<String> errMessageList) {
        this.getView().showErrorNotification(errMessageList.stream().collect(Collectors.joining(";")));
    }

    public void showSuccessMessage(String successMessage) {
        this.getView().showSuccessNotification(successMessage);
    }

    private void loadData() {
        if (!this.isFromSearch()) {
            this.setHead();
        }
        EvaluateAmtParam evaluateAmtParam = this.getEvaluateAmtParam();
        this.getOrCreate().load(EvalLoadParamDTO.builder().sumRecordId(evaluateAmtParam.getSumRecordId()).sumOrgId(evaluateAmtParam.getSumReportOrgId()).systemId(evaluateAmtParam.getSystemId()).reportTypeId(evaluateAmtParam.getReportTypeId()).reportDataIdList(evaluateAmtParam.getReportDataIdList()).build());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.selectRows(0);
            entryGrid.entryRowClick(Integer.valueOf(0));
        }
    }

    private void initHead(ApprovedAmountRecord recordRecord) {
        this.getModel().setValue("bodysys", (Object)recordRecord.getSystemId());
        this.getModel().setValue("sumtype", (Object)recordRecord.getSummaryt());
        this.getModel().setValue("sumreportorg", (Object)recordRecord.getMember());
        this.getModel().setValue("reporttype", (Object)recordRecord.getOrgReportType());
        this.getModel().setValue("reportperiod", (Object)recordRecord.getOrgReportPeriod());
        this.getModel().setValue("ratetable", (Object)recordRecord.getExRateTable());
        this.getModel().setValue("ratedate", (Object)recordRecord.getExRateDate());
        this.getModel().setValue("amtunit", (Object)AmountUnitEnum.ONE.getValue());
        this.getModel().setValue("sumrecordid", (Object)recordRecord.getSumPlanRecordId());
        this.getModel().setValue("billno", (Object)recordRecord.getNumber());
    }

    private void setSubEntryDimTypeFieldVisible(Map<String, Boolean> visibleMap, DynamicObjectCollection dimDyColl, Map<Long, Integer> customDimSeqMap) {
        Set dimTypeNumberSet = dimDyColl.stream().map(dy -> {
            if (Objects.equals(DimensionType.CUSTOM.getNumber(), dy.getString("basedata"))) {
                Long dimId = dy.getLong("id");
                return DimensionType.CUSTOM.getNumber() + "_" + customDimSeqMap.get(dimId);
            }
            return dy.getString("basedata");
        }).collect(Collectors.toSet());
        EvaluateAmtProp.EVAL_ENTRY_DIM_TYPE_FIELD_MAP.forEach((number, field) -> {
            boolean fieldMustVisible;
            if (Objects.equals(Boolean.TRUE, visibleMap.get(field))) {
                return;
            }
            boolean bl = fieldMustVisible = dimTypeNumberSet.contains(number) && (Objects.equals(number, DimensionType.COMPANY.getNumber()) || Objects.equals(number, DimensionType.SETTLEMENT_TYPE.getNumber()) || number.indexOf(DimensionType.CUSTOM.getNumber()) == 0);
            if (fieldMustVisible) {
                visibleMap.put((String)field, Boolean.TRUE);
                this.getView().setVisible(Boolean.TRUE, new String[]{field});
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{field});
        });
    }

    private BigDecimal addSubEntry(int currentIndex, BigDecimal totalEvalAmt, Map<Long, DynamicObject> subMemberLevelMap, List<WaitApprovedAmountAmtInfoResultDTO> sortedResult, Map<String, Boolean> visibleMap) {
        if (EmptyUtil.isEmpty(sortedResult)) {
            return totalEvalAmt;
        }
        AmountUnitEnum evaluateDefaultAmtUnitEnum = AmountUnitEnum.get((String)((String)this.getModel().getValue("amtunit")));
        for (WaitApprovedAmountAmtInfoResultDTO result : sortedResult) {
            int index = this.getModel().createNewEntryRow("subentryentity");
            ReportData reportData = result.getReportData();
            List dimList = reportData.getDimList();
            List dimValList = reportData.getDimValList();
            this.setEntryMemberField(visibleMap, null, dimList, dimValList, EvaluateAmtProp.EVAL_ENTRY_DIM_TYPE_FIELD_MAP, result.getCustomDimSeqMap(), pair -> this.getModel().setValue((String)pair.getLeft(), pair.getRight(), index, currentIndex));
            Long orgMemberId = (Long)reportData.getDimValByDimType(DimensionType.ORG, null);
            DynamicObject subOrg = subMemberLevelMap.get(orgMemberId);
            this.getModel().setValue("eval_reportorgname", (Object)this.getTreeTabName(result.getLevel(), subOrg.getString("name")), index, currentIndex);
            this.getModel().setValue("eval_fillway", (Object)result.getFillWay(), index, currentIndex);
            this.getModel().setValue("eval_formulamem", (Object)result.isSubFormula(), index, currentIndex);
            this.getModel().setValue("eval_childtemplateid", (Object)result.getChildTemplateId(), index, currentIndex);
            AmountUnitEnum dataAmtUnitEnum = AmountUnit.convert((AmountUnit)reportData.getAmountUnit());
            BigDecimal reportPlanAmt = AmountUtil.convert((AmountUnitEnum)dataAmtUnitEnum, (AmountUnitEnum)evaluateDefaultAmtUnitEnum, (BigDecimal)reportData.getReportPlanAmt());
            this.getModel().setValue("eval_reportamt", (Object)reportPlanAmt, index, currentIndex);
            if (result.getLevel() == 1) {
                totalEvalAmt = totalEvalAmt.add(this.getTargetCurrencyAmt(result.getEvaluateAmt(), reportData, currentIndex));
            }
            BigDecimal evaluateAmt = AmountUtil.convert((AmountUnitEnum)dataAmtUnitEnum, (AmountUnitEnum)evaluateDefaultAmtUnitEnum, (BigDecimal)result.getEvaluateAmt());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"eval_evaluateamt", (Object)evaluateAmt, (int)index, (int)currentIndex);
            BigDecimal originalApprovalAmt = AmountUtil.convert((AmountUnitEnum)dataAmtUnitEnum, (AmountUnitEnum)evaluateDefaultAmtUnitEnum, (BigDecimal)result.getOriginalEvaluateAmt());
            this.getModel().setValue("eval_originalapprovalamt", (Object)originalApprovalAmt, index, currentIndex);
            this.getModel().setValue("eval_amtunit", (Object)evaluateDefaultAmtUnitEnum.getValue(), index, currentIndex);
            this.getModel().setValue("eval_evaladjustreason", (Object)result.getEvalAdjustReason(), index, currentIndex);
            this.getModel().setValue("eval_reportdataid", (Object)reportData.getId(), index, currentIndex);
            this.getModel().setValue("eval_planreportid", (Object)reportData.getReportId(), index, currentIndex);
            this.getModel().setValue("eval_planreportnumber", (Object)result.getReport().getNumber(), index, currentIndex);
            this.getModel().setValue("eval_filluser", (Object)(EmptyUtil.isEmpty((Long)result.getFillUser()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : result.getFillUser()), index, currentIndex);
            this.getModel().setValue("eval_parentsubjectid", (Object)result.getParentSubjectId(), index, currentIndex);
            this.addSubEntry(currentIndex, BigDecimal.ZERO, subMemberLevelMap, result.getChildren(), visibleMap);
        }
        return totalEvalAmt;
    }

    private BigDecimal getTargetCurrencyAmt(BigDecimal evalAmt, ReportData reportData, int entryIndex) {
        if (EmptyUtil.isEmpty((BigDecimal)evalAmt)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryIndex);
        DynamicObject targetCurrencyDy = dynamicObject.getDynamicObject("entry_currency");
        Long targetCurrencyId = targetCurrencyDy.getLong("sourceid");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entry_summarycurrencymap");
        Long value = 0L;
        List dimList = reportData.getDimList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)dimList.get(i);
            if (templateDim.getDimType() != DimensionType.CURRENCY) continue;
            value = reportData.getDimValList().get(i);
            break;
        }
        Long finalVal = value;
        DynamicObject sourceCurrencyDy = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(dy -> Objects.equals(finalVal, dy.getPkValue())).findFirst().get();
        Long sourceCurrencyId = sourceCurrencyDy.getLong("sourceid");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject rateTable = dataEntity.getDynamicObject("ratetable");
        Long rateTableId = (Long)rateTable.getPkValue();
        Date rateDate = dataEntity.getDate("ratedate");
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)rateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)rateDate);
        if (Objects.equals(sourceCurrencyId, targetCurrencyId)) {
            exchangeRate = BigDecimal.ONE;
        }
        if (exchangeRate == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6e90\u5e01\u79cd\u201c%2$s\u201d\u5230\u76ee\u6807\u5e01\u79cd\u201c%3$s\u201d\u7684\u6c47\u7387\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"EvaluateAmtPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rateTable.getString("name"), sourceCurrencyDy.getString("name"), targetCurrencyDy.getString("name")));
        }
        String sourceAmtUnit = reportData.getAmountUnit().getNumber();
        return this.getRateChangedEvalAmount(evalAmt, exchangeRate, sourceAmtUnit);
    }

    private int getScore(WaitApprovedAmountAmtInfoResultDTO result) {
        DynamicObjectCollection subOrg = (DynamicObjectCollection)this.getModel().getValue("subreportorg");
        Map<Object, String> orgMemberLongNumberMap = subOrg.stream().map(dy -> dy.getDynamicObject("fbasedataid")).collect(Collectors.toMap(dy -> dy.getPkValue(), dy -> dy.getString("longnumber")));
        List longNumberSortList = orgMemberLongNumberMap.values().stream().sorted().collect(Collectors.toList());
        ReportData reportData = result.getReportData();
        Object orgId = reportData.getDimValByDimType(DimensionType.ORG, null);
        return longNumberSortList.indexOf(orgMemberLongNumberMap.get(orgId));
    }

    private Map<Long, DynamicObject> getSubMemberObjectMap() {
        DynamicObjectCollection subReportOrg = (DynamicObjectCollection)this.getModel().getValue("subreportorg");
        return subReportOrg.stream().map(dy -> dy.getDynamicObject("fbasedataid")).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), Function.identity()));
    }

    private String getTreeTabName(int level, String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= level; ++i) {
            sb.append(TREE_TAB);
        }
        sb.append(name);
        return sb.toString();
    }

    private void setEntryMemberField(Map<String, Boolean> visibleMap, Predicate<String> predicate, List<TemplateDim> dimList, List<Object> dimValList, Map<String, String> fieldMap, Map<Long, Integer> customDimSeqMap, Consumer<Pair> consumer) {
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            Object val = dimValList.get(i);
            String number = templateDim.getDimType().isCustomDim() ? DimsionEnums.CUSTOM.getNumber() + "_" + customDimSeqMap.get(templateDim.getDimensionId()) : templateDim.getDimType().getNumber();
            String field = fieldMap.get(number);
            if (EmptyUtil.isEmpty((String)field)) continue;
            if (EmptyUtil.isEmpty(predicate)) {
                predicate = str -> true;
            }
            visibleMap.putIfAbsent(field, Boolean.FALSE);
            if (!EmptyUtil.isNoEmpty((Object)val) || !predicate.test(number)) continue;
            consumer.accept(Pair.of((Object)field, (Object)val));
            Boolean visible = visibleMap.get(field);
            if (visible == null || visible.booleanValue()) continue;
            visibleMap.put(field, Boolean.TRUE);
            if (!templateDim.getDimType().isCustomDim()) continue;
            ((BasedataEdit)this.getControl(field)).setCaption(new LocaleString(templateDim.getDimensionName()));
        }
    }

    private void setHead() {
        EvaluateAmtParam evaluateAmtParam = this.getEvaluateAmtParam();
        this.getModel().setValue("billno", (Object)evaluateAmtParam.getNumber());
        this.getModel().setValue("bodysys", (Object)evaluateAmtParam.getSystemId());
        this.getModel().setValue("sumtype", (Object)evaluateAmtParam.getSumType());
        this.getModel().setValue("sumreportorg", (Object)evaluateAmtParam.getSumReportOrgId());
        this.getModel().setValue("reporttype", (Object)evaluateAmtParam.getReportTypeId());
        this.getModel().setValue("reportperiod", (Object)evaluateAmtParam.getReportPeriodId());
        this.getModel().setValue("ratetable", (Object)evaluateAmtParam.getRateTableId());
        this.getModel().setValue("ratedate", (Object)evaluateAmtParam.getRateDate());
        this.getModel().setValue("amtunit", (Object)evaluateAmtParam.getAmtUnit());
        this.getModel().setValue("evaluatecell", (Object)evaluateAmtParam.getEvaluateCell());
        this.getModel().setValue("sumrecordid", (Object)evaluateAmtParam.getSumRecordId());
        this.getModel().setValue("evaluatereport", (Object)evaluateAmtParam.getEvaluateReport());
        this.getModel().setValue("evaluatereportid", (Object)evaluateAmtParam.getEvaluateReportId());
    }

    private void upperSum(PropertyChangedArgs e) {
        Object[] changeSet = e.getChangeSet();
        if (EmptyUtil.isEmpty((Object[])changeSet)) {
            return;
        }
        Object changeData = changeSet[0];
        if (EmptyUtil.isEmpty((Object)changeData)) {
            return;
        }
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(currentRowIndex);
        int subEntryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
        DynamicObject evalEntry = (DynamicObject)objectCollection.get(subEntryCurrentRowIndex);
        this.updateParentSubjectEvalAmtIfNeed(evalEntry, objectCollection, currentRowIndex, subEntryCurrentRowIndex, newValue, oldValue);
        DynamicObject targetCurrency = dynamicObject.getDynamicObject("entry_currency");
        Long targetCurrencyId = targetCurrency.getLong("sourceid");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject rateTable = dataEntity.getDynamicObject("ratetable");
        Long rateTableId = (Long)rateTable.getPkValue();
        Date rateDate = dataEntity.getDate("ratedate");
        HashMap<Long, BigDecimal> exchangeRateMap = new HashMap<Long, BigDecimal>();
        BigDecimal entryEvalAmt = BigDecimal.ZERO;
        for (DynamicObject subEntryRow : objectCollection) {
            String subEntryRowEvalAmtUnit = subEntryRow.getString("eval_amtunit");
            BigDecimal subEntryRowEvalAmt = subEntryRow.getBigDecimal("eval_evaluateamt");
            DynamicObject subEntryRowCurrency = subEntryRow.getDynamicObject("eval_currency");
            Long subEntryRowSourceCurrencyId = subEntryRowCurrency.getLong("sourceid");
            if (exchangeRateMap.containsKey(subEntryRowSourceCurrencyId)) {
                entryEvalAmt = entryEvalAmt.add(this.getRateChangedEvalAmount(subEntryRowEvalAmt, (BigDecimal)exchangeRateMap.get(subEntryRowSourceCurrencyId), subEntryRowEvalAmtUnit));
                continue;
            }
            if (Objects.equals(subEntryRowSourceCurrencyId, targetCurrencyId)) {
                exchangeRateMap.put(subEntryRowSourceCurrencyId, BigDecimal.ONE);
                entryEvalAmt = entryEvalAmt.add(this.getRateChangedEvalAmount(subEntryRowEvalAmt, (BigDecimal)exchangeRateMap.get(subEntryRowSourceCurrencyId), subEntryRowEvalAmtUnit));
                continue;
            }
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)rateTableId, (Long)subEntryRowSourceCurrencyId, (Long)targetCurrencyId, (Date)rateDate);
            if (exchangeRate == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6e90\u5e01\u79cd\u201c%2$s\u201d\u5230\u76ee\u6807\u5e01\u79cd\u201c%3$s\u201d\u7684\u6c47\u7387\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"EvaluateAmtPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rateTable.getString("name"), subEntryRowCurrency.getString("name"), targetCurrency.getString("name")));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"eval_evaluateamt", (Object)oldValue, (int)subEntryCurrentRowIndex, (int)currentRowIndex);
                return;
            }
            exchangeRateMap.put(subEntryRowSourceCurrencyId, exchangeRate);
            entryEvalAmt = entryEvalAmt.add(this.getRateChangedEvalAmount(subEntryRowEvalAmt, (BigDecimal)exchangeRateMap.get(subEntryRowSourceCurrencyId), subEntryRowEvalAmtUnit));
        }
        this.getModel().setValue("entry_evaluateamt", (Object)entryEvalAmt, currentRowIndex);
    }

    private void updateParentSubjectEvalAmtIfNeed(DynamicObject evalEntry, DynamicObjectCollection objectCollection, int currentRowIndex, int subEntryCurrentRowIndex, BigDecimal newValue, BigDecimal oldValue) {
        Long parentSubjectId = evalEntry.getLong("eval_parentsubjectid");
        if (EmptyUtil.isEmpty((Long)parentSubjectId)) {
            return;
        }
        for (int i = subEntryCurrentRowIndex - 1; i >= 0; --i) {
            DynamicObject dynamicObject = (DynamicObject)objectCollection.get(i);
            Long subjectId = (Long)dynamicObject.getDynamicObject("eval_subject").getPkValue();
            if (!Objects.equals(subjectId, parentSubjectId)) continue;
            BigDecimal evalAmt = dynamicObject.getBigDecimal("eval_evaluateamt");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"eval_evaluateamt", (Object)evalAmt.add(newValue).subtract(oldValue), (int)i, (int)currentRowIndex);
            parentSubjectId = dynamicObject.getLong("eval_parentsubjectid");
            if (EmptyUtil.isEmpty((Long)parentSubjectId)) break;
        }
    }

    private BigDecimal getRateChangedEvalAmount(BigDecimal sourceAmt, BigDecimal exchangeRate, String sourceAmtUnit) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String targetAmtUnit = dataEntity.getString("amtunit");
        BigDecimal realSourceAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceAmtUnit), (AmountUnitEnum)AmountUnitEnum.ONE, (BigDecimal)sourceAmt);
        BigDecimal rateChangedAmt = realSourceAmt.multiply(exchangeRate);
        return AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)AmountUnitEnum.get((String)targetAmtUnit), (BigDecimal)rateChangedAmt);
    }

    private IEvaluateAmtController getOrCreate() {
        if (EmptyUtil.isEmpty((Object)this.evaluateAmtController)) {
            this.evaluateAmtController = new EvaluateAmtControllerImpl((IEvaluateView)this);
        }
        return this.evaluateAmtController;
    }

    private Set<Long> getAllSubReportOrgIds() {
        DynamicObjectCollection subReportOrg = (DynamicObjectCollection)this.getModel().getValue("subreportorg");
        return subReportOrg.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
    }

    private ApprovedAmountRecord getApprovedAmountRecord() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ApprovedAmountRecord record = new ApprovedAmountRecord();
        record.setSystemId((Long)dataEntity.getDynamicObject("bodysys").getPkValue());
        record.setAmountUnit(AmountUnit.getByNumber((String)dataEntity.getString("amtunit")));
        record.setMember((Long)dataEntity.getDynamicObject("sumreportorg").getPkValue());
        record.setExRateTable((Long)dataEntity.getDynamicObject("ratetable").getPkValue());
        record.setExRateDate(dataEntity.getDate("ratedate"));
        record.setNumber(dataEntity.getString("billno"));
        record.setOrgReportPeriod((Long)dataEntity.getDynamicObject("reportperiod").getPkValue());
        record.setOrgReportType((Long)dataEntity.getDynamicObject("reporttype").getPkValue());
        record.setSummaryt((SumPlanSumType)ITypeEnum.getByNumber((String)dataEntity.getString("sumtype"), SumPlanSumType.class));
        record.setSumPlanRecordId(Long.valueOf(dataEntity.getLong("sumrecordid")));
        DynamicObjectCollection sumEntryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<ApprovedAmountAmtInfo> amountAmtInfoList = new ArrayList<ApprovedAmountAmtInfo>(sumEntryEntity.size());
        for (DynamicObject dy : sumEntryEntity) {
            ApprovedAmountAmtInfo amountAmtInfo = new ApprovedAmountAmtInfo();
            amountAmtInfo.setReportDataIdStr(dy.getString("entry_sumreportdataids"));
            amountAmtInfo.setReportDataId(Long.valueOf(dy.getLong("entry_sumapprovalid")));
            amountAmtInfo.setApprovedAmt(dy.getBigDecimal("entry_evaluateamt"));
            DynamicObjectCollection evalEntryEntity = dy.getDynamicObjectCollection("subentryentity");
            ArrayList<ApprovedAmountAmtDetailInfo> detailInfoList = new ArrayList<ApprovedAmountAmtDetailInfo>(evalEntryEntity.size());
            for (DynamicObject detail : evalEntryEntity) {
                ApprovedAmountAmtDetailInfo detailInfo = new ApprovedAmountAmtDetailInfo();
                detailInfo.setEvalAdjustReason(detail.getString("eval_evaladjustreason"));
                detailInfo.setFillUser((Long)detail.getDynamicObject("eval_filluser").getPkValue());
                detailInfo.setApprovedAmt(detail.getBigDecimal("eval_evaluateamt"));
                detailInfo.setOriginalApprovedAmt(detail.getBigDecimal("eval_originalapprovalamt"));
                detailInfo.setReportDataId(Long.valueOf(detail.getLong("eval_reportdataid")));
                detailInfo.setPlanReportNumber(detail.getString("eval_planreportnumber"));
                detailInfo.setReportId(Long.valueOf(detail.getLong("eval_planreportid")));
                detailInfo.setEvalDetail(Boolean.valueOf(false));
                detailInfo.setApproved(true);
                AmountUnit amountUnit = AmountUnit.getByNumber((String)detail.getString("eval_amtunit"));
                detailInfo.setAmountUnit(amountUnit);
                detailInfoList.add(detailInfo);
            }
            amountAmtInfo.setAmtDetailInfoList(detailInfoList);
            amountAmtInfoList.add(amountAmtInfo);
        }
        record.setAmountAmtInfoList(amountAmtInfoList);
        return record;
    }

    private EvaluateAmtDetailParam.DetailInfo getDetailInfo(DynamicObject dynamicObject) {
        EvaluateAmtDetailParam.DetailInfo detailInfo = new EvaluateAmtDetailParam.DetailInfo();
        detailInfo.setMainReportDataId(Long.valueOf(dynamicObject.getLong("eval_reportdataid")));
        detailInfo.setOrgMemberId((Long)dynamicObject.getDynamicObject("eval_reportorg").getPkValue());
        detailInfo.setSubjectId((Long)dynamicObject.getDynamicObject("eval_subject").getPkValue());
        detailInfo.setCurrencyId((Long)dynamicObject.getDynamicObject("eval_currency").getPkValue());
        DynamicObject company = dynamicObject.getDynamicObject("eval_company");
        detailInfo.setCompanyId(EmptyUtil.isEmpty((DynamicObject)company) ? Long.valueOf(0L) : (Long)company.getPkValue());
        DynamicObject settleType = dynamicObject.getDynamicObject("eval_settletype");
        detailInfo.setSettleTypeId(EmptyUtil.isEmpty((DynamicObject)settleType) ? Long.valueOf(0L) : (Long)settleType.getPkValue());
        DynamicObject otherDim1Member1 = dynamicObject.getDynamicObject("eval_otheroptionaldim");
        detailInfo.setExtMem1Id(EmptyUtil.isEmpty((DynamicObject)otherDim1Member1) ? Long.valueOf(0L) : (Long)otherDim1Member1.getPkValue());
        DynamicObject otherDim1Member2 = dynamicObject.getDynamicObject("eval_otheroptionaldim2");
        detailInfo.setExtMem2Id(EmptyUtil.isEmpty((DynamicObject)otherDim1Member2) ? Long.valueOf(0L) : (Long)otherDim1Member2.getPkValue());
        DynamicObject otherDim1Member3 = dynamicObject.getDynamicObject("eval_otheroptionaldim3");
        detailInfo.setExtMem3Id(EmptyUtil.isEmpty((DynamicObject)otherDim1Member3) ? Long.valueOf(0L) : (Long)otherDim1Member3.getPkValue());
        detailInfo.setChildTemplateId(Long.valueOf(dynamicObject.getLong("eval_childtemplateid")));
        detailInfo.setReportAmt(dynamicObject.getBigDecimal("eval_reportamt"));
        detailInfo.setEvalAmt(dynamicObject.getBigDecimal("eval_evaluateamt"));
        detailInfo.setOriginalEvalAmt(dynamicObject.getBigDecimal("eval_originalapprovalamt"));
        detailInfo.setPlanReportId(Long.valueOf(dynamicObject.getLong("eval_planreportid")));
        detailInfo.setPlanReportNumber(dynamicObject.getString("eval_planreportnumber"));
        return detailInfo;
    }

    private void batchEvalDetail() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
        List<DynamicObject> detailInput = dynamicObjectCollection.stream().filter(dy -> Objects.equals(dy.getString("eval_fillway"), ReportInputType.DETAIL_INPUT.getNumber())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(detailInput)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u660e\u7ec6\u586b\u62a5\u9879\u3002", (String)"EvaluateAmtPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openDetailForm(dynamicObject, detailInput);
    }

    private void openDetailForm(DynamicObject sumEntry, List<DynamicObject> evalDyList) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_detailamtevaluate");
        formShowParameter.setStatus(this.isFromSearch() ? OperationStatus.VIEW : OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        EvaluateAmtDetailParam detailParam = new EvaluateAmtDetailParam();
        detailParam.setSumRecordId((Long)this.getModel().getValue("sumrecordid"));
        detailParam.setSumReportDataIdStr(sumEntry.getString("entry_sumreportdataids"));
        detailParam.setSumReportDataStoreId(Long.valueOf(sumEntry.getLong("entry_sumapprovalid")));
        detailParam.setSystemId((Long)((DynamicObject)this.getModel().getValue("bodysys")).getPkValue());
        detailParam.setPeriodId((Long)sumEntry.getDynamicObject("entry_period").getPkValue());
        detailParam.setCurrencyId((Long)sumEntry.getDynamicObject("entry_currency").getPkValue());
        detailParam.setRateTableId((Long)((DynamicObject)this.getModel().getValue("ratetable")).getPkValue());
        detailParam.setRateDate(dataEntity.getDate("ratedate"));
        detailParam.setSumAmtUnit(dataEntity.getString("amtunit"));
        detailParam.setEvalAmt(sumEntry.getBigDecimal("entry_evaluateamt"));
        detailParam.setDetailInfoList(evalDyList.stream().map(this::getDetailInfo).collect(Collectors.toList()));
        formShowParameter.setCustomParam(EvaluateAmtDetailParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)detailParam));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchevaldetail"));
        this.getView().showForm(formShowParameter);
    }

    private EvaluateAmtParam getEvaluateAmtParam() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String jsonStr = (String)formShowParameter.getCustomParam(EvaluateAmtParam.class.getName());
        return (EvaluateAmtParam)SerializationUtils.fromJsonString((String)jsonStr, EvaluateAmtParam.class);
    }

    private void reloadSubEntry() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("entry_needload", (Object)true, currentRowIndex);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.entryRowClick(Integer.valueOf(currentRowIndex));
    }

    private void setCustomDimFieldName(Map<String, String> dimTypeFieldMap, DynamicObjectCollection dimDyColl, Map<Long, Integer> customDimSeqMap) {
        if (customDimSeqMap.isEmpty()) {
            return;
        }
        Map<Long, String> dimNameMap = dimDyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (a, b) -> a));
        customDimSeqMap.forEach((dimId, seq) -> {
            String number = DimsionEnums.CUSTOM.getNumber() + "_" + seq;
            String field = (String)dimTypeFieldMap.get(number);
            String name = (String)dimNameMap.get(dimId);
            ((BasedataEdit)this.getControl(field)).setCaption(new LocaleString(name));
        });
    }

    private Map<Long, Integer> loadCustomDimSeqMap(Long systemId) {
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        return iCustomDimSeqService.loadCustomDimSeqMap(systemId);
    }
}

