/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.suppplement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.controller.IFundSystemController;
import kd.tmc.fpm.business.mvc.controller.impl.IFundSystemControllerImpl;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.property.SupplementBillProp;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;

public class SupplementBillList
extends FpmFilterBaseList {
    private IFundSystemController fundSystemController;

    @Override
    protected String getAuthEntityName() {
        return "fpm_supplement_bill";
    }

    @Override
    protected String getBodySystemProp() {
        return "system";
    }

    @Override
    protected String getReportOrgProp() {
        return "reportorg";
    }

    public void setFilter(SetFilterEvent e) {
        Object value;
        QFilter orgQFilter;
        String property;
        Optional<QFilter> orgOptionalQFilter;
        QFilter systemFilter;
        String property2;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> optionalQFilter = qFilters.stream().filter(i -> i.getProperty().startsWith("system")).findFirst();
        if (optionalQFilter.isPresent() && "system.id".equals(property2 = (systemFilter = optionalQFilter.get()).getProperty())) {
            this.getPageCache().put("LIST_SELECTED_SYSTEM_CACHE_KEY", systemFilter.getValue().toString());
        }
        if ((orgOptionalQFilter = qFilters.stream().filter(i -> i.getProperty().startsWith("reportorg")).findFirst()).isPresent() && "reportorg.id".equals(property = (orgQFilter = orgOptionalQFilter.get()).getProperty()) && EmptyUtil.isNoEmpty((Object)(value = orgQFilter.getValue()))) {
            this.getPageCache().put("LIST_SELECTED_ORG_CACHE_KEY", value.toString());
        }
        qFilters.add(new QFilter("reportorg", "in", this.getAuthMemberOrgIds()));
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String currentSystemId = this.getPageCache().get("currModelId");
        if (currentSystemId == null) {
            return;
        }
        FundPlanSystem fundPlanSystem = this.getOrCreateSystemController().loadSystem(Long.valueOf(Long.parseLong(currentSystemId.toString())));
        List dimList = fundPlanSystem.getDimList();
        Optional<Dimension> companyDimOptional = dimList.stream().filter(dimension -> dimension.getDimType().isCompany()).findAny();
        Optional<Dimension> settlementDimOptional = dimList.stream().filter(dimension -> dimension.getDimType().isSettlementType()).findAny();
        Map detailDimensionMap = dimList.stream().filter(dimension -> dimension.getDimType().isDetailDim()).collect(Collectors.toMap(Dimension::getNumber, Function.identity()));
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(fundPlanSystem.getId());
        ArrayList customPropListNeedRemove = new ArrayList(SupplementBillProp.CUSTOMER_LIST);
        List customDimensionList = fundPlanSystem.getDimList().stream().filter(dimension -> dimension.getDimType().isCustomDim()).collect(Collectors.toList());
        for (Dimension dimension2 : customDimensionList) {
            Integer storeSeq = (Integer)customDimSeqMap.get(dimension2.getId());
            String prop = (String)CustomDimSeqServiceImpl.SUPPLEMENT_BILL_CUSTOM_PROP_MAP.get(storeSeq);
            String columnProp = String.join((CharSequence)".", prop, "name");
            IListColumn listColumn2 = args.getListColumn(columnProp);
            listColumn2.setCaption(new LocaleString(dimension2.getName()));
            customPropListNeedRemove.remove(prop);
        }
        for (Map.Entry entry : SupplementBillProp.ENTRY_DETAIL_DIMENSION_NUMBER_MAP_FOR_LIST.entrySet()) {
            String prop = (String)entry.getKey();
            String dimensionNumber = (String)entry.getValue();
            if (!detailDimensionMap.containsKey(dimensionNumber)) continue;
            Dimension dimension3 = (Dimension)detailDimensionMap.get(dimensionNumber);
            IListColumn listColumn2 = args.getListColumn(prop);
            listColumn2.setCaption(new LocaleString(dimension3.getName()));
        }
        if (!settlementDimOptional.isPresent()) {
            args.getListColumns().removeIf(listColumn -> listColumn.getListFieldKey().startsWith("settlement"));
        }
        if (!companyDimOptional.isPresent()) {
            args.getListColumns().removeIf(listColumn -> listColumn.getListFieldKey().startsWith("company"));
        }
        for (String string : customPropListNeedRemove) {
            args.getListColumns().removeIf(listColumn -> listColumn.getListFieldKey().startsWith(prop));
        }
    }

    private IFundSystemController getOrCreateSystemController() {
        if (null == this.fundSystemController) {
            this.fundSystemController = new IFundSystemControllerImpl();
        }
        return this.fundSystemController;
    }
}

