/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.helper.TemplateHelper;

public class AnalysisTemplateManageList
extends AbstractTmcBillBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("copy".equals(operate.getOperateKey())) {
            List selectedIdList = this.getSelectedIdList();
            if (selectedIdList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u590d\u5236\u65b0\u589e\u3002", (String)"AnalysisTemplateManageList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            this.getPageCache().put("TEMPLATE_COPY_FLAG", "1");
        } else if ("enable".equals(operate.getOperateKey())) {
            DynamicObject disableDefaultTemplate;
            DynamicObject defaultTemplateExist;
            List selectedIdList = this.getSelectedIdList();
            String fields = String.join((CharSequence)",", "id", "name", "number", "model");
            QFilter qFilter = new QFilter("id", "in", (Object)selectedIdList);
            qFilter.and("dfquerytpl", "=", (Object)"1");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_template", (String)fields, (QFilter[])new QFilter[]{qFilter});
            if (CollectionUtils.isNotEmpty((Collection)query) && (defaultTemplateExist = TemplateHelper.getDefaultTemplateExist((Object)(disableDefaultTemplate = (DynamicObject)query.get(0)).get("model"))) != null && !Objects.equals(defaultTemplateExist.getLong("id"), disableDefaultTemplate.getPkValue())) {
                String existNumber = defaultTemplateExist.getString("number");
                String existName = defaultTemplateExist.getString("name");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u542f\u7528\u6a21\u677f\u5931\u8d25\uff0c\u4f53\u7cfb\u4e0b\u7684\u6a21\u677f\u3010%s\u3011\u5df2\u5f00\u542f\u4f5c\u4e3a\u9ed8\u8ba4\u67e5\u8be2\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u4e2a\u9ed8\u8ba4\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AnalysisTemplateManageList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), existNumber + " " + existName));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("releaseconfirm".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u53d1\u5e03\u540e\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u6a21\u677f\u662f\u5426\u5df2\u5b8c\u6210\u914d\u7f6e\u5e76\u53d1\u5e03\uff1f", (String)"TemplateManageList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
        if (("releaseop".equals(operateKey) || "cancelrelease".equals(operateKey)) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Cancel == messageBoxClosedEvent.getResult()) {
            return;
        }
        if ("releaseconfirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("releaseop");
        }
    }

    public void setFilter(SetFilterEvent e) {
        String property;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> first = qFilters.stream().filter(i -> i.getProperty().startsWith("model")).findFirst();
        QFilter systemFilter = first.orElse(null);
        if (systemFilter != null && "model.id".equals(property = systemFilter.getProperty())) {
            this.getPageCache().put("TEMPLATE_CONFIG_MODEL_ID_KEY", systemFilter.getValue().toString());
        }
        QFilter qFilter = new QFilter("templateuses", "in", Arrays.asList(TemplateUsesEnum.STATISTIC.getValue(), TemplateUsesEnum.ANALYSIS.getValue()));
        List modelIdList = ModelHelper.getAuthModelId();
        qFilters.add(new QFilter("model.id", "in", (Object)modelIdList));
        qFilters.add(qFilter);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        List<String> notNeedTypes = Arrays.asList(TemplateUsesEnum.PLANING.getValue(), TemplateUsesEnum.SUMMARY.getValue());
        if ("templateuses".equals(listFieldKey)) {
            args.getComboItems().removeIf(valueMapItem -> notNeedTypes.contains(valueMapItem.getValue()));
        }
    }
}

