/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.mvc.converter.DimensionPOConverter;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.common.enums.DimLevelEnum;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.helper.TemplateHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisTemplateManagePlugin
extends AbstractBasePlugIn {
    DimensionRepository dimensionRepository = new DimensionRepository();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetTemplateUses();
        this.resetDimMemberScope();
        this.resetDimLocationType();
        this.hideReleaseBtn();
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String modelId = parentView.getPageCache().get("TEMPLATE_CONFIG_MODEL_ID_KEY");
            if (modelId == null) {
                return;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            if (!StringUtils.isNumeric((CharSequence)modelId)) {
                return;
            }
            this.getModel().setValue("model", (Object)modelId);
            this.getModel().deleteEntryData("dimsettingentry");
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"templateuses", (Object)TemplateUsesEnum.ANALYSIS.getValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap4"});
        this.initF7();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_reset": {
                this.resetDim((DynamicObject)this.getModel().getValue("model"));
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "deleteentryformetric": {
                if (this.couldBeDeleted()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    private boolean couldBeDeleted() {
        int entryCurrentRowIndex;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("metricentry");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("metricentry"));
        boolean isPreset = dynamicObject.getBoolean("preset");
        if (isPreset) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6307\u6807\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AnalysisTemplateManagePlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideReleaseBtn();
        IDataModel model = this.getModel();
        Object modelVal = model.getValue("model");
        if (Objects.isNull(modelVal)) {
            return;
        }
        DynamicObject system = (DynamicObject)modelVal;
        Long primaryKey = (Long)system.getPkValue();
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(primaryKey.longValue());
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IFormView parentView = this.getView().getParentView();
        String flag = null;
        if (parentView != null) {
            flag = parentView.getPageCache().get("TEMPLATE_COPY_FLAG");
        }
        if (status == OperationStatus.ADDNEW && !"1".equals(flag)) {
            this.doGetDim(fundPlanSystem);
            this.initMetric(fundPlanSystem);
        } else {
            this.resetTemplateUses();
            this.resetDimMemberScope();
            this.resetDimLocationType();
            DynamicObjectCollection dimSets = model.getEntryEntity("dimsettingentry");
            HashMap<String, Integer> mutexOptionMap = new HashMap<String, Integer>();
            for (int i = 0; i < dimSets.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dimSets.get(i);
                Dimension dimension = this.getDimension(dynamicObject);
                if (dimension.getDimType() != DimensionType.DETAILDIM) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"dimnumber", (Object)dimension.getNumber(), (int)i);
                }
                String dimLocation = dynamicObject.getString("type");
                boolean isOpen = dynamicObject.getBoolean("isopen");
                boolean isDefaultSortItem = dynamicObject.getBoolean("isdfsortitem");
                boolean isHide = dynamicObject.getBoolean("ishide");
                boolean isDimFilter = dynamicObject.getBoolean("dimfilterdim");
                String memberScope = dynamicObject.getString("dimmemberscope");
                String level = dynamicObject.getString("level");
                this.disableDimEntryField(dimension, i, dimLocation, isOpen, isHide, isDimFilter, memberScope, level);
                if (isDefaultSortItem) {
                    mutexOptionMap.put("isdfsortitem", i);
                }
                if (!isOpen) continue;
                mutexOptionMap.put("isopen", i);
            }
            this.disableMutexOption(mutexOptionMap, dimSets);
            DynamicObjectCollection metricSets = model.getEntryEntity("metricentry");
            for (int i = 0; i < metricSets.size(); ++i) {
                DynamicObject metricDO = (DynamicObject)metricSets.get(i);
                String metricType = metricDO.getString("newmetrictype.metricpresettype");
                this.disableMetricEntryField(metricType, i);
            }
            if (parentView != null) {
                parentView.getPageCache().put("TEMPLATE_COPY_FLAG", "0");
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"templateuses", "templatetype"});
        }
        this.updateStatus();
    }

    private void disableMutexOption(Map<String, Integer> mutexOptionMap, DynamicObjectCollection dimSets) {
        if (mutexOptionMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < dimSets.size(); ++i) {
            if (mutexOptionMap.containsKey("isdfsortitem") && mutexOptionMap.get("isdfsortitem") != i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isdfsortitem"});
            }
            if (!mutexOptionMap.containsKey("isopen") || mutexOptionMap.get("isopen") == i) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isopen"});
        }
    }

    private void updateStatus() {
        boolean isDataChange = this.getModel().getDataChanged();
        this.getModel().setValue("status", (Object)BillStatusEnum.AUDIT.getValue());
        this.getModel().setDataChanged(isDataChange);
    }

    private void initMetric(FundPlanSystem fundPlanSystem) {
        IDataModel model = this.getModel();
        model.deleteEntryData("metricentry");
        Dimension metricDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC);
        if (metricDim == null || CollectionUtils.isEmpty((Collection)metricDim.getAllDimMemberList())) {
            return;
        }
        int newEntryRow = model.createNewEntryRow("metricentry");
        Optional<MetricMember> planAmt = metricDim.getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.PLANAMT).findFirst();
        IFormView view = this.getView();
        if (planAmt.isPresent()) {
            MetricMember metricMember2 = planAmt.get();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"metrictype", (Object)metricMember2.getTemplateMetricType().getCode(), (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"newmetrictype", (Object)metricMember2.getId(), (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"preset", (Object)true, (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dffilter", (Object)true, (int)newEntryRow);
            this.disableMetricEntryField(metricMember2.getTemplateMetricType().getCode(), newEntryRow);
        }
    }

    private void initEntry() {
        IDataModel model = this.getModel();
        Object modelVal = model.getValue("model");
        if (Objects.isNull(modelVal)) {
            model.deleteEntryData("dimsettingentry");
            model.deleteEntryData("metricentry");
            return;
        }
        DynamicObject system = (DynamicObject)modelVal;
        Long primaryKey = (Long)system.getPkValue();
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(primaryKey.longValue());
        this.doGetDim(fundPlanSystem);
        this.initMetric(fundPlanSystem);
        if (Objects.equals(TemplateUsesEnum.STATISTIC.getValue(), this.getModel().getValue("templateuses")) && Objects.equals(TemplateTypeEnum.DETAIL.getValue(), this.getModel().getValue("templatetype"))) {
            this.getModel().setValue("dfquerytpl", (Object)false);
        }
    }

    private void doGetDim(FundPlanSystem fundPlanSystem) {
        ArrayList dimensionList;
        if (fundPlanSystem == null || CollectionUtils.isEmpty((Collection)(dimensionList = fundPlanSystem.getDimList()))) {
            dimensionList = new ArrayList(2);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("dimsettingentry");
        dimensionList.stream().filter(dimension -> dimension.getDimType() != DimensionType.METRIC).sorted(Comparator.comparing(AnalysisTemplateManagePlugin::getDimensionScore)).forEach(this::settingUpField);
    }

    private void resetDim(DynamicObject system) {
        if (system == null) {
            this.showBodySysNotification();
            return;
        }
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(((Long)system.getPkValue()).longValue());
        List dimensionList = fundPlanSystem.getDimList();
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        this.getModel().deleteEntryData("dimsettingentry");
        if (CollectionUtils.isEmpty((Collection)dimensionList)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)dimSets)) {
            dimensionList.stream().filter(dimension -> dimension.getDimType() != DimensionType.METRIC).sorted(Comparator.comparing(AnalysisTemplateManagePlugin::getDimensionScore)).forEach(this::settingUpField);
        } else {
            HashMap dimTypeMap = new HashMap();
            dimSets.forEach(dimSet -> {
                DynamicObject dimSetDynamicObject = dimSet.getDynamicObject("dimbd");
                if (dimSetDynamicObject != null) {
                    Long dimId = (Long)dimSetDynamicObject.getPkValue();
                    dimTypeMap.put(dimId, dimSet);
                }
            });
            dimensionList.stream().filter(dimension -> dimension.getDimType() != DimensionType.METRIC).sorted(Comparator.comparing(AnalysisTemplateManagePlugin::getDimensionScore)).forEach(dimension -> {
                if (dimTypeMap.containsKey(dimension.getId())) {
                    DynamicObject dimDO = (DynamicObject)dimTypeMap.get(dimension.getId());
                    this.copyAndSaveField(dimDO);
                } else {
                    this.settingUpField((Dimension)dimension);
                }
            });
        }
    }

    private void copyAndSaveField(DynamicObject dimDO) {
        IDataModel model = this.getModel();
        String templateType = (String)model.getValue("templatetype");
        String dimType = dimDO.getString("dimnumber");
        boolean isDetail = TemplateTypeEnum.DETAIL.getValue().equals(templateType);
        if (DimensionType.DETAILDIM.getNumber().equals(dimType) && !isDetail) {
            return;
        }
        int newEntryRow = model.createNewEntryRow("dimsettingentry");
        IFormView view = this.getView();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimbdtype", (Object)dimDO.getString("dimbdtype"), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimbd", (Object)dimDO.getDynamicObject("dimbd").getPkValue(), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dim", (Object)dimDO.getDynamicObject("dimbd").getPkValue(), (int)newEntryRow);
        String level = dimDO.getString("level");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"level", (Object)level, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimnumber", (Object)dimDO.getString("dimnumber"), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"isdetaildim", (Object)dimDO.getBoolean("isdetaildim"), (int)newEntryRow);
        String dimLocation = dimDO.getString("type");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"type", (Object)dimLocation, (int)newEntryRow);
        String memberScope = dimDO.getString("dimmemberscope");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimmemberscope", (Object)memberScope, (int)newEntryRow);
        boolean isDimFilter = dimDO.getBoolean("dimfilterdim");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimfilterdim", (Object)isDimFilter, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"plantemplatemember", (Object)dimDO.getDynamicObjectCollection("plantemplatemember"), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"defaultfilter", (Object)dimDO.getDynamicObjectCollection("defaultfilter"), (int)newEntryRow);
        boolean isOpen = dimDO.getBoolean("isopen");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"isopen", (Object)isOpen, (int)newEntryRow);
        boolean isHide = dimDO.getBoolean("ishide");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"ishide", (Object)isHide, (int)newEntryRow);
        this.disableDimEntryField(this.getDimension(dimDO), newEntryRow, dimLocation, isOpen, isHide, isDimFilter, memberScope, level);
    }

    private void settingUpField(Dimension dimension) {
        String dimBdType;
        if (dimension == null) {
            return;
        }
        if (dimension.getDetailDimType() != null && !dimension.isVisible()) {
            return;
        }
        IDataModel model = this.getModel();
        String templateType = (String)model.getValue("templatetype");
        DimensionType dimType = dimension.getDimType();
        boolean isDetail = TemplateTypeEnum.DETAIL.getValue().equals(templateType);
        if (dimType == DimensionType.DETAILDIM) {
            if (!isDetail) {
                return;
            }
            dimBdType = "fpm_detailplanfields";
        } else {
            dimBdType = "fpm_dimension";
        }
        int newEntryRow = model.createNewEntryRow("dimsettingentry");
        IFormView view = this.getView();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimbdtype", (Object)dimBdType, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimbd", (Object)dimension.getId(), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dim", (Object)dimension.getId(), (int)newEntryRow);
        String level = isDetail ? "" : DimLevelEnum.ONE.getValue().toString();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"level", (Object)level, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimnumber", (Object)(dimType == DimensionType.DETAILDIM ? null : dimension.getNumber()), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"isdetaildim", (Object)(dimType == DimensionType.DETAILDIM ? 1 : 0), (int)newEntryRow);
        String dimLocation = this.getDimLocation(dimension);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"type", (Object)dimLocation, (int)newEntryRow);
        boolean isDimFilter = false;
        String memberScope = !DimLocation.PAGE.getNumber().equals(dimLocation) && dimType != DimensionType.ORG && dimType != DimensionType.PERIOD ? DimensionMemberScopeEnum.FIXED_MEMBER.getValue() : DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getValue();
        if (dimType != DimensionType.DETAILDIM) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimmemberscope", (Object)memberScope, (int)newEntryRow);
            isDimFilter = true;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"dimfilterdim", (Object)isDimFilter, (int)newEntryRow);
        if (isDetail && TemplateUsesEnum.STATISTIC.getValue().equals(model.getValue("templateuses"))) {
            if (dimension.getDimType().isOrgDim()) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"isdfsortitem", (Object)true, (int)newEntryRow);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"isdfsortitem"});
            }
        }
        this.disableDimEntryField(dimension, newEntryRow, dimLocation, false, false, isDimFilter, memberScope, level);
        model.setDataChanged(false);
    }

    private String getDimLocation(Dimension dimension) {
        String templateType = (String)this.getModel().getValue("templatetype");
        DimensionType dimType = dimension.getDimType();
        if (TemplateTypeEnum.DETAIL.getValue().equals(templateType)) {
            return DimLocation.COL.getNumber();
        }
        switch (dimType) {
            case SUBJECTS: {
                return DimLocation.ROW.getNumber();
            }
            case ORG: 
            case COMPANY: 
            case SETTLEMENT_TYPE: 
            case CUSTOM: 
            case CURRENCY: {
                return DimLocation.PAGE.getNumber();
            }
            case PERIOD: {
                return DimLocation.COL.getNumber();
            }
        }
        return null;
    }

    private void disableDimEntryField(Dimension dimension, int rowIndex, String dimLocation, boolean isOpen, boolean isHide, boolean isDimFilter, String memberScope, String level) {
        DimensionType dimType = dimension.getDimType();
        if ((isOpen || !DimLocation.PAGE.getNumber().equals(dimLocation)) && dimType != DimensionType.ORG && dimType != DimensionType.PERIOD) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
        }
        if (!DimensionMemberScopeEnum.FIXED_MEMBER.getValue().equals(memberScope)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plantemplatemember"});
        }
        if (isHide) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"type"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimfilterdim"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
        }
        if (!isDimFilter) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"defaultfilter"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"defaultfilter", null, (int)rowIndex);
        }
        String templateType = (String)this.getModel().getValue("templatetype");
        if (dimType == DimensionType.DETAILDIM) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"type"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"level"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plantemplatemember"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimfilterdim"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"defaultfilter"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isopen"});
            if (dimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ishide"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
            }
        }
        if (Arrays.asList(DimensionType.ORG, DimensionType.PERIOD, DimensionType.SUBJECTS, DimensionType.CURRENCY).contains(dimType)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ishide"});
        }
        if (DimensionType.SUBJECTS == dimType || DimLocation.PAGE.getNumber().equals(dimLocation) || !isOpen && TemplateTypeEnum.DETAIL.getValue().equals(templateType) || "1".equals(level)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"containsubtotal"});
        }
        if (DimensionType.PERIOD == dimType) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"defaultfilter"});
        }
        if (DimLocation.PAGE.getNumber().equals(dimLocation)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"level"});
            String templateUses = (String)this.getModel().getValue("templateuses");
            boolean enableScope = TemplateUseType.ANALYSIS.getNumber().equals(templateUses) && DimensionType.PERIOD != dimType;
            this.getView().setEnable(Boolean.valueOf(enableScope), rowIndex, new String[]{"dimmemberscope"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"level", null, (int)rowIndex);
        }
        if (!DimLocation.COL.getNumber().equals(dimLocation)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isopen"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
        }
        if (dimension.getMemberType() != null) {
            this.getView().setEnable(Boolean.valueOf(dimension.getMemberType() == MemberType.AMOUNT), rowIndex, new String[]{"totalrow"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"totalrow"});
        }
    }

    private void disableMetricEntryField(String type, int newEntryRow) {
        if (TemplateMetricType.PLANAMT.getCode().equals(type)) {
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"computeformula"});
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"newmetrictype"});
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"preset"});
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"dffilter"});
        }
    }

    private static int getDimensionScore(Dimension dimension) {
        DimensionType dimType = dimension.getDimType();
        switch (dimType) {
            case ORG: {
                return 1;
            }
            case PERIOD: {
                return 3;
            }
            case CURRENCY: {
                return 2;
            }
            case SUBJECTS: {
                return 4;
            }
            case COMPANY: 
            case SETTLEMENT_TYPE: 
            case CUSTOM: 
            case ACCOUNTTYPE: {
                return 5;
            }
            case DETAILDIM: {
                return 6;
            }
        }
        return 0;
    }

    private void resetTemplateUses() {
        ComboEdit templateUses = (ComboEdit)this.getControl("templateuses");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(new LocaleString(TemplateUsesEnum.ANALYSIS.getName()), TemplateUsesEnum.ANALYSIS.getValue()));
        comboItemList.add(new ComboItem(new LocaleString(TemplateUsesEnum.STATISTIC.getName()), TemplateUsesEnum.STATISTIC.getValue()));
        templateUses.setComboItems(comboItemList);
    }

    private void resetDimMemberScope() {
        ComboEdit dimMemberScope = (ComboEdit)this.getControl("dimmemberscope");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(new LocaleString(DimensionMemberScopeEnum.FIXED_MEMBER.getName()), DimensionMemberScopeEnum.FIXED_MEMBER.getValue()));
        comboItemList.add(new ComboItem(new LocaleString(DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getName()), DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getValue()));
        dimMemberScope.setComboItems(comboItemList);
    }

    private void resetDimLocationType() {
        ComboEdit dimType = (ComboEdit)this.getControl("type");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u7ef4", (String)"AnalysisTemplateManagePlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0])), DimLocation.COL.getNumber()));
        String templateType = (String)this.getModel().getValue("templatetype");
        if (!TemplateTypeEnum.DETAIL.getValue().equals(templateType)) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u884c\u7ef4", (String)"AnalysisTemplateManagePlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0])), DimLocation.ROW.getNumber()));
        }
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9875\u9762\u8fc7\u6ee4\u6761\u4ef6", (String)"AnalysisTemplateManagePlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0])), DimLocation.PAGE.getNumber()));
        dimType.setComboItems(comboItemList);
    }

    private void hideReleaseBtn() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnrelease"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelrelease"});
        }
    }

    private Dimension getDimension(DynamicObject dynamicObject) {
        DimensionType dimensionType;
        long dimensionId = (Long)dynamicObject.getDynamicObject("dimbd").getPkValue();
        String dimType = dynamicObject.getString("dimbdtype");
        Object object = dimensionType = dimType.equals("fpm_detailplanfields") ? DimensionType.DETAILDIM : null;
        if (dimensionType == DimensionType.DETAILDIM) {
            DynamicObject detailDim = this.getDynamicObject(dimensionId, "fpm_detailplanfields");
            Dimension dimension = new Dimension();
            dimension.setId(Long.valueOf(detailDim.getLong("id")));
            dimension.setSystemId(Long.valueOf(detailDim.getLong("bodysys.id")));
            dimension.setName(detailDim.getString("name"));
            dimension.setNumber(detailDim.getString("detaildimtype"));
            dimension.setDimType(DimensionType.DETAILDIM);
            dimension.setDetailDimType(DetailDimType.getDimsionByNumber((String)detailDim.getString("detaildimtype")));
            MemberType memberType = MemberType.getDimsionByNumber((String)detailDim.getString("datatype"));
            dimension.setMemberType(memberType);
            if (memberType == MemberType.ENUM) {
                String enumVal = detailDim.getString("option");
                dimension.setMemberValList(Arrays.asList(enumVal.split(",")));
            }
            dimension.setMustInput(detailDim.getBoolean("ismustinput"));
            dimension.setVisible(detailDim.getBoolean("isshow"));
            return dimension;
        }
        DynamicObject mainDimension = this.getDynamicObject(dimensionId, "fpm_dimension");
        return DimensionPOConverter.convertToMainDimension((DynamicObject)mainDimension, (List)Collections.EMPTY_LIST);
    }

    private DynamicObject getDynamicObject(Long id, String entityName) {
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        if (Objects.isNull(dynamicObject)) {
            dynamicObject = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return dynamicObject;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "model": 
            case "templatetype": 
            case "templateuses": {
                this.initEntry();
                this.resetDimLocationType();
                this.changeBillStatusDownBox();
                break;
            }
            case "ishide": {
                this.triggerByIsHide(e);
                break;
            }
            case "isopen": {
                this.triggerByIsOpen(e);
                break;
            }
            case "isdfsortitem": {
                this.triggerByIsDefaultSortItem(e);
                break;
            }
            case "type": {
                this.triggerByDimType(e);
                break;
            }
            case "dimmemberscope": {
                this.triggerByMemberScope(e);
                break;
            }
            case "dimfilterdim": {
                this.triggerByDimFilter(e);
                break;
            }
            case "plantemplatemember": {
                this.triggerByTemplateMember(e);
                break;
            }
            case "level": {
                this.triggerByLevel(e);
                break;
            }
            case "queryablerpts": {
                this.changeBillStatusDownBox();
                break;
            }
            case "dfquerytpl": {
                this.checkIfDefaultTemplateExist(e);
                break;
            }
            case "newmetrictype": {
                this.fillMetricMember(e);
                break;
            }
            case "totalrow": {
                this.handleSubjectFlowTotal();
                break;
            }
        }
    }

    private void checkIfDefaultTemplateExist(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue.booleanValue()) {
            Object id = this.getModel().getValue("id");
            DynamicObject system = (DynamicObject)this.getModel().getValue("model");
            DynamicObject defaultTemplateExist = TemplateHelper.getDefaultTemplateExist((Object)system.getPkValue());
            if (defaultTemplateExist != null && !Objects.equals(defaultTemplateExist.getLong("id"), id)) {
                String existNumber = defaultTemplateExist.getString("number");
                String existName = defaultTemplateExist.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u7684\u6a21\u677f\u3010%s\u3011\u5df2\u5f00\u542f\u4f5c\u4e3a\u9ed8\u8ba4\u67e5\u8be2\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u4e2a\u9ed8\u8ba4\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AnalysisTemplateManagePlugin_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), existNumber + " " + existName));
                this.getModel().setValue("dfquerytpl", (Object)false);
            }
        }
    }

    private void fillMetricMember(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"newmetrictype"});
    }

    private void triggerByLevel(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if ("1".equals(changeData.getNewValue())) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"containsubtotal", (Object)false, (int)rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"containsubtotal"});
        }
        this.handleSubTotal(changeData);
    }

    private void handleSubTotal(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        DynamicObject dynamicObject = (DynamicObject)dimSets.get(rowIndex);
        String dimType = dynamicObject.getString("dimnumber");
        String templateUses = (String)this.getModel().getValue("templateuses");
        if (StringUtils.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
            return;
        }
        if (DimensionType.SUBJECTS.getNumber().equals(dimType) || DimensionType.CURRENCY.getNumber().equals(dimType)) {
            return;
        }
        if (!TemplateUsesEnum.STATISTIC.getValue().equals(templateUses) && !TemplateUsesEnum.ANALYSIS.getValue().equals(templateUses)) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"containsubtotal"});
    }

    private void triggerByTemplateMember(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection newColl = (DynamicObjectCollection)changeData.getNewValue();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)newColl)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", null, (int)rowIndex);
            return;
        }
        DynamicObjectCollection dimSets = model.getEntryEntity("dimsettingentry");
        DynamicObject dynamicObject = (DynamicObject)dimSets.get(rowIndex);
        String memberScope = dynamicObject.getString("dimmemberscope");
        boolean dimFilter = dynamicObject.getBoolean("dimfilterdim");
        if (memberScope.equals(DimensionMemberScopeEnum.FIXED_MEMBER.getValue()) && dimFilter) {
            if (this.currencyInPage(dynamicObject)) {
                DynamicObjectCollection defaultFilterColl = dynamicObject.getDynamicObjectCollection("defaultfilter");
                List newMemberIdList = newColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                if (EmptyUtil.isEmpty((DynamicObjectCollection)defaultFilterColl)) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", (Object)new Object[]{newMemberIdList.get(0)}, (int)rowIndex);
                } else {
                    Object oldDefaultFilter = ((DynamicObject)defaultFilterColl.get(0)).getDynamicObject("fbasedataid").getPkValue();
                    if (!newMemberIdList.contains(oldDefaultFilter)) {
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", (Object)new Object[]{newMemberIdList.get(0)}, (int)rowIndex);
                    }
                }
                return;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", (Object)changeData.getNewValue(), (int)rowIndex);
        }
    }

    private void triggerByDimFilter(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Boolean dimFilter = (Boolean)changeData.getNewValue();
        IDataModel model = this.getModel();
        DynamicObjectCollection dimSets = model.getEntryEntity("dimsettingentry");
        DynamicObject dynamicObject = (DynamicObject)dimSets.get(rowIndex);
        String memberScope = dynamicObject.getString("dimmemberscope");
        if (EmptyUtil.isEmpty((String)memberScope)) {
            return;
        }
        if (dimFilter.booleanValue()) {
            if (memberScope.equals(DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
                DynamicObjectCollection dimMemberDOC = dynamicObject.getDynamicObjectCollection("plantemplatemember");
                if (this.currencyInPage(dynamicObject)) {
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dimMemberDOC)) {
                        Object firstMember = ((DynamicObject)dimMemberDOC.get(0)).getDynamicObject("fbasedataid").getPkValue();
                        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", (Object)new Object[]{firstMember}, (int)rowIndex);
                    }
                } else {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", (Object)dimMemberDOC, (int)rowIndex);
                }
            }
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"defaultfilter"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"defaultfilter"});
        }
        if (!dimFilter.booleanValue()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", null, (int)rowIndex);
        }
    }

    private void triggerByMemberScope(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        String memberScope = (String)changeData.getNewValue();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (memberScope.equals(DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimfilterdim", (Object)false, (int)rowIndex);
            view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"plantemplatemember"});
        } else if (memberScope.equals(DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getValue())) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimfilterdim", (Object)true, (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"defaultfilter", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"plantemplatemember", null, (int)rowIndex);
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plantemplatemember"});
        }
        this.initDimFilterF7();
    }

    private void triggerByDimType(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        String dimLocation = (String)changeData.getNewValue();
        String templateType = (String)this.getModel().getValue("templatetype");
        String templateUses = (String)this.getModel().getValue("templateuses");
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        DynamicObject dynamicObject = (DynamicObject)dimSets.get(rowIndex);
        String number = dynamicObject.getString("dimnumber");
        if (DimLocation.PAGE.getNumber().equals(dimLocation)) {
            boolean isHide = dynamicObject.getBoolean("ishide");
            if (!isHide) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimmemberscope", (Object)DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getValue(), (int)rowIndex);
            }
            boolean enableScope = TemplateUseType.ANALYSIS.getNumber().equals(templateUses) && !DimsionEnums.PERIOD.getNumber().equals(number);
            this.getView().setEnable(Boolean.valueOf(enableScope), rowIndex, new String[]{"dimmemberscope"});
            if (TemplateTypeEnum.FIXED.getValue().equals(templateType)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"level", (Object)"", (int)rowIndex);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"containsubtotal", (Object)false, (int)rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"level"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"containsubtotal"});
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"isdfsortitem", (Object)false, (int)rowIndex);
        } else {
            if (!number.equals(DimensionType.PERIOD.getNumber())) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmemberscope"});
            }
            if (TemplateTypeEnum.FIXED.getValue().equals(templateType)) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"level"});
                if (!(number.equals(DimensionType.SUBJECTS.getNumber()) || TemplateUseType.STATISTIC.getNumber().equals(templateUses) && number.equals(DimensionType.CURRENCY.getNumber()))) {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"containsubtotal"});
                }
                if (!number.equals(DimensionType.PERIOD.getNumber()) && !number.equals(DimensionType.ORG.getNumber())) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimmemberscope", (Object)DimensionMemberScopeEnum.FIXED_MEMBER.getValue(), (int)rowIndex);
                }
            }
        }
        if (DimLocation.COL.getNumber().equals(dimLocation)) {
            boolean switchOn = true;
            for (DynamicObject dimSet : dimSets) {
                boolean hasOn = dimSet.getBoolean("isopen");
                if (!hasOn) continue;
                switchOn = false;
                break;
            }
            this.getView().setEnable(Boolean.valueOf(switchOn), rowIndex, new String[]{"isopen"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"isopen", (Object)false, (int)rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"isdfsortitem"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isopen"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"isopen", (Object)false, (int)rowIndex);
        }
    }

    private void triggerByIsHide(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Boolean isHide = (Boolean)changeData.getNewValue();
        IDataModel model = this.getModel();
        DynamicObjectCollection dimSets = model.getEntryEntity("dimsettingentry");
        DynamicObject dynamicObject = (DynamicObject)dimSets.get(rowIndex);
        String dimBdType = dynamicObject.getString("dimbdtype");
        if (EmptyUtil.isEmpty((String)dimBdType)) {
            return;
        }
        String dimType = dynamicObject.getString("type");
        if (isHide.booleanValue()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimmemberscope", (Object)"", (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"plantemplatemember", (Object)"", (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dimfilterdim", (Object)false, (int)rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plantemplatemember"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimfilterdim"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdfsortitem"});
            if (!dimBdType.equals("fpm_detailplanfields")) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"type", (Object)DimLocation.PAGE.getNumber(), (int)rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"type"});
            }
        } else {
            if (!dimBdType.equals("fpm_detailplanfields")) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmemberscope"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"type"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimfilterdim"});
            }
            if (DimLocation.COL.getNumber().equals(dimType)) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"isdfsortitem"});
            }
        }
    }

    private void triggerByIsOpen(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Boolean isOpen = (Boolean)changeData.getNewValue();
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        String number = ((DynamicObject)dimSets.get(rowIndex)).getString("dimnumber");
        if (!isOpen.booleanValue()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"containsubtotal", (Object)false, (int)rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"containsubtotal"});
            for (int i = 0; i < dimSets.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dimSets.get(i);
                if (this.getDimension(dynamicObject).getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ishide", (Object)false, (int)i);
                }
                if (i == rowIndex) continue;
                String dimBdType = dynamicObject.getString("dimbdtype");
                String dimType = dynamicObject.getString("type");
                if (dimBdType.equals("fpm_detailplanfields") || !DimLocation.COL.getNumber().equals(dimType)) continue;
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"isopen"});
            }
            if (!number.equals(DimensionType.ORG.getNumber()) && !number.equals(DimensionType.PERIOD.getNumber())) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"dimmemberscope", (Object)DimensionMemberScopeEnum.SELECT_WHEN_VIEWING.getValue(), (int)rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmemberscope"});
            }
        } else {
            for (int i = 0; i < dimSets.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dimSets.get(i);
                if (this.getDimension(dynamicObject).getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ishide", (Object)true, (int)i);
                }
                if (i == rowIndex) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isopen"});
            }
            if (!number.equals(DimensionType.SUBJECTS.getNumber())) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"containsubtotal"});
            }
            if (!number.equals(DimensionType.ORG.getNumber()) && !number.equals(DimensionType.PERIOD.getNumber())) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"dimmemberscope", (Object)DimensionMemberScopeEnum.FIXED_MEMBER.getValue(), (int)rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmemberscope"});
            }
        }
    }

    private void triggerByIsDefaultSortItem(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Boolean isDefaultSortItem = (Boolean)changeData.getNewValue();
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        if (!isDefaultSortItem.booleanValue()) {
            for (int i = 0; i < dimSets.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dimSets.get(i);
                if (this.getDimension(dynamicObject).getDetailDimType() == DetailDimType.PLAN_AMOUNT || dynamicObject.getString("type").equals(DimLocation.PAGE.getNumber())) continue;
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"isdfsortitem"});
            }
        } else {
            for (int i = 0; i < dimSets.size(); ++i) {
                if (i == rowIndex) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isdfsortitem"});
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isdfsortitem", (Object)false, (int)i);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationResult operationResult;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            if (!this.checkDimMember()) {
                args.setCancel(true);
            }
            this.handleSubjectFlowTotal();
        }
        if ("releaseop".equals(operate.getOperateKey()) && !(operationResult = this.getView().invokeOperation("save")).isSuccess()) {
            args.setCancel(true);
        }
    }

    private boolean checkDimMember() {
        DynamicObject system = (DynamicObject)this.getModel().getValue("model");
        if (system == null) {
            this.showBodySysNotification();
            return false;
        }
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(((Long)system.getPkValue()).longValue());
        DynamicObject[] memberDOs = TmcDataServiceHelper.load((String)"fpm_member", (String)"id,name,number,enable", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", system.getPkValue())});
        Map memberMap = Arrays.stream(memberDOs).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        DynamicObjectCollection dimSets = this.getModel().getEntryEntity("dimsettingentry");
        StringBuilder errMsg = new StringBuilder();
        Map dimMap = fundPlanSystem.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (k1, k2) -> k1));
        for (DynamicObject dimSet : dimSets) {
            Long id;
            DynamicObject dimension = dimSet.getDynamicObject("dimbd");
            String memberScope = dimSet.getString("dimmemberscope");
            DynamicObjectCollection templateMembers = dimSet.getDynamicObjectCollection("plantemplatemember");
            if (DimensionMemberScopeEnum.FIXED_MEMBER.getValue().equals(memberScope)) {
                for (DynamicObject templateMember : templateMembers) {
                    DynamicObject dynamicObject = templateMember.getDynamicObject("fbasedataid");
                    if (dynamicObject != null && memberMap.containsKey(dynamicObject.getPkValue())) {
                        DynamicObject memberDO = (DynamicObject)memberMap.get(dynamicObject.getPkValue());
                        boolean enable = memberDO.getBoolean("enable");
                        if (enable) continue;
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011\u6210\u5458\u3010%2$s\u3011\u5df2\u88ab\u7981\u7528", (String)"AnalysisTemplateManagePlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimension.getString("name"), dynamicObject.getString("name")));
                        continue;
                    }
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011\u5df2\u9009\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u5df2\u88ab\u5220\u9664\u9879\uff0c\u8bf7\u68c0\u67e5", (String)"AnalysisTemplateManagePlugin_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimension.getString("name")));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)dimSet.getString("dimnumber")) || !dimMap.containsKey(id = Long.valueOf(dimension.getLong("id"))) || ((Dimension)dimMap.get(id)).isVisible()) continue;
            errMsg.append(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5b57\u6bb5\u3010%1$s\u3011\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u89c1\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AnalysisTemplateManagePlugin_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimension.getString("name")));
        }
        if (errMsg.length() > 0) {
            this.getView().showErrorNotification(errMsg.toString());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnrelease"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"templateuses", "templatetype"});
        } else if ("releaseop".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelrelease"});
            this.getView().invokeOperation("refresh");
        } else if ("cancelrelease".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void initF7() {
        this.initDimMemberF7();
        this.initDimFilterF7();
        this.bodySysF7Model();
        this.initMetricMemberF7();
    }

    private void initMetricMemberF7() {
        BasedataEdit control = (BasedataEdit)this.getControl("newmetrictype");
        DynamicObject system = (DynamicObject)this.getModel().getValue("model");
        control.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (system == null) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("metricentry");
            List idList = entryEntity.stream().map(dynamicObject -> dynamicObject.getDynamicObject("newmetrictype")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter filter = new QFilter("bodysystem", "=", system.getPkValue());
            filter.and(new QFilter("dimtype", "=", (Object)"Metric"));
            filter.and(new QFilter("id", "not in", idList));
            showParameter.getListFilterParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u6790\u6307\u6807", (String)"AnalysisTemplateManagePlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    private void initDimFilterF7() {
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("defaultfilter");
        mulBasedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject system = (DynamicObject)this.getModel().getValue("model");
            if (system == null) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimsettingentry");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimsettingentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("plantemplatemember");
            Object pkValue = system.getPkValue();
            Object dimId = dynamicObject.getDynamicObject("dimbd").getPkValue();
            String dimType = dynamicObject.getDynamicObject("dimbd").getString("number");
            QFilter qFilter = new QFilter("dimension", "=", dimId).and("bodysystem", "=", pkValue).and("enable", "=", (Object)"1");
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                List idList = dynamicObjectCollection.stream().map(dynamicObject1 -> dynamicObject1.getDynamicObject("fbasedataid")).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
                qFilter.and("id", "in", idList);
            }
            formShowParameter.getListFilterParameter().setFilter(qFilter);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8fc7\u6ee4\u9009\u9879", (String)"AnalysisTemplateManagePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            if (this.currencyInPage(dynamicObject)) {
                formShowParameter.setMultiSelect(false);
            }
        });
    }

    private void initDimMemberF7() {
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("plantemplatemember");
        mulBasedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject system = (DynamicObject)this.getModel().getValue("model");
            if (system == null) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimsettingentry");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimsettingentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
            DynamicObject dimObj = dynamicObject.getDynamicObject("dimbd");
            Object dimId = dimObj.getPkValue();
            Object pkValue = system.getPkValue();
            String dimType = dimObj.getString("basedata");
            QFilter qFilter = new QFilter("dimension", "=", dimId).and("dimtype", "=", (Object)dimType).and("bodysystem", "=", pkValue).and("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().setFilter(qFilter);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u9009\u9879", (String)"AnalysisTemplateManagePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        });
    }

    private void bodySysF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("model");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f-\u4f53\u7cfb\u540d\u79f0\u3002", (String)"AnalysisTemplateManagePlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void changeBillStatusDownBox() {
        Object value = this.getModel().getValue("queryablerpts");
        MulComboEdit billStatus = (MulComboEdit)this.getControl("queryablebs");
        this.getModel().setValue("queryablebs", (Object)BillState.AUDITED.getNumber());
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        if (value != null) {
            String strVal = (String)value;
            if (strVal.contains(ReportStatus.DISABLE.getVal()) || strVal.contains(ReportStatus.BEBACK.getVal())) {
                comboItemList.add(new ComboItem(new LocaleString(BillState.STAGE.getName()), BillState.STAGE.getNumber()));
                comboItemList.add(new ComboItem(new LocaleString(BillState.COMMITTED.getName()), BillState.COMMITTED.getNumber()));
            }
            comboItemList.add(new ComboItem(new LocaleString(BillState.AUDITED.getName()), BillState.AUDITED.getNumber()));
        }
        billStatus.setComboItems(comboItemList);
    }

    private void handleSubjectFlowTotal() {
        String templateType = (String)this.getModel().getValue("templatetype");
        if (!TemplateTypeEnum.DETAIL.getValue().equals(templateType)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimsettingentry");
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        boolean enableTotal = entryEntity.stream().anyMatch(item -> item.getBoolean("totalrow"));
        if (!enableTotal) {
            for (int i = 0; i < this.getModel().getEntryRowCount("dimsettingentry"); ++i) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
            }
            return;
        }
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("dimsettingentry");
        List subjectMemberObjs = collection.stream().filter(item -> "fpm_dimension".equals(item.getString("dimbdtype"))).filter(item -> DimsionEnums.SUBJECT.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("plantemplatemember")).flatMap(Collection::stream).collect(Collectors.toList());
        long subjectFlowCount = subjectMemberObjs.stream().map(item -> item.get("fbasedataid.flow")).distinct().count();
        long currencyCount = collection.stream().filter(item -> "fpm_dimension".equals(item.getString("dimbdtype"))).filter(item -> DimsionEnums.CURRENCY.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("plantemplatemember")).mapToLong(Collection::size).sum();
        if (currencyCount * subjectFlowCount > 20L) {
            for (int i = 0; i < this.getModel().getEntryRowCount("dimsettingentry"); ++i) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
            }
            return;
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("dimsettingentry"); ++i) {
            DynamicObject rowDim = this.getModel().getEntryRowEntity("dimsettingentry", i);
            if (!Objects.equals(rowDim.getString("dimbdtype"), TemplateDimBDTypeEnum.DIM.getValue())) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                continue;
            }
            if (!Objects.equals(rowDim.getDynamicObject("dimbd").getString("basedata"), DimsionEnums.SUBJECT.getNumber())) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                continue;
            }
            boolean subjectExpend = rowDim.getBoolean("isopen");
            if (subjectExpend) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                break;
            }
            boolean subjectInPage = DimLocation.PAGE.getNumber().equals(rowDim.getString("type"));
            if (subjectInPage) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                break;
            }
            this.getModel().setValue("subjectflowtotal", (Object)true, i);
            break;
        }
    }

    private boolean currencyInPage(DynamicObject dynamicObject) {
        return DimensionType.CURRENCY.getNumber().equals(dynamicObject.getString("dimnumber")) && DimLocation.PAGE.getNumber().equals(dynamicObject.getString("type"));
    }
}

