/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.mvc.converter.utils.TypeEnumUtil;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.RowColType;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.formplugin.helper.DimMemberHelper;

public class DimLayoutPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"expandmembertext"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.echoData();
        IDataModel model = this.getView().getParentView().getModel();
        Boolean releaseFlag = (Boolean)model.getValue("releasestatus");
        if (releaseFlag.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("isopen".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("dim");
            if (DimsionEnums.PERIOD.getNumber().equals(dimObj.get("basedata"))) {
                this.getModel().setValue("expandmember", null);
                if (Boolean.TRUE.equals(newValue)) {
                    this.getModel().setValue("expandmembertext", (Object)ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DimLayoutPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getModel().setValue("expandmembertext", (Object)"");
                }
            }
            if (Boolean.FALSE.equals(newValue)) {
                this.getModel().setValue("expandmember", null);
            }
        } else if ("expandmembertext".equals(name) && changeSet[0].getNewValue() != null && "".equals(changeSet[0].getNewValue())) {
            this.getModel().setValue("expandmember", null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("expandmembertext".equals(key)) {
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("dim");
            FormShowParameter sp = this.getView().getFormShowParameter().getShowParameter();
            Object modelId = sp.getCustomParam("modelId");
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("expandmember");
            List<Object> selectedIdList = memberColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            DimsionEnums dimEnum = DimsionEnums.getDimsionByNumber((String)dimObj.getString("basedata"));
            DimMemberHelper.buildMemberTreeCustomF7(dimEnum, Long.valueOf(modelId.toString()), this, "expandmembertext", selectedIdList, null, TreeDataSelectedType.NOTREESTRU, (Long)dimObj.getPkValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("expandmembertext".equals(actionId)) {
            TreeDataSelectedReturnData returnData = (TreeDataSelectedReturnData)e.getReturnData();
            this.fillMemberInfo(returnData);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confirmop".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            TemplateLayout templateLayout = new TemplateLayout();
            Object value = this.getModel().getValue("templatetype");
            templateLayout.setTemplateType(TemplateType.valueOf((String)TemplateType.getByNumber((String)value.toString()).name()));
            ArrayList<TemplateLayout.LayoutInfo> layoutInfoList = new ArrayList<TemplateLayout.LayoutInfo>();
            DynamicObjectCollection dimEntry = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dimObj : dimEntry) {
                TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
                layoutInfo.setDimensionId(Long.valueOf(dimObj.getLong("dim.id")));
                layoutInfo.setDimensionName(dimObj.getString("dim.name"));
                layoutInfo.setDimLocation(DimLocation.valueOf((String)RowColType.get((String)dimObj.getString("dimtype")).name()));
                layoutInfo.setLevel(Integer.valueOf(dimObj.getInt("dimlevel")));
                layoutInfo.setExpand(dimObj.getBoolean("isopen"));
                layoutInfo.setIncludeSum(dimObj.getBoolean("iscontaintotal"));
                DynamicObjectCollection exMember = dimObj.getDynamicObjectCollection("expandmember");
                if (exMember != null && exMember.size() > 0) {
                    List exMemberIdList = exMember.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
                    layoutInfo.setExpandMembers(exMemberIdList);
                }
                layoutInfo.setVisible(!dimObj.getBoolean("ishide"));
                layoutInfo.setScopeType((TemplateDimMemScopeType)ITypeEnum.getByNumber((String)dimObj.getString("memberscope"), TemplateDimMemScopeType.class));
                layoutInfo.setFilterDim(dimObj.getBoolean("filterdim"));
                layoutInfoList.add(layoutInfo);
            }
            templateLayout.setDimLayoutInfoList(layoutInfoList);
            this.getView().returnDataToParent((Object)templateLayout);
            this.getView().close();
        }
    }

    private void echoData() {
        FormShowParameter showParameter = this.getView().getFormShowParameter().getShowParameter();
        String templateLayoutStr = (String)showParameter.getCustomParam(TemplateLayout.class.getName());
        this.getModel().setValue("templateuses", showParameter.getCustomParam("templateUses"));
        this.getModel().setValue("maintable", showParameter.getCustomParam("maintable"));
        this.initComboItemForMemberScope();
        this.initComboItemForDimType();
        TemplateLayout templateLayout = (TemplateLayout)JSON.parseObject((String)templateLayoutStr, TemplateLayout.class);
        if (templateLayout == null) {
            return;
        }
        TemplateType templateType = templateLayout.getTemplateType();
        List dimLayoutInfoList = templateLayout.getDimLayoutInfoList();
        ComboEdit dimType = (ComboEdit)this.getView().getControl("dimtype");
        ArrayList<ComboItem> dimTypeItemList = new ArrayList<ComboItem>();
        if (TemplateType.FIXED == templateType) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isopen", "expandmember"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"dimlevel"});
            dimTypeItemList.add(new ComboItem(new LocaleString(RowColType.ROW.getName()), RowColType.ROW.getValue()));
            dimTypeItemList.add(new ComboItem(new LocaleString(RowColType.COL.getName()), RowColType.COL.getValue()));
            dimTypeItemList.add(new ComboItem(new LocaleString(RowColType.PAGE.getName()), RowColType.PAGE.getValue()));
        } else if (TemplateType.DETAIL == templateType) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isopen", "expandmember"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimlevel"});
            dimTypeItemList.add(new ComboItem(new LocaleString(RowColType.COL.getName()), RowColType.COL.getValue()));
            dimTypeItemList.add(new ComboItem(new LocaleString(RowColType.PAGE.getName()), RowColType.PAGE.getValue()));
        }
        this.getModel().setValue("templatetype", (Object)templateType.getNumber());
        dimType.setComboItems(dimTypeItemList);
        DynamicObjectCollection dimLayoutColl = this.getModel().getEntryEntity("entryentity");
        int row = 0;
        for (TemplateLayout.LayoutInfo layoutInfo : dimLayoutInfoList) {
            DynamicObject dimLayout = dimLayoutColl.addNew();
            this.getModel().setValue("dim", (Object)layoutInfo.getDimensionId(), row);
            dimLayout.set("ishide", (Object)(!layoutInfo.isVisible() ? 1 : 0));
            dimLayout.set("dimtype", (Object)RowColType.valueOf((String)layoutInfo.getDimLocation().name()).getValue());
            dimLayout.set("memberscope", (Object)TypeEnumUtil.getNumberOrDefault((ITypeEnum)layoutInfo.getScopeType()));
            dimLayout.set("filterdim", (Object)layoutInfo.isFilterDim());
            if (TemplateType.FIXED == templateType) {
                dimLayout.set("dimlevel", (Object)(layoutInfo.getLevel() == 0 ? null : layoutInfo.getLevel()));
            } else if (TemplateType.DETAIL == templateType) {
                dimLayout.set("iscontaintotal", (Object)layoutInfo.isIncludeSum());
                dimLayout.set("isopen", (Object)layoutInfo.isExpand());
                if (layoutInfo.isExpand()) {
                    if (layoutInfo.getExpandMembers() != null && layoutInfo.getExpandMembers().size() > 0) {
                        this.getModel().setValue("expandmember", (Object)layoutInfo.getExpandMembers().toArray(), row);
                        DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("expandmember", row);
                        List nameList = memberColl.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getString("name")).collect(Collectors.toList());
                        this.getModel().setValue("expandmembertext", (Object)String.join((CharSequence)",", nameList), row);
                    } else {
                        this.getModel().setValue("expandmembertext", (Object)ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DimLayoutPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), row);
                    }
                }
            }
            ++row;
        }
    }

    private void initComboItemForDimType() {
        RowColType[] rowColTypes;
        ArrayList<ComboItem> dimTypeItems = new ArrayList<ComboItem>(3);
        for (RowColType rowColType : rowColTypes = RowColType.values()) {
            dimTypeItems.add(new ComboItem(new LocaleString(rowColType.getName()), rowColType.getValue()));
        }
        ComboEdit dimTypeCombo = (ComboEdit)this.getControl("dimtype");
        dimTypeCombo.setComboItems(dimTypeItems);
    }

    private void initComboItemForMemberScope() {
        DimensionMemberScopeEnum[] values;
        String templateUse = (String)this.getModel().getValue("templateuses");
        if (!Objects.equals(templateUse, TemplateUsesEnum.SUMMARY.getValue())) {
            return;
        }
        Boolean mainTable = (Boolean)this.getModel().getValue("maintable");
        if (EmptyUtil.isEmpty((Object)mainTable) || !mainTable.booleanValue()) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        for (DimensionMemberScopeEnum scopeEnum : values = DimensionMemberScopeEnum.values()) {
            if (scopeEnum == DimensionMemberScopeEnum.SELECT_WHEN_VIEWING || scopeEnum == DimensionMemberScopeEnum.FIXED_MEMBER) continue;
            comboItems.add(new ComboItem(new LocaleString(scopeEnum.getBridge().loadKDString()), scopeEnum.getValue()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("memberscope");
        comboEdit.setComboItems(comboItems);
    }

    private void fillMemberInfo(TreeDataSelectedReturnData returnData) {
        if (returnData != null) {
            List selectedPkList = returnData.getRightTreeIdSet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            this.getModel().setValue("expandmember", (Object)selectedPkList.toArray());
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("expandmember");
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            this.getModel().setValue("expandmembertext", (Object)String.join((CharSequence)",", selectedNameList));
            this.getView().updateView("entryentity");
        }
    }
}

