/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.WaysEnum;

public class TemplateAccountSettingEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String BTNOK = "btnok";
    private ReportTemplate reportTemplate;
    private List<TemplateAccountSetting> accountSettings;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid control = (EntryGrid)this.getView().getControl("entry");
        control.addHyperClickListener((HyperLinkClickListener)this);
        Button prevBtn = (Button)this.getControl(BTNOK);
        prevBtn.addClickListener((ClickListener)this);
        this.initControlEvi();
        this.addClickListeners(new String[]{"formula", "clear", "batchset", "expandall", "closeall", "expandalldes", "closealldes"});
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl("entry");
        treeentry.addRowClickListener((RowClickEventListener)this);
    }

    private void initControlEvi() {
        BasedataEdit templateF7 = (BasedataEdit)this.getView().getControl("template");
        templateF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            List<QFilter> templateQFilters = this.createTemplateQFilter(evt.getRow());
            sp.getListFilterParameter().setQFilters(templateQFilters);
            sp.setMultiSelect(false);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.closeAll(false);
        ReportTemplate reportTemplate = this.getReportTemplate();
        boolean notMainTable = !reportTemplate.isMainTable();
        boolean summary = reportTemplate.getTemplateUse().isSummary();
        if (summary || notMainTable) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("entry");
            treeEntryGrid.getView().setVisible(Boolean.valueOf(false), new String[]{"hideinreport"});
        }
        this.handleHideInReportEntryTree();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportTemplate reportTemplate = this.getReportTemplate();
        boolean mainTable = reportTemplate.isMainTable() && reportTemplate.getTemplateUse() != TemplateUseType.SUMMARY;
        this.getView().setVisible(Boolean.valueOf(mainTable), new String[]{"template", "batchset"});
        if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("ways");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(4);
            for (WaysEnum waysEnum : WaysEnum.values()) {
                if (waysEnum == WaysEnum.DETAILED_REPORT) continue;
                comboItemList.add(new ComboItem(new LocaleString(waysEnum.getName()), waysEnum.getValue()));
            }
            comboEdit.setComboItems(comboItemList);
        }
        this.batchCreateEntry();
        IDataModel model = this.getView().getParentView().getModel();
        Boolean releaseFlag = (Boolean)model.getValue("releasestatus");
        if (releaseFlag.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entry"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTNOK});
        }
    }

    private List<TemplateAccountSetting> getAndSetSettingObject() {
        if (CollectionUtils.isEmpty(this.accountSettings)) {
            this.accountSettings = this.convertAccountSetting(this.getModel().getDataEntity(true));
        }
        return this.accountSettings;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("formula".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
            String ways = entry.getString("ways");
            if (!ReportInputType.FORMULA.getNumber().equals(ways)) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId("fpm_subjectformula");
            String expressdesc = entry.getString("formula");
            String express = entry.getString("formuladesc");
            DynamicObject subject = entry.getDynamicObject("account");
            Object subjectPK = subject.getPkValue();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", subjectPK);
            params.put("express", express);
            params.put("expressDesc", expressdesc);
            params.put("model", subject.getDynamicObject("bodysystem").getPkValue());
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            List asList = entrys.stream().map(v -> v.getDynamicObject("account").getLong("id")).collect(Collectors.toList());
            params.put("enableIds", JSON.toJSONString(asList));
            List cacheSubjectList = entrys.stream().filter(item -> {
                boolean isFormulaTerm;
                Object entryAccountId = item.getDynamicObject("account").getPkValue();
                boolean bl = isFormulaTerm = WaysEnum.isFormulaTerm((String)item.getString("ways")) && !Objects.equals(subjectPK, entryAccountId);
                if (isFormulaTerm) {
                    return true;
                }
                return WaysEnum.isSummaryItem((String)item.getString("ways"));
            }).collect(Collectors.toList());
            List subjectIds = cacheSubjectList.stream().map(item -> item.getDynamicObject("account")).filter(Objects::nonNull).map(item -> Long.valueOf(item.getPkValue().toString())).collect(Collectors.toList());
            HashMap cacheSubjectMap = new HashMap(10);
            String prop = String.join((CharSequence)",", "id", "parent.id");
            DynamicObjectCollection subjectMemberCollection = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "in", subjectIds)});
            if (CollectionUtils.isEmpty((Collection)subjectMemberCollection)) {
                return;
            }
            Map subjectMemberMap = subjectMemberCollection.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity()));
            for (DynamicObject cacheSubject : cacheSubjectList) {
                Object pkValue = cacheSubject.getDynamicObject("account").getPkValue();
                DynamicObject subjectMember = (DynamicObject)subjectMemberMap.get(Long.valueOf(pkValue.toString()));
                if (Objects.isNull(subjectMember)) continue;
                HashMap<String, Object> subjectMap = new HashMap<String, Object>(3);
                subjectMap.put("parent.id", subjectMember.getLong("parent.id"));
                subjectMap.put("ways", cacheSubject.getString("ways"));
                subjectMap.put("formulavalue", cacheSubject.getString("formuladesc"));
                cacheSubjectMap.put(subjectMember.getLong("id"), subjectMap);
            }
            params.put("cachesubject", JSON.toJSONString(cacheSubjectMap));
            parameter.setCustomParams(params);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_formulaedit"));
            this.getView().showForm(parameter);
        } else if ("batchset".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fpm_batchsetting");
            showParameter.setAppId("fpm");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchset"));
            HashMap params = new HashMap(4);
            ReportTemplate reportTemplate = this.getReportTemplate();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                String tipMessage = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u8bb0\u5f55\u3002", (String)"TemplateAccountSettingEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipMessage);
                return;
            }
            ArrayList<Long> acctIds = new ArrayList<Long>(10);
            Set<Long> parentIds = this.getParentIds();
            for (int selectRow : selectRows) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entry", selectRow);
                if (entry.getString("ways").equals(WaysEnum.FORMULA_TERM.getValue()) || entry.getString("ways").equals(WaysEnum.SUMMARY_ITEM.getValue()) || parentIds.contains(entry.getLong("id"))) continue;
                acctIds.add(entry.getLong("account_id"));
            }
            params.put("acctIds", acctIds);
            params.put("reportTemplate", this.getReportTemplate());
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        } else if ("expandalldes".equals(key) || "expandall".equals(key)) {
            this.expandAll();
        } else if ("closealldes".equals(key) || "closeall".equals(key)) {
            this.closeAll(true);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int currClickRow = evt.getRow();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currClickRow);
        if (EmptyUtil.isEmpty((DynamicObject)entry)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        boolean isContainSubLevel = this.getModel().getDataEntity().getBoolean("containsublevel");
        if (isContainSubLevel) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)evt.getSource();
            List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
            Set<Long> parentIds = this.getParentIds();
            long id = entry.getLong("id");
            if (rows.contains(currClickRow)) {
                this.recursiveCheckSubNode(id, entryEntity, parentIds, entryGrid, true);
            } else {
                this.recursiveCheckSubNode(id, entryEntity, parentIds, entryGrid, false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        boolean mainTable = this.getReportTemplate().isMainTable();
        operate.getOption().setVariableValue("ismaintable", String.valueOf(mainTable));
        switch (operateKey = operate.getOperateKey()) {
            case "confirm": {
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
                boolean allHide = entry.stream().allMatch(item -> item.getBoolean("hideinreport"));
                if (!allHide) break;
                String errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6a21\u677f\u4e2d\u4e0d\u5141\u8bb8\u6240\u6709\u8ba1\u5212\u79d1\u76ee\u5747\u8bbe\u7f6e\u4e3a\u9690\u85cf\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"TemplateAccountSettingEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("close_formulaedit".equals(actionId) && event.getReturnData() != null) {
            HashMap expressions = (HashMap)event.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            this.getModel().setValue("formula", expressions.get("expressiondesc"), rowIndex);
            this.getModel().setValue("formuladesc", expressions.get("expression"), rowIndex);
        } else if ("batchset".equals(actionId) && event.getReturnData() != null) {
            Map returnData = (Map)event.getReturnData();
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("entry");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject templateDy = null;
            Set<Long> parentIds = this.getParentIds();
            for (int selectRow : selectRows) {
                Long entryId;
                DynamicObject entry = this.getModel().getEntryRowEntity("entry", selectRow);
                if (entry.getString("ways").equals(WaysEnum.FORMULA_TERM.getValue()) || entry.getString("ways").equals(WaysEnum.SUMMARY_ITEM.getValue()) || parentIds.contains(entryId = Long.valueOf(entry.getLong("id")))) continue;
                if (EmptyUtil.isNoEmpty(returnData.get("ways"))) {
                    entry.set("ways", returnData.get("ways"));
                }
                if (EmptyUtil.isNoEmpty(returnData.get("templateId"))) {
                    if (EmptyUtil.isEmpty(templateDy)) {
                        templateDy = BusinessDataServiceHelper.loadSingle(returnData.get("templateId"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
                    }
                    entry.set("template", templateDy);
                    continue;
                }
                entry.set("template", null);
            }
            this.getView().updateView("entry");
            this.handleSubjectEntryTree();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if ("confirm".equals(operateKey) && eventArgs.getOperationResult().isSuccess()) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            ArrayList<TemplateAccountSetting> settings = new ArrayList<TemplateAccountSetting>(entrys.size());
            for (DynamicObject entry : entrys) {
                TemplateAccountSetting setting = new TemplateAccountSetting();
                setting.setId(entry.getLong("settingid"));
                setting.setAccountMemId(Long.valueOf(entry.getDynamicObject("account").getLong("id")));
                setting.setFormula(entry.getString("formuladesc"));
                DynamicObject sonTemplate = entry.getDynamicObject("template");
                if (null != sonTemplate) {
                    setting.setChildTemplateId(Long.valueOf(sonTemplate.getLong("id")));
                }
                String ways = entry.getString("ways");
                ReportInputType reportInputType = ReportInputType.getByNumber((String)ways);
                setting.setInputType(reportInputType);
                setting.setHideInReport(entry.getBoolean("hideinreport"));
                settings.add(setting);
            }
            this.getView().returnDataToParent((Object)JSON.toJSONString(settings));
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("number".equals(fieldName)) {
            int rowIndex = event.getRowIndex();
            DynamicObject entryRow = this.getModel().getEntryRowEntity("entry", rowIndex);
            Object accountId = entryRow.getDynamicObject("account").getPkValue();
            BillShowParameter sp = new BillShowParameter();
            sp.setPkId(accountId);
            sp.setBillStatus(BillOperationStatus.VIEW);
            sp.setStatus(OperationStatus.VIEW);
            sp.setFormId("fpm_member_subject");
            sp.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6a21\u677f", (String)"TemplateAccountSettingEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            sp.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("600");
            css.setHeight("446");
            sp.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm((FormShowParameter)sp);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changePrpName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (changePrpName) {
            case "ways": {
                int rowIndex = model.getEntryCurrentRowIndex("entry");
                DynamicObject entryRowEntity = model.getEntryRowEntity("entry", rowIndex);
                String ways = entryRowEntity.getString("ways");
                if (!ReportInputType.FORMULA.getNumber().equals(ways)) {
                    model.setValue("formula", null, rowIndex);
                    model.setValue("formuladesc", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"formula"});
                }
                if (ReportInputType.DETAIL_INPUT.getNumber().equals(ways)) {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"template"});
                    break;
                }
                model.setValue("template", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"template"});
                break;
            }
            case "hideinreport": {
                this.handleHideInReportChange();
                break;
            }
        }
    }

    private List<QFilter> createTemplateQFilter(int currRowIndex) {
        ReportTemplate reportTemplate = this.getReportTemplate();
        List reportPeriods = reportTemplate.getReportPeriods();
        List allTemplateDim = reportTemplate.getAllTemplateDim();
        List visibleDimIds = allTemplateDim.stream().filter(TemplateDim::isVisible).map(TemplateDim::getId).collect(Collectors.toList());
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"fpm_dimension", (String)"basedata", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)visibleDimIds.toArray())});
        Set mainTableDimTypes = dimensions.stream().map(v -> v.getString("basedata")).collect(Collectors.toSet());
        List<QFilter> qFilters = Arrays.asList(new QFilter("ismaintable", "=", (Object)"0"), new QFilter("releasestatus", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("model.id", "=", (Object)reportTemplate.getSystemId()), new QFilter("templateuses", "=", (Object)reportTemplate.getTemplateUse().getNumber()));
        DynamicObject subject = (DynamicObject)this.getModel().getValue("account");
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_template", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0));
        }
        DynamicObject[] templates = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
        ArrayList<Long> templateIds = new ArrayList<Long>();
        for (DynamicObject template : templates) {
            DynamicObjectCollection reporttypes;
            List reporttypeFromDBIds;
            boolean reportTypeCheck;
            DynamicObjectCollection layoutEntrys;
            Set subDimTypes;
            boolean subDimCheck;
            boolean currencyScopeCheck;
            Set<Object> subjectIds;
            DynamicObjectCollection dimSetEntry = template.getDynamicObjectCollection("layoutentry");
            List subDimIdList = dimSetEntry.stream().filter(item -> !item.getBoolean("dimhide")).map(item -> item.getLong("layoutdim.id")).collect(Collectors.toList());
            TemplateLayout dimLayout = reportTemplate.getDimLayout();
            List dimLayoutInfoList = dimLayout.getDimLayoutInfoList();
            List currDimIdList = dimLayoutInfoList.stream().filter(TemplateLayout.LayoutInfo::isVisible).map(TemplateLayout.LayoutInfo::getDimensionId).collect(Collectors.toList());
            if (subDimIdList.size() < currDimIdList.size() || currDimIdList.removeAll(subDimIdList) && currDimIdList.size() != 0) continue;
            if (template.getString("templatetype").equals(TemplateTypeEnum.FIXED.getValue())) {
                DynamicObjectCollection subjectEntrys = template.getDynamicObjectCollection("subjecttentry");
                List subjectObjs = subjectEntrys.stream().map(item -> item.getDynamicObject("subject")).filter(item -> item.getBoolean("isleaf")).collect(Collectors.toList());
                subjectIds = new HashSet(subjectObjs.size());
                for (DynamicObject subjectObj : subjectObjs) {
                    subjectIds.add(subjectObj.getString("id"));
                    subjectIds.add(subjectObj.getString("parent.id"));
                }
            } else {
                dimSetEntry = template.getDynamicObjectCollection("dimsettingentry");
                Optional<DynamicObject> first = dimSetEntry.stream().filter(item -> TemplateDimBDTypeEnum.DIM.getValue().equals(item.getString("dimbdtype")) && DimsionEnums.SUBJECT.getNumber().equals(item.get("dimbd.basedata"))).findFirst();
                if (!first.isPresent()) continue;
                DynamicObject subjectDimEntry = first.get();
                DynamicObjectCollection subjectMember = subjectDimEntry.getDynamicObjectCollection("plantemplatemember");
                subjectIds = subjectMember.stream().map(item -> item.getString("fbasedataid.id")).collect(Collectors.toSet());
            }
            if (!subjectIds.contains(subject.getString("id"))) continue;
            List currencyIds = reportTemplate.getCurrencyMemberIdList();
            DynamicObjectCollection currencys = template.getDynamicObjectCollection("currencymember");
            List currencyFromDBIds = currencys.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            boolean bl = currencyScopeCheck = CollectionUtils.isEmpty((Collection)currencyIds) || currencyFromDBIds.containsAll(currencyIds);
            if (!currencyScopeCheck || !(subDimCheck = (subDimTypes = (layoutEntrys = template.getDynamicObjectCollection("layoutentry")).stream().filter(v -> v.getBoolean("dimhide")).map(v -> v.getDynamicObject("layoutdim").getString("basedata")).collect(Collectors.toSet())).containsAll(mainTableDimTypes)) || !(reportTypeCheck = (reporttypeFromDBIds = (reporttypes = template.getDynamicObjectCollection("reporttype")).stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).containsAll(reportPeriods))) continue;
            templateIds.add(template.getLong("id"));
        }
        if (!CollectionUtils.isEmpty(templateIds)) {
            return Collections.singletonList(new QFilter("id", "in", (Object)templateIds.toArray()));
        }
        return Collections.singletonList(new QFilter("id", "=", (Object)0));
    }

    private void batchCreateEntry() {
        ReportTemplate reportTemplate = this.getReportTemplate();
        List accountSettings = reportTemplate.getAccountSettings();
        if (!EmptyUtil.isEmpty((Collection)accountSettings) && reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
            accountSettings.stream().filter(as -> as.getInputType() == ReportInputType.DETAIL_INPUT).forEach(as -> as.setInputType(ReportInputType.MANUAL_INPUT));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("account", new Object[0]);
        vs.addField("ways", new Object[0]);
        vs.addField("formula", new Object[0]);
        vs.addField("formuladesc", new Object[0]);
        vs.addField("template", new Object[0]);
        vs.addField("settingid", new Object[0]);
        vs.addField("hideinreport", new Object[0]);
        model.deleteEntryData("entry");
        model.beginInit();
        List<Long> accountMemIds = accountSettings.stream().map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_member", (String)"id,parent", (QFilter[])new QFilter[]{new QFilter("id", "in", accountMemIds)});
        Map accountMap = queryResult.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v, (o1, o2) -> o1, HashMap::new));
        for (TemplateAccountSetting templateAccountSetting : accountSettings) {
            String inputType = templateAccountSetting.getInputType().getNumber();
            String formula = templateAccountSetting.getFormula();
            String formulaExpressDesc = EmptyUtil.isEmpty((String)(formula = this.filterNotExistSubject(formula, accountMemIds))) ? "" : this.initExpressDesc(this.getSubjectIdByFormula(formula), formula);
            vs.addRow(new Object[]{templateAccountSetting.getAccountMemId(), inputType, formulaExpressDesc, formula, templateAccountSetting.getChildTemplateId(), templateAccountSetting.getId(), templateAccountSetting.isHideInReport()});
        }
        model.batchCreateNewEntryRow("entry", vs);
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        int rowIndex = 0;
        for (DynamicObject entry : entrys) {
            Optional<DynamicObject> first;
            String ways = entry.getString("ways");
            if (!ReportInputType.FORMULA.getNumber().equals(ways)) {
                model.setValue("formula", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ways"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
            }
            if (ReportInputType.DETAIL_INPUT.getNumber().equals(ways)) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"template"});
            } else {
                model.setValue("template", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"template"});
            }
            DynamicObject accountObj = entry.getDynamicObject("account");
            DynamicObject accountMemFromDB = (DynamicObject)accountMap.get(accountObj.getLong("id"));
            Object parentId = accountMemFromDB.get("parent");
            if (parentId != null && (first = entrys.stream().filter(item -> item.getString(String.join((CharSequence)".", "account", "id")).equals(parentId.toString())).findFirst()).isPresent()) {
                model.setValue("pid", first.get().get("id"), rowIndex);
            }
            ++rowIndex;
        }
        this.handleSubjectEntryTree();
    }

    private String filterNotExistSubject(String formula, List<Long> accountIds) {
        String newFormula = formula;
        if (EmptyUtil.isEmpty((String)formula)) {
            return "";
        }
        Set<String> subjectIds = this.getSubjectIdByFormula(formula);
        for (String subjectId : subjectIds) {
            if (accountIds.contains(Long.valueOf(subjectId))) continue;
            newFormula = newFormula.replace(String.format("-[%s]", subjectId), "");
            newFormula = newFormula.replace(String.format("+[%s]", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]+", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]-", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]", subjectId), "");
        }
        return newFormula;
    }

    private Set<String> getSubjectIdByFormula(String formula) {
        String[] expressUnits;
        HashSet<String> subjectIds = new HashSet<String>();
        String isDigitalRegex = "^[0-9]*$";
        String isDoubleBracketRegex = "^(\\[)[0-9]*(\\])$";
        String regex = "\\+|\\-";
        for (String expressUnit : expressUnits = formula.split(regex)) {
            boolean isDoubleBracket;
            boolean isDigit = expressUnit.matches(isDigitalRegex);
            if (isDigit || !(isDoubleBracket = expressUnit.matches(isDoubleBracketRegex))) continue;
            subjectIds.add(Optional.ofNullable(expressUnit).map(o -> o.replaceAll("\\[|]", "")).orElseGet(() -> ""));
        }
        return subjectIds;
    }

    private String initExpressDesc(Set<String> ids, String express) {
        DynamicObjectCollection datas = null;
        if (!express.isEmpty()) {
            List collect = ids.stream().map(Long::valueOf).collect(Collectors.toList());
            datas = QueryServiceHelper.query((String)"fpm_member", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
            for (DynamicObject data : datas) {
                String id = data.getString("id");
                String name = data.getString("name");
                express = express.replace(id, name);
            }
        }
        return express;
    }

    private ReportTemplate getReportTemplate() {
        if (this.reportTemplate == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String reportTemplateStr = (String)customParams.get(ReportTemplate.class.getName());
            this.reportTemplate = (ReportTemplate)JSON.parseObject((String)reportTemplateStr, (TypeReference)new TypeReference<ReportTemplate>(){}, (Feature[])new Feature[0]);
        }
        return this.reportTemplate;
    }

    private Set<Long> getParentIds() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        HashSet<Long> parentIds = new HashSet<Long>(10);
        entrys.forEach(o -> {
            long pid = o.getLong("pid");
            if (EmptyUtil.isNoEmpty((Long)pid)) {
                parentIds.add(pid);
            }
        });
        return parentIds;
    }

    private void recursiveCheckSubNode(Long rootId, DynamicObjectCollection entrys, Set<Long> parentIds, TreeEntryGrid entryGrid, boolean isCheck) {
        if (EmptyUtil.isEmpty((Long)rootId)) {
            return;
        }
        for (int inx = 0; inx < entrys.size(); ++inx) {
            DynamicObject entry = (DynamicObject)entrys.get(inx);
            long pid = entry.getLong("pid");
            if (rootId.compareTo(pid) != 0) continue;
            List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
            if (isCheck) {
                rows.add(inx);
            } else {
                rows.remove((Object)inx);
            }
            entryGrid.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), inx);
            long id = entry.getLong("id");
            if (!parentIds.contains(id)) continue;
            this.recursiveCheckSubNode(id, entrys, parentIds, entryGrid, isCheck);
        }
    }

    private void expandAll() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("entry");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("entry");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"closeall", "closealldes"});
        this.disableFormula();
        this.handleSubjectEntryTree();
    }

    private void disableFormula() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        int rowIndex = 0;
        for (DynamicObject entry : entrys) {
            String ways = entry.getString("ways");
            if (!ReportInputType.FORMULA.getNumber().equals(ways)) {
                model.setValue("formula", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ways"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
            }
            ++rowIndex;
        }
    }

    private void closeAll(boolean needUpdateView) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("entry");
        if (needUpdateView) {
            treeEntryGrid.setCollapse(true);
            this.getView().updateView("entry");
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeall", "closealldes"});
        this.disableFormula();
        this.handleSubjectEntryTree();
    }

    private void handleSubjectEntryTree() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        int rowIndex = 0;
        Set parentIdSet = entrys.stream().map(item -> item.get("pid")).collect(Collectors.toSet());
        for (DynamicObject entry : entrys) {
            if (parentIdSet.contains(entry.get("id"))) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ways"});
            }
            ++rowIndex;
        }
    }

    private void handleHideInReportEntryTree() {
        List<TemplateAccountSetting> andSetSettingObject = this.getAndSetSettingObject();
        Map accountMap = andSetSettingObject.stream().collect(Collectors.toMap(TemplateAccountSetting::getId, Function.identity(), (a, b) -> a));
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        int rowIndex = 0;
        HashMap<Long, Integer> rowIdMap = new HashMap<Long, Integer>(entrys.size());
        for (DynamicObject entry : entrys) {
            rowIdMap.put(entry.getLong("settingid"), rowIndex);
            ++rowIndex;
        }
        Set offHideParentId = entrys.stream().filter(item -> item.getBoolean("hideinreport")).filter(item -> EmptyUtil.isEmpty((Object)item.get("pid"))).map(item -> item.getLong("settingid")).collect(Collectors.toSet());
        for (Long id : offHideParentId) {
            TemplateAccountSetting setting = (TemplateAccountSetting)accountMap.get(id);
            List children = setting.getAllChildSetting();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            for (TemplateAccountSetting child : children) {
                Integer index = (Integer)rowIdMap.get(child.getId());
                if (Objects.isNull(index)) continue;
                this.getView().setEnable(Boolean.valueOf(false), index.intValue(), new String[]{"hideinreport"});
            }
        }
    }

    private void handleHideInReportChange() {
        List<TemplateAccountSetting> andSetSettingObject = this.getAndSetSettingObject();
        Map accountMap = andSetSettingObject.stream().collect(Collectors.toMap(TemplateAccountSetting::getId, Function.identity(), (a, b) -> a));
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        long settingId = entryRowEntity.getLong("settingid");
        boolean hide = entryRowEntity.getBoolean("hideinreport");
        TemplateAccountSetting setting = (TemplateAccountSetting)accountMap.get(settingId);
        if (Objects.isNull(setting)) {
            return;
        }
        List allChildSetting = setting.getAllChildSetting();
        if (CollectionUtils.isEmpty((Collection)allChildSetting)) {
            return;
        }
        Set childSet = allChildSetting.stream().map(TemplateAccountSetting::getId).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        Set topSettingId = entryEntity.stream().filter(i -> !EmptyUtil.isEmpty((Long)i.getLong("pid"))).map(i -> i.getLong("pid")).collect(Collectors.toSet());
        boolean isParent = topSettingId.contains(entryRowEntity.getLong("id"));
        for (int i2 = 0; i2 < entryEntity.size(); ++i2) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i2);
            long childSetId = dynamicObject.getLong("settingid");
            if (!childSet.contains(childSetId)) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"hideinreport", (Object)hide, (int)i2);
            if (!isParent) continue;
            this.getView().setEnable(Boolean.valueOf(!hide), i2, new String[]{"hideinreport"});
        }
    }

    public List<TemplateAccountSetting> convertAccountSetting(DynamicObject template) {
        ArrayList<TemplateAccountSetting> accountSettingList = new ArrayList<TemplateAccountSetting>();
        DynamicObjectCollection accountEntry = template.getDynamicObjectCollection("entry");
        HashMap parentChildNodeMappings = new HashMap(16);
        for (DynamicObject entry : accountEntry) {
            DynamicObject childTemplate;
            TemplateAccountSetting accSetting = new TemplateAccountSetting();
            accSetting.setId(entry.getLong("settingid"));
            Long acctId = entry.getDynamicObject("account").getLong("id");
            accSetting.setAccountMemId(acctId);
            accSetting.setFormula(entry.getString("formuladesc"));
            DynamicObject parentAcct = entry.getDynamicObject("account").getDynamicObject("parent");
            if (null != parentAcct) {
                HashSet<Long> sonIds;
                Long parentAcctId = parentAcct.getLong("id");
                boolean isContain = parentChildNodeMappings.containsKey(parentAcctId);
                if (isContain) {
                    sonIds = (HashSet<Long>)parentChildNodeMappings.get(parentAcctId);
                    sonIds.add(acctId);
                } else {
                    sonIds = new HashSet<Long>(16);
                    sonIds.add(acctId);
                    parentChildNodeMappings.put(parentAcctId, sonIds);
                }
            }
            if ((childTemplate = entry.getDynamicObject("template")) != null) {
                accSetting.setChildTemplateId(Long.valueOf(childTemplate.getLong("id")));
            }
            ReportInputType inputType = ReportInputType.getByNumber((String)entry.getString("ways"));
            accSetting.setInputType(inputType);
            accountSettingList.add(accSetting);
        }
        for (TemplateAccountSetting acctSetting : accountSettingList) {
            Long accountMemId = acctSetting.getAccountMemId();
            Set sonIds = (Set)parentChildNodeMappings.get(accountMemId);
            if (sonIds == null || sonIds.size() <= 0) continue;
            List childAcctSettings = accountSettingList.stream().filter(Objects::nonNull).filter(o -> sonIds.contains(o.getAccountMemId())).collect(Collectors.toList());
            acctSetting.setChildren(childAcctSettings);
        }
        return accountSettingList;
    }
}

