/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template.dimmember;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.bean.TreeDataSelectedPluginParam;
import kd.tmc.fpm.common.bean.TreeDataSelectedTreeProp;
import kd.tmc.fpm.common.enums.TreeDataSelectedCascadeType;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.result.TreeDataSelectedNode;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TreeDataSelectedPlugin
extends AbstractTreeListPlugin
implements TreeNodeCheckListener,
TreeNodeClickListener,
TreeNodeQueryListener,
SearchEnterListener {
    private static final String CACHE_LEFTTREENODEMAP = "leftTreeNodeMap";
    private static final String CACHE_RIGHTTREENODEMAP = "rightTreeNodeMap";
    private static final String CACHE_RIGHTROOTNODE = "rightRootNode";
    private static final HashMap<String, TreeNodeCheckUnit> nodeMap = new HashMap(16);

    public void registerListener(EventObject e) {
        Search searchap2;
        super.registerListener(e);
        this.addClickListeners(new String[]{"btngo", "btnback", "btn_cancleselect_1", "btn_cancleselect_2"});
        TreeView leftTreeView = (TreeView)this.getView().getControl("treeleft");
        TreeView rightTreeView = (TreeView)this.getView().getControl("treeright");
        rightTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        rightTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        leftTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        leftTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        leftTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search searchap1 = (Search)this.getView().getControl("searchap_1");
        if (searchap1 != null) {
            searchap1.addEnterListener((SearchEnterListener)this);
        }
        if ((searchap2 = (Search)this.getView().getControl("searchap_2")) != null) {
            searchap2.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        if (StringUtils.isNotEmpty((CharSequence)customParam.getTitle())) {
            this.getView().setFormTitle(new LocaleString(customParam.getTitle()));
        }
        this.initRightTree();
        this.initLeftTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btngo")) {
            this.btnGo();
        } else if (key.equals("btnback")) {
            this.btnBack();
        } else if (key.equals("btn_cancleselect_1")) {
            this.treeUnCkeckAllNode("treeleft");
        } else if (key.equals("btn_cancleselect_2")) {
            this.treeUnCkeckAllNode("treeright");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("confirmop")) {
            this.confirm();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        try (IFpmTracer tracer = IFpmTracer.getInstance();){
            try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("TreeDataPlugin treeNodeCheck");){
                span.addTag("TreeDataPlugin treeNodeCheck start");
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
                TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
                TreeDataSelectedCascadeType cascadeType = customParam.getLeftCascadeType();
                TreeView treeView = (TreeView)treeNodeCheckEvent.getSource();
                String eventKey = treeView.getKey();
                Map allNode = null;
                span.addTag("TreeDataPlugin treeNodeCheck deSerializeFromBase64");
                allNode = eventKey.equals("treeleft") ? (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_LEFTTREENODEMAP)) : (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP));
                span.addTag("TreeDataPlugin treeNodeCheck getAllParentNode");
                if ("treeleft".equals(eventKey) && TreeDataSelectedCascadeType.HALFCASCADE_TOPARENT == cascadeType) {
                    List checkedNodes = treeView.getTreeState().getCheckedNodes();
                    Set<String> parentSet = checkedNodes.stream().map(item -> item.get("parentid").toString()).collect(Collectors.toSet());
                    Set<TreeNode> allParentNode = this.getAllParentNode(parentSet, allNode);
                    allParentNode.remove(allNode.get(treeNodeCheckEvent.getNodeId().toString()));
                    treeView.checkNodes(new ArrayList<TreeNode>(allParentNode));
                }
                span.addTag("TreeDataPlugin treeNodeCheck treeView checkNodes");
                Object nodeId = treeNodeCheckEvent.getNodeId();
                if ("root".equals(nodeId)) {
                    if (treeNodeCheckEvent.getChecked().booleanValue()) {
                        List allEnableNodes = allNode.values().stream().filter(node -> !node.isDisabled()).collect(Collectors.toList());
                        treeView.checkNodes(allEnableNodes);
                    } else {
                        treeView.uncheckNodes(new ArrayList(allNode.keySet()));
                    }
                } else if (!treeNodeCheckEvent.getChecked().booleanValue()) {
                    treeView.unCheckNodeWithoutChild("root");
                }
                TreeNode treeNode = (TreeNode)allNode.get(nodeId.toString());
                if (treeNode == null) {
                    return;
                }
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(this.getAllChildren(treeNode));
                treeNode.setCheckable(treeNodeCheckEvent.getChecked().booleanValue());
                boolean includeSubLeft = this.getModel().getDataEntity().getBoolean("btn_includesub_1");
                boolean includeSubRight = this.getModel().getDataEntity().getBoolean("btn_includesub_2");
                if (treeNodeCheckEvent.getChecked().booleanValue()) {
                    if (eventKey.equals("treeleft")) {
                        TreeView treeLeft = (TreeView)this.getView().getControl("treeleft");
                        treeLeft.updateNode(treeNode);
                        treeLeft.expand(treeNode.getId());
                        if (includeSubLeft) {
                            treeNodes.removeIf(TreeNode::isDisabled);
                            treeView.checkNodes(treeNodes);
                        } else {
                            treeView.checkNodes(this.getCheckNodes(treeView, allNode));
                        }
                    } else {
                        TreeView rightTree = (TreeView)this.getView().getControl("treeright");
                        rightTree.updateNode(treeNode);
                        rightTree.expand(treeNode.getId());
                        if (includeSubRight) {
                            treeView.checkNodes(treeNodes);
                        } else {
                            treeView.checkNodes(this.getCheckNodes(treeView, allNode));
                        }
                    }
                } else {
                    List collect = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
                    if (eventKey.equals("treeleft")) {
                        TreeView treeLeft = (TreeView)this.getView().getControl("treeleft");
                        treeLeft.updateNode(treeNode);
                        if (includeSubLeft) {
                            treeView.focusNode(treeNode);
                            treeView.uncheckNodes(collect);
                        } else {
                            treeView.focusNode(treeNode);
                            treeView.checkNodes(this.getCheckNodes(treeView, allNode));
                        }
                        treeLeft.expand(treeNode.getId());
                    } else {
                        TreeView rightTree = (TreeView)this.getView().getControl("treeright");
                        rightTree.updateNode(treeNode);
                        if (includeSubRight) {
                            treeView.focusNode(treeNode);
                            treeView.uncheckNodes(collect);
                        } else {
                            treeView.focusNode(treeNode);
                            treeView.checkNodes(this.getCheckNodes(treeView, allNode));
                        }
                        rightTree.expand(treeNode.getId());
                    }
                }
                span.addTag("TreeDataPlugin treeNodeCheck end");
            }
            tracer.print();
        }
    }

    private List<TreeNode> getCheckNodes(TreeView treeView, Map<String, TreeNode> allNode) {
        return treeView.getTreeState().getSelectedNodeId().stream().map(o -> (TreeNode)allNode.get(o)).collect(Collectors.toList());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnGo() {
        try (IFpmTracer tracer = IFpmTracer.getInstance();){
            try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("TreeDataPlugin btnGo");){
                List needAddToRDataList;
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
                TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
                TreeDataSelectedType treeDataSelectedType = customParam.getTreeDataSelectedType();
                TreeDataSelectedCascadeType leftCascadeType = customParam.getLeftCascadeType();
                List rightPkList = null;
                if (customParam.getRightPkList() != null) {
                    rightPkList = customParam.getRightPkList().stream().filter(Objects::nonNull).collect(Collectors.toList());
                }
                TreeView treeLeft = (TreeView)this.getView().getControl("treeleft");
                List leftSelectedNodes = treeLeft.getTreeState().getSelectedNodes();
                List<String> nodeIdList = leftSelectedNodes.stream().map(item -> item.get("id").toString()).collect(Collectors.toList());
                Map leftAllNode = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_LEFTTREENODEMAP));
                span.addTag("btnGo getNodeList");
                Set<TreeNode> allSelectedNodeList = null;
                allSelectedNodeList = TreeDataSelectedCascadeType.HALFCASCADE_TOPARENT == leftCascadeType ? this.getNodeList(nodeIdList, leftAllNode, true) : this.getNodeList(nodeIdList, leftAllNode, false);
                TreeView treeRight = (TreeView)this.getView().getControl("treeright");
                Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP));
                List selectedNodeId = treeRight.getTreeState().getSelectedNodeId();
                if (TreeDataSelectedType.SETPARENT == treeDataSelectedType && selectedNodeId.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u4f5c\u4e3a\u7236\u8282\u70b9\u3002", (String)"TreeDataSelectedPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List tRightSourcePkList = customParam.getRightSourcePkList();
                if (tRightSourcePkList != null) {
                    List tRightSourcePks = tRightSourcePkList.stream().map(v -> v.toString()).collect(Collectors.toList());
                    needAddToRDataList = allSelectedNodeList.stream().filter(node -> !node.isDisabled()).filter(i -> rightTreeNodeMap.get(i.getId()) == null && !tRightSourcePks.contains(i.getId())).collect(Collectors.toList());
                } else {
                    needAddToRDataList = allSelectedNodeList.stream().filter(node -> !node.isDisabled()).filter(i -> rightTreeNodeMap.get(i.getId()) == null).collect(Collectors.toList());
                }
                span.addTag("btnGo getNodeList needAddToRDataList for");
                if (CollectionUtils.isEmpty(needAddToRDataList)) {
                    return;
                }
                Map treeNodeMap = needAddToRDataList.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity()));
                for (TreeNode needAddToRData : needAddToRDataList) {
                    if (needAddToRData.getId().equals("root")) continue;
                    TreeNode treeNode = new TreeNode();
                    Map treeNodeData = (Map)needAddToRData.getData();
                    String parentId = needAddToRData.getParentid();
                    if (TreeDataSelectedType.SETPARENT == treeDataSelectedType) {
                        String currParentId = "";
                        currParentId = treeNodeMap.get(parentId) == null ? (selectedNodeId.size() == 0 ? "" : (String)selectedNodeId.get(0)) : parentId;
                        treeNode.setParentid(currParentId);
                        treeNodeData.put("parentid", currParentId);
                    } else if (TreeDataSelectedType.NOTREESTRU == treeDataSelectedType) {
                        treeNode.setParentid("root");
                    } else {
                        treeNode.setParentid(parentId);
                    }
                    if (rightPkList != null && rightPkList.stream().noneMatch(e -> e.toString().equals(needAddToRData.getId()))) {
                        treeNodeData.put("isnew", true);
                    }
                    treeNode.setId(needAddToRData.getId());
                    treeNode.setText(needAddToRData.getText());
                    treeNode.setLongNumber(needAddToRData.getLongNumber());
                    treeNode.setData((Object)treeNodeData);
                    rightTreeNodeMap.put(needAddToRData.getId(), treeNode);
                }
                TreeNode root = (TreeNode)rightTreeNodeMap.get("root");
                if (Objects.isNull(root)) {
                    root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeDataSelectedPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
                span.addTag("btnGo getNodeList rightTreeNodeMap for");
                Set<TreeNode> rootChild = this.getAllChildren(root);
                Set rootChildIdList = rootChild.stream().map(TreeNode::getId).collect(Collectors.toSet());
                for (Map.Entry entry : rightTreeNodeMap.entrySet()) {
                    String id = (String)entry.getKey();
                    TreeNode node2 = (TreeNode)entry.getValue();
                    String parentId = node2.getParentid();
                    if (!"0".equals(parentId) && rightTreeNodeMap.get(parentId) != null) {
                        TreeNode parent = (TreeNode)rightTreeNodeMap.get(parentId);
                        List children = parent.getChildren();
                        if (!CollectionUtils.isEmpty((Collection)children) && children.contains(node2) || !rootChildIdList.add(node2.getId())) continue;
                        List child = parent.getChildren();
                        if (CollectionUtils.isEmpty((Collection)child)) {
                            parent.addChild(node2);
                            continue;
                        }
                        Set ids = child.stream().map(TreeNode::getId).collect(Collectors.toSet());
                        if (ids.contains(node2.getId())) continue;
                        parent.addChild(node2);
                        continue;
                    }
                    if (id.equals(root.getId()) || !rootChildIdList.add(node2.getId())) continue;
                    root.addChild(node2);
                }
                span.addTag("btnGo getNodeList treeRight for");
                root.setParentid("");
                treeRight.deleteAllNodes();
                treeRight.updateNode(root);
                treeRight.addNode(root);
                treeRight.expand(root.getId());
                this.expandTree(treeRight, rightTreeNodeMap.values());
                rightTreeNodeMap.putIfAbsent(root.getId(), root);
                this.getPageCache().put(CACHE_RIGHTTREENODEMAP, SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
                this.getPageCache().put(CACHE_RIGHTROOTNODE, SerializationUtils.serializeToBase64((Object)root));
            }
            tracer.print();
            return;
        }
    }

    private void btnBack() {
        this.getView().updateView("treeright");
        TreeView treeRight = (TreeView)this.getView().getControl("treeright");
        List selectedNodes = treeRight.getTreeState().getSelectedNodes();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        if (!customParam.getOriginalDataRemoveFlag().booleanValue()) {
            List rightPkList = customParam.getRightPkList();
            List newSelectedNodes = selectedNodes.stream().filter(item -> !"root".equals(item.get("id")) && !rightPkList.contains(Long.valueOf(item.get("id").toString()))).collect(Collectors.toList());
            if (newSelectedNodes.size() != selectedNodes.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5df2\u8df3\u8fc7\u3002\u7cfb\u7edf\u4e2d\u5df2\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"TreeDataSelectedPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                selectedNodes = newSelectedNodes;
            }
        }
        Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP));
        selectedNodes.stream().forEach(item -> {
            String id = item.get("id").toString();
            String parentId = item.get("parentid").toString();
            TreeNode currTreeNode = (TreeNode)rightTreeNodeMap.get(item.get("id").toString());
            Set<TreeNode> allChildren = this.getAllChildren(currTreeNode);
            List allChildrenIds = allChildren.stream().map(ch -> ch.getId()).collect(Collectors.toList());
            if (!"root".equals(id)) {
                TreeNode treeNode;
                if (StringUtils.isNotEmpty((CharSequence)parentId) && (treeNode = (TreeNode)rightTreeNodeMap.get(parentId)) != null) {
                    List children = treeNode.getChildren();
                    children = children.stream().filter(e -> !e.getId().equals(id)).collect(Collectors.toList());
                    treeNode.setChildren(children);
                }
                String deleteId = item.get("id").toString();
                rightTreeNodeMap.remove(deleteId);
                TreeNode root = (TreeNode)rightTreeNodeMap.get("root");
                if (root != null) {
                    root.deleteChildNode(deleteId);
                }
                for (String allChildrenId : allChildrenIds) {
                    rightTreeNodeMap.remove(allChildrenId);
                }
                treeRight.deleteNode(id);
            }
        });
        this.getPageCache().put(CACHE_RIGHTTREENODEMAP, SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
    }

    protected TreeDataSelectedReturnData getSelectedReturnData() {
        Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP));
        TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTROOTNODE));
        TreeDataSelectedReturnData returnData = new TreeDataSelectedReturnData();
        Set idSet = rightTreeNodeMap.keySet();
        if (!CollectionUtils.isEmpty(idSet)) {
            Set filterSet = idSet.stream().filter(item -> !"root".equals(item)).collect(Collectors.toSet());
            returnData.setRightTreeIdSet(filterSet);
            returnData.setRightNodeList(this.converter(new ArrayList<TreeNode>(rightTreeNodeMap.values()), root));
        }
        return returnData;
    }

    private void confirm() {
        TreeDataSelectedReturnData returnData = this.getSelectedReturnData();
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void initLeftTree() {
        Map rightTreeNodeMap;
        Collection rightTreeNodeColl;
        TreeView treeLeft = (TreeView)this.getView().getControl("treeleft");
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeDataSelectedPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        Map leftTreeNodeMap = new HashMap();
        DynamicObject[] leftDataArr = this.loadLeftData(customParam);
        Pair<TreeNode, Map<String, TreeNode>> treeNodeMapPair = this.buildTreeNode(root, leftDataArr, customParam.getLeftTreeProp(), null, true);
        TreeNode lazyRoot = TreeDataSelectedPlugin.buildTreeNode(root);
        lazyRoot.setChildren(new ArrayList());
        if (!CollectionUtils.isEmpty((Collection)root.getChildren())) {
            root.getChildren().forEach(item -> lazyRoot.getChildren().add(TreeDataSelectedPlugin.buildTreeNode(item)));
        }
        leftTreeNodeMap = (Map)treeNodeMapPair.getRight();
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(lazyRoot);
        treeLeft.addNode(lazyRoot);
        treeLeft.expand(lazyRoot.getId());
        if (!CollectionUtils.isEmpty((Collection)customParam.getLeftEnablePkList())) {
            Set leftEnablePkList = customParam.getLeftEnablePkList().stream().map(String::valueOf).collect(Collectors.toSet());
            Collection leftTreeNodeColl = leftTreeNodeMap.values();
            List<TreeNode> waitDisableNodes = leftTreeNodeColl.stream().filter(item -> !"root".equals(item.getId())).filter(item -> !leftEnablePkList.contains(item.getId())).collect(Collectors.toList());
            waitDisableNodes.forEach(item -> item.setDisabled(true));
            treeLeft.updateNodes(waitDisableNodes);
        }
        if (!CollectionUtils.isEmpty(rightTreeNodeColl = (rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP))).values())) {
            List rightIdList = rightTreeNodeColl.stream().map(TreeNode::getId).collect(Collectors.toList());
            List tRightSourcePkList = customParam.getRightSourcePkList();
            if (tRightSourcePkList != null) {
                rightIdList.addAll(tRightSourcePkList.stream().map(v -> v.toString()).collect(Collectors.toList()));
            }
            Collection leftTreeNodeColl = leftTreeNodeMap.values();
            List needCheckNodes = leftTreeNodeColl.stream().filter(item -> rightIdList.contains(item.getId())).filter(item -> !"root".equals(item.getId())).collect(Collectors.toList());
            treeLeft.checkNodes(needCheckNodes);
        }
        this.getPageCache().put(CACHE_LEFTTREENODEMAP, SerializationUtils.serializeToBase64(leftTreeNodeMap));
    }

    private void initRightTree() {
        TreeView treeRight = (TreeView)this.getView().getControl("treeright");
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeDataSelectedPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        TreeDataSelectedType treeDataSelectedType = customParam.getTreeDataSelectedType();
        DynamicObject[] rightData = this.loadRightData(customParam);
        Map rightTreeNodeMap = new HashMap();
        if (rightData != null) {
            Pair<TreeNode, Map<String, TreeNode>> treeNodeMapPair = this.buildTreeNode(root, rightData, customParam.getRightTreeProp(), treeDataSelectedType, true);
            rightTreeNodeMap = (Map)treeNodeMapPair.getRight();
            root = (TreeNode)treeNodeMapPair.getLeft();
        }
        root.setParentid("");
        treeRight.deleteAllNodes();
        treeRight.updateNode(root);
        treeRight.addNode(root);
        treeRight.expand(root.getId());
        this.getPageCache().put(CACHE_RIGHTTREENODEMAP, SerializationUtils.serializeToBase64(rightTreeNodeMap));
        this.getPageCache().put(CACHE_RIGHTROOTNODE, SerializationUtils.serializeToBase64((Object)root));
    }

    private DynamicObject[] loadLeftData(TreeDataSelectedPluginParam customParam) {
        DynamicObject[] resultData;
        try (IFpmTracer tracer = IFpmTracer.getInstance();){
            try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("TreeDataPlugin loadLeftData");){
                String leftTreeEntityName = customParam.getLeftTreeEntityName();
                resultData = "bos_org_structure".equals(leftTreeEntityName) || "bos_org".equals(leftTreeEntityName) || "cas_fundflowitem".equals(leftTreeEntityName) || "fpm_membersubject".equals(leftTreeEntityName) || "fpm_member".equals(leftTreeEntityName) ? TmcDataServiceHelper.load((String)leftTreeEntityName, (String)"id,number,longnumber,name,parent,isleaf,level,org", (QFilter[])new QFilter[]{this.getLeftQFilter()}) : TmcDataServiceHelper.load((String)leftTreeEntityName, (String)"id,number,name", (QFilter[])new QFilter[]{this.getLeftQFilter()});
                span.addTag("loadLeftData query by id");
                span.addTag("loadLeftData compare by number");
                resultData = Arrays.stream(resultData).sorted(Comparator.comparing(item -> item.getString(customParam.getLeftTreeProp().getNumberPropName()))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            }
            tracer.print();
        }
        return resultData;
    }

    private DynamicObject[] loadRightData(TreeDataSelectedPluginParam customParam) {
        DynamicObject[] resultData = null;
        List rightPkList = customParam.getRightPkList();
        String rightTreeEntityName = customParam.getRightTreeEntityName();
        if (rightPkList != null) {
            resultData = TmcDataServiceHelper.load((Object[])rightPkList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)rightTreeEntityName));
            resultData = Arrays.stream(resultData).sorted(Comparator.comparing(item -> item.getString(customParam.getRightTreeProp().getNumberPropName()))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        }
        return resultData;
    }

    protected QFilter getLeftQFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        String leftTreeQFilterStr = customParam.getLeftTreeQFilterStr();
        QFilter leftTreeQFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)leftTreeQFilterStr)) {
            leftTreeQFilter = QFilter.fromSerializedString((String)leftTreeQFilterStr);
        }
        return leftTreeQFilter;
    }

    private Pair<TreeNode, Map<String, TreeNode>> buildTreeNode(TreeNode root, DynamicObject[] dataArr, TreeDataSelectedTreeProp treePropModel, TreeDataSelectedType treeDataSelectedType, boolean initChild) {
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(10);
        allNode.put(root.getId(), root);
        for (DynamicObject data : dataArr) {
            if (StringUtils.isEmpty((CharSequence)data.getString(treePropModel.getIdPropName()))) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(data.getString(treePropModel.getIdPropName()));
            treeNode.setText(String.join((CharSequence)" ", data.getString(treePropModel.getNumberPropName()), data.getString(treePropModel.getNamePropName())));
            String parentId = "";
            if (TreeDataSelectedType.NOTREESTRU != treeDataSelectedType && data.containsProperty("parent")) {
                parentId = StringUtils.isEmpty((CharSequence)treePropModel.getParentIdPropName()) ? null : data.getString(treePropModel.getParentIdPropName());
                parentId = parentId == null ? "" : parentId;
                treeNode.setParentid(parentId);
            }
            String longNumber = "";
            if (data.containsProperty(treePropModel.getLongNumberPropName())) {
                longNumber = StringUtils.isEmpty((CharSequence)treePropModel.getLongNumberPropName()) ? data.getString(treePropModel.getNumberPropName()) : data.getString(treePropModel.getLongNumberPropName());
                treeNode.setLongNumber(longNumber);
            }
            boolean isLeaf = true;
            if (data.containsProperty(treePropModel.getIsLeafPropName())) {
                isLeaf = !StringUtils.isEmpty((CharSequence)treePropModel.getIsLeafPropName()) && data.getBoolean(treePropModel.getIsLeafPropName());
            }
            HashMap<String, Object> treeNodeData = new HashMap<String, Object>(10);
            treeNodeData.put("id", data.getString(treePropModel.getIdPropName()));
            treeNodeData.put("name", data.getString(treePropModel.getNamePropName()));
            treeNodeData.put("number", data.getString(treePropModel.getNumberPropName()));
            treeNodeData.put("parentid", parentId);
            treeNodeData.put("isleaf", isLeaf);
            treeNodeData.put("longnumber", longNumber);
            treeNodeData.put("isnew", false);
            treeNode.setData(treeNodeData);
            allNode.put(data.getString(treePropModel.getIdPropName()), treeNode);
        }
        for (Map.Entry entry : allNode.entrySet()) {
            String id = (String)entry.getKey();
            TreeNode node = (TreeNode)entry.getValue();
            String parentId = node.getParentid();
            if (!"0".equals(parentId) && allNode.get(parentId) != null) {
                TreeNode parent = (TreeNode)allNode.get(parentId);
                parent.addChild(node);
                continue;
            }
            if (id.equals(root.getId())) continue;
            root.addChild(node);
        }
        return Pair.of((Object)root, allNode);
    }

    private Set<TreeNode> getNodeList(List<String> idList, Map<String, TreeNode> treeNodeMap, boolean isContainParentNode) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("TreeDataPlugin getNodeList");){
            HashSet<TreeNode> result = new HashSet<TreeNode>();
            span.addTag("TreeDataPlugin getNodeList start");
            for (Map.Entry<String, TreeNode> next : treeNodeMap.entrySet()) {
                span.addTag("TreeDataPlugin getNodeList treeNodeMap for");
                String key = next.getKey();
                TreeNode value = next.getValue();
                if (!idList.contains(key)) continue;
                result.add(value);
            }
            if (isContainParentNode) {
                span.addTag("TreeDataPlugin getNodeList getAllParentNode");
                Set<String> parentIdSet = result.stream().map(TreeNode::getParentid).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                Set<TreeNode> allParentNode = this.getAllParentNode(parentIdSet, treeNodeMap);
                result.addAll(allParentNode);
            }
            span.addTag("TreeDataPlugin getNodeList end");
            HashSet<TreeNode> hashSet = result;
            return hashSet;
        }
    }

    private Set<TreeNode> getAllParentNode(Set<String> parentIdSet, Map<String, TreeNode> treeNodeMap) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("TreeDataPlugin getAllParentNode");){
            Set currParentIdSet;
            span.addTag("TreeDataPlugin getAllParentNode start");
            HashSet<TreeNode> result = new HashSet<TreeNode>();
            span.addTag("TreeDataPlugin getAllParentNode dowhile start");
            do {
                HashSet<TreeNode> treeNodeSet = new HashSet<TreeNode>();
                for (Map.Entry<String, TreeNode> entry : treeNodeMap.entrySet()) {
                    String key = entry.getKey();
                    TreeNode value = entry.getValue();
                    if (!parentIdSet.contains(key)) continue;
                    treeNodeSet.add(value);
                }
                currParentIdSet = treeNodeSet.stream().map(TreeNode::getParentid).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                parentIdSet = currParentIdSet;
                if (CollectionUtils.isEmpty(treeNodeSet)) continue;
                result.addAll(treeNodeSet);
            } while (!CollectionUtils.isEmpty(currParentIdSet));
            span.addTag("TreeDataPlugin getAllParentNode dowhile end");
            HashSet<TreeNode> hashSet = result;
            return hashSet;
        }
    }

    private Set<TreeNode> getAllChildren(TreeNode treeNode) {
        HashSet<TreeNode> allChildren = new HashSet<TreeNode>(10);
        this.getChildMember(treeNode, allChildren);
        return allChildren;
    }

    private void getChildMember(TreeNode member, Set<TreeNode> allChildren) {
        if (member != null && member.getChildren() != null) {
            allChildren.addAll(member.getChildren());
            for (TreeNode child : member.getChildren()) {
                this.getChildMember(child, allChildren);
            }
        }
    }

    private List<TreeDataSelectedNode> converter(List<TreeNode> treeNodeList, TreeNode rootNode) {
        ArrayList<TreeDataSelectedNode> result = new ArrayList<TreeDataSelectedNode>(treeNodeList.size());
        for (TreeNode treeNode : treeNodeList) {
            if ("root".equals(treeNode.getId())) continue;
            TreeDataSelectedNode treeDataSelectedNode = new TreeDataSelectedNode();
            Map data = (Map)treeNode.getData();
            treeDataSelectedNode.setId(treeNode.getId());
            treeDataSelectedNode.setNumber((String)data.get("number"));
            treeDataSelectedNode.setName((String)data.get("name"));
            treeDataSelectedNode.setLongNumber(treeNode.getLongNumber());
            if (treeNode.getParentid().equals("root")) {
                treeDataSelectedNode.setParentId("");
            } else {
                treeDataSelectedNode.setParentId(treeNode.getParentid());
            }
            treeDataSelectedNode.setLeaf(CollectionUtils.isEmpty((Collection)treeNode.getChildren()));
            treeDataSelectedNode.setLevel(rootNode.getNodeLevel(treeNode.getId(), 0));
            treeDataSelectedNode.setNew(((Boolean)data.get("isnew")).booleanValue());
            result.add(treeDataSelectedNode);
        }
        return result;
    }

    private void expandTree(TreeView treeView, Collection<TreeNode> treeNodeSet) {
        List parentList = treeNodeSet.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getChildren())).collect(Collectors.toList());
        for (TreeNode node : parentList) {
            treeView.expand(node.getId());
        }
    }

    protected void refreshLeftTreeData() {
        this.initLeftTree();
    }

    protected void refreshRightTreeData() {
        this.initRightTree();
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String leftTreeNodeId = (String)treeNodeEvent.getNodeId();
        Map allNode = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_LEFTTREENODEMAP));
        if (allNode.isEmpty()) {
            return;
        }
        TreeNode treeNode = TreeDataSelectedPlugin.buildTreeNode((TreeNode)allNode.get(leftTreeNodeId));
        treeNode.setChildren(null);
        for (Map.Entry entry : allNode.entrySet()) {
            TreeNode node = (TreeNode)entry.getValue();
            if (!node.getParentid().equals(leftTreeNodeId)) continue;
            TreeNode child = TreeDataSelectedPlugin.buildTreeNode(node);
            treeNode.addChild(child);
        }
        TreeView treeLeft = (TreeView)this.getView().getControl("treeleft");
        treeLeft.updateNode(treeNode);
        treeLeft.expand(treeNode.getId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParamStr = (String)formShowParameter.getCustomParam(TreeDataSelectedPluginParam.class.getName());
        TreeDataSelectedPluginParam customParam = (TreeDataSelectedPluginParam)JSON.parseObject((String)customParamStr, TreeDataSelectedPluginParam.class);
        Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_RIGHTTREENODEMAP));
        Collection rightTreeNodeColl = rightTreeNodeMap.values();
        if (!CollectionUtils.isEmpty(rightTreeNodeColl)) {
            List rightIdList = rightTreeNodeColl.stream().map(TreeNode::getId).collect(Collectors.toList());
            List tRightSourcePkList = customParam.getRightSourcePkList();
            if (tRightSourcePkList != null) {
                rightIdList.addAll(tRightSourcePkList.stream().map(v -> v.toString()).collect(Collectors.toList()));
            }
            Collection leftTreeNodeColl = allNode.values();
            List needCheckNodes = leftTreeNodeColl.stream().filter(item -> rightIdList.contains(item.getId())).collect(Collectors.toList());
            treeLeft.checkNodes(needCheckNodes);
        }
    }

    private static TreeNode buildTreeNode(TreeNode node) {
        TreeNode child = new TreeNode();
        child.setLeaf(node.isLeaf());
        child.setDisabled(node.isDisabled());
        child.setIcon(node.getIcon());
        child.setCheckable(node.isCheckable());
        child.setId(node.getId());
        child.setText(node.getText());
        child.setLongText(node.getLongText());
        child.setParentid(node.getParentid());
        if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
            child.setChildren(new ArrayList());
        }
        child.setData(node.getData());
        child.setType(node.getType());
        child.setLongNumber(node.getLongNumber());
        return child;
    }

    public void search(SearchEnterEvent searchEvent) {
        super.search(searchEvent);
        String searchText = searchEvent.getText();
        if (EmptyUtil.isEmpty((String)searchText)) {
            return;
        }
        Search searchSouce = (Search)searchEvent.getSource();
        String controlKey = searchSouce.getKey();
        String nodeMapKey = String.format("%1$s_%2$s_%3$s", this.getView().getPageId(), controlKey, searchText);
        String treeview = null;
        String nodeCache = null;
        if (controlKey.equals("searchap_1")) {
            treeview = "treeleft";
            nodeCache = CACHE_LEFTTREENODEMAP;
        } else {
            treeview = "treeright";
            nodeCache = CACHE_RIGHTTREENODEMAP;
        }
        ArrayList<Object> checkNodes = new ArrayList<Object>();
        ArrayList<String> unCheckNodes = new ArrayList<String>();
        Map allNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(nodeCache));
        if (!nodeMap.containsKey(nodeMapKey)) {
            nodeMap.clear();
            if (EmptyUtil.isEmpty((Object)allNodeMap)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u641c\u7d22\u7684\u6811\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u641c\u7d22\u3002", (String)"TreeDataSelectedPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<TreeNode> matchNodes = this.getMatchNode(allNodeMap, searchText);
            if (EmptyUtil.isEmpty(matchNodes)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e0e\u201c%1$s\u201d\u76f8\u5173\u7684\u5339\u914d\u9879\u3002", (String)"TreeDataSelectedPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), searchEvent.getText()));
                return;
            }
            TreeNodeCheckUnit treeNodeCheckUnit = new TreeNodeCheckUnit(matchNodes);
            nodeMap.put(nodeMapKey, treeNodeCheckUnit);
        }
        TreeView treeView = (TreeView)this.getControl(treeview);
        Tuple<TreeNode, TreeNode> nodeTuple = nodeMap.get(nodeMapKey).getNextTreeNode();
        checkNodes.add(nodeTuple.item1);
        if (nodeTuple.item2 != null) {
            unCheckNodes.add(((TreeNode)nodeTuple.item2).getId());
        }
        boolean includeSubLeft = this.getModel().getDataEntity().getBoolean("btn_includesub_1");
        boolean includeSubRight = this.getModel().getDataEntity().getBoolean("btn_includesub_2");
        if (includeSubLeft && controlKey.equals("searchap_1") || includeSubRight && controlKey.equals("searchap_2")) {
            checkNodes.addAll(this.getAllChildren((TreeNode)nodeTuple.item1));
            Set waitRemoveNodeIds = this.getAllChildren((TreeNode)nodeTuple.item2).stream().map(o -> o.getId()).collect(Collectors.toSet());
            unCheckNodes.addAll(waitRemoveNodeIds);
        }
        Stack<TreeNode> nodeStack = this.findParentNodes((TreeNode)nodeTuple.item1, allNodeMap);
        while (!nodeStack.empty()) {
            TreeNode node = nodeStack.pop();
            if (Objects.isNull(node) || StringUtils.isEmpty((CharSequence)node.getId())) continue;
            treeView.updateNode(node);
            treeView.expand(node.getId());
        }
        treeView.uncheckNodes(unCheckNodes);
        treeView.updateNode((TreeNode)nodeTuple.item1);
        treeView.expand(((TreeNode)nodeTuple.item1).getId());
        treeView.focusNode((TreeNode)nodeTuple.item1);
        checkNodes.removeIf(TreeNode::isDisabled);
        treeView.checkNodes(checkNodes);
    }

    private Stack<TreeNode> findParentNodes(TreeNode checkNode, Map<String, TreeNode> allNodeMap) {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        if (checkNode != null) {
            this.findParentNode(stack, checkNode, allNodeMap);
        }
        return stack;
    }

    private void findParentNode(Stack<TreeNode> treeNodeStack, TreeNode checkNode, Map<String, TreeNode> allNodeMap) {
        String parentid;
        if (checkNode != null && EmptyUtil.isNoEmpty((String)(parentid = checkNode.getParentid())) && !parentid.equals("root")) {
            TreeNode treeNode = allNodeMap.get(parentid);
            treeNodeStack.push(treeNode);
            this.findParentNode(treeNodeStack, treeNode, allNodeMap);
        }
    }

    private List<TreeNode> getMatchNode(Map<String, TreeNode> allNodeMap, String text) {
        return allNodeMap.entrySet().stream().filter(Objects::nonNull).filter(o -> ((TreeNode)o.getValue()).getText().contains(text)).map(o -> (TreeNode)o.getValue()).collect(Collectors.toList());
    }

    private void treeUnCkeckAllNode(String treeSign) {
        TreeView treeView = (TreeView)this.getControl(treeSign);
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        treeView.uncheckNodes(selectedNodeIds);
    }

    private static final class TreeNodeCheckUnit {
        private int index = 0;
        private List<TreeNode> nodes;

        public TreeNodeCheckUnit(List<TreeNode> nodes) {
            this.nodes = nodes;
        }

        public Tuple<TreeNode, TreeNode> getNextTreeNode() {
            int preIndex = this.index - 1;
            if (this.index > this.nodes.size() - 1) {
                nodeMap.clear();
                this.index = 0;
            }
            TreeNode preNode = preIndex == -1 ? null : this.nodes.get(preIndex);
            TreeNode nextNode = this.nodes.get(this.index++);
            return Tuple.create((Object)nextNode, (Object)preNode);
        }
    }
}

