/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template.rpt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.helper.ModelHelper;

public class TemplateAssignFormRpt
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object system = customParams.getOrDefault("system", null);
        this.getModel().setValue("system", system);
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changePropName = e.getProperty().getName();
        if ("type".equals(changePropName)) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        } else if ("system".equals(changePropName)) {
            this.getModel().setValue("company", null);
        }
    }

    private void initControlEvi() {
        BasedataEdit companyF7 = (BasedataEdit)this.getView().getControl("company");
        companyF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setCaption(DimsionEnums.ORG.getName());
            DynamicObject system = this.getModel().getDataEntity().getDynamicObject("system");
            if (null == system) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"TemplateAssignFormRpt_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("bodysystem", "=", system.getPkValue()));
            qFilters.add(new QFilter("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()));
            sp.getListFilterParameter().setQFilters(qFilters);
        });
        BasedataEdit systemF7 = (BasedataEdit)this.getView().getControl("system");
        systemF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            qFilterList.add(authQFilter);
            sp.getListFilterParameter().setQFilters(qFilterList);
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        hyperLinkClickEvent.getSource();
        if ("templatenumber".equals(fieldName)) {
            DynamicObject rowData = hyperLinkClickEvent.getRowData();
            DynamicObject template = rowData.getDynamicObject("templatenumber");
            this.showTemplatePage(template.getLong("id"));
        }
    }

    private void showTemplatePage(Long templateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        DynamicObject templateType = QueryServiceHelper.queryOne((String)"fpm_template", (String)"templatetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (TemplateTypeEnum.DETAIL.getValue().equals(templateType.get("templatetype"))) {
            showParameter.setFormId("fpm_template_detail");
        } else {
            showParameter.setFormId("fpm_template_fixed");
        }
        showParameter.setCustomParam("templateId", (Object)templateId);
        this.getView().showForm(showParameter);
    }
}

