/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.utils.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.EvaluateAmtParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;

public class ReportPlanSumShowUtil
extends AbstractListPlugin {
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();
    private ISummaryConfigService iSummaryConfigService = (ISummaryConfigService)FpmServiceFactory.getBizService(ISummaryConfigService.class);

    private Set<Long> getAllChildren(DynamicObject load, Set<Long> orgSubSumPlan, SumPlanParamConfig sumPlanParamConfig) {
        HashSet<Long> orgSubordinate = new HashSet<Long>(2);
        Long reportOrgId = load.getLong("reportorg.id");
        for (SumPlanParamConfigInfo sumPlanParamConfigInfo : sumPlanParamConfig.getConfigInfoList()) {
            if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId())) continue;
            List paramConfigInfos = sumPlanParamConfigInfo.getAllChildren();
            for (SumPlanParamConfigInfo paramConfigInfo : paramConfigInfos) {
                if (!paramConfigInfo.isSumAuditNode()) {
                    orgSubordinate.add(paramConfigInfo.getOrgMemberId());
                    continue;
                }
                orgSubSumPlan.add(paramConfigInfo.getOrgMemberId());
            }
        }
        return orgSubordinate;
    }

    public List<Long> getReportId(DynamicObject load, Set<Long> orgSubordinate) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)load.getLong("bodysys.id"));
        qFilter.and("reportperiod", "=", (Object)load.getLong("reportperiod.id"));
        qFilter.and("reportorg", "in", orgSubordinate);
        qFilter.and("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber());
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        return ids.stream().map(e -> (Long)e).collect(Collectors.toList());
    }

    public void showRecord(IFormView view, Object[] pkId) {
        if (null == pkId) {
            return;
        }
        QFilter qFilter = new QFilter("sumplanrecordid", "=", (Object)Long.valueOf(pkId[0].toString()));
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_innercancelrecord", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (ids.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e", (String)"ReportPlanSumShowUtil_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        view.showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_innercancelrecord").searchFormNumber("fpm_innercancelrecord").listFormId("bos_treelist").searchIds(ids).listForm("fpm_innercancelrecord").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_INNER_CANCEL_RECORD).linkSearch(true).caption(ResManager.loadKDString((String)"\u62b5\u6d88\u8bb0\u5f55", (String)"ReportPlanSumShowUtil_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
    }

    public void showReport(IFormView view, Object[] pkId) {
        List<Long> reportIds;
        if (null == pkId) {
            return;
        }
        DynamicObject load = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)"bodysys.id,reportperiod.id,reporttype.id,reportorg.id,originalreportids", (QFilter[])new QFilter("id", "=", pkId[0]).toArray());
        if (null == load) {
            return;
        }
        String originalReportIdStr = load.getString("originalreportids");
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(Long.valueOf(originalReportIdStr));
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u5b58\u5728\u53ef\u7528\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanSumShowUtil_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> orgSubSumPlan = new HashSet<Long>(16);
        Set<Long> orgSubordinate = this.getAllChildren(load, orgSubSumPlan, sumPlanParamConfig);
        Collection subordinate = null;
        if (orgSubSumPlan.size() > 0) {
            QFilter qFilter = new QFilter("bodysys", "=", (Object)load.getLong("bodysys.id"));
            qFilter.and("reportperiod", "=", (Object)load.getLong("reportperiod.id"));
            qFilter.and("reportorg", "in", orgSubSumPlan);
            subordinate = QueryServiceHelper.queryPrimaryKeys((String)"fpm_reportplansum", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        }
        if ((reportIds = this.getReportId(load, orgSubordinate)).size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e", (String)"ReportPlanSumShowUtil_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showHyperList(view, reportIds);
        if (null != subordinate) {
            this.showReportPlan(view, subordinate.stream().map(e -> (Long)e).collect(Collectors.toSet()));
        }
    }

    public void showHyperList(IFormView view, List<Long> reportIds) {
        view.showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_reportplan").searchFormNumber("fpm_report_process").listFormId("bos_treelist").searchIds(new ArrayList<Object>(reportIds)).listForm("fpm_report_process").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_REPORT_PLAN_SEARCH).linkSearch(true).caption(ResManager.loadKDString((String)"\u8054\u67e5\u8ba1\u5212\u7f16\u5236\u5355\u636e", (String)"ReportPlanSumShowUtil_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
    }

    public void showReportPlan(IFormView view, Set<Long> orgSubordinate) {
        if (EmptyUtil.isEmpty(orgSubordinate)) {
            return;
        }
        view.showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_reportplansum").searchFormNumber("fpm_reportplansum").listFormId("bos_treelist").searchIds(new ArrayList<Object>(orgSubordinate)).listForm("fpm_reportplansum").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_SUM_PLAN_RECORD).linkSearch(true).caption(ResManager.loadKDString((String)"\u8054\u67e5\u4e0b\u7ea7\u6c47\u603b\u5355\u636e", (String)"ReportPlanSumShowUtil_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
    }

    public void showRecords(IFormView view, Object[] pkId) {
        if (null == pkId) {
            return;
        }
        ApprovedAmountRecord amountRecord = this.sumPlanRepository.loadApprovedAmtBySumId(Long.valueOf(pkId[0].toString()));
        if (null == amountRecord) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e", (String)"ReportPlanSumShowUtil_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        EvaluateAmtParam evaluateAmtParam = new EvaluateAmtParam();
        evaluateAmtParam.setSumRecordId(Long.valueOf(pkId[0].toString()));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u5236\u8868\u91d1\u989d\u6838\u5b9a", (String)"ReportPlanSumShowUtil_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("fpm_fixamtevaluate");
        showParameter.setCustomParam(EvaluateAmtParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)evaluateAmtParam));
        showParameter.setCustomParam("from", (Object)"linkSearch");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pageType"));
        view.showForm(showParameter);
    }
}

