/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.utils.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.service.sumreport.service.impl.SummaryConfigServiceImpl;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.collections.MapUtils;

public class ReportPlanSumUtil {
    public static final Integer MAX_QUERY_ROW_COUNT = 50000;
    private static final IReportRepository repository = new ReportRepository();
    private static final ISummaryConfigService summaryConfigService = new SummaryConfigServiceImpl();

    public static boolean checkRequiredField(DynamicObject sumPlan) {
        DynamicObject system = sumPlan.getDynamicObject("bodysys");
        DynamicObject reportType = sumPlan.getDynamicObject("reporttype");
        DynamicObject period = sumPlan.getDynamicObject("reportperiod");
        DynamicObject reportOrg = sumPlan.getDynamicObject("reportorg");
        return system != null && reportType != null && period != null && reportOrg != null;
    }

    public static void fillHeader(AnalysisHeader header, DynamicObject sumPlan) {
        DynamicObject system = sumPlan.getDynamicObject("bodysys");
        header.setBodySystemId(Long.valueOf(system.getLong("id")));
        DynamicObject reportType = sumPlan.getDynamicObject("reporttype");
        header.setReportTypeId(Long.valueOf(reportType.getLong("id")));
        header.setInternalOffsetState(sumPlan.getString("innerstatus"));
        header.setBodySystemId(Long.valueOf(sumPlan.getDynamicObject("bodysys").getLong("id")));
        header.setReportTypeId(Long.valueOf(sumPlan.getDynamicObject("reporttype").getLong("id")));
        String orgReportIds = sumPlan.getString("originalreportids");
        header.setReportSumId(Long.valueOf(orgReportIds));
        String recordId = sumPlan.getString("id");
        header.setReportSumRecordId(Long.valueOf(recordId));
        header.setSumReportOrg(Long.valueOf(sumPlan.getLong("reportorg.id")));
        String amountunit = sumPlan.getString("amountunit");
        header.setAmountUnit(AmountUnit.getByNumber((String)amountunit));
        header.setContainDetailReportType(true);
    }

    public static void fillMembers(Set<Long> filterMemberSet, AnalysisHeader header, ReportTemplate reportTemplate, ReportTemplate analysisTemplate, DynamicObject sumPlan) {
        List dimIds = analysisTemplate.getAllTemplateDim().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        Map<Long, DimensionType> dimTypeMap = analysisTemplate.getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, TemplateDim::getDimType));
        DynamicObjectCollection dimMembers = ReportPlanSumUtil.getDimMembers(filterMemberSet);
        Map<Long, List> dimMap = dimMembers.stream().collect(Collectors.groupingBy(dy -> Long.valueOf(dy.getString("dimension.id")), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted((o1, o2) -> {
            if (DimensionType.PERIOD.getNumber().equals(o1.getString("dimtype")) && Objects.nonNull(o1.get("startdate"))) {
                return o1.getDate("startdate").compareTo(o2.getDate("startdate"));
            }
            return 0;
        }).map(dy -> dy.getLong("id")).collect(Collectors.toList()))));
        for (Long dimId : dimIds) {
            List memberIds = dimMap.get(dimId);
            if (EmptyUtil.isEmpty((Collection)memberIds)) continue;
            DimensionType dimensionType = dimTypeMap.get(dimId);
            switch (dimensionType) {
                case ORG: {
                    header.setOrg(memberIds);
                    break;
                }
                case PERIOD: {
                    header.setPeriodId(memberIds);
                    break;
                }
                case COMPANY: {
                    header.setCompany(memberIds);
                    break;
                }
                case CURRENCY: {
                    header.setCurrency(memberIds);
                    break;
                }
                case SUBJECTS: {
                    header.setSubjects(memberIds);
                    break;
                }
                case SETTLEMENT_TYPE: {
                    header.setSettlementMethod(memberIds);
                    break;
                }
                case CUSTOM: {
                    if (CollectionUtils.isEmpty((Collection)memberIds)) break;
                    header.getCustomDimension().put(String.valueOf(dimId), memberIds);
                    break;
                }
            }
        }
        ReportPlanSumUtil.addSumPlanDefaultMemberScopeIfEmpty(analysisTemplate, header, sumPlan);
        ReportPlanSumUtil.addTemplateMemberScopeIfEmpty(analysisTemplate, header);
        ReportPlanSumUtil.addTemplateMemberScopeIfEmpty(reportTemplate, header);
    }

    public static Set<Long> getFilterConditions(ReportTemplate analysisTemplate, DynamicObject sumPlan) {
        Report report = ReportPlanSumUtil.getReport(sumPlan);
        HashSet<Long> filterMemberSet = new HashSet<Long>(10);
        for (TemplateDim templateDim : analysisTemplate.getAllTemplateDim()) {
            if (!templateDim.isFilterDim() || templateDim.isViDim()) continue;
            if (templateDim.getDimType() == DimensionType.PERIOD) {
                List memberList;
                if (report.getTemplate().getTemplateType().isDetail()) {
                    memberList = report.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).collect(Collectors.toList());
                    filterMemberSet.addAll(memberList);
                    continue;
                }
                if (templateDim.getLocation() == DimLocation.COL) {
                    filterMemberSet.addAll(ReportPlanSumUtil.getPeriodFilterMemberList(report));
                    continue;
                }
                memberList = report.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).collect(Collectors.toList());
                filterMemberSet.addAll(memberList);
                continue;
            }
            filterMemberSet.addAll(ReportPlanSumUtil.getFilterMember(templateDim, sumPlan));
        }
        return filterMemberSet;
    }

    public static Set<Long> getFilterConditions(DynamicObject dataEntity) {
        List firstColIdList = dataEntity.getDynamicObjectCollection("filter_col_01").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List secondColIdList = dataEntity.getDynamicObjectCollection("filter_col_02").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List thirdColIdList = dataEntity.getDynamicObjectCollection("filter_col_03").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List firstRowIdList = dataEntity.getDynamicObjectCollection("filter_row_01").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List secondRowIdList = dataEntity.getDynamicObjectCollection("filter_row_02").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List filterList1 = dataEntity.getDynamicObjectCollection("filter_01").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List filterList2 = dataEntity.getDynamicObjectCollection("filter_02").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HashSet<Long> filterMemberSet = new HashSet<Long>(10);
        filterMemberSet.addAll(firstColIdList);
        filterMemberSet.addAll(secondColIdList);
        filterMemberSet.addAll(thirdColIdList);
        filterMemberSet.addAll(firstRowIdList);
        filterMemberSet.addAll(secondRowIdList);
        filterMemberSet.addAll(filterList1);
        filterMemberSet.addAll(filterList2);
        return filterMemberSet;
    }

    public static Report getReport(DynamicObject sumPlan) {
        Long reportId = sumPlan.getLong("originalreportids");
        List reports = repository.loadSimpleReport(Collections.singleton(reportId), np -> {
            np.setNeedTemplate(true);
            np.setNeedPeriodMember(true);
            np.setNeedReportPeriodType(true);
        });
        return (Report)reports.get(0);
    }

    public static int getSubjectSize(AnalysisHeader header, DynamicObject sumPlan) {
        DynamicObject system = sumPlan.getDynamicObject("bodysys");
        int count = 1;
        if (header.getSubjects() == null || header.getSubjects().size() < 1) {
            QFilter tQFilter = new QFilter("bodysystem", "=", system.getPkValue());
            tQFilter.and("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber());
            DynamicObjectCollection tSubjectIds = QueryServiceHelper.query((String)"fpm_membersubject", (String)"id", (QFilter[])new QFilter[]{tQFilter});
            if (Objects.nonNull(tSubjectIds)) {
                count = tSubjectIds.size();
            }
        } else {
            count = header.getSubjects().size();
        }
        return count;
    }

    private static DynamicObjectCollection getDimMembers(Set<Long> filterMemberSet) {
        if (filterMemberSet.size() < 1) {
            return new DynamicObjectCollection();
        }
        String selectFields = String.join((CharSequence)",", String.join((CharSequence)".", "dimension", "id"), "dimtype", "startdate", "id");
        return QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", filterMemberSet)});
    }

    private static void addSumPlanDefaultMemberScopeIfEmpty(ReportTemplate analysisTemplate, AnalysisHeader header, DynamicObject sumPlan) {
        List org;
        List periodId = header.getPeriodId();
        if (EmptyUtil.isEmpty((Collection)periodId)) {
            TemplateDim periodDim = analysisTemplate.getAllTemplateDim().stream().filter(templateDim -> templateDim.getDimType().isPeriodDim()).findFirst().get();
            Report report = ReportPlanSumUtil.getReport(sumPlan);
            if (analysisTemplate.getTemplateType().isDetail()) {
                header.setPeriodId(ReportPlanSumUtil.getPeriodFilterMemberList(report));
            } else {
                DimLocation location = periodDim.getLocation();
                if (DimLocation.COL == location) {
                    header.setPeriodId(ReportPlanSumUtil.getPeriodFilterMemberList(report));
                } else {
                    header.setPeriodId(report.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).collect(Collectors.toList()));
                }
            }
        }
        if (EmptyUtil.isEmpty((Collection)(org = header.getOrg()))) {
            TemplateDim orgDim = analysisTemplate.getAllTemplateDim().stream().filter(dim -> dim.getDimType() == DimensionType.ORG).findFirst().get();
            List<Long> filterMember = ReportPlanSumUtil.getFilterMember(orgDim, sumPlan);
            if (CollectionUtils.isEmpty(filterMember)) {
                DynamicObject reportOrgDy = sumPlan.getDynamicObject("reportorg");
                Long reportOrgId = (Long)reportOrgDy.getPkValue();
                header.setOrg(Collections.singletonList(reportOrgId));
            } else {
                header.setOrg(filterMember);
            }
        }
    }

    public static List<Long> getFilterMember(TemplateDim templateDim, DynamicObject sumPlan) {
        List<Long> filterScope = templateDim.getDimType() == DimensionType.ORG ? ReportPlanSumUtil.getOrgFilterMember(templateDim, sumPlan) : templateDim.getDefaultFilter();
        return filterScope;
    }

    private static List<Long> getOrgFilterMember(TemplateDim templateDim, DynamicObject sumPlan) {
        DynamicObject reportOrgDy = sumPlan.getDynamicObject("reportorg");
        Long reportOrgId = (Long)reportOrgDy.getPkValue();
        Set<Long> orgChildren = ReportPlanSumUtil.getOrgChildren(sumPlan, reportOrgId);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{new QFilter("id", "in", orgChildren), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())}, null, (int)-1);
        HashSet<Long> orgList = new HashSet<Long>(orgChildren.size());
        orgList.add(reportOrgId);
        if (ids.size() > 0) {
            orgList.addAll(ids.stream().map(Long.class::cast).collect(Collectors.toSet()));
        }
        HashSet baseSet = new HashSet(orgList);
        if (templateDim.getScopeType() == TemplateDimMemScopeType.FIXED_MEMBER) {
            baseSet.retainAll(templateDim.getMemberScope());
        }
        if (baseSet.size() == 0) {
            return new ArrayList<Long>(orgList);
        }
        if (CollectionUtils.isEmpty((Collection)templateDim.getDefaultFilter())) {
            return new ArrayList<Long>(baseSet);
        }
        HashSet defaultFilterSet = new HashSet(templateDim.getDefaultFilter());
        defaultFilterSet.retainAll(baseSet);
        return new ArrayList<Long>(defaultFilterSet);
    }

    public static Set<Long> getOrgChildren(DynamicObject sumPlan, Long reportOrgId) {
        Report report = ReportPlanSumUtil.getReport(sumPlan);
        SumPlanParamConfig sumPlanParamConfig = summaryConfigService.getSummaryParamConfig(report);
        SumPlanParamConfigInfo configInfo = sumPlanParamConfig.getConfigInfoList().stream().filter(sumPlanParamConfigInfo -> Objects.equals(sumPlanParamConfigInfo.getOrgMemberId(), reportOrgId)).findFirst().get();
        List allChildren = configInfo.getAllChildren();
        return allChildren.stream().map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
    }

    public static List<Long> getPeriodFilterMemberList(Report report) {
        PeriodType detailPeriodType = report.getReportPeriodType().getDetailPeriodType();
        List<PeriodMember> periodMemberList = report.getPeriodMemberList();
        List rollPeriodMembers = Collections.emptyList();
        List<PeriodMember> memberList = periodMemberList;
        PeriodMember periodMember = (PeriodMember)periodMemberList.get(0);
        if (!report.isRollContainsDetail()) {
            memberList = Collections.singletonList(periodMember);
            rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
        }
        ArrayList<Long> currenPeriodChildList = Objects.isNull(detailPeriodType) ? new ArrayList<Long>(Collections.singletonList(periodMember.getId())) : memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
        currenPeriodChildList.addAll(rollPeriodMembers);
        currenPeriodChildList.addAll(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        return currenPeriodChildList.stream().distinct().collect(Collectors.toList());
    }

    private static void addTemplateMemberScopeIfEmpty(ReportTemplate reportTemplate, AnalysisHeader header) {
        Map<String, List> cusDimMap;
        List allTemplateDim = reportTemplate.getAllTemplateDim();
        List<String> listNumber = allTemplateDim.stream().map(e -> e.getDimType().getNumber()).collect(Collectors.toList());
        if (MapUtils.isEmpty((Map)header.getCustomDimension()) && !MapUtils.isEmpty(cusDimMap = allTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.CUSTOM).collect(Collectors.toMap(k -> k.getDimensionId().toString(), TemplateDim::getMemberScope)))) {
            cusDimMap.forEach((k, v) -> {
                if (!CollectionUtils.isEmpty((Collection)v)) {
                    header.getCustomDimension().put(k, v);
                }
            });
        }
        listNumber.forEach(dimNumber -> {
            HashSet dfList = new HashSet(16);
            Optional<TemplateDim> first = allTemplateDim.stream().filter(e -> dimNumber.equals(e.getDimType().getNumber())).findFirst();
            if (null != first.get().getDefaultFilter()) {
                dfList.addAll(first.get().getDefaultFilter());
            }
            if (DimsionEnums.ORG.getNumber().equals(dimNumber) && (header.getOrg() == null || header.getOrg().size() < 1)) {
                dfList.addAll(first.get().getMemberScope());
                header.setOrg(new ArrayList(dfList));
            } else if (DimsionEnums.PERIOD.getNumber().equals(dimNumber) && (null == header.getPeriodId() || header.getPeriodId().size() < 1)) {
                dfList.addAll(first.get().getMemberScope());
                header.setPeriodId(new ArrayList(dfList));
            } else if (DimsionEnums.COMPANY.getNumber().equals(dimNumber) && (null == header.getCompany() || header.getCompany().size() < 1)) {
                dfList.addAll(first.get().getMemberScope());
                header.setCompany(new ArrayList(dfList));
            } else if (DimsionEnums.CURRENCY.getNumber().equals(dimNumber) && (null == header.getCurrency() || header.getCurrency().size() < 1) && !CollectionUtils.isEmpty((Collection)first.get().getMemberScope())) {
                header.setCurrency(first.get().getMemberScope());
            } else if (DimsionEnums.SUBJECT.getNumber().equals(dimNumber) && (null == header.getSubjects() || header.getSubjects().size() < 1)) {
                dfList.addAll(first.get().getMemberScope());
                header.setSubjects(new ArrayList(dfList));
            } else if (DimsionEnums.SETLTMENT.getNumber().equals(dimNumber) && (null == header.getSettlementMethod() || header.getSettlementMethod().size() < 1)) {
                dfList.addAll(first.get().getMemberScope());
                header.setSettlementMethod(new ArrayList(dfList));
            }
        });
    }
}

