/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.command;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMetaData;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.command.impl.ShrekBatchSaveServiceImpl;

public class ShrekBatchSaveCommand
implements ShrekCommand {
    private ShrekMetaData metaData;
    private List<ValueMap> valueMaps;

    public ShrekMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(ShrekMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public ShrekCommandType getCommandType() {
        return ShrekCommandType.BATCH;
    }

    @Override
    public ShrekCommandService getCommandService() {
        return new ShrekBatchSaveServiceImpl(this);
    }

    public List<ValueMap> getValueMap() {
        if (CollectionUtils.isEmpty(this.valueMaps)) {
            this.valueMaps = new ArrayList<ValueMap>();
        }
        return this.valueMaps;
    }

    public void addValue(ShrekCommandType commandType, List<ShrekDimension> dimensionList, BigDecimal value) {
        if (CollectionUtils.isEmpty(this.valueMaps)) {
            this.valueMaps = new ArrayList<ValueMap>();
        }
        ValueMap valueMap = new ValueMap(dimensionList, value);
        valueMap.setCommandType(commandType);
        this.valueMaps.add(valueMap);
    }

    public static class ValueMap {
        private List<ShrekDimension> dimensionList;
        private ShrekCommandType commandType;
        private BigDecimal value;

        public ValueMap(List<ShrekDimension> dimensionList, BigDecimal value) {
            this.dimensionList = dimensionList;
            this.value = value;
        }

        public List<ShrekDimension> getDimensionList() {
            return this.dimensionList;
        }

        public void setDimensionList(List<ShrekDimension> dimensionList) {
            this.dimensionList = dimensionList;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public ShrekCommandType getCommandType() {
            return this.commandType;
        }

        public void setCommandType(ShrekCommandType commandType) {
            this.commandType = commandType;
        }
    }
}

