/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.command;

import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.common.convert.ShrekMetaDataConvert;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekMetaData;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.command.impl.ShrekCubeSyncServiceImpl;
import kd.tmc.fpm.olap.service.command.impl.ShrekDimensionSyncServiceImpl;
import kd.tmc.fpm.olap.service.command.impl.ShrekMemberSyncServiceImpl;

public class ShrekSyncCommand
implements ShrekCommand {
    private ShrekCommandType commandType;
    private ShrekMetaData metaData;
    private List<ShrekDimension> dimensionList;
    private List<ShrekMember> memberList;

    @Override
    public ShrekCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(ShrekCommandType commandType) {
        this.commandType = commandType;
    }

    public ShrekMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(ShrekMetaData metaData) {
        this.metaData = metaData;
    }

    public List<ShrekDimension> getDimensionList() {
        return this.dimensionList;
    }

    public void setDimensionList(List<ShrekDimension> dimensionList) {
        this.dimensionList = dimensionList;
    }

    public List<ShrekMember> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<ShrekMember> memberList) {
        this.memberList = memberList;
    }

    @Override
    public ShrekCommandService getCommandService() {
        ShrekCommandType commandType = this.getCommandType();
        if (Objects.isNull((Object)commandType)) {
            return null;
        }
        if (ShrekCommandType.SYNC_CUBE == commandType) {
            return new ShrekCubeSyncServiceImpl(this);
        }
        if (ShrekCommandType.SYNC_DIMENSION == commandType) {
            return new ShrekDimensionSyncServiceImpl(this);
        }
        if (ShrekCommandType.SYNC_MEMBER == commandType) {
            return new ShrekMemberSyncServiceImpl(this);
        }
        return null;
    }

    public void setMetaDataByNumber(String number) {
        ShrekMetaData data = ShrekMetaDataConvert.convertCube(number);
        this.setMetaData(data);
    }
}

