/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.command.impl;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekMetaData;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;
import kd.tmc.fpm.olap.service.shrek.ShrekDimensionService;
import kd.tmc.fpm.olap.service.shrek.ShrekDynamicCalcService;
import kd.tmc.fpm.olap.service.shrek.ShrekMemberService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekConnectServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDimensionServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDynamicCalcServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMemberServiceImpl;
import kd.tmc.fpm.olap.utils.ShrekExceptionUtil;

public class ShrekDimensionSyncServiceImpl
implements ShrekCommandService {
    private static final Log logger = LogFactory.getLog(ShrekDimensionSyncServiceImpl.class);
    private ShrekSyncCommand command;
    private ShrekConnectService connectService;
    private ShrekDimensionService dimensionService;
    private ShrekMemberService memberService;
    private ShrekDynamicCalcService dynamicCalcService;

    public ShrekDimensionSyncServiceImpl(ShrekSyncCommand command) {
        this.command = command;
        this.connectService = new ShrekConnectServiceImpl();
        this.dimensionService = new ShrekDimensionServiceImpl();
        this.memberService = new ShrekMemberServiceImpl();
        this.dynamicCalcService = new ShrekDynamicCalcServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        FpmAssertUtil.isNotNull((Object)this.command.getMetaData(), (String)"meta data is null");
        FpmAssertUtil.isNotEmpty(this.command.getDimensionList(), (String)"dimension list is empty");
        logger.info("ShrekDimensionSyncService executeSync start");
        OlapConnection conn = null;
        try {
            ShrekMetaData metaData = this.command.getMetaData();
            String cubeNumber = metaData.getCubeNumber();
            conn = this.connectService.getConnection(cubeNumber);
            this.connectService.openConnection(conn);
            List<ShrekDimension> dimensionList = this.command.getDimensionList();
            for (ShrekDimension dimension : dimensionList) {
                this.dimensionService.createDimension(conn, cubeNumber, dimension.getNumber());
                List<ShrekMember> allDimMemberList = dimension.getAllDimMemberList();
                if (CollectionUtils.isEmpty(allDimMemberList)) continue;
                this.memberService.createMember(conn, cubeNumber, dimension.getNumber(), allDimMemberList);
                this.dynamicCalcService.updateDynamicCalc(conn, cubeNumber, dimension.getNumber(), allDimMemberList);
            }
        }
        catch (Exception e) {
            try {
                logger.error("ShrekDimensionSyncService executeSync error", (Throwable)e);
                ShrekExceptionUtil.packException(e);
            }
            catch (Throwable throwable) {
                logger.info("ShrekDimensionSyncService executeSync end");
                this.connectService.close(conn);
                throw throwable;
            }
            logger.info("ShrekDimensionSyncService executeSync end");
            this.connectService.close(conn);
        }
        logger.info("ShrekDimensionSyncService executeSync end");
        this.connectService.close(conn);
    }
}

