/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.command.impl;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekMetaData;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;
import kd.tmc.fpm.olap.service.shrek.ShrekDimensionService;
import kd.tmc.fpm.olap.service.shrek.ShrekDynamicCalcService;
import kd.tmc.fpm.olap.service.shrek.ShrekMemberService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekConnectServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDimensionServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDynamicCalcServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMemberServiceImpl;
import kd.tmc.fpm.olap.utils.ShrekExceptionUtil;

public class ShrekMemberSyncServiceImpl
implements ShrekCommandService {
    private static final Log logger = LogFactory.getLog(ShrekMemberSyncServiceImpl.class);
    private ShrekSyncCommand command;
    private ShrekConnectService connectService;
    private ShrekDimensionService dimensionService;
    private ShrekMemberService memberService;
    private ShrekDynamicCalcService dynamicCalcService;

    public ShrekMemberSyncServiceImpl(ShrekSyncCommand command) {
        this.command = command;
        this.connectService = new ShrekConnectServiceImpl();
        this.dimensionService = new ShrekDimensionServiceImpl();
        this.memberService = new ShrekMemberServiceImpl();
        this.dynamicCalcService = new ShrekDynamicCalcServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        FpmAssertUtil.isNotNull((Object)this.command.getMetaData(), (String)"meta data is null");
        FpmAssertUtil.isNotEmpty(this.command.getMemberList(), (String)"member list is empty");
        logger.info("ShrekMemberSyncServiceImpl executeSync start");
        OlapConnection conn = null;
        try {
            ShrekMetaData metaData = this.command.getMetaData();
            List<ShrekMember> memberList = this.command.getMemberList();
            String cubeNumber = metaData.getCubeNumber();
            conn = this.connectService.getConnection(cubeNumber);
            this.connectService.openConnection(conn);
            String dimNumber = memberList.get(0).getDimNumber();
            this.memberService.createMember(conn, cubeNumber, dimNumber, memberList);
        }
        catch (Exception e) {
            try {
                logger.error("ShrekMemberSyncServiceImpl executeSync error", (Throwable)e);
                ShrekExceptionUtil.packException(e);
            }
            catch (Throwable throwable) {
                logger.info("ShrekMemberSyncServiceImpl executeSync end");
                this.connectService.close(conn);
                throw throwable;
            }
            logger.info("ShrekMemberSyncServiceImpl executeSync end");
            this.connectService.close(conn);
        }
        logger.info("ShrekMemberSyncServiceImpl executeSync end");
        this.connectService.close(conn);
    }
}

