/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.command.impl;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.olap.command.ShrekSyncReportDataCommand;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.log.SyncLogQueryService;
import kd.tmc.fpm.olap.service.log.impl.SyncLogQueryServiceImpl;
import kd.tmc.fpm.olap.service.shrek.ShrekDataHandleService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDataHandleServiceImpl;

public class ShrekSyncReportDataServiceImpl
implements ShrekCommandService {
    private static final Log logger = LogFactory.getLog(ShrekSyncReportDataServiceImpl.class);
    private ShrekSyncReportDataCommand command;
    private SyncLogQueryService logQueryService;
    private ShrekDataHandleService dataHandleService;

    public ShrekSyncReportDataServiceImpl(ShrekSyncReportDataCommand command) {
        this.command = command;
        this.logQueryService = new SyncLogQueryServiceImpl();
        this.dataHandleService = new ShrekDataHandleServiceImpl();
    }

    @Override
    public void execute() {
        this.doSync();
    }

    private void doSync() {
        Long systemId = this.command.getSystemId();
        this.logQueryService.loadLogsAndExecuteCallback(systemId, waitSyncLogs -> {
            try (DLock lock = DLock.create((String)String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "SyncReportData", systemId));){
                if (!lock.tryLock()) {
                    logger.info(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ShrekSyncReportDataServiceImpl_0", (String)"tmc-fpm-olap", (Object[])new Object[0]));
                    return;
                }
                this.dataHandleService.handleReportDataToOlap(waitSyncLogs);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }
}

