/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.log.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.olap.common.convert.ShrekSyncLogConvert;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogQueryService;

public class SyncLogQueryServiceImpl
implements SyncLogQueryService {
    @Override
    public void loadLogsAndExecuteCallback(Long systemId, SyncLogQueryService.LoadCallback callback) {
        Long maxId = 0L;
        List<ShrekSyncLog> syncLogs = this.loadByMaxId(systemId, maxId);
        if (CollectionUtils.isEmpty(syncLogs)) {
            return;
        }
        callback.execute(syncLogs);
        maxId = syncLogs.stream().map(ShrekSyncLog::getId).max(Long::compareTo).orElse(null);
        while (!CollectionUtils.isEmpty(syncLogs) || Objects.nonNull(maxId)) {
            syncLogs = this.loadByMaxId(systemId, maxId);
            if (CollectionUtils.isEmpty(syncLogs)) {
                return;
            }
            callback.execute(syncLogs);
            maxId = syncLogs.stream().map(ShrekSyncLog::getId).max(Long::compareTo).orElse(null);
        }
    }

    private List<ShrekSyncLog> loadByMaxId(Long systemId, Long maxId) {
        QFilter waitSyncFilter = new QFilter("syncstatus", "=", (Object)ShrekSyncStatus.WAIT_SYNC.name());
        waitSyncFilter.and("bodysystem", "=", (Object)systemId);
        waitSyncFilter.and("id", ">", (Object)maxId);
        DynamicObject[] logList = BusinessDataServiceHelper.load((String)"fpm_olapsynclog", (String)String.join((CharSequence)",", "id", "entityid", "entityname", "syncstatus", "bodysystem.id", "synctype"), (QFilter[])new QFilter[]{waitSyncFilter}, (String)"id asc", (int)2000);
        if (logList.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(logList).map(ShrekSyncLogConvert::convert).collect(Collectors.toList());
    }

    @Override
    public List<ShrekSyncLog> loadLogsByStatus(ShrekSyncStatus syncStatus, int limit) {
        QFilter waitSyncFilter = new QFilter("syncstatus", "=", (Object)syncStatus.name());
        DynamicObjectCollection logList = QueryServiceHelper.query((String)"fpm_olapsynclog", (String)String.join((CharSequence)",", "id", "entityid", "entityname", "syncstatus", "bodysystem", "synctype"), (QFilter[])new QFilter[]{waitSyncFilter}, (String)"", (int)limit);
        if (CollectionUtils.isEmpty((Collection)logList)) {
            return Collections.emptyList();
        }
        return logList.stream().map(ShrekSyncLogConvert::convert).collect(Collectors.toList());
    }
}

