/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.olap.metadata.MetadataTypes;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.common.datasource.ShrekDataSource;
import kd.tmc.fpm.olap.common.datasource.ShrekDataSourceManager;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;

public class ShrekConnectServiceImpl
implements ShrekConnectService {
    @Override
    public OlapConnection getEmptyConnection() {
        ShrekDataSource dataSource = ShrekDataSourceManager.getCurrent();
        String url = ShrekDataSourceManager.getUrl(dataSource);
        return this.getConnection(dataSource.getUsername(), dataSource.getPassword(), url, "");
    }

    @Override
    public OlapConnection getConnection(String cubeName) {
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeName is null");
        ShrekDataSource dataSource = ShrekDataSourceManager.getCurrent();
        String url = ShrekDataSourceManager.getUrl(dataSource);
        return this.getConnection(dataSource.getUsername(), dataSource.getPassword(), url, cubeName);
    }

    @Override
    public OlapConnection openConnection(OlapConnection connection) {
        connection.Open();
        return connection;
    }

    @Override
    public void close(OlapConnection connection) {
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryOlapConnect() {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setAction(CommandTypes.create);
        cmd.setName("olapTestCube");
        boolean isSuccess = true;
        OlapConnection conn = null;
        try {
            conn = this.getEmptyConnection();
            conn.Open();
            new OlapCommand(conn, (CommandInfo)cmd).executeNonQuery();
        }
        catch (Exception e) {
            isSuccess = false;
        }
        finally {
            this.close(conn);
        }
        return isSuccess;
    }

    private OlapConnection getConnection(String username, String psw, String dataSource, String cubeName) {
        OlapConnectionStringBuilder strBuilder = new OlapConnectionStringBuilder();
        strBuilder.setProvider("kingdee.olap.Shrek");
        strBuilder.setDataSource(dataSource);
        if (!cubeName.isEmpty()) {
            strBuilder.setInitialCatalog(cubeName);
        }
        OlapConnection olapConn = new OlapConnection(strBuilder.toString());
        olapConn.setUserName(username);
        olapConn.setPassword(psw);
        return olapConn;
    }
}

