/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.helper.ReportDataFieldHelper;
import kd.tmc.fpm.common.property.ReportProp;
import kd.tmc.fpm.olap.command.ShrekBatchSaveCommand;
import kd.tmc.fpm.olap.common.convert.ShrekMetaDataConvert;
import kd.tmc.fpm.olap.common.convert.ShrekModelConvert;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.enums.SyncLogType;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.command.impl.ShrekBatchSaveServiceImpl;
import kd.tmc.fpm.olap.service.log.SyncLogSaveService;
import kd.tmc.fpm.olap.service.log.impl.SyncLogSaveServiceImpl;
import kd.tmc.fpm.olap.service.shrek.ShrekDataHandleService;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;

public class ShrekDataHandleServiceImpl
implements ShrekDataHandleService {
    private static final Log logger = LogFactory.getLog(ShrekDataHandleServiceImpl.class);
    private SyncLogSaveService logSaveService = new SyncLogSaveServiceImpl();

    @Override
    public void handleReportDataToOlap(List<ShrekSyncLog> needSyncLogs) {
        ShrekBatchSaveCommand batchSaveCommand = new ShrekBatchSaveCommand();
        ShrekBatchSaveServiceImpl commandService = new ShrekBatchSaveServiceImpl(batchSaveCommand);
        Map<Long, List<ShrekSyncLog>> dataMap = needSyncLogs.stream().collect(Collectors.groupingBy(ShrekSyncLog::getEntityId));
        Long systemId = needSyncLogs.get(0).getSystemId();
        DynamicObject system = TmcDataServiceHelper.loadSingle((Object)systemId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_bodysysmanage"));
        Map<Long, DynamicObject> dimensionMap = this.getDimensionMap(system);
        Map<Long, DynamicObject> memberArrMap = this.getMemberMap(dimensionMap);
        String cubeName = system.getString("shrekdatakey");
        if (EmptyUtil.isEmpty((String)cubeName)) {
            logger.warn("\u4f53\u7cfb:{}\u5c1a\u672a\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93", (Object)system.getString("name"));
            return;
        }
        batchSaveCommand.setMetaData(ShrekMetaDataConvert.convertCube(cubeName));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryReportData", (String)"fpm_report", (String)this.getSelectFields(dimensionMap), (QFilter[])new QFilter[]{new QFilter("maindimentry.id", "in", dataMap.keySet())}, (String)"");
        while (dataSet.hasNext()) {
            Boolean mainTable;
            Row row = dataSet.next();
            Long entryId = row.getLong("maindimentry.id");
            List<ShrekSyncLog> logs = dataMap.get(entryId);
            Map<String, List<Long>> rowDataMemberIdMap = this.getRowDataMemberIdMap(row, dimensionMap);
            if (this.checkLeafRow(dimensionMap, memberArrMap, rowDataMemberIdMap) || Objects.isNull(mainTable = row.getBoolean(String.join((CharSequence)".", "maindimentry", "maintable"))) || !mainTable.booleanValue()) continue;
            Map<String, BigDecimal> metricValue = this.getMetricValue(row);
            Map<String, String> redundantFieldValue = this.getRedundantFieldValue(row);
            BiConsumer<ShrekCommandType, ShrekBatchSaveCommand> commandConsumer = this.commandProvider(dimensionMap, memberArrMap, rowDataMemberIdMap, redundantFieldValue, metricValue);
            for (ShrekSyncLog log : logs) {
                ShrekCommandType commandType = SyncLogType.convertToCommandType(log.getLogType());
                commandConsumer.accept(commandType, batchSaveCommand);
            }
        }
        try {
            commandService.execute();
            this.updateLogStatus(needSyncLogs, ShrekSyncStatus.SYNC_DONE);
        }
        catch (Exception e) {
            this.updateLogStatus(needSyncLogs, ShrekSyncStatus.SYNC_FAILED);
            throw e;
        }
    }

    private boolean checkLeafRow(Map<Long, DynamicObject> dimensionMap, Map<Long, DynamicObject> memberArrMap, Map<String, List<Long>> rowDataMemberIdMap) {
        List memberIds = rowDataMemberIdMap.values().stream().flatMap(Collection::stream).filter(item -> item > 0L).collect(Collectors.toList());
        for (Long memberId : memberIds) {
            DynamicObject memberObj = memberArrMap.get(memberId);
            long dimId = memberObj.getLong("dimension.id");
            DynamicObject dimObj = dimensionMap.get(dimId);
            boolean isSubjects = dimObj.getString("basedata").equals(DimsionEnums.SUBJECT.getNumber());
            if (!isSubjects) continue;
            boolean isLeaf = memberObj.getBoolean("isleaf");
            return !isLeaf;
        }
        return false;
    }

    private Map<String, String> getRedundantFieldValue(Row row) {
        HashMap<String, String> redundantFieldMap = new HashMap<String, String>();
        ReportDataFieldHelper.REDUNDANT_FIELD_MAPPING_MAP.forEach((key, value) -> {
            String mainEntryProp = String.join((CharSequence)".", "maindimentry", key);
            Object o = row.get(mainEntryProp);
            if (Objects.isNull(o)) {
                redundantFieldMap.put((String)key, ShrekIdUtil.getNoneNumber(key));
                return;
            }
            if (o instanceof Boolean) {
                redundantFieldMap.put((String)key, Boolean.parseBoolean(o.toString()) ? "1" : "0");
            } else {
                redundantFieldMap.put((String)key, o.toString());
            }
        });
        redundantFieldMap.putIfAbsent("ReportPeriodDim", row.getString(String.join((CharSequence)".", "maindimentry", "entryreportperiod")));
        return redundantFieldMap;
    }

    private Map<Long, DynamicObject> getDimensionMap(DynamicObject system) {
        DynamicObject[] dimensions = TmcDataServiceHelper.load((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "basedata", "shrekdatakey"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", system.getPkValue())});
        return Arrays.stream(dimensions).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
    }

    private Map<Long, DynamicObject> getMemberMap(Map<Long, DynamicObject> dimensionMap) {
        DynamicObject[] memberIdArr = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("dimension", "in", dimensionMap.keySet())});
        Object[] memIdArr = Arrays.stream(memberIdArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] memberArr = TmcDataServiceHelper.load((Object[])memIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
        return Arrays.stream(memberArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
    }

    @Override
    public void handleAllReportPlanToOlap(QFilter syncReportFilter) {
        int totalCount = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])new QFilter[]{syncReportFilter});
        int pageSize = 100;
        int pages = totalCount / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            DynamicObject[] reportList = TmcDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.getBillHeadProp()), (QFilter[])new QFilter[]{syncReportFilter}, (String)"", (int)pageIndex, (int)pageSize);
            List filterReportList = Arrays.stream(reportList).filter(item -> Objects.nonNull(item.getDynamicObject("bodysys"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterReportList)) continue;
            Map<Object, List<DynamicObject>> reportGroupBySys = filterReportList.stream().collect(Collectors.groupingBy(v -> v.getDynamicObject("bodysys").getPkValue()));
            this.syncReportPlan(reportGroupBySys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncReportPlan(Map<Object, List<DynamicObject>> reportGroupBySys) {
        Object systemId;
        ShrekBatchSaveCommand batchSaveCommand = new ShrekBatchSaveCommand();
        ShrekBatchSaveServiceImpl commandService = new ShrekBatchSaveServiceImpl(batchSaveCommand);
        HashMap<Object, List<DynamicObject>> filterReportMap = new HashMap<Object, List<DynamicObject>>(reportGroupBySys.size());
        for (Map.Entry<Object, List<DynamicObject>> entry : reportGroupBySys.entrySet()) {
            systemId = entry.getKey();
            boolean systemSyncDone = TmcDataServiceHelper.exists((String)"fpm_bodysysmanage", (QFilter[])new QFilter[]{new QFilter("id", "=", systemId), new QFilter("shreksyncstatus", "=", (Object)ShrekSyncStatus.SYNC_DONE.name()), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
            if (!systemSyncDone) continue;
            filterReportMap.put(systemId, entry.getValue());
        }
        for (Map.Entry<Object, List<Object>> entry : filterReportMap.entrySet()) {
            systemId = entry.getKey();
            List<Object> reports = entry.getValue();
            DynamicObject system = TmcDataServiceHelper.loadSingle((String)"fpm_bodysysmanage", (String)String.join((CharSequence)",", "id", "shrekdatakey"), (QFilter[])new QFilter[]{new QFilter("id", "=", systemId)});
            String cubeName = system.getString("shrekdatakey");
            batchSaveCommand.setMetaData(ShrekMetaDataConvert.convertCube(cubeName));
            Map<Long, DynamicObject> dimensionMap = this.getDimensionMap(system);
            Map<Long, DynamicObject> memberArrMap = this.getMemberMap(dimensionMap);
            boolean emptyMetric = dimensionMap.values().stream().noneMatch(item -> item.getString("basedata").equals(DimsionEnums.METRIC.getNumber()));
            if (emptyMetric) continue;
            for (DynamicObject dynamicObject : reports) {
                Set entryPropertySet = FpmHelper.getEntryPropertyS((String)"fpm_report", (String)"maindimentry");
                String idProp = String.join((CharSequence)".", "maindimentry", "id");
                entryPropertySet.add(idProp);
                entryPropertySet.add("id");
                entryPropertySet.add(String.join((CharSequence)".", "maindimentry", "sourceid_tag"));
                DataSet reportMainEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())}, (String)"");
                while (reportMainEntryDataSet.hasNext()) {
                    Row row = reportMainEntryDataSet.next();
                    Map<String, List<Long>> rowDataMemberIdMap = this.getRowDataMemberIdMap(row, dimensionMap);
                    if (this.checkLeafRow(dimensionMap, memberArrMap, rowDataMemberIdMap)) continue;
                    Map<String, BigDecimal> metricValue = this.getMetricValue(row);
                    Map<String, String> redundantFieldValue = this.getRedundantFieldValue(row);
                    BiConsumer<ShrekCommandType, ShrekBatchSaveCommand> commandConsumer = this.commandProvider(dimensionMap, memberArrMap, rowDataMemberIdMap, redundantFieldValue, metricValue);
                    commandConsumer.accept(ShrekCommandType.UPDATE, batchSaveCommand);
                }
                try {
                    commandService.execute();
                }
                catch (Exception e) {
                    logger.error("ShrekDataHandleService batch save error, report billNo:{}", (Object)dynamicObject.getString("billno"), (Object)e);
                }
                finally {
                    batchSaveCommand.getValueMap().clear();
                }
            }
        }
    }

    private BiConsumer<ShrekCommandType, ShrekBatchSaveCommand> commandProvider(Map<Long, DynamicObject> dimensionMap, Map<Long, DynamicObject> memberArrMap, Map<String, List<Long>> rowDataMemberIdMap, Map<String, String> redundantFieldValue, Map<String, BigDecimal> metricValue) {
        List metricObj = dimensionMap.values().stream().filter(item -> item.getString("basedata").equals(DimsionEnums.METRIC.getNumber())).collect(Collectors.toList());
        Map metricMemberMap = memberArrMap.values().stream().filter(item -> item.getString("dimtype").equals(DimsionEnums.METRIC.getNumber())).filter(item -> item.getBoolean("preset")).collect(Collectors.toMap(item -> item.getString("metricpresettype"), Function.identity()));
        return (commandType, batchSaveCommand) -> {
            String cubeName = batchSaveCommand.getMetaData().getCubeNumber();
            Consumer<List<ShrekDimension>> initShrekDimension = this.initShrekDimensionFunction(dimensionMap, memberArrMap, rowDataMemberIdMap, cubeName);
            for (Map.Entry entry : metricValue.entrySet()) {
                ShrekDimension dimension;
                if (Objects.isNull(entry.getValue())) continue;
                ArrayList<ShrekDimension> dimensionList = new ArrayList<ShrekDimension>(16);
                initShrekDimension.accept(dimensionList);
                if (!CollectionUtils.isEmpty((Collection)metricObj)) {
                    DynamicObject dimObj = (DynamicObject)metricObj.get(0);
                    DynamicObject memberObj = (DynamicObject)metricMemberMap.get(entry.getKey());
                    if (Objects.nonNull(memberObj)) {
                        ShrekDimension metricDim = ShrekModelConvert.convert(cubeName, dimObj.getString("shrekdatakey"), memberObj.getString("shrekdatakey"));
                        dimensionList.add(metricDim);
                    }
                }
                Map existDimMap = dimensionList.stream().collect(Collectors.toMap(ShrekDimension::getNumber, Function.identity()));
                for (Map.Entry dimEntry : dimensionMap.entrySet()) {
                    String syncKey = ((DynamicObject)dimEntry.getValue()).getString("shrekdatakey");
                    if (StringUtils.isEmpty((Object)syncKey) || existDimMap.containsKey(syncKey)) continue;
                    DynamicObject dim = (DynamicObject)dimEntry.getValue();
                    dimension = ShrekModelConvert.convert(cubeName, dim.getString("shrekdatakey"), ShrekIdUtil.getNoneNumber(dim.getString("shrekdatakey")));
                    dimensionList.add(dimension);
                }
                for (Map.Entry fieldEntry : redundantFieldValue.entrySet()) {
                    String fieldEntryKey = (String)fieldEntry.getKey();
                    String value = (String)fieldEntry.getValue();
                    if (Objects.equals(fieldEntryKey, "ReportPeriodDim")) {
                        ShrekDimension reportPeriodDim = this.replenishReportPeriodDim(cubeName, memberArrMap, value);
                        if (!Objects.nonNull(reportPeriodDim)) continue;
                        dimensionList.add(reportPeriodDim);
                        continue;
                    }
                    dimension = ShrekModelConvert.convert(cubeName, fieldEntryKey, value);
                    dimensionList.add(dimension);
                }
                batchSaveCommand.addValue((ShrekCommandType)((Object)commandType), (List<ShrekDimension>)dimensionList, (BigDecimal)entry.getValue());
            }
        };
    }

    private Consumer<List<ShrekDimension>> initShrekDimensionFunction(Map<Long, DynamicObject> dimensionMap, Map<Long, DynamicObject> memberArrMap, Map<String, List<Long>> rowDataMemberIdMap, String cubeName) {
        Map dimensionMapByNumber = dimensionMap.values().stream().collect(Collectors.toMap(k -> k.getString("number"), Function.identity()));
        return dimensionList -> {
            for (Map.Entry rowDataMember : rowDataMemberIdMap.entrySet()) {
                String dimType = (String)rowDataMember.getKey();
                List memberIdList = (List)rowDataMember.getValue();
                if (DimsionEnums.CUSTOM.getNumber().equals(dimType)) {
                    Object customMemberId2;
                    HashSet<Long> existDimId = new HashSet<Long>(memberIdList.size());
                    for (Object customMemberId2 : memberIdList) {
                        DynamicObject memberObj = (DynamicObject)memberArrMap.get(customMemberId2);
                        if ((Long)customMemberId2 == 0L || Objects.isNull(memberObj)) continue;
                        long dimId = memberObj.getLong("dimension.id");
                        existDimId.add(dimId);
                        DynamicObject dimObj = (DynamicObject)dimensionMap.get(dimId);
                        ShrekDimension dimension = ShrekModelConvert.convert(cubeName, dimObj.getString("shrekdatakey"), memberObj.getString("shrekdatakey"));
                        dimensionList.add(dimension);
                    }
                    List customList = dimensionMap.values().stream().filter(item -> DimsionEnums.CUSTOM.getNumber().equals(item.getString("basedata"))).filter(item -> !existDimId.contains((Long)item.getPkValue())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(customList)) continue;
                    customMemberId2 = customList.iterator();
                    while (customMemberId2.hasNext()) {
                        DynamicObject customDim = (DynamicObject)customMemberId2.next();
                        ShrekDimension dimension = ShrekModelConvert.convert(cubeName, customDim.getString("shrekdatakey"), ShrekIdUtil.getNoneNumber(customDim.getString("shrekdatakey")));
                        dimensionList.add(dimension);
                    }
                    continue;
                }
                Long memberId = (Long)memberIdList.get(0);
                DynamicObject memberObj = (DynamicObject)memberArrMap.get(memberId);
                if (memberId == 0L || Objects.isNull(memberObj)) {
                    DynamicObject dimObj = (DynamicObject)dimensionMapByNumber.get(dimType);
                    ShrekDimension dimension = ShrekModelConvert.convert(cubeName, dimObj.getString("shrekdatakey"), ShrekIdUtil.getNoneNumber(dimObj.getString("shrekdatakey")));
                    dimensionList.add(dimension);
                    continue;
                }
                long dimId = memberObj.getLong("dimension.id");
                DynamicObject dimObj = (DynamicObject)dimensionMap.get(dimId);
                ShrekDimension dimension = ShrekModelConvert.convert(cubeName, dimObj.getString("shrekdatakey"), memberObj.getString("shrekdatakey"));
                dimensionList.add(dimension);
            }
        };
    }

    private ShrekDimension replenishReportPeriodDim(String cubeName, Map<Long, DynamicObject> memberArrMap, String reportPeriodIdStr) {
        if (EmptyUtil.isEmpty((String)reportPeriodIdStr)) {
            return null;
        }
        DynamicObject periodMember = memberArrMap.get(Long.parseLong(reportPeriodIdStr));
        if (Objects.isNull(periodMember)) {
            return null;
        }
        return ShrekModelConvert.convert(cubeName, "ReportPeriodDim", periodMember.getString("shrekdatakey"));
    }

    private Map<String, BigDecimal> getMetricValue(Row row) {
        HashMap<String, BigDecimal> metricValueMap = new HashMap<String, BigDecimal>(8);
        for (Map.Entry metricEntry : ReportDataFieldHelper.METRIC_MAPPING_MAP.entrySet()) {
            metricValueMap.put((String)metricEntry.getKey(), row.getBigDecimal((String)metricEntry.getValue()));
        }
        return metricValueMap;
    }

    private Map<String, List<Long>> getRowDataMemberIdMap(Row row, Map<Long, DynamicObject> dimMap) {
        Map<String, List<String>> fieldByDimNumber = this.getFieldByDimNumber(dimMap);
        HashMap<String, List<Long>> memberIdMap = new HashMap<String, List<Long>>(fieldByDimNumber.size());
        for (Map.Entry<String, List<String>> fieldEntry : fieldByDimNumber.entrySet()) {
            String dimNumber = fieldEntry.getKey();
            List<String> propList = fieldEntry.getValue();
            if (DimsionEnums.CUSTOM.getNumber().equals(dimNumber)) {
                for (String prop : propList) {
                    memberIdMap.computeIfAbsent(dimNumber, k -> new ArrayList());
                    memberIdMap.computeIfPresent(dimNumber, (k, v) -> {
                        v.add(row.getLong(prop));
                        return v;
                    });
                }
            }
            memberIdMap.put(dimNumber, Collections.singletonList(row.getLong(propList.get(0))));
        }
        return memberIdMap;
    }

    private String getSelectFields(Map<Long, DynamicObject> dimensionMap) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("maindimentry.id");
        fields.add("maindimentry.system");
        List mainDim = this.getFieldByDimNumber(dimensionMap).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        fields.addAll(mainDim);
        fields.addAll(ReportDataFieldHelper.METRIC_MAPPING_MAP.values());
        List redundantField = ReportDataFieldHelper.REDUNDANT_FIELD_MAPPING_MAP.keySet().stream().map(i -> "maindimentry." + i).collect(Collectors.toList());
        fields.addAll(redundantField);
        fields.add(String.join((CharSequence)".", "maindimentry", "entryreportperiod"));
        return String.join((CharSequence)",", fields);
    }

    private Map<String, List<String>> getFieldByDimNumber(Map<Long, DynamicObject> dimensionMap) {
        List dimNumbers = dimensionMap.values().stream().map(item -> item.getString("basedata")).collect(Collectors.toList());
        return ReportDataFieldHelper.mainPropMapByDimensionNumbers(dimNumbers);
    }

    private void updateLogStatus(List<ShrekSyncLog> logIdList, ShrekSyncStatus syncStatus) {
        logIdList.forEach(item -> item.setSyncStatus(syncStatus));
        this.logSaveService.update(logIdList);
    }
}

