/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.util.Set;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.olap.metadata.OlapDataTypes;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.service.shrek.ShrekMeasureService;
import kd.tmc.fpm.olap.service.shrek.ShrekMetaDataService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMetaDataServiceImpl;
import kd.tmc.fpm.olap.utils.TraceIdUtil;

public class ShrekMeasureServiceImpl
implements ShrekMeasureService {
    private ShrekMetaDataService mateDataService = new ShrekMetaDataServiceImpl();

    @Override
    public void createMeasure(OlapConnection conn, String cubeName, String measure) {
        FpmAssertUtil.isNotNull((Object)conn, (String)"olap connect is null");
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeName is null");
        FpmAssertUtil.isNotBlank((String)measure, (String)"measure is null");
        if (this.existMeasure(conn, cubeName, measure)) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Measure);
        meta.setName(measure.trim());
        meta.setOwnerUniqueName(cubeName);
        meta.setDataType(OlapDataTypes.object);
        TraceIdUtil.setTraceInfo((CommandInfo)meta);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }

    @Override
    public boolean existMeasure(OlapConnection conn, String cubeName, String measure) {
        Set<String> properties = this.mateDataService.getProperties(conn, cubeName, "", true);
        return properties.contains(measure);
    }
}

