/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.service.shrek.ShrekDimensionService;
import kd.tmc.fpm.olap.service.shrek.ShrekMemberService;
import kd.tmc.fpm.olap.service.shrek.ShrekMetaDataService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDimensionServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMetaDataServiceImpl;
import kd.tmc.fpm.olap.utils.NumberUtils;

public class ShrekMemberServiceImpl
implements ShrekMemberService {
    private ShrekMetaDataService mateDataService;
    private ShrekDimensionService dimensionService = new ShrekDimensionServiceImpl();

    public ShrekMemberServiceImpl() {
        this.mateDataService = new ShrekMetaDataServiceImpl();
    }

    @Override
    public void createMember(OlapConnection conn, String cubeNumber, String dimension, List<ShrekMember> members) {
        boolean existDimension = this.dimensionService.existDimension(conn, cubeNumber, dimension);
        if (!existDimension) {
            return;
        }
        HashSet<String> errors = new HashSet<String>();
        for (ShrekMember member : members) {
            if (!NumberUtils.checkNumber(member.getNumber())) {
                errors.add(member.getNumber());
                continue;
            }
            if (NumberUtils.checkKeyword(member.getNumber())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539%s\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\uff0c\u4e0d\u80fd\u4f7f\u7528\u201call\u201d\u3001\u201cnone\u201d\u3001\u201cnull\u201d\u3001\u201cother\u201d\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"ShrekMemberServiceImpl_1", (String)"tmc-fpm-olap", (Object[])new Object[]{dimension}));
        }
        if (!CollectionUtils.isEmpty(errors)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ef4\u5ea6\u7684\u6210\u5458\u7f16\u7801\u201c%2$s\u201d\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u80fd\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ShrekMemberServiceImpl_2", (String)"tmc-fpm-olap", (Object[])new Object[]{dimension, String.join((CharSequence)",", errors)}));
        }
        Set<String> existMember = this.mateDataService.getProperties(conn, cubeNumber, dimension, true);
        if ((members = members.stream().filter(m -> !existMember.contains(m.getNumber())).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeNumber.trim() + "." + dimension);
        List items = meta.getItems();
        for (ShrekMember member : members) {
            if (this.existMember(conn, cubeNumber, dimension, member.getNumber())) continue;
            items.add(new MemberMetadataItem(member.getNumber()));
        }
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }

    @Override
    public boolean existMember(OlapConnection conn, String cubeName, String dimension, String member) {
        PropertyBag metaData = this.mateDataService.getMetaData(conn, cubeName, dimension, true);
        String metas = metaData.get("children");
        String[] split = metas.split("\n");
        return Arrays.stream(split).filter(StringUtils::isNotEmpty).anyMatch(item -> item.equals(member));
    }

    @Override
    public void deleteMember(OlapConnection conn, String cubeNumber, String dimension, String member) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setAction(CommandTypes.drop);
        commandInfo.setMetadataType(MetadataTypes.Member);
        commandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimension.trim());
        commandInfo.setAllowDropMemberWhenRowReferenced(true);
        commandInfo.getItems().add(new MemberMetadataItem(member.trim()));
        OlapCommand command = new OlapCommand(conn, (CommandInfo)commandInfo);
        command.executeNonQuery();
    }

    @Override
    public Set<String> listMemberNumbers(OlapConnection conn, String cubeNumber, String dimension) {
        return this.mateDataService.getProperties(conn, cubeNumber, dimension, true);
    }
}

