/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.bean;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DimensionInfoBean {
    private List<Long> dimensionIdList;
    private List<Object> memberIdList;

    public DimensionInfoBean() {
        this.dimensionIdList = new LinkedList<Long>();
        this.memberIdList = new LinkedList<Object>();
    }

    public DimensionInfoBean copy() {
        return DimensionInfoBean.of(new ArrayList<Long>(this.dimensionIdList), new ArrayList<Object>(this.memberIdList));
    }

    public static DimensionInfoBean concat(DimensionInfoBean ... beans) {
        DimensionInfoBean infoBean = new DimensionInfoBean();
        for (DimensionInfoBean bean : beans) {
            infoBean.getDimensionIdList().addAll(bean.getDimensionIdList());
            infoBean.getMemberIdList().addAll(bean.getMemberIdList());
        }
        return infoBean;
    }

    public DimensionInfoBean(List<Long> dimensionIdList, List<Object> memberIdList) {
        this.dimensionIdList = dimensionIdList;
        this.memberIdList = memberIdList;
    }

    public static DimensionInfoBean of(List<Long> dimensionIdList, List<Object> memberIdList) {
        DimensionInfoBean bean = new DimensionInfoBean(dimensionIdList, memberIdList);
        return bean;
    }

    public List<Long> getDimensionIdList() {
        return this.dimensionIdList;
    }

    public void setDimensionIdList(List<Long> dimensionIdList) {
        this.dimensionIdList = dimensionIdList;
    }

    public List<Object> getMemberIdList() {
        return this.memberIdList;
    }

    public void setMemberIdList(List<Object> memberIdList) {
        this.memberIdList = memberIdList;
    }

    public void addDimensionInfo(Long dimensionId, Object memberId) {
        if (EmptyUtil.isEmpty((Object)memberId)) {
            return;
        }
        if (this.dimensionIdList.contains(dimensionId)) {
            return;
        }
        this.dimensionIdList.add(dimensionId);
        this.memberIdList.add(memberId);
    }

    public Object replaceValueIfContains(Long dimensionId, Object newVal) {
        int index = this.dimensionIdList.indexOf(dimensionId);
        if (index == -1) {
            this.addDimensionInfo(dimensionId, newVal);
            return 0L;
        }
        return this.memberIdList.set(index, newVal);
    }

    public Object removeDimensionInfo(Long dimensionId) {
        int index = this.dimensionIdList.indexOf(dimensionId);
        if (index == -1) {
            return 0L;
        }
        this.dimensionIdList.remove(index);
        return this.memberIdList.remove(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionInfoBean that = (DimensionInfoBean)o;
        return Objects.equals(this.getDimValueMap(), that.getDimValueMap());
    }

    public Map<Long, Object> getDimValueMap() {
        HashMap<Long, Object> dimValueMap = new HashMap<Long, Object>(this.dimensionIdList.size());
        for (int i = 0; i < this.dimensionIdList.size(); ++i) {
            dimValueMap.put(this.dimensionIdList.get(i), this.memberIdList.get(i));
        }
        return dimValueMap;
    }

    public boolean containsMemberId(Object memberId) {
        return this.memberIdList.contains(memberId);
    }

    public Object getMemberByDimensionId(Long dimensionId) {
        int index = this.dimensionIdList.indexOf(dimensionId);
        return index == -1 ? Long.valueOf(0L) : this.memberIdList.get(index);
    }

    public int hashCode() {
        Map<Long, Object> dimValueMap = this.getDimValueMap();
        List sortDimIdList = this.dimensionIdList.stream().sorted(Comparator.comparing(Long::longValue)).collect(Collectors.toList());
        List sortMemberIdList = sortDimIdList.stream().map(dimValueMap::get).collect(Collectors.toList());
        return Objects.hash(sortDimIdList, sortMemberIdList);
    }

    public String toString() {
        return "DimensionInfoBean{dimensionIdList=" + this.dimensionIdList + ", memberIdList=" + this.memberIdList + '}';
    }
}

