/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.bean;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;

public class SubjectCancelConfig
implements Serializable {
    private Long bodySysId;
    private String flow;
    private List<Subject> subjectList;

    public SubjectCancelConfig() {
    }

    public SubjectCancelConfig(Long bodySysId, String flow) {
        this.bodySysId = bodySysId;
        this.flow = flow;
    }

    public Long getBodySysId() {
        return this.bodySysId;
    }

    public void setBodySysId(Long bodySysId) {
        this.bodySysId = bodySysId;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public List<Subject> getSubjectList() {
        if (CollectionUtils.isEmpty(this.subjectList)) {
            return Collections.emptyList();
        }
        return this.subjectList.stream().sorted(Comparator.comparing(Subject::getSeq)).collect(Collectors.toList());
    }

    public void setSubjectList(List<Subject> subjectList) {
        this.subjectList = subjectList;
    }

    public static class Subject {
        private Long id;
        private String name;
        private String number;
        private Long parentId;
        private int seq;

        public Subject(Long id, String name, String number, Long parentId, int seq) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.parentId = parentId;
            this.seq = seq;
        }

        public Subject() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public Long getParentId() {
            return this.parentId;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Subject subject = (Subject)o;
            return Objects.equals(this.id, subject.id) && Objects.equals(this.name, subject.name) && Objects.equals(this.number, subject.number);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.number);
        }
    }
}

